use std::{process::Output, io::{Write, stdin, stdout}};
use std::process::Command as StdCommand;
use tokio::process::Command;

#[tokio::main]
async fn main() {
    // Get URL
    put("URL: ");
    let mut url = String::new();
    stdin().read_line(&mut url).expect("Failed to read the url.");

    // Ger format codes
    let output = Command::new("youtube-dl").args(&[url.trim(), "-F"]).output().await.expect("Failed to get available formats.");
    stdprint(&output);
    put("Format code ( if empty then default video format will be choosen ): ");
    let mut format_code = String::new();
    stdin().read_line(&mut format_code).expect("Failed to read the format code.");

    // Execute the download
    if format_code.trim().is_empty() {
        StdCommand::new("youtube-dl").arg(url.trim()).spawn().expect("Failed to execute the download.");
        return
    }
    StdCommand::new("youtube-dl").args(&[url.trim(), "-f", format_code.trim()]).spawn().expect("Failed to execute the download.");
}

fn put(x: &str) {
    print!("{}", x);
    stdout().flush().expect("Failed to execute stdout.");
}

fn stdprint(output: &Output) {
    let err = String::from_utf8_lossy(&output.stderr);
    if (&err).is_empty() {
        println!("{}", String::from_utf8_lossy(&output.stdout));
        return
    }
    panic!("{}", &err);
}
