//! YDB SDK - client for Yandex database.

mod client_builder;
mod credentials;
mod errors;
mod pub_traits;
mod sugar;
mod types;
mod types_converters;
mod channel_pool;
pub(crate) mod client;
pub(crate) mod client_common;
pub(crate) mod client_table;
#[cfg(test)]
mod client_table_test_integration;
pub(crate) mod discovery;
mod grpc;
mod load_balancer;
mod middlewares;
pub(crate) mod query;
pub(crate) mod result;
mod session;
mod session_pool;
mod test_helpers;
mod trait_operation;
pub(crate) mod transaction;
pub(crate) mod waiter;

// full enum pub types
pub use client::Client;
// full enum pub types
pub use client_builder::ClientBuilder;
// full enum pub types
pub use client_table::{RetryOptions, TableClient, TransactionOptions};
// full enum pub types
pub use discovery::{Discovery, DiscoveryState, StaticDiscovery};
// full enum pub types
pub use query::Query;
// full enum pub types
pub use result::{QueryResult, ResultSet, ResultSetRowsIter, Row, StreamResult};
// full enum pub types
pub use transaction::{Mode, Transaction};
// full enum pub types
pub use waiter::Waiter;
// full enum pub types
pub use crate::{
    credentials::{CommandLineYcToken, GCEMetadata, StaticToken, YandexMetadata},
    errors::{
        YdbError, YdbIssue, YdbIssueSeverity, YdbOrCustomerError, YdbResult,
        YdbResultWithCustomerErr, YdbStatusError,
    },
    pub_traits::{Credentials, TokenInfo},
    types::{Bytes, Sign, SignedInterval, Value, ValueList, ValueOptional, ValueStruct},
};
