///*
/// Stub for unsupported messages
/// Intentionally empty
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Unsupported {
}
///*
/// Configuration settings for a coordination node
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Config {
    /// Initialized on creation, cannot be set
    #[prost(string, tag="1")]
    pub path: ::prost::alloc::string::String,
    /// Period in milliseconds for self-checks (default 1 second)
    #[prost(uint32, tag="2")]
    pub self_check_period_millis: u32,
    /// Grace period for sessions on leader change (default 10 seconds)
    #[prost(uint32, tag="3")]
    pub session_grace_period_millis: u32,
    /// Concistency mode for read operations
    #[prost(enumeration="ConsistencyMode", tag="4")]
    pub read_consistency_mode: i32,
    /// Consistency mode for attach operations
    #[prost(enumeration="ConsistencyMode", tag="5")]
    pub attach_consistency_mode: i32,
    /// Rate limiter counters mode
    #[prost(enumeration="RateLimiterCountersMode", tag="6")]
    pub rate_limiter_counters_mode: i32,
}
///*
/// Describes an active client session
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SessionDescription {
    /// Session id generated by the server
    #[prost(uint64, tag="1")]
    pub session_id: u64,
    /// Expiration timeout of the session
    #[prost(uint64, tag="2")]
    pub timeout_millis: u64,
    /// User-specified description of this session
    #[prost(string, tag="3")]
    pub description: ::prost::alloc::string::String,
    /// True if this session is currently attached to a client
    #[prost(bool, tag="4")]
    pub attached: bool,
}
///*
/// Describes an owner or a waiter of this semaphore
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SemaphoreSession {
    /// A monotonically increasing id which determines locking order
    #[prost(uint64, tag="5")]
    pub order_id: u64,
    /// An id of the session which tried to acquire the semaphore
    #[prost(uint64, tag="1")]
    pub session_id: u64,
    /// A timeout in milliseconds for operation in waiters queue
    #[prost(uint64, tag="2")]
    pub timeout_millis: u64,
    /// Number of tokens for an acquire operation
    #[prost(uint64, tag="3")]
    pub count: u64,
    /// User-defined data attached to the acquire operation
    #[prost(bytes="vec", tag="4")]
    pub data: ::prost::alloc::vec::Vec<u8>,
}
///*
/// Describes the state of a semaphore
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SemaphoreDescription {
    /// Name of the semaphore
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
    /// User-defined data attached to the semaphore
    #[prost(bytes="vec", tag="2")]
    pub data: ::prost::alloc::vec::Vec<u8>,
    /// Number of tokens currently acquired by owners
    #[prost(uint64, tag="7")]
    pub count: u64,
    /// Maximum number of tokens that may acquired
    #[prost(uint64, tag="3")]
    pub limit: u64,
    /// Ephemeral semaphores are deleted when released by all owners and waiters
    #[prost(bool, tag="4")]
    pub ephemeral: bool,
    /// A list of current owners of the semaphore
    #[prost(message, repeated, tag="5")]
    pub owners: ::prost::alloc::vec::Vec<SemaphoreSession>,
    /// A list of current waiters on the semaphore
    #[prost(message, repeated, tag="6")]
    pub waiters: ::prost::alloc::vec::Vec<SemaphoreSession>,
}
///*
/// Session request message sent from client to server
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SessionRequest {
    #[prost(oneof="session_request::Request", tags="1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15")]
    pub request: ::core::option::Option<session_request::Request>,
}
/// Nested message and enum types in `SessionRequest`.
pub mod session_request {
    ///*
    /// Used for checking liveness of the connection
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct PingPong {
        /// Opaque number specified in the ping message is echoed in the pong message
        #[prost(uint64, tag="1")]
        pub opaque: u64,
    }
    ///*
    /// First message used to start/restore a session
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SessionStart {
        /// Path to a coordination node
        #[prost(string, tag="1")]
        pub path: ::prost::alloc::string::String,
        /// Non-zero when restoring a session, 0 when creating a new session
        #[prost(uint64, tag="2")]
        pub session_id: u64,
        /// Timeout in milliseconds during which client may restore a detached session
        #[prost(uint64, tag="3")]
        pub timeout_millis: u64,
        /// User-defined description that may be used to describe the client
        #[prost(string, tag="4")]
        pub description: ::prost::alloc::string::String,
        /// Monotonically increasing sequence number generated by the client
        /// When concurrent SessionStart requests are detected the one with
        /// the biggest sequence number will succeed
        #[prost(uint64, tag="5")]
        pub seq_no: u64,
        /// Random bytes used to protect session from restore by other clients (max. 16 bytes)
        #[prost(bytes="vec", tag="6")]
        pub protection_key: ::prost::alloc::vec::Vec<u8>,
    }
    ///*
    /// Last message used to cleanly stop session before its timeout expires
    /// nothing
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SessionStop {
    }
    ///*
    /// Used to acquire a semaphore
    /// WARNING: a single session cannot acquire the same semaphore multiple times
    /// Later requests override previous operations with the same semaphore,
    /// e.g. to reduce acquired count, change timeout or attached data.
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct AcquireSemaphore {
        /// Client-defined request id, echoed in the response
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        /// Name of the semaphore to acquire
        #[prost(string, tag="2")]
        pub name: ::prost::alloc::string::String,
        /// Timeout in milliseconds after which operation will fail
        /// if it's still waiting in the waiters queue
        #[prost(uint64, tag="3")]
        pub timeout_millis: u64,
        /// Number of tokens to acquire on the semaphore
        #[prost(uint64, tag="4")]
        pub count: u64,
        /// User-defined binary data that may be attached to the operation
        #[prost(bytes="vec", tag="5")]
        pub data: ::prost::alloc::vec::Vec<u8>,
        /// Ephemeral semaphores are created with the first acquire operation
        /// and automatically deleted with the last release operation
        #[prost(bool, tag="6")]
        pub ephemeral: bool,
    }
    ///*
    /// Used to release a semaphore
    /// WARNING: a single session cannot release the same semaphore multiple times
    /// The release operation will either remove current session from waiters
    /// queue or release an already owned semaphore.
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ReleaseSemaphore {
        /// Client-defined request id, echoed in the response
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        /// Name of the semaphore to release
        #[prost(string, tag="2")]
        pub name: ::prost::alloc::string::String,
    }
    ///*
    /// Used to describe semaphores and watch them for changes
    /// WARNING: a describe operation will cancel previous watches on the same semaphore
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DescribeSemaphore {
        /// Client-defined request id, echoed in the response
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        /// Name of the semaphore to describe
        #[prost(string, tag="2")]
        pub name: ::prost::alloc::string::String,
        /// Response will include owners list if true
        #[prost(bool, tag="3")]
        pub include_owners: bool,
        /// Response will include waiters list if true
        #[prost(bool, tag="4")]
        pub include_waiters: bool,
        /// Watch for changes in semaphore data
        #[prost(bool, tag="5")]
        pub watch_data: bool,
        /// Watch for changes in semaphore owners (including owners data)
        #[prost(bool, tag="6")]
        pub watch_owners: bool,
    }
    ///*
    /// Used to create a new semaphore
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct CreateSemaphore {
        /// Client-defined request id, echoed in the response
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        /// Name of the semaphore to create
        #[prost(string, tag="2")]
        pub name: ::prost::alloc::string::String,
        /// Number of tokens that may be acquired by sessions
        #[prost(uint64, tag="3")]
        pub limit: u64,
        /// User-defined data that is attached to the semaphore
        #[prost(bytes="vec", tag="4")]
        pub data: ::prost::alloc::vec::Vec<u8>,
    }
    ///*
    /// Used to change semaphore data
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UpdateSemaphore {
        /// Client-defined request id, echoed in the response
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        /// Name of the semaphore to update
        #[prost(string, tag="2")]
        pub name: ::prost::alloc::string::String,
        /// User-defined data that is attached to the semaphore
        #[prost(bytes="vec", tag="3")]
        pub data: ::prost::alloc::vec::Vec<u8>,
    }
    ///*
    /// Used to delete an existing semaphore
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DeleteSemaphore {
        /// Client-defined request id, echoed in the response
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        /// Name of the semaphore to delete
        #[prost(string, tag="2")]
        pub name: ::prost::alloc::string::String,
        /// Will delete semaphore even if currently acquired by sessions
        #[prost(bool, tag="3")]
        pub force: bool,
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Request {
        #[prost(message, tag="1")]
        Ping(PingPong),
        #[prost(message, tag="2")]
        Pong(PingPong),
        #[prost(message, tag="3")]
        SessionStart(SessionStart),
        #[prost(message, tag="4")]
        SessionStop(SessionStop),
        #[prost(message, tag="5")]
        Unsupported5(super::Unsupported),
        #[prost(message, tag="6")]
        Unsupported6(super::Unsupported),
        #[prost(message, tag="7")]
        AcquireSemaphore(AcquireSemaphore),
        #[prost(message, tag="8")]
        ReleaseSemaphore(ReleaseSemaphore),
        #[prost(message, tag="9")]
        DescribeSemaphore(DescribeSemaphore),
        #[prost(message, tag="10")]
        CreateSemaphore(CreateSemaphore),
        #[prost(message, tag="11")]
        UpdateSemaphore(UpdateSemaphore),
        #[prost(message, tag="12")]
        DeleteSemaphore(DeleteSemaphore),
        #[prost(message, tag="13")]
        Unsupported13(super::Unsupported),
        #[prost(message, tag="14")]
        Unsupported14(super::Unsupported),
        #[prost(message, tag="15")]
        Unsupported15(super::Unsupported),
    }
}
///*
/// Session response message sent from server to client
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SessionResponse {
    #[prost(oneof="session_response::Response", tags="1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18")]
    pub response: ::core::option::Option<session_response::Response>,
}
/// Nested message and enum types in `SessionResponse`.
pub mod session_response {
    ///*
    /// Used for checking liveness of the connection
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct PingPong {
        /// Opaque number specified in the ping message is echoed in the pong message
        #[prost(uint64, tag="1")]
        pub opaque: u64,
    }
    ///*
    /// Used to report connection and session level failures
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Failure {
        #[prost(enumeration="super::super::status_ids::StatusCode", tag="1")]
        pub status: i32,
        #[prost(message, repeated, tag="2")]
        pub issues: ::prost::alloc::vec::Vec<super::super::issue::IssueMessage>,
    }
    ///*
    /// Used to report a successful session create/restore operation
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SessionStarted {
        /// A server generation id that may be used for restoring the session
        #[prost(uint64, tag="1")]
        pub session_id: u64,
        /// Timeout in milliseconds that will be used by the server
        #[prost(uint64, tag="2")]
        pub timeout_millis: u64,
    }
    ///*
    /// Used to report a successful graceful termination of the session
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SessionStopped {
        #[prost(uint64, tag="1")]
        pub session_id: u64,
    }
    ///*
    /// Used by the server to report when an acquire operation is added to the waiters queue
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct AcquireSemaphorePending {
        #[prost(uint64, tag="1")]
        pub req_id: u64,
    }
    ///*
    /// Used by the server to report the result of an acquire operation
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct AcquireSemaphoreResult {
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        #[prost(enumeration="super::super::status_ids::StatusCode", tag="2")]
        pub status: i32,
        #[prost(message, repeated, tag="3")]
        pub issues: ::prost::alloc::vec::Vec<super::super::issue::IssueMessage>,
        /// True if semaphore was acquired, false if acquire timed out
        #[prost(bool, tag="4")]
        pub acquired: bool,
    }
    ///*
    /// Used by the server to report the result of a release operation
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ReleaseSemaphoreResult {
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        #[prost(enumeration="super::super::status_ids::StatusCode", tag="2")]
        pub status: i32,
        #[prost(message, repeated, tag="3")]
        pub issues: ::prost::alloc::vec::Vec<super::super::issue::IssueMessage>,
        /// True if semaphore was released, false if there was no active acquire operation
        #[prost(bool, tag="4")]
        pub released: bool,
    }
    ///*
    /// The result of the describe operation
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DescribeSemaphoreResult {
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        #[prost(enumeration="super::super::status_ids::StatusCode", tag="2")]
        pub status: i32,
        #[prost(message, repeated, tag="3")]
        pub issues: ::prost::alloc::vec::Vec<super::super::issue::IssueMessage>,
        #[prost(message, optional, tag="4")]
        pub semaphore_description: ::core::option::Option<super::SemaphoreDescription>,
        /// True if a watch has been added for the semaphore
        #[prost(bool, tag="5")]
        pub watch_added: bool,
    }
    ///*
    /// Used to report a change in the watched semaphore
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DescribeSemaphoreChanged {
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        #[prost(bool, tag="2")]
        pub data_changed: bool,
        #[prost(bool, tag="3")]
        pub owners_changed: bool,
    }
    ///*
    /// The result of semaphore creation
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct CreateSemaphoreResult {
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        #[prost(enumeration="super::super::status_ids::StatusCode", tag="2")]
        pub status: i32,
        #[prost(message, repeated, tag="3")]
        pub issues: ::prost::alloc::vec::Vec<super::super::issue::IssueMessage>,
    }
    ///*
    /// The result of semaphore update
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct UpdateSemaphoreResult {
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        #[prost(enumeration="super::super::status_ids::StatusCode", tag="2")]
        pub status: i32,
        #[prost(message, repeated, tag="3")]
        pub issues: ::prost::alloc::vec::Vec<super::super::issue::IssueMessage>,
    }
    ///*
    /// The result of semaphore deletion
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct DeleteSemaphoreResult {
        #[prost(uint64, tag="1")]
        pub req_id: u64,
        #[prost(enumeration="super::super::status_ids::StatusCode", tag="2")]
        pub status: i32,
        #[prost(message, repeated, tag="3")]
        pub issues: ::prost::alloc::vec::Vec<super::super::issue::IssueMessage>,
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Response {
        #[prost(message, tag="1")]
        Ping(PingPong),
        #[prost(message, tag="2")]
        Pong(PingPong),
        #[prost(message, tag="3")]
        Failure(Failure),
        #[prost(message, tag="4")]
        SessionStarted(SessionStarted),
        #[prost(message, tag="5")]
        SessionStopped(SessionStopped),
        #[prost(message, tag="6")]
        Unsupported6(super::Unsupported),
        #[prost(message, tag="7")]
        Unsupported7(super::Unsupported),
        #[prost(message, tag="8")]
        AcquireSemaphorePending(AcquireSemaphorePending),
        #[prost(message, tag="9")]
        AcquireSemaphoreResult(AcquireSemaphoreResult),
        #[prost(message, tag="10")]
        ReleaseSemaphoreResult(ReleaseSemaphoreResult),
        #[prost(message, tag="11")]
        DescribeSemaphoreResult(DescribeSemaphoreResult),
        #[prost(message, tag="12")]
        DescribeSemaphoreChanged(DescribeSemaphoreChanged),
        #[prost(message, tag="13")]
        CreateSemaphoreResult(CreateSemaphoreResult),
        #[prost(message, tag="14")]
        UpdateSemaphoreResult(UpdateSemaphoreResult),
        #[prost(message, tag="15")]
        DeleteSemaphoreResult(DeleteSemaphoreResult),
        #[prost(message, tag="16")]
        Unsupported16(super::Unsupported),
        #[prost(message, tag="17")]
        Unsupported17(super::Unsupported),
        #[prost(message, tag="18")]
        Unsupported18(super::Unsupported),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateNodeRequest {
    #[prost(string, tag="1")]
    pub path: ::prost::alloc::string::String,
    #[prost(message, optional, tag="2")]
    pub config: ::core::option::Option<Config>,
    #[prost(message, optional, tag="3")]
    pub operation_params: ::core::option::Option<super::operations::OperationParams>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateNodeResponse {
    #[prost(message, optional, tag="1")]
    pub operation: ::core::option::Option<super::operations::Operation>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AlterNodeRequest {
    #[prost(string, tag="1")]
    pub path: ::prost::alloc::string::String,
    #[prost(message, optional, tag="2")]
    pub config: ::core::option::Option<Config>,
    #[prost(message, optional, tag="3")]
    pub operation_params: ::core::option::Option<super::operations::OperationParams>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AlterNodeResponse {
    #[prost(message, optional, tag="1")]
    pub operation: ::core::option::Option<super::operations::Operation>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DropNodeRequest {
    #[prost(string, tag="1")]
    pub path: ::prost::alloc::string::String,
    #[prost(message, optional, tag="2")]
    pub operation_params: ::core::option::Option<super::operations::OperationParams>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DropNodeResponse {
    #[prost(message, optional, tag="1")]
    pub operation: ::core::option::Option<super::operations::Operation>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DescribeNodeRequest {
    #[prost(string, tag="1")]
    pub path: ::prost::alloc::string::String,
    #[prost(message, optional, tag="2")]
    pub operation_params: ::core::option::Option<super::operations::OperationParams>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DescribeNodeResponse {
    #[prost(message, optional, tag="1")]
    pub operation: ::core::option::Option<super::operations::Operation>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DescribeNodeResult {
    #[prost(message, optional, tag="1")]
    pub self_: ::core::option::Option<super::scheme::Entry>,
    #[prost(message, optional, tag="2")]
    pub config: ::core::option::Option<Config>,
}
///*
/// Consistency mode
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum ConsistencyMode {
    /// The default or current value
    Unset = 0,
    /// Strict mode makes sure operations may only complete on current leader
    Strict = 1,
    /// Relaxed mode allows operations to complete on stale masters
    Relaxed = 2,
}
///*
/// Counters mode
#[derive(serde::Serialize, serde::Deserialize)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum RateLimiterCountersMode {
    /// The default or current value
    Unset = 0,
    /// Aggregated counters for resource tree
    Aggregated = 1,
    /// Counters on every resource
    Detailed = 2,
}