use yaxpeax_superh::{SuperHInstruction, SuperHRegister, SuperHDecoder};
use yaxpeax_arch::{Decoder, U8Reader};


#[test]
fn endianness() {
    assert_eq!(SuperHDecoder { little_endian: true, ..Default::default() }.decode(&mut U8Reader::new(&[0x69, 0xE4])),
               Ok(SuperHInstruction::MovImm(0x69, SuperHRegister::R4)));
    assert_eq!(SuperHDecoder { little_endian: false, ..Default::default() }.decode(&mut U8Reader::new(&[0xE4, 0x69])),
               Ok(SuperHInstruction::MovImm(0x69, SuperHRegister::R4)));
}
