extern crate yaxpeax_superh;

use yaxpeax_superh::{SuperHFloatRegister, SuperHInstruction, SuperHRegister, Displacement8};


#[test]
fn round_trip() {
    for i in 0..=0xFFFF {
        for &fpscr_sz in &[true, false] {
            if let Some(ins) = SuperHInstruction::parse(i, fpscr_sz) {
                let rt: u16 = ins.into();
                assert_eq!(rt, i as u16, "{:#06X} !+ {:#06X} for {:?}", rt, i as u16, ins);
            }
        }
    }
}

#[test]
fn display() {
    assert_eq!(format!("{}", SuperHInstruction::MovImm(0x69, SuperHRegister::R4)), "MOV #105,R4"); // Agrees with objdump
    assert_eq!(format!("{}", SuperHInstruction::Bf(Displacement8(0xFD))), "BF 253");
    assert_eq!(format!("{}", SuperHInstruction::FMovAtIndexedRegisterS(SuperHRegister::R2, SuperHFloatRegister::Fr3)), "FMOV.S @(R0,R2),FR3");
}


mod generated_f64 {
    use yaxpeax_superh::{SuperHInstruction, SuperHRegister, SuperHRegisterBank, SuperHFloatRegister, SuperHVectorFloatRegister, SuperHDoubleRegister,
                         SuperHExtendedDoubleRegister, Displacement4, Displacement8, Displacement12};
    include!("instruction_map-with-overrides.rs");
}

mod generated_no_f64 {
    use yaxpeax_superh::{SuperHInstruction, SuperHRegister, SuperHRegisterBank, SuperHFloatRegister, SuperHVectorFloatRegister, SuperHDoubleRegister,
                         Displacement4, Displacement8, Displacement12};
    include!("instruction_map-unoverriden.rs");
}

#[test]
fn decode_f64() {
    for (i, &ins) in generated_f64::MAPPING.iter().enumerate() {
        assert_eq!(SuperHInstruction::parse(i as u16, true), ins);
    }
}

#[test]
fn decode_no_f64() {
    for (i, &ins) in generated_no_f64::MAPPING.iter().enumerate() {
        assert_eq!(SuperHInstruction::parse(i as u16, false), ins);
    }
}
