use yaxpeax_superh::{SuperHInstruction, SuperHRegister, SuperHDecoder};
use yaxpeax_arch::Decoder;


#[test]
fn endianness() {
    assert_eq!(SuperHDecoder { little_endian: true, ..Default::default() }.decode([0x69, 0xE4].iter().copied()),
               Ok(SuperHInstruction::MovImm(0x69, SuperHRegister::R4)));
    assert_eq!(SuperHDecoder { little_endian: false, ..Default::default() }.decode([0xE4, 0x69].iter().copied()),
               Ok(SuperHInstruction::MovImm(0x69, SuperHRegister::R4)));
}
