pub static MAPPING: [Option<SuperHInstruction>; 0xFFFF] = [
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R0)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R0)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    Some(SuperHInstruction::ClrT),  // CLRT (0 → `T`) `0000000000001000`
    Some(SuperHInstruction::Nop),  // NOP (No operation) `0000000000001001`
    Some(SuperHInstruction::StsMach(SuperHRegister::R0)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    Some(SuperHInstruction::Rts),  // RTS (Delayed branch; `PR` → `PC`) `0000000000001011`
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R0)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    Some(SuperHInstruction::SetT),  // SETT (1 → `T`) `0000000000011000`
    Some(SuperHInstruction::Div0U),  // DIV0U (0 → `M`/`Q`/`T`) `0000000000011001`
    Some(SuperHInstruction::StsMacl(SuperHRegister::R0)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    Some(SuperHInstruction::Sleep),  // SLEEP (Sleep or standby) `0000000000011011`
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R0)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R0)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    Some(SuperHInstruction::ClrMac),  // CLRMAC (0 → `MACH`, `MACL`) `0000000000101000`
    Some(SuperHInstruction::Movt(SuperHRegister::R0)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R0)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    Some(SuperHInstruction::Rte),  // RTE (Delayed branch; `SSR/SPC` → `SR/PC`) `0000000000101011`
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R0)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    Some(SuperHInstruction::Ldtlb),  // LDTLB (`PTEH/PTEL` → `TLB`) `0000000000111000`
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R0)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R0)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    Some(SuperHInstruction::ClrS),  // CLRS (0 → `S`) `0000000001001000`
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    Some(SuperHInstruction::SetS),  // SETS (1 → `S`) `0000000001011000`
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R0)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R0)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R0)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R0)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R0)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R0)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R0)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R0)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R0)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R0)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R0)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R0)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R0)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R0)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R0)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R0)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R0)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R0)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R0)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R0)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R0)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R0)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R0)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R0)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R1)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R1)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R1)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R1)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R1)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R1)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R1)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R1)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R1)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R1)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R1)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R1)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R1)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R1)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R1)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R1)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R1)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R1)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R1)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R1)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R1)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R1)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R1)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R1)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R1)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R1)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R1)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R1)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R1)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R1)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R1)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R1)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R1)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R1)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R1)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R1)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R2)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R2)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R2)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R2)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R2)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R2)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R2)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R2)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R2)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R2)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R2)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R2)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R2)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R2)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R2)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R2)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R2)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R2)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R2)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R2)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R2)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R2)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R2)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R2)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R2)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R2)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R2)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R2)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R2)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R2)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R2)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R2)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R2)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R2)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R2)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R2)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R3)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R3)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R3)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R3)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R3)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R3)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R3)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R3)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R3)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R3)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R3)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R3)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R3)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R3)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R3)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R3)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R3)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R3)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R3)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R3)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R3)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R3)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R3)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R3)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R3)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R3)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R3)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R3)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R3)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R3)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R3)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R3)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R3)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R3)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R3)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R3)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R4)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R4)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R4)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R4)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R4)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R4)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R4)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R4)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R4)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R4)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R4)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R4)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R4)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R4)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R4)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R4)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R4)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R4)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R4)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R4)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R4)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R4)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R4)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R4)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R4)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R4)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R4)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R4)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R4)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R4)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R4)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R4)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R4)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R4)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R4)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R4)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R5)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R5)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R5)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R5)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R5)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R5)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R5)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R5)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R5)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R5)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R5)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R5)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R5)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R5)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R5)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R5)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R5)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R5)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R5)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R5)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R5)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R5)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R5)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R5)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R5)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R5)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R5)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R5)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R5)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R5)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R5)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R5)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R5)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R5)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R5)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R5)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R6)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R6)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R6)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R6)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R6)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R6)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R6)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R6)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R6)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R6)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R6)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R6)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R6)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R6)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R6)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R6)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R6)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R6)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R6)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R6)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R6)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R6)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R6)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R6)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R6)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R6)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R6)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R6)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R6)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R6)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R6)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R6)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R6)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R6)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R6)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R6)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R7)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R7)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R7)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R7)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R7)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R7)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R7)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R7)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R7)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R7)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R7)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R7)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R7)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R7)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R7)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R7)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R7)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R7)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R7)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R7)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R7)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R7)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R7)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R7)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R7)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R7)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R7)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R7)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R7)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R7)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R7)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R7)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R7)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R7)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R7)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R7)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R8)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R8)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R8)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R8)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R8)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R8)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R8)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R8)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R8)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R8)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R8)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R8)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R8)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R8)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R8)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R8)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R8)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R8)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R8)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R8)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R8)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R8)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R8)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R8)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R8)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R8)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R8)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R8)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R8)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R8)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R8)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R8)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R8)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R8)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R8)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R8)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R9)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R9)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R9)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R9)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R9)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R9)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R9)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R9)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R9)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R9)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R9)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R9)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R9)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R9)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R9)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R9)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R9)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R9)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R9)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R9)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R9)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R9)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R9)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R9)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R9)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R9)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R9)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R9)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R9)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R9)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R9)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R9)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R9)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R9)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R9)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R9)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R10)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R10)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R10)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R10)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R10)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R10)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R10)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R10)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R10)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R10)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R10)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R10)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R10)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R10)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R10)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R10)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R10)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R10)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R10)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R10)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R10)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R10)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R10)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R10)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R10)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R10)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R10)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R10)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R10)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R10)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R10)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R10)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R10)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R10)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R10)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R10)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R11)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R11)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R11)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R11)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R11)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R11)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R11)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R11)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R11)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R11)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R11)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R11)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R11)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R11)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R11)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R11)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R11)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R11)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R11)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R11)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R11)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R11)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R11)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R11)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R11)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R11)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R11)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R11)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R11)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R11)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R11)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R11)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R11)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R11)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R11)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R11)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R12)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R12)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R12)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R12)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R12)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R12)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R12)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R12)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R12)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R12)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R12)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R12)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R12)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R12)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R12)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R12)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R12)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R12)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R12)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R12)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R12)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R12)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R12)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R12)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R12)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R12)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R12)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R12)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R12)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R12)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R12)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R12)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R12)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R12)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R12)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R12)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R13)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R13)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R13)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R13)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R13)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R13)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R13)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R13)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R13)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R13)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R13)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R13)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R13)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R13)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R13)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R13)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R13)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R13)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R13)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R13)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R13)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R13)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R13)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R13)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R13)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R13)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R13)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R13)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R13)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R13)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R13)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R13)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R13)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R13)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R13)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R13)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R14)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R14)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R14)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R14)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R14)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R14)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R14)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R14)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R14)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R14)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R14)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R14)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R14)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R14)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R14)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R14)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R14)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R14)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R14)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R14)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R14)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R14)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R14)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R14)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R14)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R14)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R14)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R14)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R14)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R14)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R14)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R14)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R14)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R14)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R14)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R14)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSr(SuperHRegister::R15)),  // STC SR,Rn (`SR` → `Rn`) `0000nnnn00000010`
    Some(SuperHInstruction::BsrF(SuperHRegister::R15)),  // BSR Rn (Delayed branch; `PC + 4` → `PR`, `Rn + PC + 4` → `PC`) `0000nnnn00000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R0, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMach(SuperHRegister::R15)),  // STS MACH,Rn (`MACH` → `Rn`) `0000nnnn00001010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R0, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R0, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R0, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R0, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcGbr(SuperHRegister::R15)),  // STC GBR,Rn (`GBR` → `Rn`) `0000nnnn00010010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R1, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsMacl(SuperHRegister::R15)),  // STS MACL,Rn (`MACL` → `Rn`) `0000nnnn00011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R1, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R1, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R1, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R1, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcVbr(SuperHRegister::R15)),  // STC VBR,Rn (`VBR` → `Rn`) `0000nnnn00100010`
    Some(SuperHInstruction::BraF(SuperHRegister::R15)),  // BRA Rn (Delayed branch; `Rn + PC + 4` → `PC`) `0000nnnn00100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R2, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    Some(SuperHInstruction::Movt(SuperHRegister::R15)),  // MOVT Rn (`T` → `Rn`) `0000nnnn00101001`
    Some(SuperHInstruction::StsPr(SuperHRegister::R15)),  // STS PR,Rn (`PR` → `Rn`) `0000nnnn00101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R2, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R2, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R2, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R2, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSsr(SuperHRegister::R15)),  // STC SSR,Rn (`SSR` → `Rn`) `0000nnnn00110010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R3, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcSgr(SuperHRegister::R15)),  // STC SGR,Rn (`SGR` → `Rn`) `0000nnnn00111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R3, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R3, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R3, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R3, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcSpc(SuperHRegister::R15)),  // STC SPC,Rn (`SPC` → `Rn`) `0000nnnn01000010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R4, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R4, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R4, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R4, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R4, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R5, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpul(SuperHRegister::R15)),  // STS FPUL,Rn (`FPUL` → `Rn`) `0000nnnn01011010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R5, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R5, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R5, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R5, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R6, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StsFpscr(SuperHRegister::R15)),  // STS FPSCR,Rn (`FPSCR` → `Rn`) `0000nnnn01101010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R6, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R6, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R6, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R6, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R7, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R7, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R7, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R7, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R7, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R0Bank, SuperHRegister::R15)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::Pref(SuperHRegister::R15)),  // PREF @Rn (`(Rn)` → operand cache) `0000nnnn10000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R8, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R8, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R8, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R8, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R8, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R1Bank, SuperHRegister::R15)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbI(SuperHRegister::R15)),  // OCBI @Rn (Invalidates operand cache block) `0000nnnn10010011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R9, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R9, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R9, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R9, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R9, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R2Bank, SuperHRegister::R15)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbP(SuperHRegister::R15)),  // OCBP @Rn (Writes back and invalidates operand cache block) `0000nnnn10100011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R10, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R10, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R10, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R10, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R10, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R3Bank, SuperHRegister::R15)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::OcbWb(SuperHRegister::R15)),  // OCBWB @Rn (Writes back operand cache block) `0000nnnn10110011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R11, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R11, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R11, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R11, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R11, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R4Bank, SuperHRegister::R15)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    Some(SuperHInstruction::MovcaL(SuperHRegister::R15)),  // MOVCA.L R0,@Rn (`R0` → `(Rn)` (without fetchingcache block)) `0000nnnn11000011`
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R12, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R12, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R12, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R12, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R12, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R5Bank, SuperHRegister::R15)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R13, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R13, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R13, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R13, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R13, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R6Bank, SuperHRegister::R15)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R14, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    None,
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R14, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R14, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R14, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R14, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    None,
    None,
    Some(SuperHInstruction::StcRmBank(SuperHRegisterBank::R7Bank, SuperHRegister::R15)),  // STC Rm_BANK,Rn (`Rm_BANK` → `Rn` (`m` = 0 to 7)) `0000nnnn1mmm0010`
    None,
    Some(SuperHInstruction::MovToAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R15)),  // MOV.B Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0100`
    Some(SuperHInstruction::MovToAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R15)),  // MOV.W Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0101`
    Some(SuperHInstruction::MovToAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R15)),  // MOV.L Rm,@(R0,Rn) (`Rm` → `(R0 + Rn)`) `0000nnnnmmmm0110`
    Some(SuperHInstruction::MulL(SuperHRegister::R15, SuperHRegister::R15)),  // MAC.L Rm,Rn (`Rn * Rm` → `MACL`, 32 * 32→ 32 bits) `0000nnnnmmmm0111`
    None,
    None,
    Some(SuperHInstruction::StcDbr(SuperHRegister::R15)),  // STC DBR,Rn (`DBR` → `Rn`) `0000nnnn11111010`
    None,
    Some(SuperHInstruction::MovFromAtIndexedRegisterB(SuperHRegister::R15, SuperHRegister::R15)),  // MOV.B @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1100`
    Some(SuperHInstruction::MovFromAtIndexedRegisterW(SuperHRegister::R15, SuperHRegister::R15)),  // MOV.W @(R0,Rm),Rn (`(R0 + Rm)` → sign extension → `Rn`) `0000nnnnmmmm1101`
    Some(SuperHInstruction::MovFromAtIndexedRegisterL(SuperHRegister::R15, SuperHRegister::R15)),  // MOV.L @(R0,Rm),Rn (`(R0 + Rm)` → `Rn`) `0000nnnnmmmm1110`
    Some(SuperHInstruction::MacL(SuperHRegister::R15, SuperHRegister::R15)),  // MAC.L @Rm+,@Rn+ (Signed, `(Rn) * (Rm) + MAC` → `MAC`, `Rn + 4` → `Rn`, `Rm + 4` → Rm`; 32 * 32 + 64 → 64 bits) `0000nnnnmmmm1111`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R0)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R1)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R2)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R3)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R4)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R5)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R6)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R7)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R8)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R9)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R10)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R4, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R5, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R6, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R7, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R8, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R9, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R10, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R11, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R12, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R13, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R14, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x0), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x1), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x2), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x3), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x4), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x5), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x6), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x7), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x8), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0x9), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xA), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xB), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xC), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xD), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xE), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R15, Displacement4(0xF), SuperHRegister::R11)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x0), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x1), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x2), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x3), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x4), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x5), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x6), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x7), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x8), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0x9), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xA), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xB), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xC), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xD), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xE), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R0, Displacement4(0xF), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x0), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x1), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x2), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x3), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x4), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x5), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x6), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x7), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x8), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0x9), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xA), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xB), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xC), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xD), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xE), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R1, Displacement4(0xF), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x0), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x1), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x2), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x3), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x4), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x5), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x6), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x7), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x8), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0x9), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xA), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xB), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xC), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xD), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xE), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R2, Displacement4(0xF), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x0), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x1), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x2), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x3), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::MovToAtDisplacedRegisterL(SuperHRegister::R3, Displacement4(0x4), SuperHRegister::R12)),  // MOV.L Rm,@(disp,Rn) (`Rm` → `(disp * 4 + Rn)`) `0001nnnnmmmmdddd`
    Some(SuperHInstruction::Mov