use colored::Colorize;

#[derive(Debug)]
pub enum Event {
    Info,
    Warning,
    Error,
    Success,
}

pub fn info(msg: String) {
    output(Event::Info, msg);
}
pub fn warn(msg: String) {
    output(Event::Warning, msg);
}
pub fn error(msg: String) {
    output(Event::Error, msg);
}
pub fn success(msg: String) {
    output(Event::Success, msg);
}

fn output(event: Event, msg: String) {
    match event {
        Event::Error => println!("[{0}] {1}", "ERR".red(), msg),
        Event::Warning => println!("[{0}] {1}", "WARN".yellow(), msg),
        Event::Info => println!("[{0}] {1}", "MSG".blue(), msg),
        Event::Success => println!("[{0}] {1}", "SUCCESS".green(), msg),
        _ => {
            println!("Event broken, please submit issue on https://github.com/limeyteam/rsh_shell/issues")
        }
    }
}