// TODO: return commands for printing
mod commands;
mod utils;
mod message;
use utils::input;
use colored::Colorize;
use colored::ColoredString;
use std::process;

#[derive(Debug)]
pub struct ShellInstance {
    commands: Vec<String>,
	exit_error_code: i32
}

impl ShellInstance {
    pub fn new() -> Self {
        Self {
            commands: vec![String::from("help"), String::from("uname")],
			exit_error_code: 0
        }
    }
}

fn main() {
    let inst = ShellInstance::new();
	loop {
		let x = input_imp();
        match &x[..] {
			"help" => commands::help(&inst),
            "uname" => commands::uname(),
			"exit" => process::exit(inst.exit_error_code),
			"" => continue,
			_ => message::error(String::from("INT Command not found, Internal Error 643"))
		}
	}
    commands::help(&inst);
}

fn input_imp() -> String {
	print!("{1}{0}", "> ".green(), ret_nm());
    return input();
}

fn ret_nm() -> String {
	return String::from("yash");
}