# yasgs

---
## About

yet another sudoku game solver

this lib will solve sudokus, but it will not only work on "standard" 9x9 sudokus,\
but also on a 4x4, 16x16, 25x25, 36x36 and 49x49 sudoku.



---
## Usage

the lib pubilshes function solve, taking asking for 2 parameters:
- an input string-lteral, describing the sudoko
- a usize-number, sepcifying how much solutions should be generated (if possible)

the results will re-use the format of the input ( e.g.: borders, newlines, spaces will be kept ).\
use this "alphabete" to specify the state of the cells (you can use '0' instead of '.', as well):\
.123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWYXZ

add yasgs into the Cargo.toml of your project


```
fn main() {
    println!("Solutions found:");
    for solution in yasgs::solve("34.. 12.. ...3 ....", 5) {
        // there are only 3 solutions
        println!("  {}", solution);    
    }

    let sudoku = "  6 . .  . . .  . . 1
    . 2 7  6 9 .  . . .
    . . 8  . . .  . 3 7
   
    . . .  5 . .  8 . .
    . . 5  9 . 7  1 . .
    . . 6  . . 2  . . .
   
    8 9 .  . . .  7 . .
    . . .  . 8 6  9 1 .
    3 . .  . . .  . . 2
   ";
   println!("\nSudoku:\n  {}", &sudoku);
   for solution in yasgs::solve(&sudoku, 1) {
    println!("Solution:\n  {}", solution);    
    }

        let sudoku = "╔═══════════╦═══════════╦═══════════╗
  ║ 5 │ . │ . ║ . │ . │ 2 ║ . │ . │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ . │ . ║ . │ . │ . ║ 3 │ 9 │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ 2 │ . │ 8 ║ 4 │ . │ 6 ║ . │ . │ . ║
  ╠═══════════╬═══════════╬═══════════╣
  ║ . │ 9 │ . ║ 5 │ 3 │ . ║ . │ . │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ 6 │ 5 ║ . │ . │ . ║ . │ . │ 8 ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ 8 │ . ║ . │ . │ . ║ 9 │ . │ 3 ║
  ╠═══════════╬═══════════╬═══════════╣
  ║ 6 │ . │ 4 ║ . │ . │ . ║ 7 │ . │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ . │ . ║ . │ . │ . ║ 2 │ 1 │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ . │ . ║ 2 │ 7 │ 4 ║ . │ . │ . ║
  ╚═══════════╩═══════════╩═══════════╝";
   println!("\nSudoku:\n  {}", &sudoku);
   for solution in yasgs::solve(&sudoku, 1) {
    println!("Solution:\n  {}", solution);    
    }
}
```
will then create this output:
```
Solutions found:
  3412 1234 2143 4321
  3412 1234 4123 2341
  3421 1234 2143 4312

Sudoku:
    6 . .  . . .  . . 1
    . 2 7  6 9 .  . . .
    . . 8  . . .  . 3 7
   
    . . .  5 . .  8 . .
    . . 5  9 . 7  1 . .
    . . 6  . . 2  . . .
   
    8 9 .  . . .  7 . .
    . . .  . 8 6  9 1 .
    3 . .  . . .  . . 2
   
Solution:
    6 5 3  4 7 8  2 9 1
    1 2 7  6 9 3  5 4 8
    9 4 8  1 2 5  6 3 7
   
    2 3 9  5 6 1  8 7 4
    4 8 5  9 3 7  1 2 6
    7 1 6  8 4 2  3 5 9
   
    8 9 2  3 1 4  7 6 5
    5 7 4  2 8 6  9 1 3
    3 6 1  7 5 9  4 8 2


Sudoku:
  ╔═══════════╦═══════════╦═══════════╗
  ║ 5 │ . │ . ║ . │ . │ 2 ║ . │ . │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ . │ . ║ . │ . │ . ║ 3 │ 9 │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ 2 │ . │ 8 ║ 4 │ . │ 6 ║ . │ . │ . ║
  ╠═══════════╬═══════════╬═══════════╣
  ║ . │ 9 │ . ║ 5 │ 3 │ . ║ . │ . │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ 6 │ 5 ║ . │ . │ . ║ . │ . │ 8 ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ 8 │ . ║ . │ . │ . ║ 9 │ . │ 3 ║
  ╠═══════════╬═══════════╬═══════════╣
  ║ 6 │ . │ 4 ║ . │ . │ . ║ 7 │ . │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ . │ . ║ . │ . │ . ║ 2 │ 1 │ . ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ . │ . │ . ║ 2 │ 7 │ 4 ║ . │ . │ . ║
  ╚═══════════╩═══════════╩═══════════╝
Solution:
  ╔═══════════╦═══════════╦═══════════╗
  ║ 5 │ 7 │ 9 ║ 3 │ 1 │ 2 ║ 4 │ 8 │ 6 ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ 1 │ 4 │ 6 ║ 8 │ 5 │ 7 ║ 3 │ 9 │ 2 ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ 2 │ 3 │ 8 ║ 4 │ 9 │ 6 ║ 5 │ 7 │ 1 ║
  ╠═══════════╬═══════════╬═══════════╣
  ║ 4 │ 9 │ 1 ║ 5 │ 3 │ 8 ║ 6 │ 2 │ 7 ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ 3 │ 6 │ 5 ║ 7 │ 2 │ 9 ║ 1 │ 4 │ 8 ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ 7 │ 8 │ 2 ║ 6 │ 4 │ 1 ║ 9 │ 5 │ 3 ║
  ╠═══════════╬═══════════╬═══════════╣
  ║ 6 │ 2 │ 4 ║ 1 │ 8 │ 5 ║ 7 │ 3 │ 9 ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ 8 │ 5 │ 7 ║ 9 │ 6 │ 3 ║ 2 │ 1 │ 4 ║
  ║───┼───┼───║───┼───┼───║───┼───┼───║
  ║ 9 │ 1 │ 3 ║ 2 │ 7 │ 4 ║ 8 │ 6 │ 5 ║
  ╚═══════════╩═══════════╩═══════════╝
```
---
## Greetings

Thank you too everyone who participated in the development of rust, cargo, atom or any crate.
