// use yap::{ Tokens, IntoTokens };
// use std::collections::HashMap;

// enum Value {
//     Number(f64),
//     String(String),
//     Bool(bool),
//     Array(Vec<Value>),
//     Object(HashMap<String,Value>)
// }

// enum Error {
//     InvalidJson,
//     Array(ArrayError),
//     String(StringError),
//     Object(ObjectError),
// }

// fn json(toks: impl Tokens<Item=char>) -> Result<Value, Error> {
//     match value(toks) {
//         // Invalid JSON; expecting [, {, etc.
//         None => Err(Error::InvalidJson),
//         // We began parsing a string/array/whatever but it was malformed
//         Some(Err(e)) => Err(e),
//         // We successfully parsed our JSON; here it is!
//         Some(Ok(res)) => Ok(res)
//     }
// }

// fn value(mut toks: impl Tokens<Item=char>) -> Option<Result<Value, Error>> {
//     yap::one_of!(toks;
//         array(toks).map(|v| v.map(Value::Array).map_err(Error::Array)),
//         string(toks).map(|v| v.map(Value::String).map_err(Error::String)),
//         bool(toks).map(|v| Ok(Value::Bool(v))),
//         number(toks).map(|v| Ok(Value::Number(v))),
//         object(toks).map(|v| v.map(Value::Object).map_err(Error::Object))
//     )
// }

// fn skip_whitespace(mut toks: impl Tokens<Item=char>) {
//     toks.skip_tokens_while(|c| c.is_ascii_whitespace());
// }

// fn field_separator(mut toks: impl Tokens<Item=char>) -> bool {
//     toks.surrounded_by(
//         |t| t.token(','),
//         |t| skip_whitespace(t)
//     )
// }

// enum ArrayError {
//     InputFinishedButArrayNotClosed,
//     FailedToParseValue(Box<Error>)
// }

// fn array(mut toks: impl Tokens<Item=char>) -> Option<Result<Vec<Value>,ArrayError>> {
//     if !toks.token('[') {
//         return None;
//     }
//     skip_whitespace(&mut toks);

//     let values: Result<Vec<Value>,Error> = toks.sep_by(
//         |t| value(t),
//         |t| field_separator(t)
//     ).collect();

//     skip_whitespace(&mut toks);
//     if !toks.token(']') {
//         return Some(Err(ArrayError::InputFinishedButArrayNotClosed));
//     }
//     Some(values.map_err(|e| ArrayError::FailedToParseValue(Box::new(e))))
// }

// enum ObjectError {
//     InputFinishedButObjectNotClosed,
//     FailedToParseValue(Box<Error>)
// }

// fn object(mut toks: impl Tokens<Item=char>) -> Option<Result<HashMap<String,Value>,ObjectError>> {
//     if !toks.token('{') {
//         return None;
//     }
//     skip_whitespace(&mut toks);

//     let values: Result<HashMap<String,Value>,Error> = toks.sep_by_err(
//         |t| {
//             let field = string(t)?;
//             value(t)
//         },
//         |t| field_separator(t)
//     ).collect();

//     skip_whitespace(&mut toks);
//     if !toks.token('}') {
//         return Some(Err(ObjectError::InputFinishedButObjectNotClosed));
//     }
//     Some(values.map_err(|e| ObjectError::FailedToParseValue(Box::new(e))))
// }

// enum StringError {
//     InputFinishedButStringNotClosed
// }

// fn string(mut toks: impl Tokens<Item=char>) -> Option<Result<String,StringError>> {
//     if !toks.token('"') {
//         return None;
//     }
//     // Ignoring escape sequences and such:
//     let s = toks.tokens_while(|&c| c != '"').collect();
//     // There must be a closing token now, or else no more input:
//     if !toks.token('"') {
//         return Some(Err(StringError::InputFinishedButStringNotClosed));
//     }
//     Some(Ok(s))
// }

// fn bool(mut toks: impl Tokens<Item=char>) -> Option<bool> {
//     if toks.tokens("true".chars()) {
//         Some(true)
//     } else if toks.tokens("false".chars()) {
//         Some(false)
//     } else {
//         None
//     }
// }

// fn number(mut toks: impl Tokens<Item=char>) -> Option<f64> {
//     // If anything fails, we consume nothing.
//     toks.optional(|toks| {
//         let start_pos = toks.location();
    
//         // We basically want to check for a number without actually
//         // doing anything with the tokens; we'll grab all of the matching
//         // tokens at once afterwards.
    
//         // Maybe it starts with a minus sign.
//         toks.token('-');
    
//         // Now, skip over digits. If none, then this isn't an number.
//         let num_digits = toks.skip_tokens_while(|c| c.is_numeric());
//         if num_digits == 0 {
//             return None
//         }
    
//         // Next, optionally look for a '.' followed by 1 or more digits.
//         toks.optional(|toks| {
//             if !toks.token('.') {
//                 return None;
//             }
//             let num_digits = toks.tokens_while(|c| c.is_numeric()).count();
//             if num_digits == 0 {
//                 None
//             } else {
//                 Some(())
//             }
//         });
    
//         // Grab our numeric digits at once and parse:
//         let end_pos = toks.location();
//         let n_str: String = toks.iter_from_to(start_pos, end_pos).collect();
//         n_str.parse().ok()
//     })
// }

fn main() {

}