use serde::{Deserialize, Serialize};

#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
#[serde(rename_all = "SCREAMING_SNAKE_CASE")]
pub enum RejectionReason {
    UnsolicitedService,
    BadService,
    IncorrectAmount,
}

impl Default for RejectionReason {
    fn default() -> Self {
        RejectionReason::UnsolicitedService
    }
}
