/*
 * Yagna Market API
 *
 * The version of the OpenAPI document: 1.6.1
 *
 * Generated by: https://openapi-generator.tech
 */

use chrono::{DateTime, Utc};
use serde::{Deserialize, Serialize};

use crate::market::Reason;

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AgreementOperationEvent {
    #[serde(rename = "eventDate")]
    pub event_date: DateTime<Utc>,
    #[serde(rename = "agreementId")]
    pub agreement_id: String,
    #[serde(flatten)]
    pub event_type: AgreementEventType,
}

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[non_exhaustive]
#[serde(tag = "eventtype")]
pub enum AgreementEventType {
    #[serde(rename = "AgreementApprovedEvent")]
    AgreementApprovedEvent,
    #[serde(rename = "AgreementRejectedEvent")]
    AgreementRejectedEvent {
        #[serde(rename = "reason", skip_serializing_if = "Option::is_none")]
        reason: Option<Reason>,
    },
    #[serde(rename = "AgreementCancelledEvent")]
    AgreementCancelledEvent {
        #[serde(rename = "reason", skip_serializing_if = "Option::is_none")]
        reason: Option<Reason>,
    },
    #[serde(rename = "AgreementTerminatedEvent")]
    AgreementTerminatedEvent {
        #[serde(rename = "terminator")]
        terminator: AgreementTerminator,
        #[serde(rename = "signature")]
        signature: String,
        #[serde(rename = "reason", skip_serializing_if = "Option::is_none")]
        reason: Option<Reason>,
    },
}

#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum AgreementTerminator {
    #[serde(rename = "Requestor")]
    Requestor,
    #[serde(rename = "Provider")]
    Provider,
}
