# Contributing to Xshe

Thank you for deciding to contribute!

If you want to request features or report bugs, we welcome [opening issues][open an issue].

Pull requests and code contributions are also welcomed!
If you are submitting a pull request with any substantial changes, [open an issue] first and link the pull request to it.

When contributing to this repository, please first search all issues and pull requests for your change.

Please note we have a [Code of Conduct], please follow it in all your interactions with the project.

## Coding conventions

  * Indent code by four spaces and markup files with two spaces.
  * Try to maintain the coding style of the surronding code you are working on.
  * Leave plenty of comments that explain what your additions do.
  * Style code with [rustfmt](https://github.com/rust-lang/rustfmt) before submitting code (run `cargo fmt`).
  * Check code with [Clippy](https://github.com/rust-lang/rust-clippy) (run `cargo clippy`).
  * Write clear commit messages.

[open an issue]: https://github.com/superatomic/xshe/issues/new/choose
[Code of Conduct]: https://github.com/superatomic/xshe/blob/main/.github/CODE_OF_CONDUCT.md

## Legal

This project is licensed under either of
Apache License, Version 2.0 ([LICENSE-APACHE](LICENSE-APACHE.txt))
or MIT license ([LICENSE-MIT](LICENSE-MIT.txt)), at your option.

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be dual licensed as above, without any
additional terms or conditions.

<https://www.apache.org/licenses/LICENSE-2.0>, <https://opensource.org/licenses/MIT>
