/// Driver for json

fn json_to_string(j: &JsonValue) -> String {
  match j {
      JsonValue::Null => {
	  "{}".to_string()
      }
      JsonValue::Short(s) => {
        s.to_string()
      }
      JsonValue::Number(s) => {
        s.to_string()
      }
      JsonValue::Boolean(s) => {
        s.to_string()
      }
      JsonValue::String(s) => {
        s.to_string()
      }
      JsonValue::Object(_) => {
        j.entries()
	  .map(|(_, v)| json_to_xml(v))
	  .fold(String::new(), |a, i| a + i.as_str())
      }
      JsonValue::Array(a) => {
        a.iter().fold(String::new(), |a, i| a + json_to_xml(i).as_str())
      }
  }
}
fn json_to_xml(j: &JsonValue) -> String {
  match j {
      JsonValue::Null => {
	  "{}".to_string()
      }
      JsonValue::Short(s) => {
        s.to_string()
      }
      JsonValue::Number(s) => {
        s.to_string()
      }
      JsonValue::Boolean(s) => {
        s.to_string()
      }
      JsonValue::String(s) => {
        s.to_string()
      }
      JsonValue::Object(_) => {
        j.entries()
	  .map(|(k, v)| format!("<{}>{}</{}>", k, json_to_xml(v), k))
	  .fold(String::new(), |a, i| a + i.as_str())
      }
      JsonValue::Array(a) => {
        a.iter().fold(String::new(), |a, i| a + json_to_xml(i).as_str())
      }
  }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn json_value() {
      let i = Item::JsonValue(JsonValue::String("this is json".to_string()));
      assert_eq!(i.to_string(), "this is json");
      assert_eq!(i.to_xml(), "this is json");
      assert_eq!(i.to_json(), "\"this is json\"")
    }
}

