use crate::core::types::amount::IssuedCurrency;
use alloc::string::String;
use serde::Deserialize;

#[derive(Debug, Deserialize, Clone)]
pub struct IOUCase(pub(crate) IssuedCurrency, pub(crate) String);

pub const TEST_XRP_CASES: [(&str, &str); 2] = [
    ("100", "4000000000000064"),
    ("100000000000000000", "416345785D8A0000"),
];

pub const TEST_PATH_SET_BUFFER: &str = "31585E1F3BD02A15D6\
185F8BB9B57CC60DEDDB37C10000000000000000000000004254430000000000\
585E1F3BD02A15D6185F8BB9B57CC60DEDDB37C131E4FE687C90257D3D2D694C\
8531CDEECBE84F33670000000000000000000000004254430000000000E4FE68\
7C90257D3D2D694C8531CDEECBE84F3367310A20B3C85F482532A9578DBB3950\
B85CA06594D100000000000000000000000042544300000000000A20B3C85F48\
2532A9578DBB3950B85CA06594D1300000000000000000000000005553440000\
0000000A20B3C85F482532A9578DBB3950B85CA06594D1FF31585E1F3BD02A15\
D6185F8BB9B57CC60DEDDB37C100000000000000000000000042544300000000\
00585E1F3BD02A15D6185F8BB9B57CC60DEDDB37C131E4FE687C90257D3D2D69\
4C8531CDEECBE84F33670000000000000000000000004254430000000000E4FE\
687C90257D3D2D694C8531CDEECBE84F33673115036E2D3F5437A83E5AC3CAEE\
34FF2C21DEB618000000000000000000000000425443000000000015036E2D3F\
5437A83E5AC3CAEE34FF2C21DEB6183000000000000000000000000055534400\
000000000A20B3C85F482532A9578DBB3950B85CA06594D1FF31585E1F3BD02A\
15D6185F8BB9B57CC60DEDDB37C1000000000000000000000000425443000000\
0000585E1F3BD02A15D6185F8BB9B57CC60DEDDB37C13157180C769B66D942EE\
69E6DCC940CA48D82337AD000000000000000000000000425443000000000057\
180C769B66D942EE69E6DCC940CA48D82337AD10000000000000000000000000\
00000000000000003000000000000000000000000055534400000000000A20B3\
C85F482532A9578DBB3950B85CA06594D100";

pub const TEST_PATH_BUFFER: &str = "31585E1F3BD02A15D6185F8BB9B5\
7CC60DEDDB37C10000000000000000000000004254430000000000585E1F3BD0\
2A15D6185F8BB9B57CC60DEDDB37C13157180C769B66D942EE69E6DCC940CA48\
D82337AD000000000000000000000000425443000000000057180C769B66D942\
EE69E6DCC940CA48D82337AD1000000000000000000000000000000000000000\
003000000000000000000000000055534400000000000A20B3C85F482532A957\
8DBB3950B85CA06594D1";

pub const TEST_PATH_STEP_BUFFER: [&str; 4] = [
    "31585E1F3BD02A15D6185F8BB9B57CC60DEDDB37C100000000000000000\
    00000004254430000000000585E1F3BD02A15D6185F8BB9B57CC60DEDDB37C1",
    "3157180C769B66D942EE69E6DCC940CA48D82337AD00000000000000000\
    0000000425443000000000057180C769B66D942EE69E6DCC940CA48D82337AD",
    "100000000000000000000000000000000000000000",
    "3000000000000000000000000055534400000000000A20B3C85F482532A\
    9578DBB3950B85CA06594D1",
];
