use xrpl_rs::{
    wallet::{Wallet},
    transports::HTTP,
    types::{
        BigInt,
    },
    XRPL,
};

#[tokio::main]
async fn main() {
    
    // Create a new XRPL client with the HTTP transport pointed at ripple testnet.
    let xrpl = XRPL::new(
        HTTP::builder()
            .with_endpoint("https://s.altnet.rippletest.net:51234/")
            .unwrap()
            .build()
            .unwrap(),
    );

    // Create wallet from secret
    let mut wallet =
        Wallet::from_secret("spFgCAbejxnqjkeBVjxJ4NBTRzHf9").unwrap();
    // address: rQUjc7rAsc26qnGtqaZdRMC6xAtz9mpJLo

    let signature = wallet.sign_payment_channel_claim("C079FDE149BABA4A706E8289312B24DC352667AD4797C18C013A955C84D7F89C".to_owned(), BigInt(100000000));
    println!("{:?}", signature);
    println!("{:?}", wallet.public_key())
}
