use xrpl_rs::{transports::HTTP, types::{BigInt, CurrencyAmount, submit::SubmitRequest, channels::ChannelVerifyRequest}, wallet::Wallet, XRPL, transaction::types::{PaymentChannelClaim, TF_CLOSE}};

#[tokio::main]
async fn main() {
    // Create a new XRPL client with the HTTP transport pointed at ripple testnet.
    let xrpl = XRPL::new(
        HTTP::builder()
            .with_endpoint("https://s.altnet.rippletest.net:51234/")
            .unwrap()
            .build()
            .unwrap(),
    );

    // Create wallet from secret
    let mut wallet = Wallet::from_secret("spoaQBwqU4fZ43euykDwtnBHt8aJr").unwrap();
    // address: rhXqkowQZBjDTLYcfxDu8vXXaJE3WCXZzw

    // Verify
    let mut verify_claim = ChannelVerifyRequest::default();
    verify_claim.channel_id = "C079FDE149BABA4A706E8289312B24DC352667AD4797C18C013A955C84D7F89C".to_owned();
    verify_claim.signature = "3045022100F24C23106C7BDF3C2CD6FA2991BE2333645BE00E9522CB3B4BBF8ADD97CD7072022073F7AA1E72B388FEB1CCA0014ACEA892143E17B987CCBFDA7AD2F4CEA706EF8A".to_owned();
    verify_claim.amount = BigInt(100000000);
    verify_claim.public_key = "0393285ac2827240d69221ba24b0a4b433be74b18f622236dbf2e3141445a9d588".to_owned();

    let verify_res = xrpl.channel_verify(verify_claim).await.unwrap();

    println!("{:?}", verify_res);
    if !verify_res.signature_verified {
        return;
    }

    // Create a payment transaction.
    let mut pay_claim = PaymentChannelClaim::default();
    pay_claim.channel = "C079FDE149BABA4A706E8289312B24DC352667AD4797C18C013A955C84D7F89C".to_owned();
    pay_claim.signature = Some("3045022100F24C23106C7BDF3C2CD6FA2991BE2333645BE00E9522CB3B4BBF8ADD97CD7072022073F7AA1E72B388FEB1CCA0014ACEA892143E17B987CCBFDA7AD2F4CEA706EF8A".to_owned());
    pay_claim.amount = Some(BigInt(100000000));
    pay_claim.balance = Some(BigInt(100000000));
    pay_claim.public_key = Some("0393285ac2827240d69221ba24b0a4b433be74b18f622236dbf2e3141445a9d588".to_owned());

    // Convert the pay_chan into a transaction.
    let mut tx = pay_claim.into_transaction();

    let tx_blob = wallet
        .fill_and_sign(&mut tx, &xrpl)
        .await
        .expect("failed to sign");

    println!("Transaction: {:?}", tx);

    // Create a sign_and_submit request.
    let mut submit_req = SubmitRequest::default();
    submit_req.tx_blob = tx_blob;

    // Submit the transaction to the ledger.
    let submit_res = xrpl
        .submit(submit_req)
        .await
        .expect("failed to make submit request");
    println!("Got response to submit request: {:?}", submit_res);
}
