use xrpl_rs::{
    wallet::{Wallet},
    transaction::types::PaymentChannelCreate,
    transports::HTTP,
    types::{
        BigInt,
        account::AccountInfoRequest, submit::SubmitRequest, CurrencyAmount,
    },
    utils::testnet,
    XRPL,
};

#[tokio::main]
async fn main() {
    
    // Create a new XRPL client with the HTTP transport pointed at ripple testnet.
    let xrpl = XRPL::new(
        HTTP::builder()
            .with_endpoint("https://s.altnet.rippletest.net:51234/")
            .unwrap()
            .build()
            .unwrap(),
    );

    // Create wallet from secret
    let mut wallet =
        Wallet::from_secret("spFgCAbejxnqjkeBVjxJ4NBTRzHf9").unwrap();
    // address: rQUjc7rAsc26qnGtqaZdRMC6xAtz9mpJLo

    // Create a payment transaction.
    let mut pay_chan = PaymentChannelCreate::default();
    pay_chan.amount = BigInt(100000000);
    pay_chan.destination = "rJemfGPCkUiUvWyEhjpWmqaR1LMq2qkBW7".to_owned(); // Set the destination to the second account.
    pay_chan.public_key = wallet.public_key();
    
    // Convert the pay_chan into a transaction.
    let mut tx = pay_chan.into_transaction();

    let tx_blob = wallet.fill_and_sign(&mut tx, &xrpl).await.expect("failed to sign");

    println!("Transaction: {:?}", tx);

    // Create a sign_and_submit request.
    let mut submit_req = SubmitRequest::default();
    submit_req.tx_blob = tx_blob;

    // Submit the transaction to the ledger.
    let submit_res = xrpl
        .submit(submit_req)
        .await
        .expect("failed to make submit request");
    println!("Got response to submit request: {:?}", submit_res);

}
