use xrpl_rs::{
    wallet::{Wallet},
    transports::HTTP,
    types::{
        BigInt,
    },
    XRPL,
};

#[tokio::main]
async fn main() {
    
    // Create a new XRPL client with the HTTP transport pointed at ripple testnet.
    let xrpl = XRPL::new(
        HTTP::builder()
            .with_endpoint("https://s.altnet.rippletest.net:51234/")
            .unwrap()
            .build()
            .unwrap(),
    );

    // Create wallet from secret
    let mut wallet =
        Wallet::from_secret("spFgCAbejxnqjkeBVjxJ4NBTRzHf9").unwrap();
    // address: rQUjc7rAsc26qnGtqaZdRMC6xAtz9mpJLo

    let signature = wallet.sign_payment_channel_claim("1D98B74BC85E52F76C56824FE699EFC650F26808CD47CF56CCEA1F86D48FEFCE".to_owned(), BigInt(1000000));
    println!("{:?}", signature);
    println!("{:?}", wallet.public_key())
}
