use xrpl_rs::{transports::HTTP, types::account::AccountChannelsRequest, XRPL};

#[tokio::main]
async fn main() {
    // // Generate testnet credentials.
    // let creds = testnet::get_testnet_credentials()
    //     .await
    //     .expect("error generating testnet credentials");
    // // Print the account and balance
    // println!("Credentials: {:?}", creds,);
    // Create a new XRPL client with the HTTP transport pointed at ripple testnet.
    let xrpl = XRPL::new(
        HTTP::builder()
            .with_endpoint("https://s.devnet.rippletest.net:51234")
            .unwrap()
            .build()
            .unwrap(),
    );
    // // Create wallet from secret
    // let mut wallet = Wallet::from_secret(&creds.account.secret).unwrap();
    // println!("{}", wallet.address());

    // Create an account info request.
    let mut req = AccountChannelsRequest::default();
    // Set the account to the testnet credentials.
    req.account = "rE2xnuTUYf3KyBTULuNM71wEFbn9yAaXYh".to_owned();
    // Fetch the account info for an address.
    let account_channels = xrpl.account_channels(req).await.unwrap();
    // Print the account and balance
    println!(
        "Channels: {:?}",
        account_channels
    );
}
