If you are new to GitHub, visit the [first-contributions instructions](https://github.com/firstcontributions/first-contributions/blob/master/README.md) to learn how to contribute on GitHub.

If you are new to Rust, I recommend you to go through [the book](https://doc.rust-lang.org/book).

To find issues you can help with, go though the list of [good first issues](https://github.com/sayanarijit/xplr/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22) or issues labeled with [help wanted](https://github.com/sayanarijit/xplr/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22).

If you have something to suggest or issues to report, you can [create a new issue](https://github.com/sayanarijit/xplr/issues/new). Be sure to explain in details the context and the outcome that you are lookign for. If reporting bugs, provide basic information like you OS version, `xplr` version, window manager and the terminal you are using.

Once found or created an issue, let us know that you want to work on it by commenting in the issue.


Development Guideline
---------------------

Assuming that you have mentioned the issue you are working on and that you have forked and cloned the repository locally, in order to contribute by making changes to the code follow the steps below:

- Make changes to the code

- Test the changes

```bash
cargo run

cargo test
```

- Format code and get linting helps

```bash
cargo fmt

cargo clippy
```

- Commit, push and finally create a pull request.

- Don't worry if you make a mistake, we will provide constructive feedback and guidance to improve the pull request.

- If you encounter any situation that violates our [code of conduct](https://github.com/sayanarijit/xplr/blob/main/CODE_OF_CONDUCT.md) please report it to sayanarijit@gmail.com.
