use std::fs::File;

use html5ever::tendril::TendrilSink;
use xpather::result::Result;
use xpather::factory::Document;

pub fn main() -> Result<()> {
	let doc = parse_doc(&mut File::open("./doc/example.html").unwrap());

	let mut found = doc.evaluate(r##"//div[@class="row v-m-bottom-g"]"##)?;


	let node = found.next().unwrap()?;
	let node = node.into_node()?;

	println!("-------------------------------------------------------------------------------");

	// Eval generates an Infinite Loop
	let mut eval = node.evaluate_from(".//div[@class=\"fulfillment-add-to-cart-button\"]//button[contains(@class, \"add-to-cart-button\")]/text()", &doc)?;
	println!("{:?}", eval.next());
	println!("==============================================");
	println!("{:?}", eval.next());

	println!("More Base: {}", found.next().is_some());

	// let factory = Factory::new(r#"2 + A"#, &doc, &doc.root);

	// let now = Instant::now();

	// let mut prod = factory.produce()?;

	// println!("{:?}", now.elapsed());

	// let now = Instant::now();

	// println!("Output");

	// // println!("{:#?}", prod.collect_nodes());
	// println!("{:#?}", prod.next());

	// println!("{:?}", now.elapsed());

	Ok(())
}


pub fn parse_doc<R: std::io::Read>(data: &mut R) -> Document {
	let parse: markup5ever_rcdom::RcDom = html5ever::parse_document(markup5ever_rcdom::RcDom::default(), Default::default())
		.from_utf8()
		.read_from(data)
		.expect("html5ever");

	Document::new(parse.document.into())
}