macro_rules! res_opt_catch {
	($val:expr) => {
		match $val? {
			Some(v) => v,
			None => return Ok(None)
		}
	};
}


pub mod value;
pub mod result;
pub mod parser;
pub mod tokens;
pub mod context;
pub mod factory;
pub mod functions;
pub mod expressions;
pub mod nodetest;

use std::{fs::File, time::Instant};

use html5ever::tendril::TendrilSink;
pub use nodetest::{NodeTest, NameTest};
pub use result::{Result, Error};
pub use value::{Value, Node, Nodeset};
pub use tokens::{ExprToken, AxisName, NodeType, Operator, PrincipalNodeType};
pub use context::Evaluation;
pub use parser::Tokenizer;
pub use factory::{Factory, Document};

// TODO: Fix issue of "1 + 1" eval infinite looping when called with .collect().


pub fn main() -> Result<()> {
	let doc = parse_doc(&mut File::open("./doc/example.html").unwrap());

	let factory = Factory::new(r#"2 + A"#, &doc, &doc.root);

	let now = Instant::now();

	let mut prod = factory.produce()?;

	println!("{:?}", now.elapsed());

	let now = Instant::now();

	println!("Output");

	// println!("{:#?}", prod.collect_nodes());
	println!("{:#?}", prod.next());

	println!("{:?}", now.elapsed());

	Ok(())
}


pub fn parse_doc<R: std::io::Read>(data: &mut R) -> Document {
	let parse: markup5ever_rcdom::RcDom = html5ever::parse_document(markup5ever_rcdom::RcDom::default(), Default::default())
		.from_utf8()
		.read_from(data)
		.expect("html5ever");

	Document::new(parse.document.into())
}