# Contributing

Thanks for choosing to contribute!

The following are a set of guidelines to follow when contributing to this project.

## Code Of Conduct

This project adheres to the Adobe [code of conduct](../CODE_OF_CONDUCT.md). By participating,
you are expected to uphold this code. Please report unacceptable behavior to
[Grp-opensourceoffice@adobe.com](mailto:Grp-opensourceoffice@adobe.com).

## Have a Question?

Start by filing an issue. The existing committers on this project work to reach
consensus around project direction and issue solutions within issue threads
(when appropriate).

## Contributor License Agreement

All third-party contributions to this project must be accompanied by a signed contributor
license agreement. This gives Adobe permission to redistribute your contributions
as part of the project. [Sign our CLA](https://opensource.adobe.com/cla.html). You
only need to submit an Adobe CLA one time, so if you have submitted one previously,
you are good to go!

## Code Reviews

All submissions should come in the form of pull requests and need to be reviewed
by project committers. Read [GitHub's pull request documentation](https://help.github.com/articles/about-pull-requests/)
for more information on sending pull requests.

Lastly, please follow the [pull request template](PULL_REQUEST_TEMPLATE.md) when
submitting a pull request!

## Code Quality

Please ensure that your contributions:

* Follow [Rust's code format](https://github.com/rust-lang/rustfmt) where relevant.
  (Hint: Run `cargo fmt` before committing.)
* Provide [API documentation](https://doc.rust-lang.org/stable/rust-by-example/meta/doc.html)
  where relevant. (If you are adding new APIs, please run `cargo doc` to review
  the documentation.)
* Provide test coverage for any new features being added.
* Pass all existing tests. (Please run `cargo test` before submitting.)
* Pass Rust's standard lint checks. (Please run `cargo clippy` before submitting.)

With the exception of documentation and code coverage, all of these requirements
are enforced by PR validation. Please fix any validation failures as they are
flagged; that will save time for the reviewers who will read your PR.

## From Contributor to Committer

We love contributions from our community! If you'd like to go a step beyond contributor
and become a committer with full write access and a say in the project, you must
be invited to the project. The existing committers employ an internal nomination
process that must reach lazy consensus (silence is approval) before invitations
are issued. If you feel you are qualified and want to get more deeply involved,
feel free to reach out to existing committers to have a conversation about that.

## Security Issues

Security issues shouldn't be reported on this issue tracker. Instead, [file an issue to our security experts](https://helpx.adobe.com/security/alertus.html).
