use std::fmt::Display;

/// Types whose `Display` implementation can be safely used as an XML name.
pub trait NameSafe: Display {}

/// Types whose `Display` implementation can be safely embedded in
/// double-quoted XML attribute values. Literal `"` and `&` characters must be
/// escaped as `&quot;` and `&amp;` respectively.
pub trait AttValueSafe: Display {}

/// Types whose `Display` implementation can be safely embedded between XML
/// tags.  Literal `<` and `&` characters must be escaped as `&lt;` and `&amp;`
/// respectively.
pub trait PcdataSafe: Display {}

impl NameSafe for &'static str {}
impl AttValueSafe for &'static str {}
impl PcdataSafe for &'static str {}

macro_rules! primitive_impls {
    ($($type: ty),+) => {
        $(
            impl AttValueSafe for $type {}
            impl PcdataSafe for $type {}
        )+
    };
}

primitive_impls!(
    bool, char, f32, f64, i8, i16, i32, i64, i128, isize, u8, u16, u32, u64, u128, usize
);
