#[doc = "Register `MII_PHY_ADR` reader"]
pub struct R(crate::R<MII_PHY_ADR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MII_PHY_ADR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MII_PHY_ADR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MII_PHY_ADR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MII_PHY_ADR` writer"]
pub struct W(crate::W<MII_PHY_ADR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MII_PHY_ADR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MII_PHY_ADR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MII_PHY_ADR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PHY_ADDR` reader - PHY Address"]
pub struct PHY_ADDR_R(crate::FieldReader<u8, u8>);
impl PHY_ADDR_R {
    pub(crate) fn new(bits: u8) -> Self {
        PHY_ADDR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PHY_ADDR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PHY_ADDR` writer - PHY Address"]
pub struct PHY_ADDR_W<'a> {
    w: &'a mut W,
}
impl<'a> PHY_ADDR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u8 & 0x1f);
        self.w
    }
}
#[doc = "Show configured PHY address of port 0-3 in registerECAT0_MII_CONT_STAT\\[7:3\\]. Select port x with bits \\[4:0\\]
of this register (valid values are 0-3)\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum PHY_CADDR_A {
    #[doc = "0: Show address of port 0 (offset)"]
    VALUE1 = 0,
    #[doc = "1: Show individual address of port x"]
    VALUE2 = 1,
}
impl From<PHY_CADDR_A> for bool {
    #[inline(always)]
    fn from(variant: PHY_CADDR_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `PHY_CADDR` reader - Show configured PHY address of port 0-3 in registerECAT0_MII_CONT_STAT\\[7:3\\]. Select port x with bits \\[4:0\\]
of this register (valid values are 0-3)"]
pub struct PHY_CADDR_R(crate::FieldReader<bool, PHY_CADDR_A>);
impl PHY_CADDR_R {
    pub(crate) fn new(bits: bool) -> Self {
        PHY_CADDR_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PHY_CADDR_A {
        match self.bits {
            false => PHY_CADDR_A::VALUE1,
            true => PHY_CADDR_A::VALUE2,
        }
    }
    #[doc = "Checks if the value of the field is `VALUE1`"]
    #[inline(always)]
    pub fn is_value1(&self) -> bool {
        **self == PHY_CADDR_A::VALUE1
    }
    #[doc = "Checks if the value of the field is `VALUE2`"]
    #[inline(always)]
    pub fn is_value2(&self) -> bool {
        **self == PHY_CADDR_A::VALUE2
    }
}
impl core::ops::Deref for PHY_CADDR_R {
    type Target = crate::FieldReader<bool, PHY_CADDR_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PHY_CADDR` writer - Show configured PHY address of port 0-3 in registerECAT0_MII_CONT_STAT\\[7:3\\]. Select port x with bits \\[4:0\\]
of this register (valid values are 0-3)"]
pub struct PHY_CADDR_W<'a> {
    w: &'a mut W,
}
impl<'a> PHY_CADDR_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PHY_CADDR_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Show address of port 0 (offset)"]
    #[inline(always)]
    pub fn value1(self) -> &'a mut W {
        self.variant(PHY_CADDR_A::VALUE1)
    }
    #[doc = "Show individual address of port x"]
    #[inline(always)]
    pub fn value2(self) -> &'a mut W {
        self.variant(PHY_CADDR_A::VALUE2)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:4 - PHY Address"]
    #[inline(always)]
    pub fn phy_addr(&self) -> PHY_ADDR_R {
        PHY_ADDR_R::new((self.bits & 0x1f) as u8)
    }
    #[doc = "Bit 7 - Show configured PHY address of port 0-3 in registerECAT0_MII_CONT_STAT\\[7:3\\]. Select port x with bits \\[4:0\\]
of this register (valid values are 0-3)"]
    #[inline(always)]
    pub fn phy_caddr(&self) -> PHY_CADDR_R {
        PHY_CADDR_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:4 - PHY Address"]
    #[inline(always)]
    pub fn phy_addr(&mut self) -> PHY_ADDR_W {
        PHY_ADDR_W { w: self }
    }
    #[doc = "Bit 7 - Show configured PHY address of port 0-3 in registerECAT0_MII_CONT_STAT\\[7:3\\]. Select port x with bits \\[4:0\\]
of this register (valid values are 0-3)"]
    #[inline(always)]
    pub fn phy_caddr(&mut self) -> PHY_CADDR_W {
        PHY_CADDR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "PHY Address\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mii_phy_adr](index.html) module"]
pub struct MII_PHY_ADR_SPEC;
impl crate::RegisterSpec for MII_PHY_ADR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mii_phy_adr::R](R) reader structure"]
impl crate::Readable for MII_PHY_ADR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [mii_phy_adr::W](W) writer structure"]
impl crate::Writable for MII_PHY_ADR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MII_PHY_ADR to value 0"]
impl crate::Resettable for MII_PHY_ADR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
