#[doc = "Register `EVRVADCSTAT` reader"]
pub struct R(crate::R<EVRVADCSTAT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EVRVADCSTAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EVRVADCSTAT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EVRVADCSTAT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `VADC13V` reader - VADC 1.3 V Conversion Result"]
pub struct VADC13V_R(crate::FieldReader<u8, u8>);
impl VADC13V_R {
    pub(crate) fn new(bits: u8) -> Self {
        VADC13V_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VADC13V_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `VADC33V` reader - VADC 3.3 V Conversion Result"]
pub struct VADC33V_R(crate::FieldReader<u8, u8>);
impl VADC33V_R {
    pub(crate) fn new(bits: u8) -> Self {
        VADC33V_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for VADC33V_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bits 0:7 - VADC 1.3 V Conversion Result"]
    #[inline(always)]
    pub fn vadc13v(&self) -> VADC13V_R {
        VADC13V_R::new((self.bits & 0xff) as u8)
    }
    #[doc = "Bits 8:15 - VADC 3.3 V Conversion Result"]
    #[inline(always)]
    pub fn vadc33v(&self) -> VADC33V_R {
        VADC33V_R::new(((self.bits >> 8) & 0xff) as u8)
    }
}
#[doc = "EVR VADC Status Register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [evrvadcstat](index.html) module"]
pub struct EVRVADCSTAT_SPEC;
impl crate::RegisterSpec for EVRVADCSTAT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [evrvadcstat::R](R) reader structure"]
impl crate::Readable for EVRVADCSTAT_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets EVRVADCSTAT to value 0"]
impl crate::Resettable for EVRVADCSTAT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
