use std::env;
use std::process;

use xiaokang::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });

    
    if let Err(e) = xiaokang::run(&config) {
        eprintln!("运行失败: {}", e);
        process::exit(1);
    };
    println!(">>> 运行成功");
    println!(">>> search for {}", config.query);
    println!(">>> in file {}", config.filename);

}
