use serde::{Deserialize, Serialize};

use crate::UserTier;

#[derive(Serialize, Deserialize)]
pub struct UserWire {
    pub id: String,
    pub username: String,
    pub discriminator: String,
    pub avatar: Option<String>,
    pub public_flags: u64,
    pub internal_flags: u32,
    pub tier: UserTier,
}

impl Default for UserTier {
    fn default() -> Self {
        Self::None
    }
}
