use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, Serialize, Deserialize)]
pub struct TemplateMetaWire {
    pub code: String,
    pub creator_id: String,
    pub guild_id: Option<String>,
    pub name: String,
    pub description: Option<String>,
    pub usage_count: u64,
    pub upvote_count: u64,
    pub user_upvoted: bool,
    pub tags: Vec<String>,
    pub language: Option<String>,
    pub internal: bool,
}

#[derive(Serialize, Deserialize)]
pub struct TemplateListResponseWire {
    pub total: u64,
    pub templates: Vec<TemplateMetaWire>,
}
