use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CopyMessagesRequestMode {
    Before {
        before: Option<String>,
        message_count: Option<u32>,
    },
    After {
        after: Option<String>,
        message_count: Option<u32>,
    },
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub struct CopyMessagesRequest {
    pub source_id: String,
    pub target_id: String,
    #[serde(flatten)]
    pub mode: CopyMessagesRequestMode,
}
