use serde_repr::{Deserialize_repr, Serialize_repr};

#[derive(Debug, Clone, Serialize_repr, Deserialize_repr, PartialEq)]
#[repr(u8)]
pub enum UserTier {
    None = 0,
    One = 1,
    Two = 2,
    Three = 3,
}

use UserTier::*;

impl UserTier {
    pub fn max_backup_messages(&self) -> u32 {
        match self {
            None => 0,
            One => 50,
            Two => 100,
            Three => 250,
        }
    }
}
