use serde::{Serialize, Deserialize};
use twilight_cache_inmemory::model::CachedGuild;

#[derive(Serialize, Deserialize)]
pub struct GuildWire {
    pub id: String,
    pub name: String,
    pub icon: Option<String>,
    pub member_count: Option<u64>,
}

impl From<CachedGuild> for GuildWire {
    fn from(guild: CachedGuild) -> Self {
        Self {
            id: guild.id().to_string(),
            name: guild.name().to_string(),
            icon: guild.icon().map(|i| i.to_string()),
            member_count: guild.member_count(),
        }
    }
}
