use clap::{Args, Subcommand};

pub use create::*;
pub use delete::*;
pub use get::*;
pub use list::*;
pub use load::*;

mod create;
mod delete;
mod get;
mod list;
mod load;

#[derive(Args)]
pub struct BackupArgs {
    #[clap(subcommand)]
    pub command: BackupCommand
}

#[derive(Subcommand)]
pub enum BackupCommand {
    Create(BackupCreateArgs),
    Load(BackupLoadArgs),
    Get(BackupGetArgs),
    Delete(BackupDeleteArgs),
    List
}