use clap::Args;

use crate::CliContext;

#[derive(Args, Debug)]
pub struct BackupLoadArgs {
    backup_id: String,
    #[clap(short, long)]
    guild_id: u64,
    #[clap(short, long, multiple_values = true)]
    options: Vec<String>,
    #[clap(short, long, default_value_t = 0)]
    message_count: u32,
}

pub async fn handle_backup_load(context: &CliContext, args: BackupLoadArgs) {
    let resp = context.client.backup_load(args.guild_id, &args.backup_id, 0, args.message_count).await;
    println!("{:#?}", resp)
}