use clap::Args;

use crate::CliContext;

#[derive(Args, Debug)]
pub struct BackupGetArgs {
    backup_id: String,
}

pub async fn handle_backup_get(context: &CliContext, args: BackupGetArgs) {
    let resp = context.client.backup_get(&args.backup_id).await;
    println!("{:#?}", resp)
}