use clap::Args;
use dialoguer::Confirm;

use crate::CliContext;

#[derive(Args, Debug)]
pub struct BackupDeleteArgs {
    backup_id: String,
}

pub async fn handle_backup_delete(context: &CliContext, args: BackupDeleteArgs) {
    if Confirm::new().with_prompt("Do you want to delete the backup?").interact().unwrap() {
        let resp = context.client.backup_delete(&args.backup_id).await;
        println!("{:#?}", resp)
    }
}