use clap::Args;
use xenon_lib::wire::BackupCreateFlags;
use console::style;

use crate::CliContext;

#[derive(Args, Debug)]
pub struct BackupCreateArgs {
    #[clap(short, long)]
    guild_id: u64,
    #[clap(short, long, multiple_values = true)]
    options: Vec<String>,
    #[clap(short, long, default_value_t = 0)]
    message_count: u32,
}

pub async fn handle_backup_create(context: &CliContext, args: BackupCreateArgs) {
    let mut flags = BackupCreateFlags::empty();
    for option in args.options {
        match option.to_lowercase().as_str() {
            "channels" => flags |= BackupCreateFlags::CHANNELS,
            "roles" => flags |= BackupCreateFlags::ROLES,
            "bans" => flags |= BackupCreateFlags::BANS,
            "members" => flags |= BackupCreateFlags::MEMBERS,
            "messages" => flags |= BackupCreateFlags::MESSAGES,
            _ => {
                println!("Invalid backup create option {}", style(&option).bold());
                return
            }
        }
    }

    let resp = context.client.backup_create(args.guild_id, flags.bits(), args.message_count).await;


    println!("{:#?}", resp)
}