/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const __XEN_TOOLS__: u32 = 1;
pub const _UNISTD_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 30;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const _POSIX_VERSION: u32 = 200809;
pub const __POSIX2_THIS_VERSION: u32 = 200809;
pub const _POSIX2_VERSION: u32 = 200809;
pub const _POSIX2_C_VERSION: u32 = 200809;
pub const _POSIX2_C_BIND: u32 = 200809;
pub const _POSIX2_C_DEV: u32 = 200809;
pub const _POSIX2_SW_DEV: u32 = 200809;
pub const _POSIX2_LOCALEDEF: u32 = 200809;
pub const _XOPEN_VERSION: u32 = 700;
pub const _XOPEN_XCU_VERSION: u32 = 4;
pub const _XOPEN_XPG2: u32 = 1;
pub const _XOPEN_XPG3: u32 = 1;
pub const _XOPEN_XPG4: u32 = 1;
pub const _XOPEN_UNIX: u32 = 1;
pub const _XOPEN_ENH_I18N: u32 = 1;
pub const _XOPEN_LEGACY: u32 = 1;
pub const _BITS_POSIX_OPT_H: u32 = 1;
pub const _POSIX_JOB_CONTROL: u32 = 1;
pub const _POSIX_SAVED_IDS: u32 = 1;
pub const _POSIX_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_SYNCHRONIZED_IO: u32 = 200809;
pub const _POSIX_FSYNC: u32 = 200809;
pub const _POSIX_MAPPED_FILES: u32 = 200809;
pub const _POSIX_MEMLOCK: u32 = 200809;
pub const _POSIX_MEMLOCK_RANGE: u32 = 200809;
pub const _POSIX_MEMORY_PROTECTION: u32 = 200809;
pub const _POSIX_CHOWN_RESTRICTED: u32 = 0;
pub const _POSIX_VDISABLE: u8 = 0u8;
pub const _POSIX_NO_TRUNC: u32 = 1;
pub const _XOPEN_REALTIME: u32 = 1;
pub const _XOPEN_REALTIME_THREADS: u32 = 1;
pub const _XOPEN_SHM: u32 = 1;
pub const _POSIX_THREADS: u32 = 200809;
pub const _POSIX_REENTRANT_FUNCTIONS: u32 = 1;
pub const _POSIX_THREAD_SAFE_FUNCTIONS: u32 = 200809;
pub const _POSIX_THREAD_PRIORITY_SCHEDULING: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKSIZE: u32 = 200809;
pub const _POSIX_THREAD_ATTR_STACKADDR: u32 = 200809;
pub const _POSIX_THREAD_PRIO_INHERIT: u32 = 200809;
pub const _POSIX_THREAD_PRIO_PROTECT: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_INHERIT: u32 = 200809;
pub const _POSIX_THREAD_ROBUST_PRIO_PROTECT: i32 = -1;
pub const _POSIX_SEMAPHORES: u32 = 200809;
pub const _POSIX_REALTIME_SIGNALS: u32 = 200809;
pub const _POSIX_ASYNCHRONOUS_IO: u32 = 200809;
pub const _POSIX_ASYNC_IO: u32 = 1;
pub const _LFS_ASYNCHRONOUS_IO: u32 = 1;
pub const _POSIX_PRIORITIZED_IO: u32 = 200809;
pub const _LFS64_ASYNCHRONOUS_IO: u32 = 1;
pub const _LFS_LARGEFILE: u32 = 1;
pub const _LFS64_LARGEFILE: u32 = 1;
pub const _LFS64_STDIO: u32 = 1;
pub const _POSIX_SHARED_MEMORY_OBJECTS: u32 = 200809;
pub const _POSIX_CPUTIME: u32 = 0;
pub const _POSIX_THREAD_CPUTIME: u32 = 0;
pub const _POSIX_REGEXP: u32 = 1;
pub const _POSIX_READER_WRITER_LOCKS: u32 = 200809;
pub const _POSIX_SHELL: u32 = 1;
pub const _POSIX_TIMEOUTS: u32 = 200809;
pub const _POSIX_SPIN_LOCKS: u32 = 200809;
pub const _POSIX_SPAWN: u32 = 200809;
pub const _POSIX_TIMERS: u32 = 200809;
pub const _POSIX_BARRIERS: u32 = 200809;
pub const _POSIX_MESSAGE_PASSING: u32 = 200809;
pub const _POSIX_THREAD_PROCESS_SHARED: u32 = 200809;
pub const _POSIX_MONOTONIC_CLOCK: u32 = 0;
pub const _POSIX_CLOCK_SELECTION: u32 = 200809;
pub const _POSIX_ADVISORY_INFO: u32 = 200809;
pub const _POSIX_IPV6: u32 = 200809;
pub const _POSIX_RAW_SOCKETS: u32 = 200809;
pub const _POSIX2_CHAR_TERM: u32 = 200809;
pub const _POSIX_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_THREAD_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_TRACE: i32 = -1;
pub const _POSIX_TRACE_EVENT_FILTER: i32 = -1;
pub const _POSIX_TRACE_INHERIT: i32 = -1;
pub const _POSIX_TRACE_LOG: i32 = -1;
pub const _POSIX_TYPED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX_V7_LPBIG_OFFBIG: i32 = -1;
pub const _POSIX_V6_LPBIG_OFFBIG: i32 = -1;
pub const _XBS5_LPBIG_OFFBIG: i32 = -1;
pub const _POSIX_V7_LP64_OFF64: u32 = 1;
pub const _POSIX_V6_LP64_OFF64: u32 = 1;
pub const _XBS5_LP64_OFF64: u32 = 1;
pub const __ILP32_OFF32_CFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __ILP32_OFF32_LDFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __ILP32_OFFBIG_CFLAGS: &'static [u8; 48usize] =
    b"-m32 -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64\0";
pub const __ILP32_OFFBIG_LDFLAGS: &'static [u8; 5usize] = b"-m32\0";
pub const __LP64_OFF64_CFLAGS: &'static [u8; 5usize] = b"-m64\0";
pub const __LP64_OFF64_LDFLAGS: &'static [u8; 5usize] = b"-m64\0";
pub const STDIN_FILENO: u32 = 0;
pub const STDOUT_FILENO: u32 = 1;
pub const STDERR_FILENO: u32 = 2;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const R_OK: u32 = 4;
pub const W_OK: u32 = 2;
pub const X_OK: u32 = 1;
pub const F_OK: u32 = 0;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const L_SET: u32 = 0;
pub const L_INCR: u32 = 1;
pub const L_XTND: u32 = 2;
pub const _GETOPT_POSIX_H: u32 = 1;
pub const _GETOPT_CORE_H: u32 = 1;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const _STDINT_H: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const _STDIO_H: u32 = 1;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const __XEN_LATEST_INTERFACE_VERSION__: u32 = 264448;
pub const __XEN_INTERFACE_VERSION__: u32 = 264448;
pub const FLAT_RING3_CS32: u32 = 57379;
pub const FLAT_RING3_CS64: u32 = 57395;
pub const FLAT_RING3_DS32: u32 = 57387;
pub const FLAT_RING3_DS64: u32 = 0;
pub const FLAT_RING3_SS32: u32 = 57387;
pub const FLAT_RING3_SS64: u32 = 57387;
pub const FLAT_KERNEL_DS64: u32 = 0;
pub const FLAT_KERNEL_DS32: u32 = 57387;
pub const FLAT_KERNEL_DS: u32 = 0;
pub const FLAT_KERNEL_CS64: u32 = 57395;
pub const FLAT_KERNEL_CS32: u32 = 57379;
pub const FLAT_KERNEL_CS: u32 = 57395;
pub const FLAT_KERNEL_SS64: u32 = 57387;
pub const FLAT_KERNEL_SS32: u32 = 57387;
pub const FLAT_KERNEL_SS: u32 = 57387;
pub const FLAT_USER_DS64: u32 = 0;
pub const FLAT_USER_DS32: u32 = 57387;
pub const FLAT_USER_DS: u32 = 0;
pub const FLAT_USER_CS64: u32 = 57395;
pub const FLAT_USER_CS32: u32 = 57379;
pub const FLAT_USER_CS: u32 = 57395;
pub const FLAT_USER_SS64: u32 = 57387;
pub const FLAT_USER_SS32: u32 = 57387;
pub const FLAT_USER_SS: u32 = 57387;
pub const __HYPERVISOR_VIRT_START: i64 = -140737488355328;
pub const __HYPERVISOR_VIRT_END: i64 = -131941395333120;
pub const __MACH2PHYS_VIRT_START: i64 = -140737488355328;
pub const __MACH2PHYS_VIRT_END: i64 = -140462610448384;
pub const SEGBASE_FS: u32 = 0;
pub const SEGBASE_GS_USER: u32 = 1;
pub const SEGBASE_GS_KERNEL: u32 = 2;
pub const SEGBASE_GS_USER_SEL: u32 = 3;
pub const _VGCF_in_syscall: u32 = 8;
pub const VGCF_in_syscall: u32 = 256;
pub const VGCF_IN_SYSCALL: u32 = 256;
pub const PRI_xen_pfn: &'static [u8; 3usize] = b"lx\0";
pub const XEN_HAVE_PV_GUEST_ENTRY: u32 = 1;
pub const XEN_HAVE_PV_UPCALL_MASK: u32 = 1;
pub const FIRST_RESERVED_GDT_PAGE: u32 = 14;
pub const FIRST_RESERVED_GDT_BYTE: u32 = 57344;
pub const FIRST_RESERVED_GDT_ENTRY: u32 = 7168;
pub const XEN_LEGACY_MAX_VCPUS: u32 = 32;
pub const PRI_xen_ulong: &'static [u8; 3usize] = b"lx\0";
pub const VGCF_I387_VALID: u32 = 1;
pub const VGCF_IN_KERNEL: u32 = 4;
pub const _VGCF_i387_valid: u32 = 0;
pub const VGCF_i387_valid: u32 = 1;
pub const _VGCF_in_kernel: u32 = 2;
pub const VGCF_in_kernel: u32 = 4;
pub const _VGCF_failsafe_disables_events: u32 = 3;
pub const VGCF_failsafe_disables_events: u32 = 8;
pub const _VGCF_syscall_disables_events: u32 = 4;
pub const VGCF_syscall_disables_events: u32 = 16;
pub const _VGCF_online: u32 = 5;
pub const VGCF_online: u32 = 32;
pub const _XEN_X86_EMU_LAPIC: u32 = 0;
pub const XEN_X86_EMU_LAPIC: u32 = 1;
pub const _XEN_X86_EMU_HPET: u32 = 1;
pub const XEN_X86_EMU_HPET: u32 = 2;
pub const _XEN_X86_EMU_PM: u32 = 2;
pub const XEN_X86_EMU_PM: u32 = 4;
pub const _XEN_X86_EMU_RTC: u32 = 3;
pub const XEN_X86_EMU_RTC: u32 = 8;
pub const _XEN_X86_EMU_IOAPIC: u32 = 4;
pub const XEN_X86_EMU_IOAPIC: u32 = 16;
pub const _XEN_X86_EMU_PIC: u32 = 5;
pub const XEN_X86_EMU_PIC: u32 = 32;
pub const _XEN_X86_EMU_VGA: u32 = 6;
pub const XEN_X86_EMU_VGA: u32 = 64;
pub const _XEN_X86_EMU_IOMMU: u32 = 7;
pub const XEN_X86_EMU_IOMMU: u32 = 128;
pub const _XEN_X86_EMU_PIT: u32 = 8;
pub const XEN_X86_EMU_PIT: u32 = 256;
pub const _XEN_X86_EMU_USE_PIRQ: u32 = 9;
pub const XEN_X86_EMU_USE_PIRQ: u32 = 512;
pub const XEN_X86_EMU_ALL: u32 = 1023;
pub const XEN_ACPI_CPU_MAP: u32 = 44800;
pub const XEN_ACPI_GPE0_CPUHP_BIT: u32 = 2;
pub const XEN_EMULATE_PREFIX: &'static [u8; 34usize] = b".byte 0x0f,0x0b,0x78,0x65,0x6e ; \0";
pub const XEN_CPUID: &'static [u8; 39usize] = b".byte 0x0f,0x0b,0x78,0x65,0x6e ; cpuid\0";
pub const __HYPERVISOR_set_trap_table: u32 = 0;
pub const __HYPERVISOR_mmu_update: u32 = 1;
pub const __HYPERVISOR_set_gdt: u32 = 2;
pub const __HYPERVISOR_stack_switch: u32 = 3;
pub const __HYPERVISOR_set_callbacks: u32 = 4;
pub const __HYPERVISOR_fpu_taskswitch: u32 = 5;
pub const __HYPERVISOR_sched_op_compat: u32 = 6;
pub const __HYPERVISOR_platform_op: u32 = 7;
pub const __HYPERVISOR_set_debugreg: u32 = 8;
pub const __HYPERVISOR_get_debugreg: u32 = 9;
pub const __HYPERVISOR_update_descriptor: u32 = 10;
pub const __HYPERVISOR_memory_op: u32 = 12;
pub const __HYPERVISOR_multicall: u32 = 13;
pub const __HYPERVISOR_update_va_mapping: u32 = 14;
pub const __HYPERVISOR_set_timer_op: u32 = 15;
pub const __HYPERVISOR_event_channel_op_compat: u32 = 16;
pub const __HYPERVISOR_xen_version: u32 = 17;
pub const __HYPERVISOR_console_io: u32 = 18;
pub const __HYPERVISOR_physdev_op_compat: u32 = 19;
pub const __HYPERVISOR_grant_table_op: u32 = 20;
pub const __HYPERVISOR_vm_assist: u32 = 21;
pub const __HYPERVISOR_update_va_mapping_otherdomain: u32 = 22;
pub const __HYPERVISOR_iret: u32 = 23;
pub const __HYPERVISOR_vcpu_op: u32 = 24;
pub const __HYPERVISOR_set_segment_base: u32 = 25;
pub const __HYPERVISOR_mmuext_op: u32 = 26;
pub const __HYPERVISOR_xsm_op: u32 = 27;
pub const __HYPERVISOR_nmi_op: u32 = 28;
pub const __HYPERVISOR_sched_op: u32 = 29;
pub const __HYPERVISOR_callback_op: u32 = 30;
pub const __HYPERVISOR_xenoprof_op: u32 = 31;
pub const __HYPERVISOR_event_channel_op: u32 = 32;
pub const __HYPERVISOR_physdev_op: u32 = 33;
pub const __HYPERVISOR_hvm_op: u32 = 34;
pub const __HYPERVISOR_sysctl: u32 = 35;
pub const __HYPERVISOR_domctl: u32 = 36;
pub const __HYPERVISOR_kexec_op: u32 = 37;
pub const __HYPERVISOR_tmem_op: u32 = 38;
pub const __HYPERVISOR_xc_reserved_op: u32 = 39;
pub const __HYPERVISOR_xenpmu_op: u32 = 40;
pub const __HYPERVISOR_dm_op: u32 = 41;
pub const __HYPERVISOR_arch_0: u32 = 48;
pub const __HYPERVISOR_arch_1: u32 = 49;
pub const __HYPERVISOR_arch_2: u32 = 50;
pub const __HYPERVISOR_arch_3: u32 = 51;
pub const __HYPERVISOR_arch_4: u32 = 52;
pub const __HYPERVISOR_arch_5: u32 = 53;
pub const __HYPERVISOR_arch_6: u32 = 54;
pub const __HYPERVISOR_arch_7: u32 = 55;
pub const VIRQ_TIMER: u32 = 0;
pub const VIRQ_DEBUG: u32 = 1;
pub const VIRQ_CONSOLE: u32 = 2;
pub const VIRQ_DOM_EXC: u32 = 3;
pub const VIRQ_TBUF: u32 = 4;
pub const VIRQ_DEBUGGER: u32 = 6;
pub const VIRQ_XENOPROF: u32 = 7;
pub const VIRQ_CON_RING: u32 = 8;
pub const VIRQ_PCPU_STATE: u32 = 9;
pub const VIRQ_MEM_EVENT: u32 = 10;
pub const VIRQ_XC_RESERVED: u32 = 11;
pub const VIRQ_ENOMEM: u32 = 12;
pub const VIRQ_XENPMU: u32 = 13;
pub const VIRQ_ARCH_0: u32 = 16;
pub const VIRQ_ARCH_1: u32 = 17;
pub const VIRQ_ARCH_2: u32 = 18;
pub const VIRQ_ARCH_3: u32 = 19;
pub const VIRQ_ARCH_4: u32 = 20;
pub const VIRQ_ARCH_5: u32 = 21;
pub const VIRQ_ARCH_6: u32 = 22;
pub const VIRQ_ARCH_7: u32 = 23;
pub const NR_VIRQS: u32 = 24;
pub const MMU_NORMAL_PT_UPDATE: u32 = 0;
pub const MMU_MACHPHYS_UPDATE: u32 = 1;
pub const MMU_PT_UPDATE_PRESERVE_AD: u32 = 2;
pub const MMUEXT_PIN_L1_TABLE: u32 = 0;
pub const MMUEXT_PIN_L2_TABLE: u32 = 1;
pub const MMUEXT_PIN_L3_TABLE: u32 = 2;
pub const MMUEXT_PIN_L4_TABLE: u32 = 3;
pub const MMUEXT_UNPIN_TABLE: u32 = 4;
pub const MMUEXT_NEW_BASEPTR: u32 = 5;
pub const MMUEXT_TLB_FLUSH_LOCAL: u32 = 6;
pub const MMUEXT_INVLPG_LOCAL: u32 = 7;
pub const MMUEXT_TLB_FLUSH_MULTI: u32 = 8;
pub const MMUEXT_INVLPG_MULTI: u32 = 9;
pub const MMUEXT_TLB_FLUSH_ALL: u32 = 10;
pub const MMUEXT_INVLPG_ALL: u32 = 11;
pub const MMUEXT_FLUSH_CACHE: u32 = 12;
pub const MMUEXT_SET_LDT: u32 = 13;
pub const MMUEXT_NEW_USER_BASEPTR: u32 = 15;
pub const MMUEXT_CLEAR_PAGE: u32 = 16;
pub const MMUEXT_COPY_PAGE: u32 = 17;
pub const MMUEXT_FLUSH_CACHE_GLOBAL: u32 = 18;
pub const MMUEXT_MARK_SUPER: u32 = 19;
pub const MMUEXT_UNMARK_SUPER: u32 = 20;
pub const CONSOLEIO_write: u32 = 0;
pub const CONSOLEIO_read: u32 = 1;
pub const VMASST_CMD_enable: u32 = 0;
pub const VMASST_CMD_disable: u32 = 1;
pub const VMASST_TYPE_4gb_segments: u32 = 0;
pub const VMASST_TYPE_4gb_segments_notify: u32 = 1;
pub const VMASST_TYPE_writable_pagetables: u32 = 2;
pub const VMASST_TYPE_pae_extended_cr3: u32 = 3;
pub const VMASST_TYPE_architectural_iopl: u32 = 4;
pub const VMASST_TYPE_runstate_update_flag: u32 = 5;
pub const VMASST_TYPE_m2p_strict: u32 = 32;
pub const XEN_PVCLOCK_TSC_STABLE_BIT: u32 = 1;
pub const XEN_PVCLOCK_GUEST_STOPPED: u32 = 2;
pub const MAX_GUEST_CMDLINE: u32 = 1024;
pub const SIF_PRIVILEGED: u32 = 1;
pub const SIF_INITDOMAIN: u32 = 2;
pub const SIF_MULTIBOOT_MOD: u32 = 4;
pub const SIF_MOD_START_PFN: u32 = 8;
pub const SIF_VIRT_P2M_4TOOLS: u32 = 16;
pub const SIF_PM_MASK: u32 = 65280;
pub const XEN_VGATYPE_TEXT_MODE_3: u32 = 3;
pub const XEN_VGATYPE_VESA_LFB: u32 = 35;
pub const XEN_VGATYPE_EFI_LFB: u32 = 112;
pub const GNTTAB_NR_RESERVED_ENTRIES: u32 = 8;
pub const GNTTAB_RESERVED_CONSOLE: u32 = 0;
pub const GNTTAB_RESERVED_XENSTORE: u32 = 1;
pub const GTF_invalid: u32 = 0;
pub const GTF_permit_access: u32 = 1;
pub const GTF_accept_transfer: u32 = 2;
pub const GTF_transitive: u32 = 3;
pub const GTF_type_mask: u32 = 3;
pub const _GTF_readonly: u32 = 2;
pub const GTF_readonly: u32 = 4;
pub const _GTF_reading: u32 = 3;
pub const GTF_reading: u32 = 8;
pub const _GTF_writing: u32 = 4;
pub const GTF_writing: u32 = 16;
pub const _GTF_PWT: u32 = 5;
pub const GTF_PWT: u32 = 32;
pub const _GTF_PCD: u32 = 6;
pub const GTF_PCD: u32 = 64;
pub const _GTF_PAT: u32 = 7;
pub const GTF_PAT: u32 = 128;
pub const _GTF_sub_page: u32 = 8;
pub const GTF_sub_page: u32 = 256;
pub const _GTF_transfer_committed: u32 = 2;
pub const GTF_transfer_committed: u32 = 4;
pub const _GTF_transfer_completed: u32 = 3;
pub const GTF_transfer_completed: u32 = 8;
pub const GNTTABOP_map_grant_ref: u32 = 0;
pub const GNTTABOP_unmap_grant_ref: u32 = 1;
pub const GNTTABOP_setup_table: u32 = 2;
pub const GNTTABOP_dump_table: u32 = 3;
pub const GNTTABOP_transfer: u32 = 4;
pub const GNTTABOP_copy: u32 = 5;
pub const GNTTABOP_query_size: u32 = 6;
pub const GNTTABOP_unmap_and_replace: u32 = 7;
pub const GNTTABOP_set_version: u32 = 8;
pub const GNTTABOP_get_status_frames: u32 = 9;
pub const GNTTABOP_get_version: u32 = 10;
pub const GNTTABOP_swap_grant_ref: u32 = 11;
pub const GNTTABOP_cache_flush: u32 = 12;
pub const _GNTCOPY_source_gref: u32 = 0;
pub const GNTCOPY_source_gref: u32 = 1;
pub const _GNTCOPY_dest_gref: u32 = 1;
pub const GNTCOPY_dest_gref: u32 = 2;
pub const GNTTAB_CACHE_CLEAN: u32 = 1;
pub const GNTTAB_CACHE_INVAL: u32 = 2;
pub const GNTTAB_CACHE_SOURCE_GREF: u32 = 2147483648;
pub const _GNTMAP_device_map: u32 = 0;
pub const GNTMAP_device_map: u32 = 1;
pub const _GNTMAP_host_map: u32 = 1;
pub const GNTMAP_host_map: u32 = 2;
pub const _GNTMAP_readonly: u32 = 2;
pub const GNTMAP_readonly: u32 = 4;
pub const _GNTMAP_application_map: u32 = 3;
pub const GNTMAP_application_map: u32 = 8;
pub const _GNTMAP_contains_pte: u32 = 4;
pub const GNTMAP_contains_pte: u32 = 16;
pub const _GNTMAP_can_fail: u32 = 5;
pub const GNTMAP_can_fail: u32 = 32;
pub const _GNTMAP_guest_avail0: u32 = 16;
pub const GNTST_okay: u32 = 0;
pub const GNTST_general_error: i32 = -1;
pub const GNTST_bad_domain: i32 = -2;
pub const GNTST_bad_gntref: i32 = -3;
pub const GNTST_bad_handle: i32 = -4;
pub const GNTST_bad_virt_addr: i32 = -5;
pub const GNTST_bad_dev_addr: i32 = -6;
pub const GNTST_no_device_space: i32 = -7;
pub const GNTST_permission_denied: i32 = -8;
pub const GNTST_bad_page: i32 = -9;
pub const GNTST_bad_copy_arg: i32 = -10;
pub const GNTST_address_too_big: i32 = -11;
pub const GNTST_eagain: i32 = -12;
pub const HVM_FILE_MAGIC: u32 = 1412960902;
pub const HVM_FILE_VERSION: u32 = 1;
pub const _XEN_X86_FPU_INITIALISED: u32 = 0;
pub const XEN_X86_FPU_INITIALISED: u32 = 1;
pub const VIOAPIC_NUM_PINS: u32 = 48;
pub const RTC_CMOS_SIZE: u32 = 14;
pub const HPET_TIMER_NUM: u32 = 3;
pub const MTRR_VCNT: u32 = 8;
pub const NUM_FIXED_MSR: u32 = 11;
pub const CPU_XSAVE_CODE: u32 = 16;
pub const CPU_MSR_CODE: u32 = 20;
pub const HVM_SAVE_CODE_MAX: u32 = 20;
pub const PHYSDEVOP_eoi: u32 = 12;
pub const PHYSDEVOP_pirq_eoi_gmfn_v1: u32 = 17;
pub const PHYSDEVOP_pirq_eoi_gmfn_v2: u32 = 28;
pub const PHYSDEVOP_irq_status_query: u32 = 5;
pub const _XENIRQSTAT_needs_eoi: u32 = 0;
pub const XENIRQSTAT_needs_eoi: u32 = 1;
pub const _XENIRQSTAT_shared: u32 = 1;
pub const XENIRQSTAT_shared: u32 = 2;
pub const PHYSDEVOP_set_iopl: u32 = 6;
pub const PHYSDEVOP_set_iobitmap: u32 = 7;
pub const PHYSDEVOP_apic_read: u32 = 8;
pub const PHYSDEVOP_apic_write: u32 = 9;
pub const PHYSDEVOP_alloc_irq_vector: u32 = 10;
pub const PHYSDEVOP_free_irq_vector: u32 = 11;
pub const MAP_PIRQ_TYPE_MSI: u32 = 0;
pub const MAP_PIRQ_TYPE_GSI: u32 = 1;
pub const MAP_PIRQ_TYPE_UNKNOWN: u32 = 2;
pub const MAP_PIRQ_TYPE_MSI_SEG: u32 = 3;
pub const MAP_PIRQ_TYPE_MULTI_MSI: u32 = 4;
pub const PHYSDEVOP_map_pirq: u32 = 13;
pub const PHYSDEVOP_unmap_pirq: u32 = 14;
pub const PHYSDEVOP_manage_pci_add: u32 = 15;
pub const PHYSDEVOP_manage_pci_remove: u32 = 16;
pub const PHYSDEVOP_restore_msi: u32 = 19;
pub const PHYSDEVOP_manage_pci_add_ext: u32 = 20;
pub const PHYSDEVOP_setup_gsi: u32 = 21;
pub const PHYSDEVOP_get_free_pirq: u32 = 23;
pub const XEN_PCI_MMCFG_RESERVED: u32 = 1;
pub const PHYSDEVOP_pci_mmcfg_reserved: u32 = 24;
pub const XEN_PCI_DEV_EXTFN: u32 = 1;
pub const XEN_PCI_DEV_VIRTFN: u32 = 2;
pub const XEN_PCI_DEV_PXM: u32 = 4;
pub const PHYSDEVOP_pci_device_add: u32 = 25;
pub const PHYSDEVOP_pci_device_remove: u32 = 26;
pub const PHYSDEVOP_restore_msi_ext: u32 = 27;
pub const PHYSDEVOP_prepare_msix: u32 = 30;
pub const PHYSDEVOP_release_msix: u32 = 31;
pub const PHYSDEVOP_DBGP_RESET_PREPARE: u32 = 1;
pub const PHYSDEVOP_DBGP_RESET_DONE: u32 = 2;
pub const PHYSDEVOP_DBGP_BUS_UNKNOWN: u32 = 0;
pub const PHYSDEVOP_DBGP_BUS_PCI: u32 = 1;
pub const PHYSDEVOP_dbgp_op: u32 = 29;
pub const PHYSDEVOP_IRQ_UNMASK_NOTIFY: u32 = 4;
pub const PHYSDEVOP_pirq_eoi_gmfn: u32 = 28;
pub const XENMEM_increase_reservation: u32 = 0;
pub const XENMEM_decrease_reservation: u32 = 1;
pub const XENMEM_populate_physmap: u32 = 6;
pub const XENMEMF_populate_on_demand: u32 = 65536;
pub const XENMEMF_exact_node_request: u32 = 131072;
pub const XENMEMF_vnode: u32 = 262144;
pub const XENMEM_exchange: u32 = 11;
pub const XENMEM_maximum_ram_page: u32 = 2;
pub const XENMEM_current_reservation: u32 = 3;
pub const XENMEM_maximum_reservation: u32 = 4;
pub const XENMEM_maximum_gpfn: u32 = 14;
pub const XENMEM_machphys_mfn_list: u32 = 5;
pub const XENMEM_machphys_compat_mfn_list: u32 = 25;
pub const XENMEM_machphys_mapping: u32 = 12;
pub const XENMAPSPACE_shared_info: u32 = 0;
pub const XENMAPSPACE_grant_table: u32 = 1;
pub const XENMAPSPACE_gmfn: u32 = 2;
pub const XENMAPSPACE_gmfn_range: u32 = 3;
pub const XENMAPSPACE_gmfn_foreign: u32 = 4;
pub const XENMAPSPACE_dev_mmio: u32 = 5;
pub const XENMEM_add_to_physmap: u32 = 7;
pub const XENMAPIDX_grant_table_status: u32 = 2147483648;
pub const XENMEM_add_to_physmap_batch: u32 = 23;
pub const XENMEM_remove_from_physmap: u32 = 15;
pub const XENMEM_memory_map: u32 = 9;
pub const XENMEM_machine_memory_map: u32 = 10;
pub const XENMEM_set_memory_map: u32 = 13;
pub const XENMEM_set_pod_target: u32 = 16;
pub const XENMEM_get_pod_target: u32 = 17;
pub const XENMEM_get_sharing_freed_pages: u32 = 18;
pub const XENMEM_get_sharing_shared_pages: u32 = 19;
pub const XENMEM_paging_op: u32 = 20;
pub const XENMEM_paging_op_nominate: u32 = 0;
pub const XENMEM_paging_op_evict: u32 = 1;
pub const XENMEM_paging_op_prep: u32 = 2;
pub const XENMEM_access_op: u32 = 21;
pub const XENMEM_access_op_set_access: u32 = 0;
pub const XENMEM_access_op_get_access: u32 = 1;
pub const XENMEM_access_op_set_access_multi: u32 = 4;
pub const XENMEM_sharing_op: u32 = 22;
pub const XENMEM_sharing_op_nominate_gfn: u32 = 0;
pub const XENMEM_sharing_op_nominate_gref: u32 = 1;
pub const XENMEM_sharing_op_share: u32 = 2;
pub const XENMEM_sharing_op_debug_gfn: u32 = 3;
pub const XENMEM_sharing_op_debug_mfn: u32 = 4;
pub const XENMEM_sharing_op_debug_gref: u32 = 5;
pub const XENMEM_sharing_op_add_physmap: u32 = 6;
pub const XENMEM_sharing_op_audit: u32 = 7;
pub const XENMEM_sharing_op_range_share: u32 = 8;
pub const XENMEM_SHARING_OP_S_HANDLE_INVALID: i32 = -10;
pub const XENMEM_SHARING_OP_C_HANDLE_INVALID: i32 = -9;
pub const XENMEM_claim_pages: u32 = 24;
pub const XENMEM_reserved_device_memory_map: u32 = 27;
pub const XENMEM_RDM_ALL: u32 = 1;
pub const XENMEM_get_vnumainfo: u32 = 26;
pub const XEN_DOMCTL_INTERFACE_VERSION: u32 = 13;
pub const _XEN_DOMCTL_CDF_hvm_guest: u32 = 0;
pub const XEN_DOMCTL_CDF_hvm_guest: u32 = 1;
pub const _XEN_DOMCTL_CDF_hap: u32 = 1;
pub const XEN_DOMCTL_CDF_hap: u32 = 2;
pub const _XEN_DOMCTL_CDF_s3_integrity: u32 = 2;
pub const XEN_DOMCTL_CDF_s3_integrity: u32 = 4;
pub const _XEN_DOMCTL_CDF_oos_off: u32 = 3;
pub const XEN_DOMCTL_CDF_oos_off: u32 = 8;
pub const _XEN_DOMCTL_CDF_xs_domain: u32 = 4;
pub const XEN_DOMCTL_CDF_xs_domain: u32 = 16;
pub const _XEN_DOMINF_dying: u32 = 0;
pub const XEN_DOMINF_dying: u32 = 1;
pub const _XEN_DOMINF_hvm_guest: u32 = 1;
pub const XEN_DOMINF_hvm_guest: u32 = 2;
pub const _XEN_DOMINF_shutdown: u32 = 2;
pub const XEN_DOMINF_shutdown: u32 = 4;
pub const _XEN_DOMINF_paused: u32 = 3;
pub const XEN_DOMINF_paused: u32 = 8;
pub const _XEN_DOMINF_blocked: u32 = 4;
pub const XEN_DOMINF_blocked: u32 = 16;
pub const _XEN_DOMINF_running: u32 = 5;
pub const XEN_DOMINF_running: u32 = 32;
pub const _XEN_DOMINF_debugged: u32 = 6;
pub const XEN_DOMINF_debugged: u32 = 64;
pub const _XEN_DOMINF_xs_domain: u32 = 7;
pub const XEN_DOMINF_xs_domain: u32 = 128;
pub const _XEN_DOMINF_hap: u32 = 8;
pub const XEN_DOMINF_hap: u32 = 256;
pub const XEN_DOMINF_shutdownmask: u32 = 255;
pub const XEN_DOMINF_shutdownshift: u32 = 16;
pub const XEN_INVALID_MAX_VCPU_ID: i32 = -1;
pub const XEN_DOMCTL_PFINFO_LTAB_SHIFT: u32 = 28;
pub const XEN_DOMCTL_PFINFO_NOTAB: u32 = 0;
pub const XEN_DOMCTL_PFINFO_L1TAB: u32 = 268435456;
pub const XEN_DOMCTL_PFINFO_L2TAB: u32 = 536870912;
pub const XEN_DOMCTL_PFINFO_L3TAB: u32 = 805306368;
pub const XEN_DOMCTL_PFINFO_L4TAB: u32 = 1073741824;
pub const XEN_DOMCTL_PFINFO_LTABTYPE_MASK: u32 = 1879048192;
pub const XEN_DOMCTL_PFINFO_LPINTAB: u32 = 2147483648;
pub const XEN_DOMCTL_PFINFO_XTAB: u32 = 4026531840;
pub const XEN_DOMCTL_PFINFO_XALLOC: u32 = 3758096384;
pub const XEN_DOMCTL_PFINFO_BROKEN: u32 = 3489660928;
pub const XEN_DOMCTL_PFINFO_LTAB_MASK: u32 = 4026531840;
pub const XEN_DOMCTL_SHADOW_OP_OFF: u32 = 0;
pub const XEN_DOMCTL_SHADOW_OP_ENABLE: u32 = 32;
pub const XEN_DOMCTL_SHADOW_OP_CLEAN: u32 = 11;
pub const XEN_DOMCTL_SHADOW_OP_PEEK: u32 = 12;
pub const XEN_DOMCTL_SHADOW_OP_GET_ALLOCATION: u32 = 30;
pub const XEN_DOMCTL_SHADOW_OP_SET_ALLOCATION: u32 = 31;
pub const XEN_DOMCTL_SHADOW_OP_ENABLE_TEST: u32 = 1;
pub const XEN_DOMCTL_SHADOW_OP_ENABLE_LOGDIRTY: u32 = 2;
pub const XEN_DOMCTL_SHADOW_ENABLE_REFCOUNT: u32 = 2;
pub const XEN_DOMCTL_SHADOW_ENABLE_LOG_DIRTY: u32 = 4;
pub const XEN_DOMCTL_SHADOW_ENABLE_TRANSLATE: u32 = 8;
pub const XEN_DOMCTL_SHADOW_ENABLE_EXTERNAL: u32 = 16;
pub const XEN_DOMCTL_SHADOW_LOGDIRTY_FINAL: u32 = 1;
pub const _XEN_VCPUAFFINITY_HARD: u32 = 0;
pub const XEN_VCPUAFFINITY_HARD: u32 = 1;
pub const _XEN_VCPUAFFINITY_SOFT: u32 = 1;
pub const XEN_VCPUAFFINITY_SOFT: u32 = 2;
pub const _XEN_VCPUAFFINITY_FORCE: u32 = 2;
pub const XEN_VCPUAFFINITY_FORCE: u32 = 4;
pub const XEN_SCHEDULER_CREDIT: u32 = 5;
pub const XEN_SCHEDULER_CREDIT2: u32 = 6;
pub const XEN_SCHEDULER_ARINC653: u32 = 7;
pub const XEN_SCHEDULER_RTDS: u32 = 8;
pub const XEN_SCHEDULER_NULL: u32 = 9;
pub const XEN_DOMCTL_SCHEDOP_putinfo: u32 = 0;
pub const XEN_DOMCTL_SCHEDOP_getinfo: u32 = 1;
pub const XEN_DOMCTL_SCHEDOP_putvcpuinfo: u32 = 2;
pub const XEN_DOMCTL_SCHEDOP_getvcpuinfo: u32 = 3;
pub const XEN_DOMCTL_SENDTRIGGER_NMI: u32 = 0;
pub const XEN_DOMCTL_SENDTRIGGER_RESET: u32 = 1;
pub const XEN_DOMCTL_SENDTRIGGER_INIT: u32 = 2;
pub const XEN_DOMCTL_SENDTRIGGER_POWER: u32 = 3;
pub const XEN_DOMCTL_SENDTRIGGER_SLEEP: u32 = 4;
pub const XEN_DOMCTL_DEV_PCI: u32 = 0;
pub const XEN_DOMCTL_DEV_DT: u32 = 1;
pub const XEN_DOMCTL_DEV_RDM_RELAXED: u32 = 1;
pub const DPCI_ADD_MAPPING: u32 = 1;
pub const DPCI_REMOVE_MAPPING: u32 = 0;
pub const XEN_DOMCTL_MEM_CACHEATTR_UC: u32 = 0;
pub const XEN_DOMCTL_MEM_CACHEATTR_WC: u32 = 1;
pub const XEN_DOMCTL_MEM_CACHEATTR_WT: u32 = 4;
pub const XEN_DOMCTL_MEM_CACHEATTR_WP: u32 = 5;
pub const XEN_DOMCTL_MEM_CACHEATTR_WB: u32 = 6;
pub const XEN_DOMCTL_MEM_CACHEATTR_UCM: u32 = 7;
pub const XEN_CPUID_INPUT_UNUSED: u32 = 4294967295;
pub const XEN_DOMCTL_DEBUG_OP_SINGLE_STEP_OFF: u32 = 0;
pub const XEN_DOMCTL_DEBUG_OP_SINGLE_STEP_ON: u32 = 1;
pub const XEN_VM_EVENT_ENABLE: u32 = 0;
pub const XEN_VM_EVENT_DISABLE: u32 = 1;
pub const XEN_VM_EVENT_RESUME: u32 = 2;
pub const XEN_DOMCTL_VM_EVENT_OP_PAGING: u32 = 1;
pub const XEN_DOMCTL_VM_EVENT_OP_MONITOR: u32 = 2;
pub const XEN_DOMCTL_VM_EVENT_OP_SHARING: u32 = 3;
pub const XEN_DOMCTL_MEM_SHARING_CONTROL: u32 = 0;
pub const XEN_DOMCTL_PSR_CMT_OP_DETACH: u32 = 0;
pub const XEN_DOMCTL_PSR_CMT_OP_ATTACH: u32 = 1;
pub const XEN_DOMCTL_PSR_CMT_OP_QUERY_RMID: u32 = 2;
pub const XEN_DOMCTL_MONITOR_OP_ENABLE: u32 = 0;
pub const XEN_DOMCTL_MONITOR_OP_DISABLE: u32 = 1;
pub const XEN_DOMCTL_MONITOR_OP_GET_CAPABILITIES: u32 = 2;
pub const XEN_DOMCTL_MONITOR_OP_EMULATE_EACH_REP: u32 = 3;
pub const XEN_DOMCTL_MONITOR_EVENT_WRITE_CTRLREG: u32 = 0;
pub const XEN_DOMCTL_MONITOR_EVENT_MOV_TO_MSR: u32 = 1;
pub const XEN_DOMCTL_MONITOR_EVENT_SINGLESTEP: u32 = 2;
pub const XEN_DOMCTL_MONITOR_EVENT_SOFTWARE_BREAKPOINT: u32 = 3;
pub const XEN_DOMCTL_MONITOR_EVENT_GUEST_REQUEST: u32 = 4;
pub const XEN_DOMCTL_MONITOR_EVENT_DEBUG_EXCEPTION: u32 = 5;
pub const XEN_DOMCTL_MONITOR_EVENT_CPUID: u32 = 6;
pub const XEN_DOMCTL_MONITOR_EVENT_PRIVILEGED_CALL: u32 = 7;
pub const XEN_DOMCTL_MONITOR_EVENT_INTERRUPT: u32 = 8;
pub const XEN_DOMCTL_MONITOR_EVENT_DESC_ACCESS: u32 = 9;
pub const XEN_DOMCTL_PSR_CAT_OP_SET_L3_CBM: u32 = 0;
pub const XEN_DOMCTL_PSR_CAT_OP_GET_L3_CBM: u32 = 1;
pub const XEN_DOMCTL_PSR_CAT_OP_SET_L3_CODE: u32 = 2;
pub const XEN_DOMCTL_PSR_CAT_OP_SET_L3_DATA: u32 = 3;
pub const XEN_DOMCTL_PSR_CAT_OP_GET_L3_CODE: u32 = 4;
pub const XEN_DOMCTL_PSR_CAT_OP_GET_L3_DATA: u32 = 5;
pub const XEN_DOMCTL_createdomain: u32 = 1;
pub const XEN_DOMCTL_destroydomain: u32 = 2;
pub const XEN_DOMCTL_pausedomain: u32 = 3;
pub const XEN_DOMCTL_unpausedomain: u32 = 4;
pub const XEN_DOMCTL_getdomaininfo: u32 = 5;
pub const XEN_DOMCTL_getmemlist: u32 = 6;
pub const XEN_DOMCTL_setvcpuaffinity: u32 = 9;
pub const XEN_DOMCTL_shadow_op: u32 = 10;
pub const XEN_DOMCTL_max_mem: u32 = 11;
pub const XEN_DOMCTL_setvcpucontext: u32 = 12;
pub const XEN_DOMCTL_getvcpucontext: u32 = 13;
pub const XEN_DOMCTL_getvcpuinfo: u32 = 14;
pub const XEN_DOMCTL_max_vcpus: u32 = 15;
pub const XEN_DOMCTL_scheduler_op: u32 = 16;
pub const XEN_DOMCTL_setdomainhandle: u32 = 17;
pub const XEN_DOMCTL_setdebugging: u32 = 18;
pub const XEN_DOMCTL_irq_permission: u32 = 19;
pub const XEN_DOMCTL_iomem_permission: u32 = 20;
pub const XEN_DOMCTL_ioport_permission: u32 = 21;
pub const XEN_DOMCTL_hypercall_init: u32 = 22;
pub const XEN_DOMCTL_arch_setup: u32 = 23;
pub const XEN_DOMCTL_settimeoffset: u32 = 24;
pub const XEN_DOMCTL_getvcpuaffinity: u32 = 25;
pub const XEN_DOMCTL_real_mode_area: u32 = 26;
pub const XEN_DOMCTL_resumedomain: u32 = 27;
pub const XEN_DOMCTL_sendtrigger: u32 = 28;
pub const XEN_DOMCTL_subscribe: u32 = 29;
pub const XEN_DOMCTL_gethvmcontext: u32 = 33;
pub const XEN_DOMCTL_sethvmcontext: u32 = 34;
pub const XEN_DOMCTL_set_address_size: u32 = 35;
pub const XEN_DOMCTL_get_address_size: u32 = 36;
pub const XEN_DOMCTL_assign_device: u32 = 37;
pub const XEN_DOMCTL_bind_pt_irq: u32 = 38;
pub const XEN_DOMCTL_memory_mapping: u32 = 39;
pub const XEN_DOMCTL_ioport_mapping: u32 = 40;
pub const XEN_DOMCTL_pin_mem_cacheattr: u32 = 41;
pub const XEN_DOMCTL_set_ext_vcpucontext: u32 = 42;
pub const XEN_DOMCTL_get_ext_vcpucontext: u32 = 43;
pub const XEN_DOMCTL_set_opt_feature: u32 = 44;
pub const XEN_DOMCTL_test_assign_device: u32 = 45;
pub const XEN_DOMCTL_set_target: u32 = 46;
pub const XEN_DOMCTL_deassign_device: u32 = 47;
pub const XEN_DOMCTL_unbind_pt_irq: u32 = 48;
pub const XEN_DOMCTL_set_cpuid: u32 = 49;
pub const XEN_DOMCTL_get_device_group: u32 = 50;
pub const XEN_DOMCTL_set_machine_address_size: u32 = 51;
pub const XEN_DOMCTL_get_machine_address_size: u32 = 52;
pub const XEN_DOMCTL_suppress_spurious_page_faults: u32 = 53;
pub const XEN_DOMCTL_debug_op: u32 = 54;
pub const XEN_DOMCTL_gethvmcontext_partial: u32 = 55;
pub const XEN_DOMCTL_vm_event_op: u32 = 56;
pub const XEN_DOMCTL_mem_sharing_op: u32 = 57;
pub const XEN_DOMCTL_disable_migrate: u32 = 58;
pub const XEN_DOMCTL_gettscinfo: u32 = 59;
pub const XEN_DOMCTL_settscinfo: u32 = 60;
pub const XEN_DOMCTL_getpageframeinfo3: u32 = 61;
pub const XEN_DOMCTL_setvcpuextstate: u32 = 62;
pub const XEN_DOMCTL_getvcpuextstate: u32 = 63;
pub const XEN_DOMCTL_set_access_required: u32 = 64;
pub const XEN_DOMCTL_audit_p2m: u32 = 65;
pub const XEN_DOMCTL_set_virq_handler: u32 = 66;
pub const XEN_DOMCTL_set_broken_page_p2m: u32 = 67;
pub const XEN_DOMCTL_setnodeaffinity: u32 = 68;
pub const XEN_DOMCTL_getnodeaffinity: u32 = 69;
pub const XEN_DOMCTL_set_max_evtchn: u32 = 70;
pub const XEN_DOMCTL_cacheflush: u32 = 71;
pub const XEN_DOMCTL_get_vcpu_msrs: u32 = 72;
pub const XEN_DOMCTL_set_vcpu_msrs: u32 = 73;
pub const XEN_DOMCTL_setvnumainfo: u32 = 74;
pub const XEN_DOMCTL_psr_cmt_op: u32 = 75;
pub const XEN_DOMCTL_monitor_op: u32 = 77;
pub const XEN_DOMCTL_psr_cat_op: u32 = 78;
pub const XEN_DOMCTL_soft_reset: u32 = 79;
pub const XEN_DOMCTL_gdbsx_guestmemio: u32 = 1000;
pub const XEN_DOMCTL_gdbsx_pausevcpu: u32 = 1001;
pub const XEN_DOMCTL_gdbsx_unpausevcpu: u32 = 1002;
pub const XEN_DOMCTL_gdbsx_domstatus: u32 = 1003;
pub const TMEM_SPEC_VERSION: u32 = 1;
pub const TMEM_NEW_POOL: u32 = 1;
pub const TMEM_DESTROY_POOL: u32 = 2;
pub const TMEM_PUT_PAGE: u32 = 4;
pub const TMEM_GET_PAGE: u32 = 5;
pub const TMEM_FLUSH_PAGE: u32 = 6;
pub const TMEM_FLUSH_OBJECT: u32 = 7;
pub const TMEM_AUTH: u32 = 101;
pub const TMEM_RESTORE_NEW: u32 = 102;
pub const TMEM_POOL_PERSIST: u32 = 1;
pub const TMEM_POOL_SHARED: u32 = 2;
pub const TMEM_POOL_PRECOMPRESSED: u32 = 4;
pub const TMEM_POOL_PAGESIZE_SHIFT: u32 = 4;
pub const TMEM_POOL_PAGESIZE_MASK: u32 = 15;
pub const TMEM_POOL_VERSION_SHIFT: u32 = 24;
pub const TMEM_POOL_VERSION_MASK: u32 = 255;
pub const TMEM_POOL_RESERVED_BITS: u32 = 16776960;
pub const TMEM_CLIENT_COMPRESS: u32 = 1;
pub const TMEM_CLIENT_FROZEN: u32 = 2;
pub const EFROZEN: u32 = 1000;
pub const EEMPTY: u32 = 1001;
pub const XEN_SYSCTL_INTERFACE_VERSION: u32 = 15;
pub const XEN_SYSCTL_TBUFOP_get_info: u32 = 0;
pub const XEN_SYSCTL_TBUFOP_set_cpu_mask: u32 = 1;
pub const XEN_SYSCTL_TBUFOP_set_evt_mask: u32 = 2;
pub const XEN_SYSCTL_TBUFOP_set_size: u32 = 3;
pub const XEN_SYSCTL_TBUFOP_enable: u32 = 4;
pub const XEN_SYSCTL_TBUFOP_disable: u32 = 5;
pub const _XEN_SYSCTL_PHYSCAP_hvm: u32 = 0;
pub const XEN_SYSCTL_PHYSCAP_hvm: u32 = 1;
pub const _XEN_SYSCTL_PHYSCAP_hvm_directio: u32 = 1;
pub const XEN_SYSCTL_PHYSCAP_hvm_directio: u32 = 2;
pub const XEN_SYSCTL_PERFCOP_reset: u32 = 1;
pub const XEN_SYSCTL_PERFCOP_query: u32 = 2;
pub const PMSTAT_CATEGORY_MASK: u32 = 240;
pub const PMSTAT_PX: u32 = 16;
pub const PMSTAT_CX: u32 = 32;
pub const PMSTAT_get_max_px: u32 = 17;
pub const PMSTAT_get_pxstat: u32 = 18;
pub const PMSTAT_reset_pxstat: u32 = 19;
pub const PMSTAT_get_max_cx: u32 = 33;
pub const PMSTAT_get_cxstat: u32 = 34;
pub const PMSTAT_reset_cxstat: u32 = 35;
pub const XEN_SYSCTL_CPU_HOTPLUG_ONLINE: u32 = 0;
pub const XEN_SYSCTL_CPU_HOTPLUG_OFFLINE: u32 = 1;
pub const CPUFREQ_NAME_LEN: u32 = 16;
pub const SCALING_MAX_FREQ: u32 = 1;
pub const SCALING_MIN_FREQ: u32 = 2;
pub const SCALING_SETSPEED: u32 = 3;
pub const SAMPLING_RATE: u32 = 4;
pub const UP_THRESHOLD: u32 = 5;
pub const PM_PARA_CATEGORY_MASK: u32 = 240;
pub const CPUFREQ_PARA: u32 = 16;
pub const GET_CPUFREQ_PARA: u32 = 17;
pub const SET_CPUFREQ_GOV: u32 = 18;
pub const SET_CPUFREQ_PARA: u32 = 19;
pub const GET_CPUFREQ_AVGFREQ: u32 = 20;
pub const XEN_SYSCTL_pm_op_set_sched_opt_smt: u32 = 33;
pub const XEN_SYSCTL_pm_op_get_max_cstate: u32 = 34;
pub const XEN_SYSCTL_pm_op_set_max_cstate: u32 = 35;
pub const XEN_SYSCTL_pm_op_set_vcpu_migration_delay: u32 = 36;
pub const XEN_SYSCTL_pm_op_get_vcpu_migration_delay: u32 = 37;
pub const XEN_SYSCTL_pm_op_enable_turbo: u32 = 38;
pub const XEN_SYSCTL_pm_op_disable_turbo: u32 = 39;
pub const sysctl_page_offline: u32 = 1;
pub const sysctl_page_online: u32 = 2;
pub const sysctl_query_page_offline: u32 = 3;
pub const PG_OFFLINE_STATUS_MASK: u32 = 255;
pub const PG_OFFLINE_INVALID: u32 = 1;
pub const PG_OFFLINE_OFFLINED: u32 = 2;
pub const PG_OFFLINE_PENDING: u32 = 4;
pub const PG_OFFLINE_FAILED: u32 = 8;
pub const PG_OFFLINE_AGAIN: u32 = 16;
pub const PG_ONLINE_FAILED: u32 = 8;
pub const PG_ONLINE_ONLINED: u32 = 2;
pub const PG_OFFLINE_STATUS_OFFLINED: u32 = 2;
pub const PG_OFFLINE_STATUS_ONLINE: u32 = 4;
pub const PG_OFFLINE_STATUS_OFFLINE_PENDING: u32 = 8;
pub const PG_OFFLINE_STATUS_BROKEN: u32 = 16;
pub const PG_OFFLINE_MISC_MASK: u32 = 4080;
pub const PG_OFFLINE_XENPAGE: u32 = 256;
pub const PG_OFFLINE_DOM0PAGE: u32 = 512;
pub const PG_OFFLINE_ANONYMOUS: u32 = 1024;
pub const PG_OFFLINE_NOT_CONV_RAM: u32 = 2048;
pub const PG_OFFLINE_OWNED: u32 = 4096;
pub const PG_OFFLINE_BROKEN: u32 = 8192;
pub const PG_ONLINE_BROKEN: u32 = 8192;
pub const PG_OFFLINE_OWNER_SHIFT: u32 = 16;
pub const XEN_SYSCTL_LOCKPROF_reset: u32 = 1;
pub const XEN_SYSCTL_LOCKPROF_query: u32 = 2;
pub const LOCKPROF_TYPE_GLOBAL: u32 = 0;
pub const LOCKPROF_TYPE_PERDOM: u32 = 1;
pub const LOCKPROF_TYPE_N: u32 = 2;
pub const XEN_INVALID_CORE_ID: i32 = -1;
pub const XEN_INVALID_SOCKET_ID: i32 = -1;
pub const XEN_INVALID_NODE_ID: i32 = -1;
pub const XEN_INVALID_MEM_SZ: i32 = -1;
pub const XEN_INVALID_NODE_DIST: i32 = -1;
pub const XEN_SYSCTL_CPUPOOL_OP_CREATE: u32 = 1;
pub const XEN_SYSCTL_CPUPOOL_OP_DESTROY: u32 = 2;
pub const XEN_SYSCTL_CPUPOOL_OP_INFO: u32 = 3;
pub const XEN_SYSCTL_CPUPOOL_OP_ADDCPU: u32 = 4;
pub const XEN_SYSCTL_CPUPOOL_OP_RMCPU: u32 = 5;
pub const XEN_SYSCTL_CPUPOOL_OP_MOVEDOMAIN: u32 = 6;
pub const XEN_SYSCTL_CPUPOOL_OP_FREEINFO: u32 = 7;
pub const XEN_SYSCTL_CPUPOOL_PAR_ANY: u32 = 4294967295;
pub const ARINC653_MAX_DOMAINS_PER_SCHEDULE: u32 = 64;
pub const XEN_SYSCTL_SCHED_RATELIMIT_MAX: u32 = 500000;
pub const XEN_SYSCTL_SCHED_RATELIMIT_MIN: u32 = 100;
pub const XEN_SYSCTL_CSCHED_TSLICE_MAX: u32 = 1000;
pub const XEN_SYSCTL_CSCHED_TSLICE_MIN: u32 = 1;
pub const XEN_SYSCTL_SCHEDOP_putinfo: u32 = 0;
pub const XEN_SYSCTL_SCHEDOP_getinfo: u32 = 1;
pub const XEN_GCOV_FORMAT_MAGIC: u32 = 1480806230;
pub const XEN_SYSCTL_GCOV_get_size: u32 = 0;
pub const XEN_SYSCTL_GCOV_read: u32 = 1;
pub const XEN_SYSCTL_GCOV_reset: u32 = 2;
pub const XEN_SYSCTL_PSR_CMT_get_total_rmid: u32 = 0;
pub const XEN_SYSCTL_PSR_CMT_get_l3_upscaling_factor: u32 = 1;
pub const XEN_SYSCTL_PSR_CMT_get_l3_cache_size: u32 = 2;
pub const XEN_SYSCTL_PSR_CMT_enabled: u32 = 3;
pub const XEN_SYSCTL_PSR_CMT_get_l3_event_mask: u32 = 4;
pub const XEN_INVALID_DEV: i32 = -2;
pub const XEN_SYSCTL_PSR_CAT_get_l3_info: u32 = 0;
pub const XEN_SYSCTL_PSR_CAT_L3_CDP: u32 = 1;
pub const XEN_SYSCTL_TMEM_OP_ALL_CLIENTS: u32 = 65535;
pub const XEN_SYSCTL_TMEM_OP_THAW: u32 = 0;
pub const XEN_SYSCTL_TMEM_OP_FREEZE: u32 = 1;
pub const XEN_SYSCTL_TMEM_OP_FLUSH: u32 = 2;
pub const XEN_SYSCTL_TMEM_OP_DESTROY: u32 = 3;
pub const XEN_SYSCTL_TMEM_OP_LIST: u32 = 4;
pub const XEN_SYSCTL_TMEM_OP_GET_CLIENT_INFO: u32 = 5;
pub const XEN_SYSCTL_TMEM_OP_SET_CLIENT_INFO: u32 = 6;
pub const XEN_SYSCTL_TMEM_OP_GET_POOLS: u32 = 7;
pub const XEN_SYSCTL_TMEM_OP_QUERY_FREEABLE_MB: u32 = 8;
pub const XEN_SYSCTL_TMEM_OP_SET_POOLS: u32 = 9;
pub const XEN_SYSCTL_TMEM_OP_SAVE_BEGIN: u32 = 10;
pub const XEN_SYSCTL_TMEM_OP_SET_AUTH: u32 = 11;
pub const XEN_SYSCTL_TMEM_OP_SAVE_GET_NEXT_PAGE: u32 = 19;
pub const XEN_SYSCTL_TMEM_OP_SAVE_GET_NEXT_INV: u32 = 20;
pub const XEN_SYSCTL_TMEM_OP_SAVE_END: u32 = 21;
pub const XEN_SYSCTL_TMEM_OP_RESTORE_BEGIN: u32 = 30;
pub const XEN_SYSCTL_TMEM_OP_RESTORE_PUT_PAGE: u32 = 32;
pub const XEN_SYSCTL_TMEM_OP_RESTORE_FLUSH_PAGE: u32 = 33;
pub const XEN_SYSCTL_CPU_LEVELCAP_faulting: u32 = 1;
pub const XEN_SYSCTL_CPU_LEVELCAP_ecx: u32 = 2;
pub const XEN_SYSCTL_CPU_LEVELCAP_edx: u32 = 4;
pub const XEN_SYSCTL_CPU_LEVELCAP_extd_ecx: u32 = 8;
pub const XEN_SYSCTL_CPU_LEVELCAP_extd_edx: u32 = 16;
pub const XEN_SYSCTL_CPU_LEVELCAP_xsave_eax: u32 = 32;
pub const XEN_SYSCTL_CPU_LEVELCAP_thermal_ecx: u32 = 64;
pub const XEN_SYSCTL_CPU_LEVELCAP_l7s0_eax: u32 = 128;
pub const XEN_SYSCTL_CPU_LEVELCAP_l7s0_ebx: u32 = 256;
pub const XEN_SYSCTL_cpu_featureset_raw: u32 = 0;
pub const XEN_SYSCTL_cpu_featureset_host: u32 = 1;
pub const XEN_SYSCTL_cpu_featureset_pv: u32 = 2;
pub const XEN_SYSCTL_cpu_featureset_hvm: u32 = 3;
pub const LIVEPATCH_PAYLOAD_VERSION: u32 = 1;
pub const XEN_LIVEPATCH_NAME_SIZE: u32 = 128;
pub const XEN_SYSCTL_LIVEPATCH_UPLOAD: u32 = 0;
pub const XEN_SYSCTL_LIVEPATCH_GET: u32 = 1;
pub const LIVEPATCH_STATE_CHECKED: u32 = 1;
pub const LIVEPATCH_STATE_APPLIED: u32 = 2;
pub const XEN_SYSCTL_LIVEPATCH_LIST: u32 = 2;
pub const XEN_SYSCTL_LIVEPATCH_ACTION: u32 = 3;
pub const LIVEPATCH_ACTION_UNLOAD: u32 = 1;
pub const LIVEPATCH_ACTION_REVERT: u32 = 2;
pub const LIVEPATCH_ACTION_APPLY: u32 = 3;
pub const LIVEPATCH_ACTION_REPLACE: u32 = 4;
pub const XEN_SYSCTL_readconsole: u32 = 1;
pub const XEN_SYSCTL_tbuf_op: u32 = 2;
pub const XEN_SYSCTL_physinfo: u32 = 3;
pub const XEN_SYSCTL_sched_id: u32 = 4;
pub const XEN_SYSCTL_perfc_op: u32 = 5;
pub const XEN_SYSCTL_getdomaininfolist: u32 = 6;
pub const XEN_SYSCTL_debug_keys: u32 = 7;
pub const XEN_SYSCTL_getcpuinfo: u32 = 8;
pub const XEN_SYSCTL_availheap: u32 = 9;
pub const XEN_SYSCTL_get_pmstat: u32 = 10;
pub const XEN_SYSCTL_cpu_hotplug: u32 = 11;
pub const XEN_SYSCTL_pm_op: u32 = 12;
pub const XEN_SYSCTL_page_offline_op: u32 = 14;
pub const XEN_SYSCTL_lockprof_op: u32 = 15;
pub const XEN_SYSCTL_cputopoinfo: u32 = 16;
pub const XEN_SYSCTL_numainfo: u32 = 17;
pub const XEN_SYSCTL_cpupool_op: u32 = 18;
pub const XEN_SYSCTL_scheduler_op: u32 = 19;
pub const XEN_SYSCTL_gcov_op: u32 = 20;
pub const XEN_SYSCTL_psr_cmt_op: u32 = 21;
pub const XEN_SYSCTL_pcitopoinfo: u32 = 22;
pub const XEN_SYSCTL_psr_cat_op: u32 = 23;
pub const XEN_SYSCTL_tmem_op: u32 = 24;
pub const XEN_SYSCTL_get_cpu_levelling_caps: u32 = 25;
pub const XEN_SYSCTL_get_cpu_featureset: u32 = 26;
pub const XEN_SYSCTL_livepatch_op: u32 = 27;
pub const XENVER_version: u32 = 0;
pub const XENVER_extraversion: u32 = 1;
pub const XENVER_compile_info: u32 = 2;
pub const XENVER_capabilities: u32 = 3;
pub const XENVER_changeset: u32 = 4;
pub const XENVER_platform_parameters: u32 = 5;
pub const XENVER_get_features: u32 = 6;
pub const XENFEAT_writable_page_tables: u32 = 0;
pub const XENFEAT_writable_descriptor_tables: u32 = 1;
pub const XENFEAT_auto_translated_physmap: u32 = 2;
pub const XENFEAT_supervisor_mode_kernel: u32 = 3;
pub const XENFEAT_pae_pgdir_above_4gb: u32 = 4;
pub const XENFEAT_mmu_pt_update_preserve_ad: u32 = 5;
pub const XENFEAT_highmem_assist: u32 = 6;
pub const XENFEAT_gnttab_map_avail_bits: u32 = 7;
pub const XENFEAT_hvm_callback_vector: u32 = 8;
pub const XENFEAT_hvm_safe_pvclock: u32 = 9;
pub const XENFEAT_hvm_pirqs: u32 = 10;
pub const XENFEAT_dom0: u32 = 11;
pub const XENFEAT_memory_op_vnode_supported: u32 = 13;
pub const XENFEAT_NR_SUBMAPS: u32 = 1;
pub const XENVER_pagesize: u32 = 7;
pub const XENVER_guest_handle: u32 = 8;
pub const XENVER_commandline: u32 = 9;
pub const XENVER_build_id: u32 = 10;
pub const EVTCHNOP_bind_interdomain: u32 = 0;
pub const EVTCHNOP_bind_virq: u32 = 1;
pub const EVTCHNOP_bind_pirq: u32 = 2;
pub const EVTCHNOP_close: u32 = 3;
pub const EVTCHNOP_send: u32 = 4;
pub const EVTCHNOP_status: u32 = 5;
pub const EVTCHNOP_alloc_unbound: u32 = 6;
pub const EVTCHNOP_bind_ipi: u32 = 7;
pub const EVTCHNOP_bind_vcpu: u32 = 8;
pub const EVTCHNOP_unmask: u32 = 9;
pub const EVTCHNOP_reset: u32 = 10;
pub const EVTCHNOP_init_control: u32 = 11;
pub const EVTCHNOP_expand_array: u32 = 12;
pub const EVTCHNOP_set_priority: u32 = 13;
pub const BIND_PIRQ__WILL_SHARE: u32 = 1;
pub const EVTCHNSTAT_closed: u32 = 0;
pub const EVTCHNSTAT_unbound: u32 = 1;
pub const EVTCHNSTAT_interdomain: u32 = 2;
pub const EVTCHNSTAT_pirq: u32 = 3;
pub const EVTCHNSTAT_virq: u32 = 4;
pub const EVTCHNSTAT_ipi: u32 = 5;
pub const EVTCHN_FIFO_PRIORITY_MAX: u32 = 0;
pub const EVTCHN_FIFO_PRIORITY_DEFAULT: u32 = 7;
pub const EVTCHN_FIFO_PRIORITY_MIN: u32 = 15;
pub const EVTCHN_FIFO_MAX_QUEUES: u32 = 16;
pub const EVTCHN_FIFO_PENDING: u32 = 31;
pub const EVTCHN_FIFO_MASKED: u32 = 30;
pub const EVTCHN_FIFO_LINKED: u32 = 29;
pub const EVTCHN_FIFO_BUSY: u32 = 28;
pub const EVTCHN_FIFO_LINK_BITS: u32 = 17;
pub const EVTCHN_FIFO_LINK_MASK: u32 = 131071;
pub const EVTCHN_FIFO_NR_CHANNELS: u32 = 131072;
pub const SCHEDOP_yield: u32 = 0;
pub const SCHEDOP_block: u32 = 1;
pub const SCHEDOP_shutdown: u32 = 2;
pub const SCHEDOP_poll: u32 = 3;
pub const SCHEDOP_remote_shutdown: u32 = 4;
pub const SCHEDOP_shutdown_code: u32 = 5;
pub const SCHEDOP_watchdog: u32 = 6;
pub const SCHEDOP_pin_override: u32 = 7;
pub const SHUTDOWN_poweroff: u32 = 0;
pub const SHUTDOWN_reboot: u32 = 1;
pub const SHUTDOWN_suspend: u32 = 2;
pub const SHUTDOWN_crash: u32 = 3;
pub const SHUTDOWN_watchdog: u32 = 4;
pub const SHUTDOWN_soft_reset: u32 = 5;
pub const SHUTDOWN_MAX: u32 = 5;
pub const XEN_DMOP_create_ioreq_server: u32 = 1;
pub const XEN_DMOP_get_ioreq_server_info: u32 = 2;
pub const XEN_DMOP_map_io_range_to_ioreq_server: u32 = 3;
pub const XEN_DMOP_unmap_io_range_from_ioreq_server: u32 = 4;
pub const XEN_DMOP_IO_RANGE_PORT: u32 = 0;
pub const XEN_DMOP_IO_RANGE_MEMORY: u32 = 1;
pub const XEN_DMOP_IO_RANGE_PCI: u32 = 2;
pub const XEN_DMOP_set_ioreq_server_state: u32 = 5;
pub const XEN_DMOP_destroy_ioreq_server: u32 = 6;
pub const XEN_DMOP_track_dirty_vram: u32 = 7;
pub const XEN_DMOP_set_pci_intx_level: u32 = 8;
pub const XEN_DMOP_set_isa_irq_level: u32 = 9;
pub const XEN_DMOP_set_pci_link_route: u32 = 10;
pub const XEN_DMOP_modified_memory: u32 = 11;
pub const XEN_DMOP_set_mem_type: u32 = 12;
pub const XEN_DMOP_inject_event: u32 = 13;
pub const XEN_DMOP_EVENT_ext_int: u32 = 0;
pub const XEN_DMOP_EVENT_nmi: u32 = 2;
pub const XEN_DMOP_EVENT_hw_exc: u32 = 3;
pub const XEN_DMOP_EVENT_sw_int: u32 = 4;
pub const XEN_DMOP_EVENT_pri_sw_exc: u32 = 5;
pub const XEN_DMOP_EVENT_sw_exc: u32 = 6;
pub const XEN_DMOP_inject_msi: u32 = 14;
pub const XEN_DMOP_map_mem_type_to_ioreq_server: u32 = 15;
pub const XEN_DMOP_IOREQ_MEM_ACCESS_READ: u32 = 1;
pub const XEN_DMOP_IOREQ_MEM_ACCESS_WRITE: u32 = 2;
pub const TRACE_EXTRA_MAX: u32 = 7;
pub const TRACE_EXTRA_SHIFT: u32 = 28;
pub const TRC_CLS_SHIFT: u32 = 16;
pub const TRC_GEN: u32 = 126976;
pub const TRC_SCHED: u32 = 192512;
pub const TRC_DOM0OP: u32 = 323584;
pub const TRC_HVM: u32 = 585728;
pub const TRC_MEM: u32 = 1110016;
pub const TRC_PV: u32 = 2158592;
pub const TRC_SHADOW: u32 = 4255744;
pub const TRC_HW: u32 = 8450048;
pub const TRC_GUEST: u32 = 134279168;
pub const TRC_ALL: u32 = 268431360;
pub const TRC_HD_CYCLE_FLAG: u32 = 2147483648;
pub const TRC_SUBCLS_SHIFT: u32 = 12;
pub const TRC_HVM_ENTRYEXIT: u32 = 528384;
pub const TRC_HVM_HANDLER: u32 = 532480;
pub const TRC_HVM_EMUL: u32 = 540672;
pub const TRC_SCHED_MIN: u32 = 135168;
pub const TRC_SCHED_CLASS: u32 = 139264;
pub const TRC_SCHED_VERBOSE: u32 = 163840;
pub const TRC_SCHED_ID_BITS: u32 = 3;
pub const TRC_SCHED_ID_SHIFT: u32 = 9;
pub const TRC_SCHED_ID_MASK: u32 = 3584;
pub const TRC_SCHED_EVT_MASK: i32 = -3585;
pub const TRC_SCHED_CSCHED: u32 = 0;
pub const TRC_SCHED_CSCHED2: u32 = 1;
pub const TRC_SCHED_ARINC653: u32 = 3;
pub const TRC_SCHED_RTDS: u32 = 4;
pub const TRC_DOM0_DOMOPS: u32 = 266240;
pub const TRC_HW_PM: u32 = 8392704;
pub const TRC_HW_IRQ: u32 = 8396800;
pub const TRC_LOST_RECORDS: u32 = 126977;
pub const TRC_TRACE_WRAP_BUFFER: u32 = 126978;
pub const TRC_TRACE_CPU_CHANGE: u32 = 126979;
pub const TRC_SCHED_RUNSTATE_CHANGE: u32 = 135169;
pub const TRC_SCHED_CONTINUE_RUNNING: u32 = 135170;
pub const TRC_SCHED_DOM_ADD: u32 = 163841;
pub const TRC_SCHED_DOM_REM: u32 = 163842;
pub const TRC_SCHED_SLEEP: u32 = 163843;
pub const TRC_SCHED_WAKE: u32 = 163844;
pub const TRC_SCHED_YIELD: u32 = 163845;
pub const TRC_SCHED_BLOCK: u32 = 163846;
pub const TRC_SCHED_SHUTDOWN: u32 = 163847;
pub const TRC_SCHED_CTL: u32 = 163848;
pub const TRC_SCHED_ADJDOM: u32 = 163849;
pub const TRC_SCHED_SWITCH: u32 = 163850;
pub const TRC_SCHED_S_TIMER_FN: u32 = 163851;
pub const TRC_SCHED_T_TIMER_FN: u32 = 163852;
pub const TRC_SCHED_DOM_TIMER_FN: u32 = 163853;
pub const TRC_SCHED_SWITCH_INFPREV: u32 = 163854;
pub const TRC_SCHED_SWITCH_INFNEXT: u32 = 163855;
pub const TRC_SCHED_SHUTDOWN_CODE: u32 = 163856;
pub const TRC_SCHED_SWITCH_INFCONT: u32 = 163857;
pub const TRC_DOM0_DOM_ADD: u32 = 266241;
pub const TRC_DOM0_DOM_REM: u32 = 266242;
pub const TRC_MEM_PAGE_GRANT_MAP: u32 = 1110017;
pub const TRC_MEM_PAGE_GRANT_UNMAP: u32 = 1110018;
pub const TRC_MEM_PAGE_GRANT_TRANSFER: u32 = 1110019;
pub const TRC_MEM_SET_P2M_ENTRY: u32 = 1110020;
pub const TRC_MEM_DECREASE_RESERVATION: u32 = 1110021;
pub const TRC_MEM_POD_POPULATE: u32 = 1110032;
pub const TRC_MEM_POD_ZERO_RECLAIM: u32 = 1110033;
pub const TRC_MEM_POD_SUPERPAGE_SPLINTER: u32 = 1110034;
pub const TRC_PV_ENTRY: u32 = 2101248;
pub const TRC_PV_SUBCALL: u32 = 2105344;
pub const TRC_PV_HYPERCALL: u32 = 2101249;
pub const TRC_PV_TRAP: u32 = 2101251;
pub const TRC_PV_PAGE_FAULT: u32 = 2101252;
pub const TRC_PV_FORCED_INVALID_OP: u32 = 2101253;
pub const TRC_PV_EMULATE_PRIVOP: u32 = 2101254;
pub const TRC_PV_EMULATE_4GB: u32 = 2101255;
pub const TRC_PV_MATH_STATE_RESTORE: u32 = 2101256;
pub const TRC_PV_PAGING_FIXUP: u32 = 2101257;
pub const TRC_PV_GDT_LDT_MAPPING_FAULT: u32 = 2101258;
pub const TRC_PV_PTWR_EMULATION: u32 = 2101259;
pub const TRC_PV_PTWR_EMULATION_PAE: u32 = 2101260;
pub const TRC_PV_HYPERCALL_V2: u32 = 2101261;
pub const TRC_PV_HYPERCALL_SUBCALL: u32 = 2105358;
pub const TRC_PV_HYPERCALL_V2_ARG_MASK: u32 = 4293918720;
pub const TRC_SHADOW_NOT_SHADOW: u32 = 4255745;
pub const TRC_SHADOW_FAST_PROPAGATE: u32 = 4255746;
pub const TRC_SHADOW_FAST_MMIO: u32 = 4255747;
pub const TRC_SHADOW_FALSE_FAST_PATH: u32 = 4255748;
pub const TRC_SHADOW_MMIO: u32 = 4255749;
pub const TRC_SHADOW_FIXUP: u32 = 4255750;
pub const TRC_SHADOW_DOMF_DYING: u32 = 4255751;
pub const TRC_SHADOW_EMULATE: u32 = 4255752;
pub const TRC_SHADOW_EMULATE_UNSHADOW_USER: u32 = 4255753;
pub const TRC_SHADOW_EMULATE_UNSHADOW_EVTINJ: u32 = 4255754;
pub const TRC_SHADOW_EMULATE_UNSHADOW_UNHANDLED: u32 = 4255755;
pub const TRC_SHADOW_WRMAP_BF: u32 = 4255756;
pub const TRC_SHADOW_PREALLOC_UNPIN: u32 = 4255757;
pub const TRC_SHADOW_RESYNC_FULL: u32 = 4255758;
pub const TRC_SHADOW_RESYNC_ONLY: u32 = 4255759;
pub const TRC_HVM_NESTEDFLAG: u32 = 1024;
pub const TRC_HVM_VMENTRY: u32 = 528385;
pub const TRC_HVM_VMEXIT: u32 = 528386;
pub const TRC_HVM_PF_XEN: u32 = 532481;
pub const TRC_HVM_PF_INJECT: u32 = 532482;
pub const TRC_HVM_INJ_EXC: u32 = 532483;
pub const TRC_HVM_INJ_VIRQ: u32 = 532484;
pub const TRC_HVM_REINJ_VIRQ: u32 = 532485;
pub const TRC_HVM_IO_READ: u32 = 532486;
pub const TRC_HVM_IO_WRITE: u32 = 532487;
pub const TRC_HVM_CR_READ: u32 = 532488;
pub const TRC_HVM_CR_WRITE: u32 = 532489;
pub const TRC_HVM_DR_READ: u32 = 532490;
pub const TRC_HVM_DR_WRITE: u32 = 532491;
pub const TRC_HVM_MSR_READ: u32 = 532492;
pub const TRC_HVM_MSR_WRITE: u32 = 532493;
pub const TRC_HVM_CPUID: u32 = 532494;
pub const TRC_HVM_INTR: u32 = 532495;
pub const TRC_HVM_NMI: u32 = 532496;
pub const TRC_HVM_SMI: u32 = 532497;
pub const TRC_HVM_VMMCALL: u32 = 532498;
pub const TRC_HVM_HLT: u32 = 532499;
pub const TRC_HVM_INVLPG: u32 = 532500;
pub const TRC_HVM_MCE: u32 = 532501;
pub const TRC_HVM_IOPORT_READ: u32 = 532502;
pub const TRC_HVM_IOMEM_READ: u32 = 532503;
pub const TRC_HVM_CLTS: u32 = 532504;
pub const TRC_HVM_LMSW: u32 = 532505;
pub const TRC_HVM_RDTSC: u32 = 532506;
pub const TRC_HVM_INTR_WINDOW: u32 = 532512;
pub const TRC_HVM_NPF: u32 = 532513;
pub const TRC_HVM_REALMODE_EMULATE: u32 = 532514;
pub const TRC_HVM_TRAP: u32 = 532515;
pub const TRC_HVM_TRAP_DEBUG: u32 = 532516;
pub const TRC_HVM_VLAPIC: u32 = 532517;
pub const TRC_HVM_IOPORT_WRITE: u32 = 533014;
pub const TRC_HVM_IOMEM_WRITE: u32 = 533015;
pub const TRC_HVM_EMUL_HPET_START_TIMER: u32 = 540673;
pub const TRC_HVM_EMUL_PIT_START_TIMER: u32 = 540674;
pub const TRC_HVM_EMUL_RTC_START_TIMER: u32 = 540675;
pub const TRC_HVM_EMUL_LAPIC_START_TIMER: u32 = 540676;
pub const TRC_HVM_EMUL_HPET_STOP_TIMER: u32 = 540677;
pub const TRC_HVM_EMUL_PIT_STOP_TIMER: u32 = 540678;
pub const TRC_HVM_EMUL_RTC_STOP_TIMER: u32 = 540679;
pub const TRC_HVM_EMUL_LAPIC_STOP_TIMER: u32 = 540680;
pub const TRC_HVM_EMUL_PIT_TIMER_CB: u32 = 540681;
pub const TRC_HVM_EMUL_LAPIC_TIMER_CB: u32 = 540682;
pub const TRC_HVM_EMUL_PIC_INT_OUTPUT: u32 = 540683;
pub const TRC_HVM_EMUL_PIC_KICK: u32 = 540684;
pub const TRC_HVM_EMUL_PIC_INTACK: u32 = 540685;
pub const TRC_HVM_EMUL_PIC_POSEDGE: u32 = 540686;
pub const TRC_HVM_EMUL_PIC_NEGEDGE: u32 = 540687;
pub const TRC_HVM_EMUL_PIC_PEND_IRQ_CALL: u32 = 540688;
pub const TRC_HVM_EMUL_LAPIC_PIC_INTR: u32 = 540689;
pub const TRC_PM_FREQ_CHANGE: u32 = 8392705;
pub const TRC_PM_IDLE_ENTRY: u32 = 8392706;
pub const TRC_PM_IDLE_EXIT: u32 = 8392707;
pub const TRC_HW_IRQ_MOVE_CLEANUP_DELAY: u32 = 8396801;
pub const TRC_HW_IRQ_MOVE_CLEANUP: u32 = 8396802;
pub const TRC_HW_IRQ_BIND_VECTOR: u32 = 8396803;
pub const TRC_HW_IRQ_CLEAR_VECTOR: u32 = 8396804;
pub const TRC_HW_IRQ_MOVE_FINISH: u32 = 8396805;
pub const TRC_HW_IRQ_ASSIGN_VECTOR: u32 = 8396806;
pub const TRC_HW_IRQ_UNMAPPED_VECTOR: u32 = 8396807;
pub const TRC_HW_IRQ_HANDLED: u32 = 8396808;
pub const TRC_64_FLAG: u32 = 256;
pub const HVMOP_set_param: u32 = 0;
pub const HVMOP_get_param: u32 = 1;
pub const HVMOP_flush_tlbs: u32 = 5;
pub const HVMOP_pagetable_dying: u32 = 9;
pub const HVMOP_get_time: u32 = 10;
pub const HVMOP_xentrace: u32 = 11;
pub const HVMOP_set_mem_access: u32 = 12;
pub const HVMOP_get_mem_access: u32 = 13;
pub const HVMOP_get_mem_type: u32 = 15;
pub const HVM_IOREQSRV_BUFIOREQ_OFF: u32 = 0;
pub const HVM_IOREQSRV_BUFIOREQ_LEGACY: u32 = 1;
pub const HVM_IOREQSRV_BUFIOREQ_ATOMIC: u32 = 2;
pub const HVMOP_set_evtchn_upcall_vector: u32 = 23;
pub const HVMOP_guest_request_vm_event: u32 = 24;
pub const HVMOP_altp2m: u32 = 25;
pub const HVMOP_ALTP2M_INTERFACE_VERSION: u32 = 1;
pub const HVMOP_altp2m_get_domain_state: u32 = 1;
pub const HVMOP_altp2m_set_domain_state: u32 = 2;
pub const HVMOP_altp2m_vcpu_enable_notify: u32 = 3;
pub const HVMOP_altp2m_create_p2m: u32 = 4;
pub const HVMOP_altp2m_destroy_p2m: u32 = 5;
pub const HVMOP_altp2m_switch_p2m: u32 = 6;
pub const HVMOP_altp2m_set_mem_access: u32 = 7;
pub const HVMOP_altp2m_change_gfn: u32 = 8;
pub const HVM_PARAM_CALLBACK_IRQ: u32 = 0;
pub const HVM_PARAM_CALLBACK_TYPE_GSI: u32 = 0;
pub const HVM_PARAM_CALLBACK_TYPE_PCI_INTX: u32 = 1;
pub const HVM_PARAM_CALLBACK_TYPE_VECTOR: u32 = 2;
pub const HVM_PARAM_STORE_PFN: u32 = 1;
pub const HVM_PARAM_STORE_EVTCHN: u32 = 2;
pub const HVM_PARAM_PAE_ENABLED: u32 = 4;
pub const HVM_PARAM_IOREQ_PFN: u32 = 5;
pub const HVM_PARAM_BUFIOREQ_PFN: u32 = 6;
pub const HVM_PARAM_BUFIOREQ_EVTCHN: u32 = 26;
pub const HVM_PARAM_VIRIDIAN: u32 = 9;
pub const _HVMPV_base_freq: u32 = 0;
pub const HVMPV_base_freq: u32 = 1;
pub const _HVMPV_no_freq: u32 = 1;
pub const HVMPV_no_freq: u32 = 2;
pub const _HVMPV_time_ref_count: u32 = 2;
pub const HVMPV_time_ref_count: u32 = 4;
pub const _HVMPV_reference_tsc: u32 = 3;
pub const HVMPV_reference_tsc: u32 = 8;
pub const _HVMPV_hcall_remote_tlb_flush: u32 = 4;
pub const HVMPV_hcall_remote_tlb_flush: u32 = 16;
pub const _HVMPV_apic_assist: u32 = 5;
pub const HVMPV_apic_assist: u32 = 32;
pub const _HVMPV_crash_ctl: u32 = 6;
pub const HVMPV_crash_ctl: u32 = 64;
pub const HVMPV_feature_mask: u32 = 127;
pub const HVM_PARAM_TIMER_MODE: u32 = 10;
pub const HVMPTM_delay_for_missed_ticks: u32 = 0;
pub const HVMPTM_no_delay_for_missed_ticks: u32 = 1;
pub const HVMPTM_no_missed_ticks_pending: u32 = 2;
pub const HVMPTM_one_missed_tick_pending: u32 = 3;
pub const HVM_PARAM_HPET_ENABLED: u32 = 11;
pub const HVM_PARAM_IDENT_PT: u32 = 12;
pub const HVM_PARAM_DM_DOMAIN: u32 = 13;
pub const HVM_PARAM_ACPI_S_STATE: u32 = 14;
pub const HVM_PARAM_VM86_TSS: u32 = 15;
pub const HVM_PARAM_VPT_ALIGN: u32 = 16;
pub const HVM_PARAM_CONSOLE_PFN: u32 = 17;
pub const HVM_PARAM_CONSOLE_EVTCHN: u32 = 18;
pub const HVM_PARAM_ACPI_IOPORTS_LOCATION: u32 = 19;
pub const HVM_PARAM_MEMORY_EVENT_CR0: u32 = 20;
pub const HVM_PARAM_MEMORY_EVENT_CR3: u32 = 21;
pub const HVM_PARAM_MEMORY_EVENT_CR4: u32 = 22;
pub const HVM_PARAM_MEMORY_EVENT_INT3: u32 = 23;
pub const HVM_PARAM_MEMORY_EVENT_SINGLE_STEP: u32 = 25;
pub const HVM_PARAM_MEMORY_EVENT_MSR: u32 = 30;
pub const HVM_PARAM_NESTEDHVM: u32 = 24;
pub const HVM_PARAM_PAGING_RING_PFN: u32 = 27;
pub const HVM_PARAM_MONITOR_RING_PFN: u32 = 28;
pub const HVM_PARAM_SHARING_RING_PFN: u32 = 29;
pub const HVM_PARAM_TRIPLE_FAULT_REASON: u32 = 31;
pub const HVM_PARAM_IOREQ_SERVER_PFN: u32 = 32;
pub const HVM_PARAM_NR_IOREQ_SERVER_PAGES: u32 = 33;
pub const HVM_PARAM_VM_GENERATION_ID_ADDR: u32 = 34;
pub const HVM_PARAM_ALTP2M: u32 = 35;
pub const XEN_ALTP2M_disabled: u32 = 0;
pub const XEN_ALTP2M_mixed: u32 = 1;
pub const XEN_ALTP2M_external: u32 = 2;
pub const XEN_ALTP2M_limited: u32 = 3;
pub const HVM_PARAM_X87_FIP_WIDTH: u32 = 36;
pub const HVM_PARAM_VM86_TSS_SIZED: u32 = 37;
pub const HVM_PARAM_MCA_CAP: u32 = 38;
pub const HVM_NR_PARAMS: u32 = 39;
pub const XEN_FLASK_INTERFACE_VERSION: u32 = 1;
pub const FLASK_LOAD: u32 = 1;
pub const FLASK_GETENFORCE: u32 = 2;
pub const FLASK_SETENFORCE: u32 = 3;
pub const FLASK_CONTEXT_TO_SID: u32 = 4;
pub const FLASK_SID_TO_CONTEXT: u32 = 5;
pub const FLASK_ACCESS: u32 = 6;
pub const FLASK_CREATE: u32 = 7;
pub const FLASK_RELABEL: u32 = 8;
pub const FLASK_USER: u32 = 9;
pub const FLASK_POLICYVERS: u32 = 10;
pub const FLASK_GETBOOL: u32 = 11;
pub const FLASK_SETBOOL: u32 = 12;
pub const FLASK_COMMITBOOLS: u32 = 13;
pub const FLASK_MLS: u32 = 14;
pub const FLASK_DISABLE: u32 = 15;
pub const FLASK_GETAVC_THRESHOLD: u32 = 16;
pub const FLASK_SETAVC_THRESHOLD: u32 = 17;
pub const FLASK_AVC_HASHSTATS: u32 = 18;
pub const FLASK_AVC_CACHESTATS: u32 = 19;
pub const FLASK_MEMBER: u32 = 20;
pub const FLASK_ADD_OCONTEXT: u32 = 21;
pub const FLASK_DEL_OCONTEXT: u32 = 22;
pub const FLASK_GET_PEER_SID: u32 = 23;
pub const FLASK_RELABEL_DOMAIN: u32 = 24;
pub const FLASK_DEVICETREE_LABEL: u32 = 25;
pub const KEXEC_XEN_NO_PAGES: u32 = 17;
pub const KEXEC_TYPE_DEFAULT: u32 = 0;
pub const KEXEC_TYPE_CRASH: u32 = 1;
pub const KEXEC_CMD_kexec: u32 = 0;
pub const KEXEC_CMD_kexec_load_v1: u32 = 1;
pub const KEXEC_CMD_kexec_unload_v1: u32 = 2;
pub const KEXEC_RANGE_MA_CRASH: u32 = 0;
pub const KEXEC_RANGE_MA_XEN: u32 = 1;
pub const KEXEC_RANGE_MA_CPU: u32 = 2;
pub const KEXEC_RANGE_MA_XENHEAP: u32 = 3;
pub const KEXEC_RANGE_MA_BOOT_PARAM: u32 = 4;
pub const KEXEC_RANGE_MA_EFI_MEMMAP: u32 = 5;
pub const KEXEC_RANGE_MA_VMCOREINFO: u32 = 6;
pub const KEXEC_CMD_kexec_get_range: u32 = 3;
pub const KEXEC_CMD_kexec_load: u32 = 4;
pub const KEXEC_CMD_kexec_unload: u32 = 5;
pub const KEXEC_CMD_kexec_status: u32 = 6;
pub const XENPF_INTERFACE_VERSION: u32 = 50331649;
pub const XENPF_settime32: u32 = 17;
pub const XENPF_settime64: u32 = 62;
pub const XENPF_settime: u32 = 62;
pub const XENPF_add_memtype: u32 = 31;
pub const XENPF_del_memtype: u32 = 32;
pub const XENPF_read_memtype: u32 = 33;
pub const XENPF_microcode_update: u32 = 35;
pub const XENPF_platform_quirk: u32 = 39;
pub const QUIRK_NOIRQBALANCING: u32 = 1;
pub const QUIRK_IOAPIC_BAD_REGSEL: u32 = 2;
pub const QUIRK_IOAPIC_GOOD_REGSEL: u32 = 3;
pub const XENPF_efi_runtime_call: u32 = 49;
pub const XEN_EFI_get_time: u32 = 1;
pub const XEN_EFI_set_time: u32 = 2;
pub const XEN_EFI_get_wakeup_time: u32 = 3;
pub const XEN_EFI_set_wakeup_time: u32 = 4;
pub const XEN_EFI_get_next_high_monotonic_count: u32 = 5;
pub const XEN_EFI_get_variable: u32 = 6;
pub const XEN_EFI_set_variable: u32 = 7;
pub const XEN_EFI_get_next_variable_name: u32 = 8;
pub const XEN_EFI_query_variable_info: u32 = 9;
pub const XEN_EFI_query_capsule_capabilities: u32 = 10;
pub const XEN_EFI_update_capsule: u32 = 11;
pub const XEN_EFI_GET_TIME_SET_CLEARS_NS: u32 = 1;
pub const XEN_EFI_GET_WAKEUP_TIME_ENABLED: u32 = 1;
pub const XEN_EFI_GET_WAKEUP_TIME_PENDING: u32 = 2;
pub const XEN_EFI_SET_WAKEUP_TIME_ENABLE: u32 = 1;
pub const XEN_EFI_SET_WAKEUP_TIME_ENABLE_ONLY: u32 = 2;
pub const XEN_EFI_VARIABLE_NON_VOLATILE: u32 = 1;
pub const XEN_EFI_VARIABLE_BOOTSERVICE_ACCESS: u32 = 2;
pub const XEN_EFI_VARIABLE_RUNTIME_ACCESS: u32 = 4;
pub const XEN_EFI_VARINFO_BOOT_SNAPSHOT: u32 = 1;
pub const XENPF_firmware_info: u32 = 50;
pub const XEN_FW_DISK_INFO: u32 = 1;
pub const XEN_FW_DISK_MBR_SIGNATURE: u32 = 2;
pub const XEN_FW_VBEDDC_INFO: u32 = 3;
pub const XEN_FW_EFI_INFO: u32 = 4;
pub const XEN_FW_EFI_VERSION: u32 = 0;
pub const XEN_FW_EFI_CONFIG_TABLE: u32 = 1;
pub const XEN_FW_EFI_VENDOR: u32 = 2;
pub const XEN_FW_EFI_MEM_INFO: u32 = 3;
pub const XEN_FW_EFI_RT_VERSION: u32 = 4;
pub const XEN_FW_EFI_PCI_ROM: u32 = 5;
pub const XEN_FW_EFI_APPLE_PROPERTIES: u32 = 6;
pub const XEN_FW_KBD_SHIFT_FLAGS: u32 = 5;
pub const XENPF_enter_acpi_sleep: u32 = 51;
pub const XENPF_ACPI_SLEEP_EXTENDED: u32 = 1;
pub const XENPF_change_freq: u32 = 52;
pub const XENPF_getidletime: u32 = 53;
pub const XENPF_set_processor_pminfo: u32 = 54;
pub const XEN_PROCESSOR_PM_CX: u32 = 1;
pub const XEN_PROCESSOR_PM_PX: u32 = 2;
pub const XEN_PROCESSOR_PM_TX: u32 = 4;
pub const XEN_PM_CX: u32 = 0;
pub const XEN_PM_PX: u32 = 1;
pub const XEN_PM_TX: u32 = 2;
pub const XEN_PM_PDC: u32 = 3;
pub const XEN_PX_PCT: u32 = 1;
pub const XEN_PX_PSS: u32 = 2;
pub const XEN_PX_PPC: u32 = 4;
pub const XEN_PX_PSD: u32 = 8;
pub const XENPF_get_cpuinfo: u32 = 55;
pub const XEN_PCPU_FLAGS_ONLINE: u32 = 1;
pub const XEN_PCPU_FLAGS_INVALID: u32 = 2;
pub const XENPF_get_cpu_version: u32 = 48;
pub const XENPF_cpu_online: u32 = 56;
pub const XENPF_cpu_offline: u32 = 57;
pub const XENPF_cpu_hotadd: u32 = 58;
pub const XENPF_mem_hotadd: u32 = 59;
pub const XENPF_core_parking: u32 = 60;
pub const XEN_CORE_PARKING_SET: u32 = 1;
pub const XEN_CORE_PARKING_GET: u32 = 2;
pub const XENPF_resource_op: u32 = 61;
pub const XEN_RESOURCE_OP_MSR_READ: u32 = 0;
pub const XEN_RESOURCE_OP_MSR_WRITE: u32 = 1;
pub const XENPF_get_symbol: u32 = 63;
pub const XTL_STDIOSTREAM_SHOW_PID: u32 = 1;
pub const XTL_STDIOSTREAM_SHOW_DATE: u32 = 2;
pub const XTL_STDIOSTREAM_HIDE_PROGRESS: u32 = 4;
pub const XTL_STDIOSTREAM_PROGRESS_USE_CR: u32 = 8;
pub const XTL_STDIOSTREAM_PROGRESS_NO_CR: u32 = 16;
pub const __FOREIGN_X86_32_H_TMP__: u32 = 1;
pub const __i386___X86_32: u32 = 1;
pub const FLAT_RING1_CS_X86_32: u32 = 57369;
pub const FLAT_RING1_DS_X86_32: u32 = 57377;
pub const FLAT_RING1_SS_X86_32: u32 = 57377;
pub const FLAT_KERNEL_CS_X86_32: u32 = 57369;
pub const FLAT_KERNEL_DS_X86_32: u32 = 57377;
pub const FLAT_KERNEL_SS_X86_32: u32 = 57377;
pub const XEN_HAVE_PV_GUEST_ENTRY_X86_32: u32 = 1;
pub const XEN_LEGACY_MAX_VCPUS_X86_32: u32 = 32;
pub const _VGCF_i387_valid_X86_32: u32 = 0;
pub const VGCF_i387_valid_X86_32: u32 = 1;
pub const _VGCF_in_kernel_X86_32: u32 = 2;
pub const VGCF_in_kernel_X86_32: u32 = 4;
pub const _VGCF_failsafe_disables_events_X86_32: u32 = 3;
pub const VGCF_failsafe_disables_events_X86_32: u32 = 8;
pub const _VGCF_syscall_disables_events_X86_32: u32 = 4;
pub const VGCF_syscall_disables_events_X86_32: u32 = 16;
pub const _VGCF_online_X86_32: u32 = 5;
pub const VGCF_online_X86_32: u32 = 32;
pub const MAX_GUEST_CMDLINE_X86_32: u32 = 1024;
pub const x86_32_has_no_vcpu_cr_regs: u32 = 1;
pub const x86_32_has_no_vcpu_ar_regs: u32 = 1;
pub const x86_32_has_no_vcpu_guest_core_regs: u32 = 1;
pub const __FOREIGN_X86_64_H_TMP__: u32 = 1;
pub const __x86_64___X86_64: u32 = 1;
pub const FLAT_RING3_CS64_X86_64: u32 = 57395;
pub const FLAT_RING3_DS64_X86_64: u32 = 0;
pub const FLAT_RING3_SS64_X86_64: u32 = 57387;
pub const FLAT_KERNEL_DS64_X86_64: u32 = 0;
pub const FLAT_KERNEL_DS_X86_64: u32 = 0;
pub const FLAT_KERNEL_CS64_X86_64: u32 = 57395;
pub const FLAT_KERNEL_CS_X86_64: u32 = 57395;
pub const FLAT_KERNEL_SS64_X86_64: u32 = 57387;
pub const FLAT_KERNEL_SS_X86_64: u32 = 57387;
pub const XEN_HAVE_PV_GUEST_ENTRY_X86_64: u32 = 1;
pub const XEN_LEGACY_MAX_VCPUS_X86_64: u32 = 32;
pub const _VGCF_i387_valid_X86_64: u32 = 0;
pub const VGCF_i387_valid_X86_64: u32 = 1;
pub const _VGCF_in_kernel_X86_64: u32 = 2;
pub const VGCF_in_kernel_X86_64: u32 = 4;
pub const _VGCF_failsafe_disables_events_X86_64: u32 = 3;
pub const VGCF_failsafe_disables_events_X86_64: u32 = 8;
pub const _VGCF_syscall_disables_events_X86_64: u32 = 4;
pub const VGCF_syscall_disables_events_X86_64: u32 = 16;
pub const _VGCF_online_X86_64: u32 = 5;
pub const VGCF_online_X86_64: u32 = 32;
pub const MAX_GUEST_CMDLINE_X86_64: u32 = 1024;
pub const x86_64_has_no_vcpu_cr_regs: u32 = 1;
pub const x86_64_has_no_vcpu_ar_regs: u32 = 1;
pub const x86_64_has_no_vcpu_guest_core_regs: u32 = 1;
pub const __HYPERVISOR_mca: u32 = 48;
pub const XEN_MCA_INTERFACE_VERSION: u32 = 32292867;
pub const XEN_MC_NONURGENT: u32 = 1;
pub const XEN_MC_URGENT: u32 = 2;
pub const XEN_MC_ACK: u32 = 4;
pub const XEN_MC_OK: u32 = 0;
pub const XEN_MC_FETCHFAILED: u32 = 1;
pub const XEN_MC_NODATA: u32 = 2;
pub const XEN_MC_NOMATCH: u32 = 4;
pub const XEN_MC_CANNOTHANDLE: u32 = 8;
pub const XEN_MC_NOTDELIVERED: u32 = 16;
pub const XEN_MC_VCPUID_INVALID: u32 = 65535;
pub const VIRQ_MCA: u32 = 16;
pub const MC_TYPE_GLOBAL: u32 = 0;
pub const MC_TYPE_BANK: u32 = 1;
pub const MC_TYPE_EXTENDED: u32 = 2;
pub const MC_TYPE_RECOVERY: u32 = 3;
pub const MC_FLAG_CORRECTABLE: u32 = 1;
pub const MC_FLAG_UNCORRECTABLE: u32 = 2;
pub const MC_FLAG_RECOVERABLE: u32 = 4;
pub const MC_FLAG_POLLED: u32 = 8;
pub const MC_FLAG_RESET: u32 = 16;
pub const MC_FLAG_CMCI: u32 = 32;
pub const MC_FLAG_MCE: u32 = 64;
pub const REC_ACTION_RECOVERED: u32 = 1;
pub const REC_ACTION_NONE: u32 = 2;
pub const REC_ACTION_NEED_RESET: u32 = 4;
pub const MC_ACTION_PAGE_OFFLINE: u32 = 1;
pub const MC_ACTION_CPU_OFFLINE: u32 = 2;
pub const MC_ACTION_CACHE_SHRINK: u32 = 4;
pub const MAX_UNION_SIZE: u32 = 16;
pub const MCINFO_HYPERCALLSIZE: u32 = 1024;
pub const MCINFO_MAXSIZE: u32 = 768;
pub const MCINFO_FLAGS_UNCOMPLETE: u32 = 1;
pub const __MC_MSR_ARRAYSIZE: u32 = 8;
pub const __MC_NMSRS: u32 = 1;
pub const MC_NCAPS: u32 = 7;
pub const MC_CAPS_STD_EDX: u32 = 0;
pub const MC_CAPS_AMD_EDX: u32 = 1;
pub const MC_CAPS_TM: u32 = 2;
pub const MC_CAPS_LINUX: u32 = 3;
pub const MC_CAPS_STD_ECX: u32 = 4;
pub const MC_CAPS_VIA: u32 = 5;
pub const MC_CAPS_AMD_ECX: u32 = 6;
pub const XEN_MC_fetch: u32 = 1;
pub const XEN_MC_notifydomain: u32 = 2;
pub const XEN_MC_physcpuinfo: u32 = 3;
pub const XEN_MC_msrinject: u32 = 4;
pub const MC_MSRINJ_MAXMSRS: u32 = 8;
pub const MC_MSRINJ_F_INTERPOSE: u32 = 1;
pub const MC_MSRINJ_F_GPADDR: u32 = 2;
pub const XEN_MC_mceinject: u32 = 5;
pub const XEN_MC_inject_v2: u32 = 6;
pub const XEN_MC_INJECT_TYPE_MASK: u32 = 7;
pub const XEN_MC_INJECT_TYPE_MCE: u32 = 0;
pub const XEN_MC_INJECT_TYPE_CMCI: u32 = 1;
pub const XEN_MC_INJECT_TYPE_LMCE: u32 = 2;
pub const XEN_MC_INJECT_CPU_BROADCAST: u32 = 8;
pub const XC_PAGE_SHIFT: u32 = 12;
pub const XC_PAGE_SIZE: u32 = 4096;
pub const XC_PAGE_MASK: i32 = -4096;
pub const INVALID_MFN: i32 = -1;
pub const XENCTRL_HAS_XC_INTERFACE: u32 = 1;
pub const XC_CORE_MAGIC: u32 = 4027575277;
pub const XC_CORE_MAGIC_HVM: u32 = 4027575278;
pub const XC_CPUPOOL_POOLID_ANY: u32 = 4294967295;
pub const E820_RAM: u32 = 1;
pub const E820_RESERVED: u32 = 2;
pub const E820_ACPI: u32 = 3;
pub const E820_NVS: u32 = 4;
pub const E820_UNUSABLE: u32 = 5;
pub const E820MAX: u32 = 128;
pub const XC_MAX_ERROR_MSG_LEN: u32 = 1024;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type gid_t = __gid_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type useconds_t = __useconds_t;
pub type pid_t = __pid_t;
pub type socklen_t = __socklen_t;
extern "C" {
    pub fn access(
        __name: *const ::std::os::raw::c_char,
        __type: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faccessat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __type: ::std::os::raw::c_int,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lseek(
        __fd: ::std::os::raw::c_int,
        __offset: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> __off_t;
}
extern "C" {
    pub fn close(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn read(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbytes: usize,
    ) -> isize;
}
extern "C" {
    pub fn write(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: usize,
    ) -> isize;
}
extern "C" {
    pub fn pread(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbytes: usize,
        __offset: __off_t,
    ) -> isize;
}
extern "C" {
    pub fn pwrite(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: usize,
        __offset: __off_t,
    ) -> isize;
}
extern "C" {
    pub fn pipe(__pipedes: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn alarm(__seconds: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sleep(__seconds: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn ualarm(__value: __useconds_t, __interval: __useconds_t) -> __useconds_t;
}
extern "C" {
    pub fn usleep(__useconds: __useconds_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pause() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chown(
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchown(
        __fd: ::std::os::raw::c_int,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchown(
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchownat(
        __fd: ::std::os::raw::c_int,
        __file: *const ::std::os::raw::c_char,
        __owner: __uid_t,
        __group: __gid_t,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chdir(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchdir(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getcwd(__buf: *mut ::std::os::raw::c_char, __size: usize)
        -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getwd(__buf: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn dup(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup2(__fd: ::std::os::raw::c_int, __fd2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut __environ: *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn execve(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fexecve(
        __fd: ::std::os::raw::c_int,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execv(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execle(
        __path: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execl(
        __path: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execvp(
        __file: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execlp(
        __file: *const ::std::os::raw::c_char,
        __arg: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nice(__inc: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _exit(__status: ::std::os::raw::c_int);
}
pub const _PC_LINK_MAX: _bindgen_ty_1 = 0;
pub const _PC_MAX_CANON: _bindgen_ty_1 = 1;
pub const _PC_MAX_INPUT: _bindgen_ty_1 = 2;
pub const _PC_NAME_MAX: _bindgen_ty_1 = 3;
pub const _PC_PATH_MAX: _bindgen_ty_1 = 4;
pub const _PC_PIPE_BUF: _bindgen_ty_1 = 5;
pub const _PC_CHOWN_RESTRICTED: _bindgen_ty_1 = 6;
pub const _PC_NO_TRUNC: _bindgen_ty_1 = 7;
pub const _PC_VDISABLE: _bindgen_ty_1 = 8;
pub const _PC_SYNC_IO: _bindgen_ty_1 = 9;
pub const _PC_ASYNC_IO: _bindgen_ty_1 = 10;
pub const _PC_PRIO_IO: _bindgen_ty_1 = 11;
pub const _PC_SOCK_MAXBUF: _bindgen_ty_1 = 12;
pub const _PC_FILESIZEBITS: _bindgen_ty_1 = 13;
pub const _PC_REC_INCR_XFER_SIZE: _bindgen_ty_1 = 14;
pub const _PC_REC_MAX_XFER_SIZE: _bindgen_ty_1 = 15;
pub const _PC_REC_MIN_XFER_SIZE: _bindgen_ty_1 = 16;
pub const _PC_REC_XFER_ALIGN: _bindgen_ty_1 = 17;
pub const _PC_ALLOC_SIZE_MIN: _bindgen_ty_1 = 18;
pub const _PC_SYMLINK_MAX: _bindgen_ty_1 = 19;
pub const _PC_2_SYMLINKS: _bindgen_ty_1 = 20;
pub type _bindgen_ty_1 = u32;
pub const _SC_ARG_MAX: _bindgen_ty_2 = 0;
pub const _SC_CHILD_MAX: _bindgen_ty_2 = 1;
pub const _SC_CLK_TCK: _bindgen_ty_2 = 2;
pub const _SC_NGROUPS_MAX: _bindgen_ty_2 = 3;
pub const _SC_OPEN_MAX: _bindgen_ty_2 = 4;
pub const _SC_STREAM_MAX: _bindgen_ty_2 = 5;
pub const _SC_TZNAME_MAX: _bindgen_ty_2 = 6;
pub const _SC_JOB_CONTROL: _bindgen_ty_2 = 7;
pub const _SC_SAVED_IDS: _bindgen_ty_2 = 8;
pub const _SC_REALTIME_SIGNALS: _bindgen_ty_2 = 9;
pub const _SC_PRIORITY_SCHEDULING: _bindgen_ty_2 = 10;
pub const _SC_TIMERS: _bindgen_ty_2 = 11;
pub const _SC_ASYNCHRONOUS_IO: _bindgen_ty_2 = 12;
pub const _SC_PRIORITIZED_IO: _bindgen_ty_2 = 13;
pub const _SC_SYNCHRONIZED_IO: _bindgen_ty_2 = 14;
pub const _SC_FSYNC: _bindgen_ty_2 = 15;
pub const _SC_MAPPED_FILES: _bindgen_ty_2 = 16;
pub const _SC_MEMLOCK: _bindgen_ty_2 = 17;
pub const _SC_MEMLOCK_RANGE: _bindgen_ty_2 = 18;
pub const _SC_MEMORY_PROTECTION: _bindgen_ty_2 = 19;
pub const _SC_MESSAGE_PASSING: _bindgen_ty_2 = 20;
pub const _SC_SEMAPHORES: _bindgen_ty_2 = 21;
pub const _SC_SHARED_MEMORY_OBJECTS: _bindgen_ty_2 = 22;
pub const _SC_AIO_LISTIO_MAX: _bindgen_ty_2 = 23;
pub const _SC_AIO_MAX: _bindgen_ty_2 = 24;
pub const _SC_AIO_PRIO_DELTA_MAX: _bindgen_ty_2 = 25;
pub const _SC_DELAYTIMER_MAX: _bindgen_ty_2 = 26;
pub const _SC_MQ_OPEN_MAX: _bindgen_ty_2 = 27;
pub const _SC_MQ_PRIO_MAX: _bindgen_ty_2 = 28;
pub const _SC_VERSION: _bindgen_ty_2 = 29;
pub const _SC_PAGESIZE: _bindgen_ty_2 = 30;
pub const _SC_RTSIG_MAX: _bindgen_ty_2 = 31;
pub const _SC_SEM_NSEMS_MAX: _bindgen_ty_2 = 32;
pub const _SC_SEM_VALUE_MAX: _bindgen_ty_2 = 33;
pub const _SC_SIGQUEUE_MAX: _bindgen_ty_2 = 34;
pub const _SC_TIMER_MAX: _bindgen_ty_2 = 35;
pub const _SC_BC_BASE_MAX: _bindgen_ty_2 = 36;
pub const _SC_BC_DIM_MAX: _bindgen_ty_2 = 37;
pub const _SC_BC_SCALE_MAX: _bindgen_ty_2 = 38;
pub const _SC_BC_STRING_MAX: _bindgen_ty_2 = 39;
pub const _SC_COLL_WEIGHTS_MAX: _bindgen_ty_2 = 40;
pub const _SC_EQUIV_CLASS_MAX: _bindgen_ty_2 = 41;
pub const _SC_EXPR_NEST_MAX: _bindgen_ty_2 = 42;
pub const _SC_LINE_MAX: _bindgen_ty_2 = 43;
pub const _SC_RE_DUP_MAX: _bindgen_ty_2 = 44;
pub const _SC_CHARCLASS_NAME_MAX: _bindgen_ty_2 = 45;
pub const _SC_2_VERSION: _bindgen_ty_2 = 46;
pub const _SC_2_C_BIND: _bindgen_ty_2 = 47;
pub const _SC_2_C_DEV: _bindgen_ty_2 = 48;
pub const _SC_2_FORT_DEV: _bindgen_ty_2 = 49;
pub const _SC_2_FORT_RUN: _bindgen_ty_2 = 50;
pub const _SC_2_SW_DEV: _bindgen_ty_2 = 51;
pub const _SC_2_LOCALEDEF: _bindgen_ty_2 = 52;
pub const _SC_PII: _bindgen_ty_2 = 53;
pub const _SC_PII_XTI: _bindgen_ty_2 = 54;
pub const _SC_PII_SOCKET: _bindgen_ty_2 = 55;
pub const _SC_PII_INTERNET: _bindgen_ty_2 = 56;
pub const _SC_PII_OSI: _bindgen_ty_2 = 57;
pub const _SC_POLL: _bindgen_ty_2 = 58;
pub const _SC_SELECT: _bindgen_ty_2 = 59;
pub const _SC_UIO_MAXIOV: _bindgen_ty_2 = 60;
pub const _SC_IOV_MAX: _bindgen_ty_2 = 60;
pub const _SC_PII_INTERNET_STREAM: _bindgen_ty_2 = 61;
pub const _SC_PII_INTERNET_DGRAM: _bindgen_ty_2 = 62;
pub const _SC_PII_OSI_COTS: _bindgen_ty_2 = 63;
pub const _SC_PII_OSI_CLTS: _bindgen_ty_2 = 64;
pub const _SC_PII_OSI_M: _bindgen_ty_2 = 65;
pub const _SC_T_IOV_MAX: _bindgen_ty_2 = 66;
pub const _SC_THREADS: _bindgen_ty_2 = 67;
pub const _SC_THREAD_SAFE_FUNCTIONS: _bindgen_ty_2 = 68;
pub const _SC_GETGR_R_SIZE_MAX: _bindgen_ty_2 = 69;
pub const _SC_GETPW_R_SIZE_MAX: _bindgen_ty_2 = 70;
pub const _SC_LOGIN_NAME_MAX: _bindgen_ty_2 = 71;
pub const _SC_TTY_NAME_MAX: _bindgen_ty_2 = 72;
pub const _SC_THREAD_DESTRUCTOR_ITERATIONS: _bindgen_ty_2 = 73;
pub const _SC_THREAD_KEYS_MAX: _bindgen_ty_2 = 74;
pub const _SC_THREAD_STACK_MIN: _bindgen_ty_2 = 75;
pub const _SC_THREAD_THREADS_MAX: _bindgen_ty_2 = 76;
pub const _SC_THREAD_ATTR_STACKADDR: _bindgen_ty_2 = 77;
pub const _SC_THREAD_ATTR_STACKSIZE: _bindgen_ty_2 = 78;
pub const _SC_THREAD_PRIORITY_SCHEDULING: _bindgen_ty_2 = 79;
pub const _SC_THREAD_PRIO_INHERIT: _bindgen_ty_2 = 80;
pub const _SC_THREAD_PRIO_PROTECT: _bindgen_ty_2 = 81;
pub const _SC_THREAD_PROCESS_SHARED: _bindgen_ty_2 = 82;
pub const _SC_NPROCESSORS_CONF: _bindgen_ty_2 = 83;
pub const _SC_NPROCESSORS_ONLN: _bindgen_ty_2 = 84;
pub const _SC_PHYS_PAGES: _bindgen_ty_2 = 85;
pub const _SC_AVPHYS_PAGES: _bindgen_ty_2 = 86;
pub const _SC_ATEXIT_MAX: _bindgen_ty_2 = 87;
pub const _SC_PASS_MAX: _bindgen_ty_2 = 88;
pub const _SC_XOPEN_VERSION: _bindgen_ty_2 = 89;
pub const _SC_XOPEN_XCU_VERSION: _bindgen_ty_2 = 90;
pub const _SC_XOPEN_UNIX: _bindgen_ty_2 = 91;
pub const _SC_XOPEN_CRYPT: _bindgen_ty_2 = 92;
pub const _SC_XOPEN_ENH_I18N: _bindgen_ty_2 = 93;
pub const _SC_XOPEN_SHM: _bindgen_ty_2 = 94;
pub const _SC_2_CHAR_TERM: _bindgen_ty_2 = 95;
pub const _SC_2_C_VERSION: _bindgen_ty_2 = 96;
pub const _SC_2_UPE: _bindgen_ty_2 = 97;
pub const _SC_XOPEN_XPG2: _bindgen_ty_2 = 98;
pub const _SC_XOPEN_XPG3: _bindgen_ty_2 = 99;
pub const _SC_XOPEN_XPG4: _bindgen_ty_2 = 100;
pub const _SC_CHAR_BIT: _bindgen_ty_2 = 101;
pub const _SC_CHAR_MAX: _bindgen_ty_2 = 102;
pub const _SC_CHAR_MIN: _bindgen_ty_2 = 103;
pub const _SC_INT_MAX: _bindgen_ty_2 = 104;
pub const _SC_INT_MIN: _bindgen_ty_2 = 105;
pub const _SC_LONG_BIT: _bindgen_ty_2 = 106;
pub const _SC_WORD_BIT: _bindgen_ty_2 = 107;
pub const _SC_MB_LEN_MAX: _bindgen_ty_2 = 108;
pub const _SC_NZERO: _bindgen_ty_2 = 109;
pub const _SC_SSIZE_MAX: _bindgen_ty_2 = 110;
pub const _SC_SCHAR_MAX: _bindgen_ty_2 = 111;
pub const _SC_SCHAR_MIN: _bindgen_ty_2 = 112;
pub const _SC_SHRT_MAX: _bindgen_ty_2 = 113;
pub const _SC_SHRT_MIN: _bindgen_ty_2 = 114;
pub const _SC_UCHAR_MAX: _bindgen_ty_2 = 115;
pub const _SC_UINT_MAX: _bindgen_ty_2 = 116;
pub const _SC_ULONG_MAX: _bindgen_ty_2 = 117;
pub const _SC_USHRT_MAX: _bindgen_ty_2 = 118;
pub const _SC_NL_ARGMAX: _bindgen_ty_2 = 119;
pub const _SC_NL_LANGMAX: _bindgen_ty_2 = 120;
pub const _SC_NL_MSGMAX: _bindgen_ty_2 = 121;
pub const _SC_NL_NMAX: _bindgen_ty_2 = 122;
pub const _SC_NL_SETMAX: _bindgen_ty_2 = 123;
pub const _SC_NL_TEXTMAX: _bindgen_ty_2 = 124;
pub const _SC_XBS5_ILP32_OFF32: _bindgen_ty_2 = 125;
pub const _SC_XBS5_ILP32_OFFBIG: _bindgen_ty_2 = 126;
pub const _SC_XBS5_LP64_OFF64: _bindgen_ty_2 = 127;
pub const _SC_XBS5_LPBIG_OFFBIG: _bindgen_ty_2 = 128;
pub const _SC_XOPEN_LEGACY: _bindgen_ty_2 = 129;
pub const _SC_XOPEN_REALTIME: _bindgen_ty_2 = 130;
pub const _SC_XOPEN_REALTIME_THREADS: _bindgen_ty_2 = 131;
pub const _SC_ADVISORY_INFO: _bindgen_ty_2 = 132;
pub const _SC_BARRIERS: _bindgen_ty_2 = 133;
pub const _SC_BASE: _bindgen_ty_2 = 134;
pub const _SC_C_LANG_SUPPORT: _bindgen_ty_2 = 135;
pub const _SC_C_LANG_SUPPORT_R: _bindgen_ty_2 = 136;
pub const _SC_CLOCK_SELECTION: _bindgen_ty_2 = 137;
pub const _SC_CPUTIME: _bindgen_ty_2 = 138;
pub const _SC_THREAD_CPUTIME: _bindgen_ty_2 = 139;
pub const _SC_DEVICE_IO: _bindgen_ty_2 = 140;
pub const _SC_DEVICE_SPECIFIC: _bindgen_ty_2 = 141;
pub const _SC_DEVICE_SPECIFIC_R: _bindgen_ty_2 = 142;
pub const _SC_FD_MGMT: _bindgen_ty_2 = 143;
pub const _SC_FIFO: _bindgen_ty_2 = 144;
pub const _SC_PIPE: _bindgen_ty_2 = 145;
pub const _SC_FILE_ATTRIBUTES: _bindgen_ty_2 = 146;
pub const _SC_FILE_LOCKING: _bindgen_ty_2 = 147;
pub const _SC_FILE_SYSTEM: _bindgen_ty_2 = 148;
pub const _SC_MONOTONIC_CLOCK: _bindgen_ty_2 = 149;
pub const _SC_MULTI_PROCESS: _bindgen_ty_2 = 150;
pub const _SC_SINGLE_PROCESS: _bindgen_ty_2 = 151;
pub const _SC_NETWORKING: _bindgen_ty_2 = 152;
pub const _SC_READER_WRITER_LOCKS: _bindgen_ty_2 = 153;
pub const _SC_SPIN_LOCKS: _bindgen_ty_2 = 154;
pub const _SC_REGEXP: _bindgen_ty_2 = 155;
pub const _SC_REGEX_VERSION: _bindgen_ty_2 = 156;
pub const _SC_SHELL: _bindgen_ty_2 = 157;
pub const _SC_SIGNALS: _bindgen_ty_2 = 158;
pub const _SC_SPAWN: _bindgen_ty_2 = 159;
pub const _SC_SPORADIC_SERVER: _bindgen_ty_2 = 160;
pub const _SC_THREAD_SPORADIC_SERVER: _bindgen_ty_2 = 161;
pub const _SC_SYSTEM_DATABASE: _bindgen_ty_2 = 162;
pub const _SC_SYSTEM_DATABASE_R: _bindgen_ty_2 = 163;
pub const _SC_TIMEOUTS: _bindgen_ty_2 = 164;
pub const _SC_TYPED_MEMORY_OBJECTS: _bindgen_ty_2 = 165;
pub const _SC_USER_GROUPS: _bindgen_ty_2 = 166;
pub const _SC_USER_GROUPS_R: _bindgen_ty_2 = 167;
pub const _SC_2_PBS: _bindgen_ty_2 = 168;
pub const _SC_2_PBS_ACCOUNTING: _bindgen_ty_2 = 169;
pub const _SC_2_PBS_LOCATE: _bindgen_ty_2 = 170;
pub const _SC_2_PBS_MESSAGE: _bindgen_ty_2 = 171;
pub const _SC_2_PBS_TRACK: _bindgen_ty_2 = 172;
pub const _SC_SYMLOOP_MAX: _bindgen_ty_2 = 173;
pub const _SC_STREAMS: _bindgen_ty_2 = 174;
pub const _SC_2_PBS_CHECKPOINT: _bindgen_ty_2 = 175;
pub const _SC_V6_ILP32_OFF32: _bindgen_ty_2 = 176;
pub const _SC_V6_ILP32_OFFBIG: _bindgen_ty_2 = 177;
pub const _SC_V6_LP64_OFF64: _bindgen_ty_2 = 178;
pub const _SC_V6_LPBIG_OFFBIG: _bindgen_ty_2 = 179;
pub const _SC_HOST_NAME_MAX: _bindgen_ty_2 = 180;
pub const _SC_TRACE: _bindgen_ty_2 = 181;
pub const _SC_TRACE_EVENT_FILTER: _bindgen_ty_2 = 182;
pub const _SC_TRACE_INHERIT: _bindgen_ty_2 = 183;
pub const _SC_TRACE_LOG: _bindgen_ty_2 = 184;
pub const _SC_LEVEL1_ICACHE_SIZE: _bindgen_ty_2 = 185;
pub const _SC_LEVEL1_ICACHE_ASSOC: _bindgen_ty_2 = 186;
pub const _SC_LEVEL1_ICACHE_LINESIZE: _bindgen_ty_2 = 187;
pub const _SC_LEVEL1_DCACHE_SIZE: _bindgen_ty_2 = 188;
pub const _SC_LEVEL1_DCACHE_ASSOC: _bindgen_ty_2 = 189;
pub const _SC_LEVEL1_DCACHE_LINESIZE: _bindgen_ty_2 = 190;
pub const _SC_LEVEL2_CACHE_SIZE: _bindgen_ty_2 = 191;
pub const _SC_LEVEL2_CACHE_ASSOC: _bindgen_ty_2 = 192;
pub const _SC_LEVEL2_CACHE_LINESIZE: _bindgen_ty_2 = 193;
pub const _SC_LEVEL3_CACHE_SIZE: _bindgen_ty_2 = 194;
pub const _SC_LEVEL3_CACHE_ASSOC: _bindgen_ty_2 = 195;
pub const _SC_LEVEL3_CACHE_LINESIZE: _bindgen_ty_2 = 196;
pub const _SC_LEVEL4_CACHE_SIZE: _bindgen_ty_2 = 197;
pub const _SC_LEVEL4_CACHE_ASSOC: _bindgen_ty_2 = 198;
pub const _SC_LEVEL4_CACHE_LINESIZE: _bindgen_ty_2 = 199;
pub const _SC_IPV6: _bindgen_ty_2 = 235;
pub const _SC_RAW_SOCKETS: _bindgen_ty_2 = 236;
pub const _SC_V7_ILP32_OFF32: _bindgen_ty_2 = 237;
pub const _SC_V7_ILP32_OFFBIG: _bindgen_ty_2 = 238;
pub const _SC_V7_LP64_OFF64: _bindgen_ty_2 = 239;
pub const _SC_V7_LPBIG_OFFBIG: _bindgen_ty_2 = 240;
pub const _SC_SS_REPL_MAX: _bindgen_ty_2 = 241;
pub const _SC_TRACE_EVENT_NAME_MAX: _bindgen_ty_2 = 242;
pub const _SC_TRACE_NAME_MAX: _bindgen_ty_2 = 243;
pub const _SC_TRACE_SYS_MAX: _bindgen_ty_2 = 244;
pub const _SC_TRACE_USER_EVENT_MAX: _bindgen_ty_2 = 245;
pub const _SC_XOPEN_STREAMS: _bindgen_ty_2 = 246;
pub const _SC_THREAD_ROBUST_PRIO_INHERIT: _bindgen_ty_2 = 247;
pub const _SC_THREAD_ROBUST_PRIO_PROTECT: _bindgen_ty_2 = 248;
pub type _bindgen_ty_2 = u32;
pub const _CS_PATH: _bindgen_ty_3 = 0;
pub const _CS_V6_WIDTH_RESTRICTED_ENVS: _bindgen_ty_3 = 1;
pub const _CS_GNU_LIBC_VERSION: _bindgen_ty_3 = 2;
pub const _CS_GNU_LIBPTHREAD_VERSION: _bindgen_ty_3 = 3;
pub const _CS_V5_WIDTH_RESTRICTED_ENVS: _bindgen_ty_3 = 4;
pub const _CS_V7_WIDTH_RESTRICTED_ENVS: _bindgen_ty_3 = 5;
pub const _CS_LFS_CFLAGS: _bindgen_ty_3 = 1000;
pub const _CS_LFS_LDFLAGS: _bindgen_ty_3 = 1001;
pub const _CS_LFS_LIBS: _bindgen_ty_3 = 1002;
pub const _CS_LFS_LINTFLAGS: _bindgen_ty_3 = 1003;
pub const _CS_LFS64_CFLAGS: _bindgen_ty_3 = 1004;
pub const _CS_LFS64_LDFLAGS: _bindgen_ty_3 = 1005;
pub const _CS_LFS64_LIBS: _bindgen_ty_3 = 1006;
pub const _CS_LFS64_LINTFLAGS: _bindgen_ty_3 = 1007;
pub const _CS_XBS5_ILP32_OFF32_CFLAGS: _bindgen_ty_3 = 1100;
pub const _CS_XBS5_ILP32_OFF32_LDFLAGS: _bindgen_ty_3 = 1101;
pub const _CS_XBS5_ILP32_OFF32_LIBS: _bindgen_ty_3 = 1102;
pub const _CS_XBS5_ILP32_OFF32_LINTFLAGS: _bindgen_ty_3 = 1103;
pub const _CS_XBS5_ILP32_OFFBIG_CFLAGS: _bindgen_ty_3 = 1104;
pub const _CS_XBS5_ILP32_OFFBIG_LDFLAGS: _bindgen_ty_3 = 1105;
pub const _CS_XBS5_ILP32_OFFBIG_LIBS: _bindgen_ty_3 = 1106;
pub const _CS_XBS5_ILP32_OFFBIG_LINTFLAGS: _bindgen_ty_3 = 1107;
pub const _CS_XBS5_LP64_OFF64_CFLAGS: _bindgen_ty_3 = 1108;
pub const _CS_XBS5_LP64_OFF64_LDFLAGS: _bindgen_ty_3 = 1109;
pub const _CS_XBS5_LP64_OFF64_LIBS: _bindgen_ty_3 = 1110;
pub const _CS_XBS5_LP64_OFF64_LINTFLAGS: _bindgen_ty_3 = 1111;
pub const _CS_XBS5_LPBIG_OFFBIG_CFLAGS: _bindgen_ty_3 = 1112;
pub const _CS_XBS5_LPBIG_OFFBIG_LDFLAGS: _bindgen_ty_3 = 1113;
pub const _CS_XBS5_LPBIG_OFFBIG_LIBS: _bindgen_ty_3 = 1114;
pub const _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS: _bindgen_ty_3 = 1115;
pub const _CS_POSIX_V6_ILP32_OFF32_CFLAGS: _bindgen_ty_3 = 1116;
pub const _CS_POSIX_V6_ILP32_OFF32_LDFLAGS: _bindgen_ty_3 = 1117;
pub const _CS_POSIX_V6_ILP32_OFF32_LIBS: _bindgen_ty_3 = 1118;
pub const _CS_POSIX_V6_ILP32_OFF32_LINTFLAGS: _bindgen_ty_3 = 1119;
pub const _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS: _bindgen_ty_3 = 1120;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS: _bindgen_ty_3 = 1121;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LIBS: _bindgen_ty_3 = 1122;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LINTFLAGS: _bindgen_ty_3 = 1123;
pub const _CS_POSIX_V6_LP64_OFF64_CFLAGS: _bindgen_ty_3 = 1124;
pub const _CS_POSIX_V6_LP64_OFF64_LDFLAGS: _bindgen_ty_3 = 1125;
pub const _CS_POSIX_V6_LP64_OFF64_LIBS: _bindgen_ty_3 = 1126;
pub const _CS_POSIX_V6_LP64_OFF64_LINTFLAGS: _bindgen_ty_3 = 1127;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS: _bindgen_ty_3 = 1128;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS: _bindgen_ty_3 = 1129;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LIBS: _bindgen_ty_3 = 1130;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LINTFLAGS: _bindgen_ty_3 = 1131;
pub const _CS_POSIX_V7_ILP32_OFF32_CFLAGS: _bindgen_ty_3 = 1132;
pub const _CS_POSIX_V7_ILP32_OFF32_LDFLAGS: _bindgen_ty_3 = 1133;
pub const _CS_POSIX_V7_ILP32_OFF32_LIBS: _bindgen_ty_3 = 1134;
pub const _CS_POSIX_V7_ILP32_OFF32_LINTFLAGS: _bindgen_ty_3 = 1135;
pub const _CS_POSIX_V7_ILP32_OFFBIG_CFLAGS: _bindgen_ty_3 = 1136;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LDFLAGS: _bindgen_ty_3 = 1137;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LIBS: _bindgen_ty_3 = 1138;
pub const _CS_POSIX_V7_ILP32_OFFBIG_LINTFLAGS: _bindgen_ty_3 = 1139;
pub const _CS_POSIX_V7_LP64_OFF64_CFLAGS: _bindgen_ty_3 = 1140;
pub const _CS_POSIX_V7_LP64_OFF64_LDFLAGS: _bindgen_ty_3 = 1141;
pub const _CS_POSIX_V7_LP64_OFF64_LIBS: _bindgen_ty_3 = 1142;
pub const _CS_POSIX_V7_LP64_OFF64_LINTFLAGS: _bindgen_ty_3 = 1143;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_CFLAGS: _bindgen_ty_3 = 1144;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LDFLAGS: _bindgen_ty_3 = 1145;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LIBS: _bindgen_ty_3 = 1146;
pub const _CS_POSIX_V7_LPBIG_OFFBIG_LINTFLAGS: _bindgen_ty_3 = 1147;
pub const _CS_V6_ENV: _bindgen_ty_3 = 1148;
pub const _CS_V7_ENV: _bindgen_ty_3 = 1149;
pub type _bindgen_ty_3 = u32;
extern "C" {
    pub fn pathconf(
        __path: *const ::std::os::raw::c_char,
        __name: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fpathconf(
        __fd: ::std::os::raw::c_int,
        __name: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sysconf(__name: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn confstr(
        __name: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> usize;
}
extern "C" {
    pub fn getpid() -> __pid_t;
}
extern "C" {
    pub fn getppid() -> __pid_t;
}
extern "C" {
    pub fn getpgrp() -> __pid_t;
}
extern "C" {
    pub fn __getpgid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn getpgid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn setpgid(__pid: __pid_t, __pgid: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpgrp() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsid() -> __pid_t;
}
extern "C" {
    pub fn getsid(__pid: __pid_t) -> __pid_t;
}
extern "C" {
    pub fn getuid() -> __uid_t;
}
extern "C" {
    pub fn geteuid() -> __uid_t;
}
extern "C" {
    pub fn getgid() -> __gid_t;
}
extern "C" {
    pub fn getegid() -> __gid_t;
}
extern "C" {
    pub fn getgroups(__size: ::std::os::raw::c_int, __list: *mut __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setuid(__uid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setreuid(__ruid: __uid_t, __euid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seteuid(__uid: __uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgid(__gid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setregid(__rgid: __gid_t, __egid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setegid(__gid: __gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fork() -> __pid_t;
}
extern "C" {
    pub fn vfork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyname(__fd: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ttyname_r(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_char,
        __buflen: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isatty(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyslot() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn link(
        __from: *const ::std::os::raw::c_char,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn linkat(
        __fromfd: ::std::os::raw::c_int,
        __from: *const ::std::os::raw::c_char,
        __tofd: ::std::os::raw::c_int,
        __to: *const ::std::os::raw::c_char,
        __flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn symlink(
        __from: *const ::std::os::raw::c_char,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlink(
        __path: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> isize;
}
extern "C" {
    pub fn symlinkat(
        __from: *const ::std::os::raw::c_char,
        __tofd: ::std::os::raw::c_int,
        __to: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlinkat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __buf: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> isize;
}
extern "C" {
    pub fn unlink(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlinkat(
        __fd: ::std::os::raw::c_int,
        __name: *const ::std::os::raw::c_char,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rmdir(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tcgetpgrp(__fd: ::std::os::raw::c_int) -> __pid_t;
}
extern "C" {
    pub fn tcsetpgrp(__fd: ::std::os::raw::c_int, __pgrp_id: __pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getlogin_r(
        __name: *mut ::std::os::raw::c_char,
        __name_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setlogin(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut optind: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut opterr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optopt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn getopt(
        ___argc: ::std::os::raw::c_int,
        ___argv: *const *mut ::std::os::raw::c_char,
        __shortopts: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostname(__name: *mut ::std::os::raw::c_char, __len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostname(
        __name: *const ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostid(__id: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdomainname(
        __name: *mut ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setdomainname(
        __name: *const ::std::os::raw::c_char,
        __len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vhangup() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn revoke(__file: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn profil(
        __sample_buffer: *mut ::std::os::raw::c_ushort,
        __size: usize,
        __offset: usize,
        __scale: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acct(__name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getusershell() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn endusershell();
}
extern "C" {
    pub fn setusershell();
}
extern "C" {
    pub fn daemon(
        __nochdir: ::std::os::raw::c_int,
        __noclose: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chroot(__path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpass(__prompt: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fsync(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostid() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn sync();
}
extern "C" {
    pub fn getpagesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdtablesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn truncate(
        __file: *const ::std::os::raw::c_char,
        __length: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftruncate(__fd: ::std::os::raw::c_int, __length: __off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn brk(__addr: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sbrk(__delta: isize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn syscall(__sysno: ::std::os::raw::c_long, ...) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lockf(
        __fd: ::std::os::raw::c_int,
        __cmd: ::std::os::raw::c_int,
        __len: __off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fdatasync(__fildes: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn crypt(
        __key: *const ::std::os::raw::c_char,
        __salt: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getentropy(
        __buffer: *mut ::std::os::raw::c_void,
        __length: usize,
    ) -> ::std::os::raw::c_int;
}
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        32usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        16usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce1 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout___mbstate_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mbstate_t__bindgen_ty_1>())).__wchb as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t__bindgen_ty_1),
            "::",
            stringify!(__wchb)
        )
    );
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        8usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos_t),
            "::",
            stringify!(__state)
        )
    );
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
#[test]
fn bindgen_test_layout__G_fpos64_t() {
    assert_eq!(
        ::std::mem::size_of::<_G_fpos64_t>(),
        16usize,
        concat!("Size of: ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_G_fpos64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_G_fpos64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__pos as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__pos)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_G_fpos64_t>())).__state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_G_fpos64_t),
            "::",
            stringify!(__state)
        )
    );
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_end as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_read_base as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_base as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_ptr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_write_end as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_base as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_buf_end as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_base as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_backup_base as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._IO_save_end as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._markers as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._chain as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._fileno as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._flags2 as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._old_offset as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._cur_column as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._vtable_offset as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._shortbuf as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._lock as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._codecvt as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._wide_data as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_list as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._freeres_buf as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>())).__pad5 as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._mode as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_IO_FILE>()))._unused2 as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
pub type fpos_t = __fpos_t;
extern "C" {
    pub static mut stdin: *mut FILE;
}
extern "C" {
    pub static mut stdout: *mut FILE;
}
extern "C" {
    pub static mut stderr: *mut FILE;
}
extern "C" {
    pub fn remove(__filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(__fd: ::std::os::raw::c_int, __modes: *const ::std::os::raw::c_char)
        -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: usize,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut usize,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char, __size: usize);
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(__w: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut usize,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut usize,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut usize,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(__s: *const ::std::os::raw::c_char, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __s: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: usize,
        __n: usize,
        __stream: *mut FILE,
    ) -> usize;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: usize,
        __n: usize,
        __stream: *mut FILE,
    ) -> usize;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(__stream: *mut FILE, __pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(__stream: *mut FILE, __pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn __uflow(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(arg1: *mut FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iret_context {
    pub rax: u64,
    pub r11: u64,
    pub rcx: u64,
    pub flags: u64,
    pub rip: u64,
    pub cs: u64,
    pub rflags: u64,
    pub rsp: u64,
    pub ss: u64,
}
#[test]
fn bindgen_test_layout_iret_context() {
    assert_eq!(
        ::std::mem::size_of::<iret_context>(),
        72usize,
        concat!("Size of: ", stringify!(iret_context))
    );
    assert_eq!(
        ::std::mem::align_of::<iret_context>(),
        8usize,
        concat!("Alignment of ", stringify!(iret_context))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).rax as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(rax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).r11 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(r11)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).rcx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(rcx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).rip as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).cs as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).rflags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(rflags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).rsp as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(rsp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<iret_context>())).ss as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(iret_context),
            "::",
            stringify!(ss)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cpu_user_regs {
    pub __bindgen_anon_1: cpu_user_regs__bindgen_ty_1,
    pub __bindgen_anon_2: cpu_user_regs__bindgen_ty_2,
    pub __bindgen_anon_3: cpu_user_regs__bindgen_ty_3,
    pub __bindgen_anon_4: cpu_user_regs__bindgen_ty_4,
    pub __bindgen_anon_5: cpu_user_regs__bindgen_ty_5,
    pub __bindgen_anon_6: cpu_user_regs__bindgen_ty_6,
    pub __bindgen_anon_7: cpu_user_regs__bindgen_ty_7,
    pub __bindgen_anon_8: cpu_user_regs__bindgen_ty_8,
    pub __bindgen_anon_9: cpu_user_regs__bindgen_ty_9,
    pub __bindgen_anon_10: cpu_user_regs__bindgen_ty_10,
    pub __bindgen_anon_11: cpu_user_regs__bindgen_ty_11,
    pub __bindgen_anon_12: cpu_user_regs__bindgen_ty_12,
    pub __bindgen_anon_13: cpu_user_regs__bindgen_ty_13,
    pub __bindgen_anon_14: cpu_user_regs__bindgen_ty_14,
    pub __bindgen_anon_15: cpu_user_regs__bindgen_ty_15,
    pub error_code: u32,
    pub entry_vector: u32,
    pub __bindgen_anon_16: cpu_user_regs__bindgen_ty_16,
    pub cs: u16,
    pub _pad0: [u16; 1usize],
    pub saved_upcall_mask: u8,
    pub _pad1: [u8; 3usize],
    pub __bindgen_anon_17: cpu_user_regs__bindgen_ty_17,
    pub __bindgen_anon_18: cpu_user_regs__bindgen_ty_18,
    pub ss: u16,
    pub _pad2: [u16; 3usize],
    pub es: u16,
    pub _pad3: [u16; 3usize],
    pub ds: u16,
    pub _pad4: [u16; 3usize],
    pub fs: u16,
    pub _pad5: [u16; 3usize],
    pub gs: u16,
    pub _pad6: [u16; 3usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_1 {
    pub r15: u64,
    pub r15d: u32,
    pub r15w: u16,
    pub r15b: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_1>())).r15 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_1),
            "::",
            stringify!(r15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_1>())).r15d as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_1),
            "::",
            stringify!(r15d)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_1>())).r15w as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_1),
            "::",
            stringify!(r15w)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_1>())).r15b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_1),
            "::",
            stringify!(r15b)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_2 {
    pub r14: u64,
    pub r14d: u32,
    pub r14w: u16,
    pub r14b: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_2>())).r14 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_2),
            "::",
            stringify!(r14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_2>())).r14d as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_2),
            "::",
            stringify!(r14d)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_2>())).r14w as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_2),
            "::",
            stringify!(r14w)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_2>())).r14b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_2),
            "::",
            stringify!(r14b)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_3 {
    pub r13: u64,
    pub r13d: u32,
    pub r13w: u16,
    pub r13b: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_3>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_3>())).r13 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_3),
            "::",
            stringify!(r13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_3>())).r13d as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_3),
            "::",
            stringify!(r13d)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_3>())).r13w as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_3),
            "::",
            stringify!(r13w)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_3>())).r13b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_3),
            "::",
            stringify!(r13b)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_4 {
    pub r12: u64,
    pub r12d: u32,
    pub r12w: u16,
    pub r12b: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_4>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_4>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_4>())).r12 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_4),
            "::",
            stringify!(r12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_4>())).r12d as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_4),
            "::",
            stringify!(r12d)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_4>())).r12w as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_4),
            "::",
            stringify!(r12w)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_4>())).r12b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_4),
            "::",
            stringify!(r12b)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_5 {
    pub rbp: u64,
    pub ebp: u32,
    pub bp: u16,
    pub bpl: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_5() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_5>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_5))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_5>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_5))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_5>())).rbp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_5),
            "::",
            stringify!(rbp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_5>())).ebp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_5),
            "::",
            stringify!(ebp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_5>())).bp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_5),
            "::",
            stringify!(bp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_5>())).bpl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_5),
            "::",
            stringify!(bpl)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_6 {
    pub rbx: u64,
    pub ebx: u32,
    pub bx: u16,
    pub __bindgen_anon_1: cpu_user_regs__bindgen_ty_6__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cpu_user_regs__bindgen_ty_6__bindgen_ty_1 {
    pub bl: u8,
    pub bh: u8,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_6__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_6__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(cpu_user_regs__bindgen_ty_6__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_6__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(cpu_user_regs__bindgen_ty_6__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_6__bindgen_ty_1>())).bl as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_6__bindgen_ty_1),
            "::",
            stringify!(bl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_6__bindgen_ty_1>())).bh as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_6__bindgen_ty_1),
            "::",
            stringify!(bh)
        )
    );
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_6() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_6>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_6))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_6>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_6))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_6>())).rbx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_6),
            "::",
            stringify!(rbx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_6>())).ebx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_6),
            "::",
            stringify!(ebx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_6>())).bx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_6),
            "::",
            stringify!(bx)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_7 {
    pub r11: u64,
    pub r11d: u32,
    pub r11w: u16,
    pub r11b: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_7() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_7>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_7))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_7>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_7))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_7>())).r11 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_7),
            "::",
            stringify!(r11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_7>())).r11d as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_7),
            "::",
            stringify!(r11d)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_7>())).r11w as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_7),
            "::",
            stringify!(r11w)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_7>())).r11b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_7),
            "::",
            stringify!(r11b)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_8 {
    pub r10: u64,
    pub r10d: u32,
    pub r10w: u16,
    pub r10b: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_8() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_8>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_8))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_8>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_8))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_8>())).r10 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_8),
            "::",
            stringify!(r10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_8>())).r10d as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_8),
            "::",
            stringify!(r10d)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_8>())).r10w as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_8),
            "::",
            stringify!(r10w)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_8>())).r10b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_8),
            "::",
            stringify!(r10b)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_9 {
    pub r9: u64,
    pub r9d: u32,
    pub r9w: u16,
    pub r9b: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_9() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_9>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_9))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_9>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_9))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_9>())).r9 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_9),
            "::",
            stringify!(r9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_9>())).r9d as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_9),
            "::",
            stringify!(r9d)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_9>())).r9w as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_9),
            "::",
            stringify!(r9w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_9>())).r9b as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_9),
            "::",
            stringify!(r9b)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_10 {
    pub r8: u64,
    pub r8d: u32,
    pub r8w: u16,
    pub r8b: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_10() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_10>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_10))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_10>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_10))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_10>())).r8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_10),
            "::",
            stringify!(r8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_10>())).r8d as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_10),
            "::",
            stringify!(r8d)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_10>())).r8w as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_10),
            "::",
            stringify!(r8w)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_10>())).r8b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_10),
            "::",
            stringify!(r8b)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_11 {
    pub rax: u64,
    pub eax: u32,
    pub ax: u16,
    pub __bindgen_anon_1: cpu_user_regs__bindgen_ty_11__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cpu_user_regs__bindgen_ty_11__bindgen_ty_1 {
    pub al: u8,
    pub ah: u8,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_11__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_11__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(cpu_user_regs__bindgen_ty_11__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_11__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(cpu_user_regs__bindgen_ty_11__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_11__bindgen_ty_1>())).al as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_11__bindgen_ty_1),
            "::",
            stringify!(al)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_11__bindgen_ty_1>())).ah as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_11__bindgen_ty_1),
            "::",
            stringify!(ah)
        )
    );
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_11() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_11>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_11))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_11>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_11))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_11>())).rax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_11),
            "::",
            stringify!(rax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_11>())).eax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_11),
            "::",
            stringify!(eax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_11>())).ax as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_11),
            "::",
            stringify!(ax)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_12 {
    pub rcx: u64,
    pub ecx: u32,
    pub cx: u16,
    pub __bindgen_anon_1: cpu_user_regs__bindgen_ty_12__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cpu_user_regs__bindgen_ty_12__bindgen_ty_1 {
    pub cl: u8,
    pub ch: u8,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_12__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_12__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(cpu_user_regs__bindgen_ty_12__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_12__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(cpu_user_regs__bindgen_ty_12__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_12__bindgen_ty_1>())).cl as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_12__bindgen_ty_1),
            "::",
            stringify!(cl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_12__bindgen_ty_1>())).ch as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_12__bindgen_ty_1),
            "::",
            stringify!(ch)
        )
    );
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_12() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_12>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_12))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_12>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_12))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_12>())).rcx as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_12),
            "::",
            stringify!(rcx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_12>())).ecx as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_12),
            "::",
            stringify!(ecx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_12>())).cx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_12),
            "::",
            stringify!(cx)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_13 {
    pub rdx: u64,
    pub edx: u32,
    pub dx: u16,
    pub __bindgen_anon_1: cpu_user_regs__bindgen_ty_13__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cpu_user_regs__bindgen_ty_13__bindgen_ty_1 {
    pub dl: u8,
    pub dh: u8,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_13__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_13__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(cpu_user_regs__bindgen_ty_13__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_13__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(cpu_user_regs__bindgen_ty_13__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_13__bindgen_ty_1>())).dl as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_13__bindgen_ty_1),
            "::",
            stringify!(dl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_13__bindgen_ty_1>())).dh as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_13__bindgen_ty_1),
            "::",
            stringify!(dh)
        )
    );
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_13() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_13>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_13))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_13>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_13))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_13>())).rdx as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_13),
            "::",
            stringify!(rdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_13>())).edx as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_13),
            "::",
            stringify!(edx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_13>())).dx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_13),
            "::",
            stringify!(dx)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_14 {
    pub rsi: u64,
    pub esi: u32,
    pub si: u16,
    pub sil: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_14() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_14>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_14))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_14>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_14))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_14>())).rsi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_14),
            "::",
            stringify!(rsi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_14>())).esi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_14),
            "::",
            stringify!(esi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_14>())).si as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_14),
            "::",
            stringify!(si)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_14>())).sil as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_14),
            "::",
            stringify!(sil)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_15 {
    pub rdi: u64,
    pub edi: u32,
    pub di: u16,
    pub dil: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_15() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_15>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_15))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_15>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_15))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_15>())).rdi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_15),
            "::",
            stringify!(rdi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_15>())).edi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_15),
            "::",
            stringify!(edi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_15>())).di as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_15),
            "::",
            stringify!(di)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_15>())).dil as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_15),
            "::",
            stringify!(dil)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_16 {
    pub rip: u64,
    pub eip: u32,
    pub ip: u16,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_16() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_16>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_16))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_16>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_16))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_16>())).rip as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_16),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_16>())).eip as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_16),
            "::",
            stringify!(eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_16>())).ip as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_16),
            "::",
            stringify!(ip)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_17 {
    pub rflags: u64,
    pub eflags: u32,
    pub flags: u16,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_17() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_17>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_17))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_17>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_17))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_17>())).rflags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_17),
            "::",
            stringify!(rflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_17>())).eflags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_17),
            "::",
            stringify!(eflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_17>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_17),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cpu_user_regs__bindgen_ty_18 {
    pub rsp: u64,
    pub esp: u32,
    pub sp: u16,
    pub spl: u8,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_cpu_user_regs__bindgen_ty_18() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs__bindgen_ty_18>(),
        8usize,
        concat!("Size of: ", stringify!(cpu_user_regs__bindgen_ty_18))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs__bindgen_ty_18>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs__bindgen_ty_18))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_18>())).rsp as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_18),
            "::",
            stringify!(rsp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_18>())).esp as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_18),
            "::",
            stringify!(esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_18>())).sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_18),
            "::",
            stringify!(sp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<cpu_user_regs__bindgen_ty_18>())).spl as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs__bindgen_ty_18),
            "::",
            stringify!(spl)
        )
    );
}
#[test]
fn bindgen_test_layout_cpu_user_regs() {
    assert_eq!(
        ::std::mem::size_of::<cpu_user_regs>(),
        200usize,
        concat!("Size of: ", stringify!(cpu_user_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<cpu_user_regs>(),
        8usize,
        concat!("Alignment of ", stringify!(cpu_user_regs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).error_code as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(error_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).entry_vector as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(entry_vector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).cs as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>()))._pad0 as *const _ as usize },
        138usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(_pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).saved_upcall_mask as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(saved_upcall_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>()))._pad1 as *const _ as usize },
        141usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(_pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).ss as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>()))._pad2 as *const _ as usize },
        162usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(_pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).es as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>()))._pad3 as *const _ as usize },
        170usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(_pad3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).ds as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(ds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>()))._pad4 as *const _ as usize },
        178usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(_pad4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>()))._pad5 as *const _ as usize },
        186usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(_pad5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>())).gs as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(gs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<cpu_user_regs>()))._pad6 as *const _ as usize },
        194usize,
        concat!(
            "Offset of field: ",
            stringify!(cpu_user_regs),
            "::",
            stringify!(_pad6)
        )
    );
}
pub type cpu_user_regs_t = cpu_user_regs;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_cpu_user_regs_t {
    pub p: *mut cpu_user_regs_t,
}
#[test]
fn bindgen_test_layout___guest_handle_cpu_user_regs_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_cpu_user_regs_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_cpu_user_regs_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_cpu_user_regs_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_cpu_user_regs_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_cpu_user_regs_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_cpu_user_regs_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_cpu_user_regs_t {
    pub p: *const cpu_user_regs_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_cpu_user_regs_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_cpu_user_regs_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_cpu_user_regs_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_cpu_user_regs_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_cpu_user_regs_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_cpu_user_regs_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_cpu_user_regs_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct arch_vcpu_info {
    pub cr2: ::std::os::raw::c_ulong,
    pub pad: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_arch_vcpu_info() {
    assert_eq!(
        ::std::mem::size_of::<arch_vcpu_info>(),
        16usize,
        concat!("Size of: ", stringify!(arch_vcpu_info))
    );
    assert_eq!(
        ::std::mem::align_of::<arch_vcpu_info>(),
        8usize,
        concat!("Alignment of ", stringify!(arch_vcpu_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arch_vcpu_info>())).cr2 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(arch_vcpu_info),
            "::",
            stringify!(cr2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arch_vcpu_info>())).pad as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(arch_vcpu_info),
            "::",
            stringify!(pad)
        )
    );
}
pub type arch_vcpu_info_t = arch_vcpu_info;
pub type xen_callback_t = ::std::os::raw::c_ulong;
pub type xen_pfn_t = ::std::os::raw::c_ulong;
pub type xen_ulong_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct trap_info {
    pub vector: u8,
    pub flags: u8,
    pub cs: u16,
    pub address: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_trap_info() {
    assert_eq!(
        ::std::mem::size_of::<trap_info>(),
        16usize,
        concat!("Size of: ", stringify!(trap_info))
    );
    assert_eq!(
        ::std::mem::align_of::<trap_info>(),
        8usize,
        concat!("Alignment of ", stringify!(trap_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<trap_info>())).vector as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(trap_info),
            "::",
            stringify!(vector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<trap_info>())).flags as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(trap_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<trap_info>())).cs as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(trap_info),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<trap_info>())).address as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(trap_info),
            "::",
            stringify!(address)
        )
    );
}
pub type trap_info_t = trap_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_trap_info_t {
    pub p: *mut trap_info_t,
}
#[test]
fn bindgen_test_layout___guest_handle_trap_info_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_trap_info_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_trap_info_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_trap_info_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_trap_info_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_trap_info_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_trap_info_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_trap_info_t {
    pub p: *const trap_info_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_trap_info_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_trap_info_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_trap_info_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_trap_info_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_trap_info_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_trap_info_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_trap_info_t),
            "::",
            stringify!(p)
        )
    );
}
pub type tsc_timestamp_t = u64;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vcpu_guest_context {
    pub fpu_ctxt: vcpu_guest_context__bindgen_ty_1,
    pub flags: ::std::os::raw::c_ulong,
    pub user_regs: cpu_user_regs,
    pub trap_ctxt: [trap_info; 256usize],
    pub ldt_base: ::std::os::raw::c_ulong,
    pub ldt_ents: ::std::os::raw::c_ulong,
    pub gdt_frames: [::std::os::raw::c_ulong; 16usize],
    pub gdt_ents: ::std::os::raw::c_ulong,
    pub kernel_ss: ::std::os::raw::c_ulong,
    pub kernel_sp: ::std::os::raw::c_ulong,
    pub ctrlreg: [::std::os::raw::c_ulong; 8usize],
    pub debugreg: [::std::os::raw::c_ulong; 8usize],
    pub event_callback_eip: ::std::os::raw::c_ulong,
    pub failsafe_callback_eip: ::std::os::raw::c_ulong,
    pub syscall_callback_eip: ::std::os::raw::c_ulong,
    pub vm_assist: ::std::os::raw::c_ulong,
    pub fs_base: u64,
    pub gs_base_kernel: u64,
    pub gs_base_user: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vcpu_guest_context__bindgen_ty_1 {
    pub x: [::std::os::raw::c_char; 512usize],
}
#[test]
fn bindgen_test_layout_vcpu_guest_context__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<vcpu_guest_context__bindgen_ty_1>(),
        512usize,
        concat!("Size of: ", stringify!(vcpu_guest_context__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<vcpu_guest_context__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(vcpu_guest_context__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vcpu_guest_context__bindgen_ty_1>())).x as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context__bindgen_ty_1),
            "::",
            stringify!(x)
        )
    );
}
#[test]
fn bindgen_test_layout_vcpu_guest_context() {
    assert_eq!(
        ::std::mem::size_of::<vcpu_guest_context>(),
        5168usize,
        concat!("Size of: ", stringify!(vcpu_guest_context))
    );
    assert_eq!(
        ::std::mem::align_of::<vcpu_guest_context>(),
        8usize,
        concat!("Alignment of ", stringify!(vcpu_guest_context))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).fpu_ctxt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(fpu_ctxt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).flags as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).user_regs as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(user_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).trap_ctxt as *const _ as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(trap_ctxt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).ldt_base as *const _ as usize },
        4816usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(ldt_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).ldt_ents as *const _ as usize },
        4824usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(ldt_ents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).gdt_frames as *const _ as usize },
        4832usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(gdt_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).gdt_ents as *const _ as usize },
        4960usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(gdt_ents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).kernel_ss as *const _ as usize },
        4968usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(kernel_ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).kernel_sp as *const _ as usize },
        4976usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(kernel_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).ctrlreg as *const _ as usize },
        4984usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(ctrlreg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).debugreg as *const _ as usize },
        5048usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(debugreg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vcpu_guest_context>())).event_callback_eip as *const _ as usize
        },
        5112usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(event_callback_eip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vcpu_guest_context>())).failsafe_callback_eip as *const _
                as usize
        },
        5120usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(failsafe_callback_eip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vcpu_guest_context>())).syscall_callback_eip as *const _ as usize
        },
        5128usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(syscall_callback_eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).vm_assist as *const _ as usize },
        5136usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(vm_assist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).fs_base as *const _ as usize },
        5144usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(fs_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vcpu_guest_context>())).gs_base_kernel as *const _ as usize
        },
        5152usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(gs_base_kernel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_guest_context>())).gs_base_user as *const _ as usize },
        5160usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_guest_context),
            "::",
            stringify!(gs_base_user)
        )
    );
}
pub type vcpu_guest_context_t = vcpu_guest_context;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_vcpu_guest_context_t {
    pub p: *mut vcpu_guest_context_t,
}
#[test]
fn bindgen_test_layout___guest_handle_vcpu_guest_context_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_vcpu_guest_context_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_vcpu_guest_context_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_vcpu_guest_context_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_vcpu_guest_context_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_vcpu_guest_context_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_vcpu_guest_context_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_vcpu_guest_context_t {
    pub p: *const vcpu_guest_context_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_vcpu_guest_context_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_vcpu_guest_context_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_vcpu_guest_context_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_vcpu_guest_context_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_vcpu_guest_context_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_vcpu_guest_context_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_vcpu_guest_context_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct arch_shared_info {
    pub max_pfn: ::std::os::raw::c_ulong,
    pub pfn_to_mfn_frame_list_list: xen_pfn_t,
    pub nmi_reason: ::std::os::raw::c_ulong,
    pub p2m_cr3: ::std::os::raw::c_ulong,
    pub p2m_vaddr: ::std::os::raw::c_ulong,
    pub p2m_generation: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_arch_shared_info() {
    assert_eq!(
        ::std::mem::size_of::<arch_shared_info>(),
        48usize,
        concat!("Size of: ", stringify!(arch_shared_info))
    );
    assert_eq!(
        ::std::mem::align_of::<arch_shared_info>(),
        8usize,
        concat!("Alignment of ", stringify!(arch_shared_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arch_shared_info>())).max_pfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(arch_shared_info),
            "::",
            stringify!(max_pfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<arch_shared_info>())).pfn_to_mfn_frame_list_list as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(arch_shared_info),
            "::",
            stringify!(pfn_to_mfn_frame_list_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arch_shared_info>())).nmi_reason as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(arch_shared_info),
            "::",
            stringify!(nmi_reason)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arch_shared_info>())).p2m_cr3 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(arch_shared_info),
            "::",
            stringify!(p2m_cr3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arch_shared_info>())).p2m_vaddr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(arch_shared_info),
            "::",
            stringify!(p2m_vaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arch_shared_info>())).p2m_generation as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(arch_shared_info),
            "::",
            stringify!(p2m_generation)
        )
    );
}
pub type arch_shared_info_t = arch_shared_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_arch_domainconfig {
    pub emulation_flags: u32,
}
#[test]
fn bindgen_test_layout_xen_arch_domainconfig() {
    assert_eq!(
        ::std::mem::size_of::<xen_arch_domainconfig>(),
        4usize,
        concat!("Size of: ", stringify!(xen_arch_domainconfig))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_arch_domainconfig>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_arch_domainconfig))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_arch_domainconfig>())).emulation_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_arch_domainconfig),
            "::",
            stringify!(emulation_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_char {
    pub p: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout___guest_handle_char() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_char>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_char))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_char>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_char))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_char>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_char),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_char {
    pub p: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout___guest_handle_const_char() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_char>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_char))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_char>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_char))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_char>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_char),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_uchar {
    pub p: *mut ::std::os::raw::c_uchar,
}
#[test]
fn bindgen_test_layout___guest_handle_uchar() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_uchar>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_uchar))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_uchar>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_uchar))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_uchar>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_uchar),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_uchar {
    pub p: *const ::std::os::raw::c_uchar,
}
#[test]
fn bindgen_test_layout___guest_handle_const_uchar() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_uchar>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_uchar))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_uchar>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_uchar))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_uchar>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_uchar),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_int {
    pub p: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___guest_handle_int() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_int>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_int))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_int>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_int))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_int>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_int),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_int {
    pub p: *const ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___guest_handle_const_int() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_int>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_int))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_int>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_int))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_int>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_int),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_uint {
    pub p: *mut ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___guest_handle_uint() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_uint>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_uint))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_uint>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_uint))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_uint>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_uint),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_uint {
    pub p: *const ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___guest_handle_const_uint() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_uint>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_uint))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_uint>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_uint))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_uint>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_uint),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_void {
    pub p: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___guest_handle_void() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_void>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_void))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_void>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_void))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_void>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_void),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_void {
    pub p: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___guest_handle_const_void() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_void>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_void))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_void>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_void))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_void>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_void),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_uint64_t {
    pub p: *mut u64,
}
#[test]
fn bindgen_test_layout___guest_handle_uint64_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_uint64_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_uint64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_uint64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_uint64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_uint64_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_uint64_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_uint64_t {
    pub p: *const u64,
}
#[test]
fn bindgen_test_layout___guest_handle_const_uint64_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_uint64_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_uint64_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_uint64_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_uint64_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_uint64_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_uint64_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_pfn_t {
    pub p: *mut xen_pfn_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_pfn_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_pfn_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_pfn_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_pfn_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_xen_pfn_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_xen_pfn_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_pfn_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_pfn_t {
    pub p: *const xen_pfn_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_pfn_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_pfn_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_xen_pfn_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_pfn_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_xen_pfn_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_pfn_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_pfn_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_ulong_t {
    pub p: *mut xen_ulong_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_ulong_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_ulong_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_ulong_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_ulong_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_xen_ulong_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_xen_ulong_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_ulong_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_ulong_t {
    pub p: *const xen_ulong_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_ulong_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_ulong_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_xen_ulong_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_ulong_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_ulong_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_ulong_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_ulong_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mmuext_op {
    pub cmd: ::std::os::raw::c_uint,
    pub arg1: mmuext_op__bindgen_ty_1,
    pub arg2: mmuext_op__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mmuext_op__bindgen_ty_1 {
    pub mfn: xen_pfn_t,
    pub linear_addr: ::std::os::raw::c_ulong,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_mmuext_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<mmuext_op__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(mmuext_op__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<mmuext_op__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(mmuext_op__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mmuext_op__bindgen_ty_1>())).mfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mmuext_op__bindgen_ty_1),
            "::",
            stringify!(mfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mmuext_op__bindgen_ty_1>())).linear_addr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mmuext_op__bindgen_ty_1),
            "::",
            stringify!(linear_addr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mmuext_op__bindgen_ty_2 {
    pub nr_ents: ::std::os::raw::c_uint,
    pub vcpumask: __guest_handle_const_void,
    pub src_mfn: xen_pfn_t,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_mmuext_op__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<mmuext_op__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(mmuext_op__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<mmuext_op__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(mmuext_op__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mmuext_op__bindgen_ty_2>())).nr_ents as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mmuext_op__bindgen_ty_2),
            "::",
            stringify!(nr_ents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<mmuext_op__bindgen_ty_2>())).vcpumask as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mmuext_op__bindgen_ty_2),
            "::",
            stringify!(vcpumask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mmuext_op__bindgen_ty_2>())).src_mfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mmuext_op__bindgen_ty_2),
            "::",
            stringify!(src_mfn)
        )
    );
}
#[test]
fn bindgen_test_layout_mmuext_op() {
    assert_eq!(
        ::std::mem::size_of::<mmuext_op>(),
        24usize,
        concat!("Size of: ", stringify!(mmuext_op))
    );
    assert_eq!(
        ::std::mem::align_of::<mmuext_op>(),
        8usize,
        concat!("Alignment of ", stringify!(mmuext_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mmuext_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mmuext_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mmuext_op>())).arg1 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mmuext_op),
            "::",
            stringify!(arg1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mmuext_op>())).arg2 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mmuext_op),
            "::",
            stringify!(arg2)
        )
    );
}
pub type mmuext_op_t = mmuext_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_mmuext_op_t {
    pub p: *mut mmuext_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_mmuext_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_mmuext_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_mmuext_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_mmuext_op_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_mmuext_op_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_mmuext_op_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_mmuext_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_mmuext_op_t {
    pub p: *const mmuext_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_mmuext_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_mmuext_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_mmuext_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_mmuext_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_mmuext_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_mmuext_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_mmuext_op_t),
            "::",
            stringify!(p)
        )
    );
}
pub type domid_t = u16;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mmu_update {
    pub ptr: u64,
    pub val: u64,
}
#[test]
fn bindgen_test_layout_mmu_update() {
    assert_eq!(
        ::std::mem::size_of::<mmu_update>(),
        16usize,
        concat!("Size of: ", stringify!(mmu_update))
    );
    assert_eq!(
        ::std::mem::align_of::<mmu_update>(),
        8usize,
        concat!("Alignment of ", stringify!(mmu_update))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mmu_update>())).ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mmu_update),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mmu_update>())).val as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mmu_update),
            "::",
            stringify!(val)
        )
    );
}
pub type mmu_update_t = mmu_update;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_mmu_update_t {
    pub p: *mut mmu_update_t,
}
#[test]
fn bindgen_test_layout___guest_handle_mmu_update_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_mmu_update_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_mmu_update_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_mmu_update_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_mmu_update_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_mmu_update_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_mmu_update_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_mmu_update_t {
    pub p: *const mmu_update_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_mmu_update_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_mmu_update_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_mmu_update_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_mmu_update_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_mmu_update_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_mmu_update_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_mmu_update_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct multicall_entry {
    pub op: xen_ulong_t,
    pub result: xen_ulong_t,
    pub args: [xen_ulong_t; 6usize],
}
#[test]
fn bindgen_test_layout_multicall_entry() {
    assert_eq!(
        ::std::mem::size_of::<multicall_entry>(),
        64usize,
        concat!("Size of: ", stringify!(multicall_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<multicall_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(multicall_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<multicall_entry>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(multicall_entry),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<multicall_entry>())).result as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(multicall_entry),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<multicall_entry>())).args as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(multicall_entry),
            "::",
            stringify!(args)
        )
    );
}
pub type multicall_entry_t = multicall_entry;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_multicall_entry_t {
    pub p: *mut multicall_entry_t,
}
#[test]
fn bindgen_test_layout___guest_handle_multicall_entry_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_multicall_entry_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_multicall_entry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_multicall_entry_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_multicall_entry_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_multicall_entry_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_multicall_entry_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_multicall_entry_t {
    pub p: *const multicall_entry_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_multicall_entry_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_multicall_entry_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_multicall_entry_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_multicall_entry_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_multicall_entry_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_multicall_entry_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_multicall_entry_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vcpu_time_info {
    pub version: u32,
    pub pad0: u32,
    pub tsc_timestamp: u64,
    pub system_time: u64,
    pub tsc_to_system_mul: u32,
    pub tsc_shift: i8,
    pub flags: u8,
    pub pad1: [u8; 2usize],
}
#[test]
fn bindgen_test_layout_vcpu_time_info() {
    assert_eq!(
        ::std::mem::size_of::<vcpu_time_info>(),
        32usize,
        concat!("Size of: ", stringify!(vcpu_time_info))
    );
    assert_eq!(
        ::std::mem::align_of::<vcpu_time_info>(),
        8usize,
        concat!("Alignment of ", stringify!(vcpu_time_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_time_info>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_time_info),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_time_info>())).pad0 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_time_info),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_time_info>())).tsc_timestamp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_time_info),
            "::",
            stringify!(tsc_timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_time_info>())).system_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_time_info),
            "::",
            stringify!(system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vcpu_time_info>())).tsc_to_system_mul as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_time_info),
            "::",
            stringify!(tsc_to_system_mul)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_time_info>())).tsc_shift as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_time_info),
            "::",
            stringify!(tsc_shift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_time_info>())).flags as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_time_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_time_info>())).pad1 as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_time_info),
            "::",
            stringify!(pad1)
        )
    );
}
pub type vcpu_time_info_t = vcpu_time_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vcpu_info {
    pub evtchn_upcall_pending: u8,
    pub evtchn_upcall_mask: u8,
    pub evtchn_pending_sel: xen_ulong_t,
    pub arch: arch_vcpu_info,
    pub time: vcpu_time_info,
}
#[test]
fn bindgen_test_layout_vcpu_info() {
    assert_eq!(
        ::std::mem::size_of::<vcpu_info>(),
        64usize,
        concat!("Size of: ", stringify!(vcpu_info))
    );
    assert_eq!(
        ::std::mem::align_of::<vcpu_info>(),
        8usize,
        concat!("Alignment of ", stringify!(vcpu_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_info>())).evtchn_upcall_pending as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_info),
            "::",
            stringify!(evtchn_upcall_pending)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_info>())).evtchn_upcall_mask as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_info),
            "::",
            stringify!(evtchn_upcall_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_info>())).evtchn_pending_sel as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_info),
            "::",
            stringify!(evtchn_pending_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_info>())).arch as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_info),
            "::",
            stringify!(arch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vcpu_info>())).time as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vcpu_info),
            "::",
            stringify!(time)
        )
    );
}
pub type vcpu_info_t = vcpu_info;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct shared_info {
    pub vcpu_info: [vcpu_info; 32usize],
    pub evtchn_pending: [xen_ulong_t; 64usize],
    pub evtchn_mask: [xen_ulong_t; 64usize],
    pub wc_version: u32,
    pub wc_sec: u32,
    pub wc_nsec: u32,
    pub wc_sec_hi: u32,
    pub arch: arch_shared_info,
}
#[test]
fn bindgen_test_layout_shared_info() {
    assert_eq!(
        ::std::mem::size_of::<shared_info>(),
        3136usize,
        concat!("Size of: ", stringify!(shared_info))
    );
    assert_eq!(
        ::std::mem::align_of::<shared_info>(),
        8usize,
        concat!("Alignment of ", stringify!(shared_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shared_info>())).vcpu_info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(shared_info),
            "::",
            stringify!(vcpu_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shared_info>())).evtchn_pending as *const _ as usize },
        2048usize,
        concat!(
            "Offset of field: ",
            stringify!(shared_info),
            "::",
            stringify!(evtchn_pending)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shared_info>())).evtchn_mask as *const _ as usize },
        2560usize,
        concat!(
            "Offset of field: ",
            stringify!(shared_info),
            "::",
            stringify!(evtchn_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shared_info>())).wc_version as *const _ as usize },
        3072usize,
        concat!(
            "Offset of field: ",
            stringify!(shared_info),
            "::",
            stringify!(wc_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shared_info>())).wc_sec as *const _ as usize },
        3076usize,
        concat!(
            "Offset of field: ",
            stringify!(shared_info),
            "::",
            stringify!(wc_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shared_info>())).wc_nsec as *const _ as usize },
        3080usize,
        concat!(
            "Offset of field: ",
            stringify!(shared_info),
            "::",
            stringify!(wc_nsec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shared_info>())).wc_sec_hi as *const _ as usize },
        3084usize,
        concat!(
            "Offset of field: ",
            stringify!(shared_info),
            "::",
            stringify!(wc_sec_hi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<shared_info>())).arch as *const _ as usize },
        3088usize,
        concat!(
            "Offset of field: ",
            stringify!(shared_info),
            "::",
            stringify!(arch)
        )
    );
}
pub type shared_info_t = shared_info;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct start_info {
    pub magic: [::std::os::raw::c_char; 32usize],
    pub nr_pages: ::std::os::raw::c_ulong,
    pub shared_info: ::std::os::raw::c_ulong,
    pub flags: u32,
    pub store_mfn: xen_pfn_t,
    pub store_evtchn: u32,
    pub console: start_info__bindgen_ty_1,
    pub pt_base: ::std::os::raw::c_ulong,
    pub nr_pt_frames: ::std::os::raw::c_ulong,
    pub mfn_list: ::std::os::raw::c_ulong,
    pub mod_start: ::std::os::raw::c_ulong,
    pub mod_len: ::std::os::raw::c_ulong,
    pub cmd_line: [i8; 1024usize],
    pub first_p2m_pfn: ::std::os::raw::c_ulong,
    pub nr_p2m_frames: ::std::os::raw::c_ulong,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union start_info__bindgen_ty_1 {
    pub domU: start_info__bindgen_ty_1__bindgen_ty_1,
    pub dom0: start_info__bindgen_ty_1__bindgen_ty_2,
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct start_info__bindgen_ty_1__bindgen_ty_1 {
    pub mfn: xen_pfn_t,
    pub evtchn: u32,
}
#[test]
fn bindgen_test_layout_start_info__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<start_info__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(start_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<start_info__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(start_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<start_info__bindgen_ty_1__bindgen_ty_1>())).mfn as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(mfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<start_info__bindgen_ty_1__bindgen_ty_1>())).evtchn as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(evtchn)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct start_info__bindgen_ty_1__bindgen_ty_2 {
    pub info_off: u32,
    pub info_size: u32,
}
#[test]
fn bindgen_test_layout_start_info__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<start_info__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(start_info__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<start_info__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(start_info__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<start_info__bindgen_ty_1__bindgen_ty_2>())).info_off as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(info_off)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<start_info__bindgen_ty_1__bindgen_ty_2>())).info_size as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(info_size)
        )
    );
}
#[test]
fn bindgen_test_layout_start_info__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<start_info__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(start_info__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<start_info__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(start_info__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info__bindgen_ty_1>())).domU as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info__bindgen_ty_1),
            "::",
            stringify!(domU)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info__bindgen_ty_1>())).dom0 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info__bindgen_ty_1),
            "::",
            stringify!(dom0)
        )
    );
}
#[test]
fn bindgen_test_layout_start_info() {
    assert_eq!(
        ::std::mem::size_of::<start_info>(),
        1168usize,
        concat!("Size of: ", stringify!(start_info))
    );
    assert_eq!(
        ::std::mem::align_of::<start_info>(),
        8usize,
        concat!("Alignment of ", stringify!(start_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).nr_pages as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(nr_pages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).shared_info as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(shared_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).store_mfn as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(store_mfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).store_evtchn as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(store_evtchn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).console as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(console)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).pt_base as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(pt_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).nr_pt_frames as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(nr_pt_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).mfn_list as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(mfn_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).mod_start as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(mod_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).mod_len as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(mod_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).cmd_line as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(cmd_line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).first_p2m_pfn as *const _ as usize },
        1152usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(first_p2m_pfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<start_info>())).nr_p2m_frames as *const _ as usize },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(start_info),
            "::",
            stringify!(nr_p2m_frames)
        )
    );
}
pub type start_info_t = start_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_multiboot_mod_list {
    pub mod_start: u32,
    pub mod_end: u32,
    pub cmdline: u32,
    pub pad: u32,
}
#[test]
fn bindgen_test_layout_xen_multiboot_mod_list() {
    assert_eq!(
        ::std::mem::size_of::<xen_multiboot_mod_list>(),
        16usize,
        concat!("Size of: ", stringify!(xen_multiboot_mod_list))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_multiboot_mod_list>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_multiboot_mod_list))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_multiboot_mod_list>())).mod_start as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_multiboot_mod_list),
            "::",
            stringify!(mod_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_multiboot_mod_list>())).mod_end as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_multiboot_mod_list),
            "::",
            stringify!(mod_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_multiboot_mod_list>())).cmdline as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_multiboot_mod_list),
            "::",
            stringify!(cmdline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_multiboot_mod_list>())).pad as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_multiboot_mod_list),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct dom0_vga_console_info {
    pub video_type: u8,
    pub u: dom0_vga_console_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dom0_vga_console_info__bindgen_ty_1 {
    pub text_mode_3: dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1,
    pub vesa_lfb: dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2,
    _bindgen_union_align: [u32; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1 {
    pub font_height: u16,
    pub cursor_x: u16,
    pub cursor_y: u16,
    pub rows: u16,
    pub columns: u16,
}
#[test]
fn bindgen_test_layout_dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1>(),
        10usize,
        concat!(
            "Size of: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1>()))
                .font_height as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(font_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1>())).cursor_x
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(cursor_x)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1>())).cursor_y
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(cursor_y)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1>())).rows
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(rows)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1>())).columns
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(columns)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2 {
    pub width: u16,
    pub height: u16,
    pub bytes_per_line: u16,
    pub bits_per_pixel: u16,
    pub lfb_base: u32,
    pub lfb_size: u32,
    pub red_pos: u8,
    pub red_size: u8,
    pub green_pos: u8,
    pub green_size: u8,
    pub blue_pos: u8,
    pub blue_size: u8,
    pub rsvd_pos: u8,
    pub rsvd_size: u8,
    pub gbl_caps: u32,
    pub mode_attrs: u16,
}
#[test]
fn bindgen_test_layout_dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).width
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).height
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>()))
                .bytes_per_line as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(bytes_per_line)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>()))
                .bits_per_pixel as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(bits_per_pixel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).lfb_base
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(lfb_base)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).lfb_size
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(lfb_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).red_pos
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(red_pos)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).red_size
                as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(red_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).green_pos
                as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(green_pos)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).green_size
                as *const _ as usize
        },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(green_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).blue_pos
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(blue_pos)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).blue_size
                as *const _ as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(blue_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).rsvd_pos
                as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(rsvd_pos)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).rsvd_size
                as *const _ as usize
        },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(rsvd_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).gbl_caps
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(gbl_caps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2>())).mode_attrs
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(mode_attrs)
        )
    );
}
#[test]
fn bindgen_test_layout_dom0_vga_console_info__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<dom0_vga_console_info__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(dom0_vga_console_info__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<dom0_vga_console_info__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(dom0_vga_console_info__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1>())).text_mode_3 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1),
            "::",
            stringify!(text_mode_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info__bindgen_ty_1>())).vesa_lfb as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info__bindgen_ty_1),
            "::",
            stringify!(vesa_lfb)
        )
    );
}
#[test]
fn bindgen_test_layout_dom0_vga_console_info() {
    assert_eq!(
        ::std::mem::size_of::<dom0_vga_console_info>(),
        36usize,
        concat!("Size of: ", stringify!(dom0_vga_console_info))
    );
    assert_eq!(
        ::std::mem::align_of::<dom0_vga_console_info>(),
        4usize,
        concat!("Alignment of ", stringify!(dom0_vga_console_info))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<dom0_vga_console_info>())).video_type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info),
            "::",
            stringify!(video_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dom0_vga_console_info>())).u as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(dom0_vga_console_info),
            "::",
            stringify!(u)
        )
    );
}
pub type dom0_vga_console_info_t = dom0_vga_console_info;
pub type xen_domain_handle_t = [u8; 16usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_uint8 {
    pub p: *mut u8,
}
#[test]
fn bindgen_test_layout___guest_handle_uint8() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_uint8>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_uint8))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_uint8>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_uint8))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_uint8>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_uint8),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_uint8 {
    pub p: *const u8,
}
#[test]
fn bindgen_test_layout___guest_handle_const_uint8() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_uint8>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_uint8))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_uint8>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_uint8))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_uint8>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_uint8),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_uint16 {
    pub p: *mut u16,
}
#[test]
fn bindgen_test_layout___guest_handle_uint16() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_uint16>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_uint16))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_uint16>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_uint16))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_uint16>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_uint16),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_uint16 {
    pub p: *const u16,
}
#[test]
fn bindgen_test_layout___guest_handle_const_uint16() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_uint16>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_uint16))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_uint16>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_uint16))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_uint16>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_uint16),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_uint32 {
    pub p: *mut u32,
}
#[test]
fn bindgen_test_layout___guest_handle_uint32() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_uint32>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_uint32))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_uint32>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_uint32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_uint32>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_uint32),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_uint32 {
    pub p: *const u32,
}
#[test]
fn bindgen_test_layout___guest_handle_const_uint32() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_uint32>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_uint32))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_uint32>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_uint32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_uint32>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_uint32),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_uint64 {
    pub p: *mut u64,
}
#[test]
fn bindgen_test_layout___guest_handle_uint64() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_uint64>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_uint64))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_uint64>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_uint64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_uint64>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_uint64),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_uint64 {
    pub p: *const u64,
}
#[test]
fn bindgen_test_layout___guest_handle_const_uint64() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_uint64>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_uint64))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_uint64>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_uint64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_const_uint64>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_uint64),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xenctl_bitmap {
    pub bitmap: __guest_handle_uint8,
    pub nr_bits: u32,
}
#[test]
fn bindgen_test_layout_xenctl_bitmap() {
    assert_eq!(
        ::std::mem::size_of::<xenctl_bitmap>(),
        16usize,
        concat!("Size of: ", stringify!(xenctl_bitmap))
    );
    assert_eq!(
        ::std::mem::align_of::<xenctl_bitmap>(),
        8usize,
        concat!("Alignment of ", stringify!(xenctl_bitmap))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xenctl_bitmap>())).bitmap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xenctl_bitmap),
            "::",
            stringify!(bitmap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xenctl_bitmap>())).nr_bits as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xenctl_bitmap),
            "::",
            stringify!(nr_bits)
        )
    );
}
pub type grant_ref_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct grant_entry_v1 {
    pub flags: u16,
    pub domid: domid_t,
    pub frame: u32,
}
#[test]
fn bindgen_test_layout_grant_entry_v1() {
    assert_eq!(
        ::std::mem::size_of::<grant_entry_v1>(),
        8usize,
        concat!("Size of: ", stringify!(grant_entry_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<grant_entry_v1>(),
        4usize,
        concat!("Alignment of ", stringify!(grant_entry_v1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_v1>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_v1>())).domid as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v1),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_v1>())).frame as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v1),
            "::",
            stringify!(frame)
        )
    );
}
pub type grant_entry_v1_t = grant_entry_v1;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct grant_entry_header {
    pub flags: u16,
    pub domid: domid_t,
}
#[test]
fn bindgen_test_layout_grant_entry_header() {
    assert_eq!(
        ::std::mem::size_of::<grant_entry_header>(),
        4usize,
        concat!("Size of: ", stringify!(grant_entry_header))
    );
    assert_eq!(
        ::std::mem::align_of::<grant_entry_header>(),
        2usize,
        concat!("Alignment of ", stringify!(grant_entry_header))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_header>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_header),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_header>())).domid as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_header),
            "::",
            stringify!(domid)
        )
    );
}
pub type grant_entry_header_t = grant_entry_header;
#[repr(C)]
#[derive(Copy, Clone)]
pub union grant_entry_v2 {
    pub hdr: grant_entry_header_t,
    pub full_page: grant_entry_v2__bindgen_ty_1,
    pub sub_page: grant_entry_v2__bindgen_ty_2,
    pub transitive: grant_entry_v2__bindgen_ty_3,
    pub __spacer: [u32; 4usize],
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct grant_entry_v2__bindgen_ty_1 {
    pub hdr: grant_entry_header_t,
    pub pad0: u32,
    pub frame: u64,
}
#[test]
fn bindgen_test_layout_grant_entry_v2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<grant_entry_v2__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(grant_entry_v2__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<grant_entry_v2__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(grant_entry_v2__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_1>())).hdr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_1),
            "::",
            stringify!(hdr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_1>())).pad0 as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_1),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_1>())).frame as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_1),
            "::",
            stringify!(frame)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct grant_entry_v2__bindgen_ty_2 {
    pub hdr: grant_entry_header_t,
    pub page_off: u16,
    pub length: u16,
    pub frame: u64,
}
#[test]
fn bindgen_test_layout_grant_entry_v2__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<grant_entry_v2__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(grant_entry_v2__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<grant_entry_v2__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(grant_entry_v2__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_2>())).hdr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_2),
            "::",
            stringify!(hdr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_2>())).page_off as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_2),
            "::",
            stringify!(page_off)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_2>())).length as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_2),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_2>())).frame as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_2),
            "::",
            stringify!(frame)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct grant_entry_v2__bindgen_ty_3 {
    pub hdr: grant_entry_header_t,
    pub trans_domid: domid_t,
    pub pad0: u16,
    pub gref: grant_ref_t,
}
#[test]
fn bindgen_test_layout_grant_entry_v2__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<grant_entry_v2__bindgen_ty_3>(),
        12usize,
        concat!("Size of: ", stringify!(grant_entry_v2__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<grant_entry_v2__bindgen_ty_3>(),
        4usize,
        concat!("Alignment of ", stringify!(grant_entry_v2__bindgen_ty_3))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_3>())).hdr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_3),
            "::",
            stringify!(hdr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_3>())).trans_domid as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_3),
            "::",
            stringify!(trans_domid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_3>())).pad0 as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_3),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<grant_entry_v2__bindgen_ty_3>())).gref as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2__bindgen_ty_3),
            "::",
            stringify!(gref)
        )
    );
}
#[test]
fn bindgen_test_layout_grant_entry_v2() {
    assert_eq!(
        ::std::mem::size_of::<grant_entry_v2>(),
        16usize,
        concat!("Size of: ", stringify!(grant_entry_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<grant_entry_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(grant_entry_v2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_v2>())).hdr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2),
            "::",
            stringify!(hdr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_v2>())).full_page as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2),
            "::",
            stringify!(full_page)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_v2>())).sub_page as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2),
            "::",
            stringify!(sub_page)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_v2>())).transitive as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2),
            "::",
            stringify!(transitive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<grant_entry_v2>())).__spacer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(grant_entry_v2),
            "::",
            stringify!(__spacer)
        )
    );
}
pub type grant_entry_v2_t = grant_entry_v2;
pub type grant_status_t = u16;
pub type grant_handle_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_map_grant_ref {
    pub host_addr: u64,
    pub flags: u32,
    pub ref_: grant_ref_t,
    pub dom: domid_t,
    pub status: i16,
    pub handle: grant_handle_t,
    pub dev_bus_addr: u64,
}
#[test]
fn bindgen_test_layout_gnttab_map_grant_ref() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_map_grant_ref>(),
        32usize,
        concat!("Size of: ", stringify!(gnttab_map_grant_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_map_grant_ref>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_map_grant_ref))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_map_grant_ref>())).host_addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_map_grant_ref),
            "::",
            stringify!(host_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_map_grant_ref>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_map_grant_ref),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_map_grant_ref>())).ref_ as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_map_grant_ref),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_map_grant_ref>())).dom as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_map_grant_ref),
            "::",
            stringify!(dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_map_grant_ref>())).status as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_map_grant_ref),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_map_grant_ref>())).handle as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_map_grant_ref),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_map_grant_ref>())).dev_bus_addr as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_map_grant_ref),
            "::",
            stringify!(dev_bus_addr)
        )
    );
}
pub type gnttab_map_grant_ref_t = gnttab_map_grant_ref;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_map_grant_ref_t {
    pub p: *mut gnttab_map_grant_ref_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_map_grant_ref_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_map_grant_ref_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_gnttab_map_grant_ref_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_map_grant_ref_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_map_grant_ref_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_map_grant_ref_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_map_grant_ref_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_map_grant_ref_t {
    pub p: *const gnttab_map_grant_ref_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_map_grant_ref_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_map_grant_ref_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_map_grant_ref_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_map_grant_ref_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_map_grant_ref_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_map_grant_ref_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_map_grant_ref_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_unmap_grant_ref {
    pub host_addr: u64,
    pub dev_bus_addr: u64,
    pub handle: grant_handle_t,
    pub status: i16,
}
#[test]
fn bindgen_test_layout_gnttab_unmap_grant_ref() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_unmap_grant_ref>(),
        24usize,
        concat!("Size of: ", stringify!(gnttab_unmap_grant_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_unmap_grant_ref>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_unmap_grant_ref))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_unmap_grant_ref>())).host_addr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_unmap_grant_ref),
            "::",
            stringify!(host_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_unmap_grant_ref>())).dev_bus_addr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_unmap_grant_ref),
            "::",
            stringify!(dev_bus_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_unmap_grant_ref>())).handle as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_unmap_grant_ref),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_unmap_grant_ref>())).status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_unmap_grant_ref),
            "::",
            stringify!(status)
        )
    );
}
pub type gnttab_unmap_grant_ref_t = gnttab_unmap_grant_ref;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_unmap_grant_ref_t {
    pub p: *mut gnttab_unmap_grant_ref_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_unmap_grant_ref_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_unmap_grant_ref_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_gnttab_unmap_grant_ref_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_unmap_grant_ref_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_unmap_grant_ref_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_unmap_grant_ref_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_unmap_grant_ref_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_unmap_grant_ref_t {
    pub p: *const gnttab_unmap_grant_ref_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_unmap_grant_ref_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_unmap_grant_ref_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_unmap_grant_ref_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_unmap_grant_ref_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_unmap_grant_ref_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_unmap_grant_ref_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_unmap_grant_ref_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_setup_table {
    pub dom: domid_t,
    pub nr_frames: u32,
    pub status: i16,
    pub frame_list: __guest_handle_xen_pfn_t,
}
#[test]
fn bindgen_test_layout_gnttab_setup_table() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_setup_table>(),
        24usize,
        concat!("Size of: ", stringify!(gnttab_setup_table))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_setup_table>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_setup_table))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_setup_table>())).dom as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_setup_table),
            "::",
            stringify!(dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_setup_table>())).nr_frames as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_setup_table),
            "::",
            stringify!(nr_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_setup_table>())).status as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_setup_table),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_setup_table>())).frame_list as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_setup_table),
            "::",
            stringify!(frame_list)
        )
    );
}
pub type gnttab_setup_table_t = gnttab_setup_table;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_setup_table_t {
    pub p: *mut gnttab_setup_table_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_setup_table_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_setup_table_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_gnttab_setup_table_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_setup_table_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_setup_table_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_setup_table_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_setup_table_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_setup_table_t {
    pub p: *const gnttab_setup_table_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_setup_table_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_setup_table_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_setup_table_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_setup_table_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_setup_table_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_setup_table_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_setup_table_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_dump_table {
    pub dom: domid_t,
    pub status: i16,
}
#[test]
fn bindgen_test_layout_gnttab_dump_table() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_dump_table>(),
        4usize,
        concat!("Size of: ", stringify!(gnttab_dump_table))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_dump_table>(),
        2usize,
        concat!("Alignment of ", stringify!(gnttab_dump_table))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_dump_table>())).dom as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_dump_table),
            "::",
            stringify!(dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_dump_table>())).status as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_dump_table),
            "::",
            stringify!(status)
        )
    );
}
pub type gnttab_dump_table_t = gnttab_dump_table;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_dump_table_t {
    pub p: *mut gnttab_dump_table_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_dump_table_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_dump_table_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_gnttab_dump_table_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_dump_table_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_dump_table_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_dump_table_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_dump_table_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_dump_table_t {
    pub p: *const gnttab_dump_table_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_dump_table_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_dump_table_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_dump_table_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_dump_table_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_dump_table_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_dump_table_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_dump_table_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_transfer {
    pub mfn: xen_pfn_t,
    pub domid: domid_t,
    pub ref_: grant_ref_t,
    pub status: i16,
}
#[test]
fn bindgen_test_layout_gnttab_transfer() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_transfer>(),
        24usize,
        concat!("Size of: ", stringify!(gnttab_transfer))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_transfer>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_transfer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_transfer>())).mfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_transfer),
            "::",
            stringify!(mfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_transfer>())).domid as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_transfer),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_transfer>())).ref_ as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_transfer),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_transfer>())).status as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_transfer),
            "::",
            stringify!(status)
        )
    );
}
pub type gnttab_transfer_t = gnttab_transfer;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_transfer_t {
    pub p: *mut gnttab_transfer_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_transfer_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_transfer_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_gnttab_transfer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_transfer_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_transfer_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_transfer_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_transfer_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_transfer_t {
    pub p: *const gnttab_transfer_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_transfer_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_transfer_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_transfer_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_transfer_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_transfer_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_transfer_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_transfer_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct gnttab_copy {
    pub source: gnttab_copy_gnttab_copy_ptr,
    pub dest: gnttab_copy_gnttab_copy_ptr,
    pub len: u16,
    pub flags: u16,
    pub status: i16,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct gnttab_copy_gnttab_copy_ptr {
    pub u: gnttab_copy_gnttab_copy_ptr__bindgen_ty_1,
    pub domid: domid_t,
    pub offset: u16,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union gnttab_copy_gnttab_copy_ptr__bindgen_ty_1 {
    pub ref_: grant_ref_t,
    pub gmfn: xen_pfn_t,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_gnttab_copy_gnttab_copy_ptr__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_copy_gnttab_copy_ptr__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(gnttab_copy_gnttab_copy_ptr__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_copy_gnttab_copy_ptr__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(gnttab_copy_gnttab_copy_ptr__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_copy_gnttab_copy_ptr__bindgen_ty_1>())).ref_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy_gnttab_copy_ptr__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_copy_gnttab_copy_ptr__bindgen_ty_1>())).gmfn as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy_gnttab_copy_ptr__bindgen_ty_1),
            "::",
            stringify!(gmfn)
        )
    );
}
#[test]
fn bindgen_test_layout_gnttab_copy_gnttab_copy_ptr() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_copy_gnttab_copy_ptr>(),
        16usize,
        concat!("Size of: ", stringify!(gnttab_copy_gnttab_copy_ptr))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_copy_gnttab_copy_ptr>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_copy_gnttab_copy_ptr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_copy_gnttab_copy_ptr>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy_gnttab_copy_ptr),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_copy_gnttab_copy_ptr>())).domid as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy_gnttab_copy_ptr),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_copy_gnttab_copy_ptr>())).offset as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy_gnttab_copy_ptr),
            "::",
            stringify!(offset)
        )
    );
}
#[test]
fn bindgen_test_layout_gnttab_copy() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_copy>(),
        40usize,
        concat!("Size of: ", stringify!(gnttab_copy))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_copy>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_copy))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_copy>())).source as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_copy>())).dest as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy),
            "::",
            stringify!(dest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_copy>())).len as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_copy>())).flags as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_copy>())).status as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_copy),
            "::",
            stringify!(status)
        )
    );
}
pub type gnttab_copy_t = gnttab_copy;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_copy_t {
    pub p: *mut gnttab_copy_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_copy_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_copy_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_gnttab_copy_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_copy_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_gnttab_copy_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_gnttab_copy_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_copy_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_copy_t {
    pub p: *const gnttab_copy_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_copy_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_copy_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_gnttab_copy_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_copy_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_copy_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_copy_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_copy_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_query_size {
    pub dom: domid_t,
    pub nr_frames: u32,
    pub max_nr_frames: u32,
    pub status: i16,
}
#[test]
fn bindgen_test_layout_gnttab_query_size() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_query_size>(),
        16usize,
        concat!("Size of: ", stringify!(gnttab_query_size))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_query_size>(),
        4usize,
        concat!("Alignment of ", stringify!(gnttab_query_size))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_query_size>())).dom as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_query_size),
            "::",
            stringify!(dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_query_size>())).nr_frames as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_query_size),
            "::",
            stringify!(nr_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_query_size>())).max_nr_frames as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_query_size),
            "::",
            stringify!(max_nr_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_query_size>())).status as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_query_size),
            "::",
            stringify!(status)
        )
    );
}
pub type gnttab_query_size_t = gnttab_query_size;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_query_size_t {
    pub p: *mut gnttab_query_size_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_query_size_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_query_size_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_gnttab_query_size_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_query_size_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_query_size_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_query_size_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_query_size_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_query_size_t {
    pub p: *const gnttab_query_size_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_query_size_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_query_size_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_query_size_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_query_size_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_query_size_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_query_size_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_query_size_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_unmap_and_replace {
    pub host_addr: u64,
    pub new_addr: u64,
    pub handle: grant_handle_t,
    pub status: i16,
}
#[test]
fn bindgen_test_layout_gnttab_unmap_and_replace() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_unmap_and_replace>(),
        24usize,
        concat!("Size of: ", stringify!(gnttab_unmap_and_replace))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_unmap_and_replace>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_unmap_and_replace))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_unmap_and_replace>())).host_addr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_unmap_and_replace),
            "::",
            stringify!(host_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_unmap_and_replace>())).new_addr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_unmap_and_replace),
            "::",
            stringify!(new_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_unmap_and_replace>())).handle as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_unmap_and_replace),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_unmap_and_replace>())).status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_unmap_and_replace),
            "::",
            stringify!(status)
        )
    );
}
pub type gnttab_unmap_and_replace_t = gnttab_unmap_and_replace;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_unmap_and_replace_t {
    pub p: *mut gnttab_unmap_and_replace_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_unmap_and_replace_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_unmap_and_replace_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_gnttab_unmap_and_replace_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_unmap_and_replace_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_unmap_and_replace_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_unmap_and_replace_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_unmap_and_replace_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_unmap_and_replace_t {
    pub p: *const gnttab_unmap_and_replace_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_unmap_and_replace_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_unmap_and_replace_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_unmap_and_replace_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_unmap_and_replace_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_unmap_and_replace_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_unmap_and_replace_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_unmap_and_replace_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_set_version {
    pub version: u32,
}
#[test]
fn bindgen_test_layout_gnttab_set_version() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_set_version>(),
        4usize,
        concat!("Size of: ", stringify!(gnttab_set_version))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_set_version>(),
        4usize,
        concat!("Alignment of ", stringify!(gnttab_set_version))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_set_version>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_set_version),
            "::",
            stringify!(version)
        )
    );
}
pub type gnttab_set_version_t = gnttab_set_version;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_set_version_t {
    pub p: *mut gnttab_set_version_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_set_version_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_set_version_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_gnttab_set_version_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_set_version_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_set_version_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_set_version_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_set_version_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_set_version_t {
    pub p: *const gnttab_set_version_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_set_version_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_set_version_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_set_version_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_set_version_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_set_version_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_set_version_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_set_version_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_get_status_frames {
    pub nr_frames: u32,
    pub dom: domid_t,
    pub status: i16,
    pub frame_list: __guest_handle_uint64_t,
}
#[test]
fn bindgen_test_layout_gnttab_get_status_frames() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_get_status_frames>(),
        16usize,
        concat!("Size of: ", stringify!(gnttab_get_status_frames))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_get_status_frames>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_get_status_frames))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_get_status_frames>())).nr_frames as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_get_status_frames),
            "::",
            stringify!(nr_frames)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_get_status_frames>())).dom as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_get_status_frames),
            "::",
            stringify!(dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_get_status_frames>())).status as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_get_status_frames),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_get_status_frames>())).frame_list as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_get_status_frames),
            "::",
            stringify!(frame_list)
        )
    );
}
pub type gnttab_get_status_frames_t = gnttab_get_status_frames;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_get_status_frames_t {
    pub p: *mut gnttab_get_status_frames_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_get_status_frames_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_get_status_frames_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_gnttab_get_status_frames_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_get_status_frames_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_get_status_frames_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_get_status_frames_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_get_status_frames_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_get_status_frames_t {
    pub p: *const gnttab_get_status_frames_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_get_status_frames_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_get_status_frames_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_get_status_frames_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_get_status_frames_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_get_status_frames_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_get_status_frames_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_get_status_frames_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_get_version {
    pub dom: domid_t,
    pub pad: u16,
    pub version: u32,
}
#[test]
fn bindgen_test_layout_gnttab_get_version() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_get_version>(),
        8usize,
        concat!("Size of: ", stringify!(gnttab_get_version))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_get_version>(),
        4usize,
        concat!("Alignment of ", stringify!(gnttab_get_version))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_get_version>())).dom as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_get_version),
            "::",
            stringify!(dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_get_version>())).pad as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_get_version),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_get_version>())).version as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_get_version),
            "::",
            stringify!(version)
        )
    );
}
pub type gnttab_get_version_t = gnttab_get_version;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_get_version_t {
    pub p: *mut gnttab_get_version_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_get_version_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_get_version_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_gnttab_get_version_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_get_version_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_get_version_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_get_version_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_get_version_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_get_version_t {
    pub p: *const gnttab_get_version_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_get_version_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_get_version_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_get_version_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_get_version_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_get_version_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_get_version_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_get_version_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gnttab_swap_grant_ref {
    pub ref_a: grant_ref_t,
    pub ref_b: grant_ref_t,
    pub status: i16,
}
#[test]
fn bindgen_test_layout_gnttab_swap_grant_ref() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_swap_grant_ref>(),
        12usize,
        concat!("Size of: ", stringify!(gnttab_swap_grant_ref))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_swap_grant_ref>(),
        4usize,
        concat!("Alignment of ", stringify!(gnttab_swap_grant_ref))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_swap_grant_ref>())).ref_a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_swap_grant_ref),
            "::",
            stringify!(ref_a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_swap_grant_ref>())).ref_b as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_swap_grant_ref),
            "::",
            stringify!(ref_b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_swap_grant_ref>())).status as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_swap_grant_ref),
            "::",
            stringify!(status)
        )
    );
}
pub type gnttab_swap_grant_ref_t = gnttab_swap_grant_ref;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_swap_grant_ref_t {
    pub p: *mut gnttab_swap_grant_ref_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_swap_grant_ref_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_swap_grant_ref_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_gnttab_swap_grant_ref_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_swap_grant_ref_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_swap_grant_ref_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_swap_grant_ref_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_swap_grant_ref_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_swap_grant_ref_t {
    pub p: *const gnttab_swap_grant_ref_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_swap_grant_ref_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_swap_grant_ref_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_swap_grant_ref_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_swap_grant_ref_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_swap_grant_ref_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_swap_grant_ref_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_swap_grant_ref_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct gnttab_cache_flush {
    pub a: gnttab_cache_flush__bindgen_ty_1,
    pub offset: u16,
    pub length: u16,
    pub op: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union gnttab_cache_flush__bindgen_ty_1 {
    pub dev_bus_addr: u64,
    pub ref_: grant_ref_t,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_gnttab_cache_flush__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_cache_flush__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(gnttab_cache_flush__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_cache_flush__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(gnttab_cache_flush__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_cache_flush__bindgen_ty_1>())).dev_bus_addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_cache_flush__bindgen_ty_1),
            "::",
            stringify!(dev_bus_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gnttab_cache_flush__bindgen_ty_1>())).ref_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_cache_flush__bindgen_ty_1),
            "::",
            stringify!(ref_)
        )
    );
}
#[test]
fn bindgen_test_layout_gnttab_cache_flush() {
    assert_eq!(
        ::std::mem::size_of::<gnttab_cache_flush>(),
        16usize,
        concat!("Size of: ", stringify!(gnttab_cache_flush))
    );
    assert_eq!(
        ::std::mem::align_of::<gnttab_cache_flush>(),
        8usize,
        concat!("Alignment of ", stringify!(gnttab_cache_flush))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_cache_flush>())).a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_cache_flush),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_cache_flush>())).offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_cache_flush),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_cache_flush>())).length as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_cache_flush),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gnttab_cache_flush>())).op as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(gnttab_cache_flush),
            "::",
            stringify!(op)
        )
    );
}
pub type gnttab_cache_flush_t = gnttab_cache_flush;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_gnttab_cache_flush_t {
    pub p: *mut gnttab_cache_flush_t,
}
#[test]
fn bindgen_test_layout___guest_handle_gnttab_cache_flush_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_gnttab_cache_flush_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_gnttab_cache_flush_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_gnttab_cache_flush_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_gnttab_cache_flush_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_gnttab_cache_flush_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_gnttab_cache_flush_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_gnttab_cache_flush_t {
    pub p: *const gnttab_cache_flush_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_gnttab_cache_flush_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_gnttab_cache_flush_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_gnttab_cache_flush_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_gnttab_cache_flush_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_gnttab_cache_flush_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_gnttab_cache_flush_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_gnttab_cache_flush_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_save_descriptor {
    pub typecode: u16,
    pub instance: u16,
    pub length: u32,
}
#[test]
fn bindgen_test_layout_hvm_save_descriptor() {
    assert_eq!(
        ::std::mem::size_of::<hvm_save_descriptor>(),
        8usize,
        concat!("Size of: ", stringify!(hvm_save_descriptor))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_save_descriptor>(),
        4usize,
        concat!("Alignment of ", stringify!(hvm_save_descriptor))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_save_descriptor>())).typecode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_save_descriptor),
            "::",
            stringify!(typecode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_save_descriptor>())).instance as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_save_descriptor),
            "::",
            stringify!(instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_save_descriptor>())).length as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_save_descriptor),
            "::",
            stringify!(length)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_save_end {}
#[test]
fn bindgen_test_layout_hvm_save_end() {
    assert_eq!(
        ::std::mem::size_of::<hvm_save_end>(),
        0usize,
        concat!("Size of: ", stringify!(hvm_save_end))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_save_end>(),
        1usize,
        concat!("Alignment of ", stringify!(hvm_save_end))
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct __HVM_SAVE_TYPE_END {
    pub t: hvm_save_end,
    pub c: __IncompleteArrayField<::std::os::raw::c_char>,
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_END() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_END>(),
        1usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_END))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_END>(),
        1usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_END))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_END>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_END),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_END>())).c as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_END),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_END>())).cpt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_END),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_save_header {
    pub magic: u32,
    pub version: u32,
    pub changeset: u64,
    pub cpuid: u32,
    pub gtsc_khz: u32,
}
#[test]
fn bindgen_test_layout_hvm_save_header() {
    assert_eq!(
        ::std::mem::size_of::<hvm_save_header>(),
        24usize,
        concat!("Size of: ", stringify!(hvm_save_header))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_save_header>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_save_header))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_save_header>())).magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_save_header),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_save_header>())).version as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_save_header),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_save_header>())).changeset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_save_header),
            "::",
            stringify!(changeset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_save_header>())).cpuid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_save_header),
            "::",
            stringify!(cpuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_save_header>())).gtsc_khz as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_save_header),
            "::",
            stringify!(gtsc_khz)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_HEADER {
    pub t: hvm_save_header,
    pub c: [::std::os::raw::c_char; 1usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_HEADER() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_HEADER>(),
        32usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_HEADER))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_HEADER>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_HEADER))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_HEADER>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_HEADER),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_HEADER>())).c as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_HEADER),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_HEADER>())).cpt as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_HEADER),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_cpu {
    pub fpu_regs: [u8; 512usize],
    pub rax: u64,
    pub rbx: u64,
    pub rcx: u64,
    pub rdx: u64,
    pub rbp: u64,
    pub rsi: u64,
    pub rdi: u64,
    pub rsp: u64,
    pub r8: u64,
    pub r9: u64,
    pub r10: u64,
    pub r11: u64,
    pub r12: u64,
    pub r13: u64,
    pub r14: u64,
    pub r15: u64,
    pub rip: u64,
    pub rflags: u64,
    pub cr0: u64,
    pub cr2: u64,
    pub cr3: u64,
    pub cr4: u64,
    pub dr0: u64,
    pub dr1: u64,
    pub dr2: u64,
    pub dr3: u64,
    pub dr6: u64,
    pub dr7: u64,
    pub cs_sel: u32,
    pub ds_sel: u32,
    pub es_sel: u32,
    pub fs_sel: u32,
    pub gs_sel: u32,
    pub ss_sel: u32,
    pub tr_sel: u32,
    pub ldtr_sel: u32,
    pub cs_limit: u32,
    pub ds_limit: u32,
    pub es_limit: u32,
    pub fs_limit: u32,
    pub gs_limit: u32,
    pub ss_limit: u32,
    pub tr_limit: u32,
    pub ldtr_limit: u32,
    pub idtr_limit: u32,
    pub gdtr_limit: u32,
    pub cs_base: u64,
    pub ds_base: u64,
    pub es_base: u64,
    pub fs_base: u64,
    pub gs_base: u64,
    pub ss_base: u64,
    pub tr_base: u64,
    pub ldtr_base: u64,
    pub idtr_base: u64,
    pub gdtr_base: u64,
    pub cs_arbytes: u32,
    pub ds_arbytes: u32,
    pub es_arbytes: u32,
    pub fs_arbytes: u32,
    pub gs_arbytes: u32,
    pub ss_arbytes: u32,
    pub tr_arbytes: u32,
    pub ldtr_arbytes: u32,
    pub sysenter_cs: u64,
    pub sysenter_esp: u64,
    pub sysenter_eip: u64,
    pub shadow_gs: u64,
    pub msr_flags: u64,
    pub msr_lstar: u64,
    pub msr_star: u64,
    pub msr_cstar: u64,
    pub msr_syscall_mask: u64,
    pub msr_efer: u64,
    pub msr_tsc_aux: u64,
    pub tsc: u64,
    pub __bindgen_anon_1: hvm_hw_cpu__bindgen_ty_1,
    pub error_code: u32,
    pub flags: u32,
    pub pad0: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hvm_hw_cpu__bindgen_ty_1 {
    pub pending_event: u32,
    pub __bindgen_anon_1: hvm_hw_cpu__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_cpu__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(hvm_hw_cpu__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(hvm_hw_cpu__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl hvm_hw_cpu__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn pending_vector(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u8) }
    }
    #[inline]
    pub fn set_pending_vector(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn pending_type(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_pending_type(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn pending_error_valid(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pending_error_valid(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pending_reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 19u8) as u32) }
    }
    #[inline]
    pub fn set_pending_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 19u8, val as u64)
        }
    }
    #[inline]
    pub fn pending_valid(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pending_valid(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pending_vector: u8,
        pending_type: u8,
        pending_error_valid: u8,
        pending_reserved: u32,
        pending_valid: u8,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let pending_vector: u8 = unsafe { ::std::mem::transmute(pending_vector) };
            pending_vector as u64
        });
        __bindgen_bitfield_unit.set(8usize, 3u8, {
            let pending_type: u8 = unsafe { ::std::mem::transmute(pending_type) };
            pending_type as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let pending_error_valid: u8 = unsafe { ::std::mem::transmute(pending_error_valid) };
            pending_error_valid as u64
        });
        __bindgen_bitfield_unit.set(12usize, 19u8, {
            let pending_reserved: u32 = unsafe { ::std::mem::transmute(pending_reserved) };
            pending_reserved as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let pending_valid: u8 = unsafe { ::std::mem::transmute(pending_valid) };
            pending_valid as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(hvm_hw_cpu__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(hvm_hw_cpu__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu__bindgen_ty_1>())).pending_event as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu__bindgen_ty_1),
            "::",
            stringify!(pending_event)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu>(),
        1032usize,
        concat!("Size of: ", stringify!(hvm_hw_cpu))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_cpu))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).fpu_regs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(fpu_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rax as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rbx as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rbx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rcx as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rcx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rdx as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rdx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rbp as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rbp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rsi as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rdi as *const _ as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rdi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rsp as *const _ as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rsp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).r8 as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(r8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).r9 as *const _ as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(r9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).r10 as *const _ as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(r10)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).r11 as *const _ as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(r11)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).r12 as *const _ as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(r12)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).r13 as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(r13)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).r14 as *const _ as usize },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(r14)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).r15 as *const _ as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(r15)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rip as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).rflags as *const _ as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(rflags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).cr0 as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(cr0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).cr2 as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(cr2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).cr3 as *const _ as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(cr3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).cr4 as *const _ as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(cr4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).dr0 as *const _ as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(dr0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).dr1 as *const _ as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(dr1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).dr2 as *const _ as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(dr2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).dr3 as *const _ as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(dr3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).dr6 as *const _ as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(dr6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).dr7 as *const _ as usize },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(dr7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).cs_sel as *const _ as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(cs_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ds_sel as *const _ as usize },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ds_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).es_sel as *const _ as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(es_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).fs_sel as *const _ as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(fs_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).gs_sel as *const _ as usize },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(gs_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ss_sel as *const _ as usize },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ss_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).tr_sel as *const _ as usize },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(tr_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ldtr_sel as *const _ as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ldtr_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).cs_limit as *const _ as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(cs_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ds_limit as *const _ as usize },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ds_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).es_limit as *const _ as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(es_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).fs_limit as *const _ as usize },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(fs_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).gs_limit as *const _ as usize },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(gs_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ss_limit as *const _ as usize },
        788usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ss_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).tr_limit as *const _ as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(tr_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ldtr_limit as *const _ as usize },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ldtr_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).idtr_limit as *const _ as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(idtr_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).gdtr_limit as *const _ as usize },
        804usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(gdtr_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).cs_base as *const _ as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(cs_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ds_base as *const _ as usize },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ds_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).es_base as *const _ as usize },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(es_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).fs_base as *const _ as usize },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(fs_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).gs_base as *const _ as usize },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(gs_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ss_base as *const _ as usize },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ss_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).tr_base as *const _ as usize },
        856usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(tr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ldtr_base as *const _ as usize },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ldtr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).idtr_base as *const _ as usize },
        872usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(idtr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).gdtr_base as *const _ as usize },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(gdtr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).cs_arbytes as *const _ as usize },
        888usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(cs_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ds_arbytes as *const _ as usize },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ds_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).es_arbytes as *const _ as usize },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(es_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).fs_arbytes as *const _ as usize },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(fs_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).gs_arbytes as *const _ as usize },
        904usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(gs_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ss_arbytes as *const _ as usize },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ss_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).tr_arbytes as *const _ as usize },
        912usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(tr_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).ldtr_arbytes as *const _ as usize },
        916usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(ldtr_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).sysenter_cs as *const _ as usize },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(sysenter_cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).sysenter_esp as *const _ as usize },
        928usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(sysenter_esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).sysenter_eip as *const _ as usize },
        936usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(sysenter_eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).shadow_gs as *const _ as usize },
        944usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(shadow_gs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).msr_flags as *const _ as usize },
        952usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(msr_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).msr_lstar as *const _ as usize },
        960usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(msr_lstar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).msr_star as *const _ as usize },
        968usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(msr_star)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).msr_cstar as *const _ as usize },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(msr_cstar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).msr_syscall_mask as *const _ as usize },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(msr_syscall_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).msr_efer as *const _ as usize },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(msr_efer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).msr_tsc_aux as *const _ as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(msr_tsc_aux)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).tsc as *const _ as usize },
        1008usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(tsc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).error_code as *const _ as usize },
        1020usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(error_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).flags as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu>())).pad0 as *const _ as usize },
        1028usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu),
            "::",
            stringify!(pad0)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_cpu_compat {
    pub fpu_regs: [u8; 512usize],
    pub rax: u64,
    pub rbx: u64,
    pub rcx: u64,
    pub rdx: u64,
    pub rbp: u64,
    pub rsi: u64,
    pub rdi: u64,
    pub rsp: u64,
    pub r8: u64,
    pub r9: u64,
    pub r10: u64,
    pub r11: u64,
    pub r12: u64,
    pub r13: u64,
    pub r14: u64,
    pub r15: u64,
    pub rip: u64,
    pub rflags: u64,
    pub cr0: u64,
    pub cr2: u64,
    pub cr3: u64,
    pub cr4: u64,
    pub dr0: u64,
    pub dr1: u64,
    pub dr2: u64,
    pub dr3: u64,
    pub dr6: u64,
    pub dr7: u64,
    pub cs_sel: u32,
    pub ds_sel: u32,
    pub es_sel: u32,
    pub fs_sel: u32,
    pub gs_sel: u32,
    pub ss_sel: u32,
    pub tr_sel: u32,
    pub ldtr_sel: u32,
    pub cs_limit: u32,
    pub ds_limit: u32,
    pub es_limit: u32,
    pub fs_limit: u32,
    pub gs_limit: u32,
    pub ss_limit: u32,
    pub tr_limit: u32,
    pub ldtr_limit: u32,
    pub idtr_limit: u32,
    pub gdtr_limit: u32,
    pub cs_base: u64,
    pub ds_base: u64,
    pub es_base: u64,
    pub fs_base: u64,
    pub gs_base: u64,
    pub ss_base: u64,
    pub tr_base: u64,
    pub ldtr_base: u64,
    pub idtr_base: u64,
    pub gdtr_base: u64,
    pub cs_arbytes: u32,
    pub ds_arbytes: u32,
    pub es_arbytes: u32,
    pub fs_arbytes: u32,
    pub gs_arbytes: u32,
    pub ss_arbytes: u32,
    pub tr_arbytes: u32,
    pub ldtr_arbytes: u32,
    pub sysenter_cs: u64,
    pub sysenter_esp: u64,
    pub sysenter_eip: u64,
    pub shadow_gs: u64,
    pub msr_flags: u64,
    pub msr_lstar: u64,
    pub msr_star: u64,
    pub msr_cstar: u64,
    pub msr_syscall_mask: u64,
    pub msr_efer: u64,
    pub tsc: u64,
    pub __bindgen_anon_1: hvm_hw_cpu_compat__bindgen_ty_1,
    pub error_code: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hvm_hw_cpu_compat__bindgen_ty_1 {
    pub pending_event: u32,
    pub __bindgen_anon_1: hvm_hw_cpu_compat__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_cpu_compat__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu_compat__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu_compat__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(hvm_hw_cpu_compat__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu_compat__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(hvm_hw_cpu_compat__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl hvm_hw_cpu_compat__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn pending_vector(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u8) }
    }
    #[inline]
    pub fn set_pending_vector(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn pending_type(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_pending_type(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn pending_error_valid(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pending_error_valid(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pending_reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 19u8) as u32) }
    }
    #[inline]
    pub fn set_pending_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 19u8, val as u64)
        }
    }
    #[inline]
    pub fn pending_valid(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pending_valid(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pending_vector: u8,
        pending_type: u8,
        pending_error_valid: u8,
        pending_reserved: u32,
        pending_valid: u8,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let pending_vector: u8 = unsafe { ::std::mem::transmute(pending_vector) };
            pending_vector as u64
        });
        __bindgen_bitfield_unit.set(8usize, 3u8, {
            let pending_type: u8 = unsafe { ::std::mem::transmute(pending_type) };
            pending_type as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let pending_error_valid: u8 = unsafe { ::std::mem::transmute(pending_error_valid) };
            pending_error_valid as u64
        });
        __bindgen_bitfield_unit.set(12usize, 19u8, {
            let pending_reserved: u32 = unsafe { ::std::mem::transmute(pending_reserved) };
            pending_reserved as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let pending_valid: u8 = unsafe { ::std::mem::transmute(pending_valid) };
            pending_valid as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu_compat__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu_compat__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(hvm_hw_cpu_compat__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu_compat__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(hvm_hw_cpu_compat__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu_compat__bindgen_ty_1>())).pending_event as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat__bindgen_ty_1),
            "::",
            stringify!(pending_event)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu_compat() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu_compat>(),
        1016usize,
        concat!("Size of: ", stringify!(hvm_hw_cpu_compat))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu_compat>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_cpu_compat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).fpu_regs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(fpu_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rax as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rbx as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rbx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rcx as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rcx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rdx as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rdx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rbp as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rbp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rsi as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rdi as *const _ as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rdi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rsp as *const _ as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rsp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).r8 as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(r8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).r9 as *const _ as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(r9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).r10 as *const _ as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(r10)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).r11 as *const _ as usize },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(r11)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).r12 as *const _ as usize },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(r12)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).r13 as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(r13)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).r14 as *const _ as usize },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(r14)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).r15 as *const _ as usize },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(r15)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rip as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).rflags as *const _ as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(rflags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).cr0 as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(cr0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).cr2 as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(cr2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).cr3 as *const _ as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(cr3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).cr4 as *const _ as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(cr4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).dr0 as *const _ as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(dr0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).dr1 as *const _ as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(dr1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).dr2 as *const _ as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(dr2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).dr3 as *const _ as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(dr3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).dr6 as *const _ as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(dr6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).dr7 as *const _ as usize },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(dr7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).cs_sel as *const _ as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(cs_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ds_sel as *const _ as usize },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ds_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).es_sel as *const _ as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(es_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).fs_sel as *const _ as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(fs_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).gs_sel as *const _ as usize },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(gs_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ss_sel as *const _ as usize },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ss_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).tr_sel as *const _ as usize },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(tr_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ldtr_sel as *const _ as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ldtr_sel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).cs_limit as *const _ as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(cs_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ds_limit as *const _ as usize },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ds_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).es_limit as *const _ as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(es_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).fs_limit as *const _ as usize },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(fs_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).gs_limit as *const _ as usize },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(gs_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ss_limit as *const _ as usize },
        788usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ss_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).tr_limit as *const _ as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(tr_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ldtr_limit as *const _ as usize },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ldtr_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).idtr_limit as *const _ as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(idtr_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).gdtr_limit as *const _ as usize },
        804usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(gdtr_limit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).cs_base as *const _ as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(cs_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ds_base as *const _ as usize },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ds_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).es_base as *const _ as usize },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(es_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).fs_base as *const _ as usize },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(fs_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).gs_base as *const _ as usize },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(gs_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ss_base as *const _ as usize },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ss_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).tr_base as *const _ as usize },
        856usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(tr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ldtr_base as *const _ as usize },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ldtr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).idtr_base as *const _ as usize },
        872usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(idtr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).gdtr_base as *const _ as usize },
        880usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(gdtr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).cs_arbytes as *const _ as usize },
        888usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(cs_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ds_arbytes as *const _ as usize },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ds_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).es_arbytes as *const _ as usize },
        896usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(es_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).fs_arbytes as *const _ as usize },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(fs_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).gs_arbytes as *const _ as usize },
        904usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(gs_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ss_arbytes as *const _ as usize },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ss_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).tr_arbytes as *const _ as usize },
        912usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(tr_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).ldtr_arbytes as *const _ as usize },
        916usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(ldtr_arbytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).sysenter_cs as *const _ as usize },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(sysenter_cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).sysenter_esp as *const _ as usize },
        928usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(sysenter_esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).sysenter_eip as *const _ as usize },
        936usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(sysenter_eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).shadow_gs as *const _ as usize },
        944usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(shadow_gs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).msr_flags as *const _ as usize },
        952usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(msr_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).msr_lstar as *const _ as usize },
        960usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(msr_lstar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).msr_star as *const _ as usize },
        968usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(msr_star)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).msr_cstar as *const _ as usize },
        976usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(msr_cstar)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).msr_syscall_mask as *const _ as usize
        },
        984usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(msr_syscall_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).msr_efer as *const _ as usize },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(msr_efer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).tsc as *const _ as usize },
        1000usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(tsc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_compat>())).error_code as *const _ as usize },
        1012usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_compat),
            "::",
            stringify!(error_code)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __HVM_SAVE_TYPE_CPU {
    pub t: hvm_hw_cpu,
    pub c: [::std::os::raw::c_char; 2usize],
    pub cpt: [::std::os::raw::c_char; 2usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_CPU() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_CPU>(),
        1040usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_CPU))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_CPU>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_CPU))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_CPU>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_CPU),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_CPU>())).c as *const _ as usize },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_CPU),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_CPU>())).cpt as *const _ as usize },
        1034usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_CPU),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_vpic {
    pub irr: u8,
    pub imr: u8,
    pub isr: u8,
    pub irq_base: u8,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize], u8>,
    pub elcr: u8,
    pub int_output: u8,
}
#[test]
fn bindgen_test_layout_hvm_hw_vpic() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_vpic>(),
        8usize,
        concat!("Size of: ", stringify!(hvm_hw_vpic))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_vpic>(),
        1usize,
        concat!("Alignment of ", stringify!(hvm_hw_vpic))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vpic>())).irr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vpic),
            "::",
            stringify!(irr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vpic>())).imr as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vpic),
            "::",
            stringify!(imr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vpic>())).isr as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vpic),
            "::",
            stringify!(isr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vpic>())).irq_base as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vpic),
            "::",
            stringify!(irq_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vpic>())).elcr as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vpic),
            "::",
            stringify!(elcr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vpic>())).int_output as *const _ as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vpic),
            "::",
            stringify!(int_output)
        )
    );
}
impl hvm_hw_vpic {
    #[inline]
    pub fn init_state(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_init_state(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn priority_add(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_priority_add(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn readsel_isr(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_readsel_isr(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn poll(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_poll(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn auto_eoi(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_auto_eoi(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn rotate_on_auto_eoi(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_rotate_on_auto_eoi(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn special_fully_nested_mode(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_special_fully_nested_mode(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn special_mask_mode(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_special_mask_mode(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_master(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_is_master(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        init_state: u8,
        priority_add: u8,
        readsel_isr: u8,
        poll: u8,
        auto_eoi: u8,
        rotate_on_auto_eoi: u8,
        special_fully_nested_mode: u8,
        special_mask_mode: u8,
        is_master: u8,
    ) -> __BindgenBitfieldUnit<[u8; 2usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let init_state: u8 = unsafe { ::std::mem::transmute(init_state) };
            init_state as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let priority_add: u8 = unsafe { ::std::mem::transmute(priority_add) };
            priority_add as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let readsel_isr: u8 = unsafe { ::std::mem::transmute(readsel_isr) };
            readsel_isr as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let poll: u8 = unsafe { ::std::mem::transmute(poll) };
            poll as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let auto_eoi: u8 = unsafe { ::std::mem::transmute(auto_eoi) };
            auto_eoi as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let rotate_on_auto_eoi: u8 = unsafe { ::std::mem::transmute(rotate_on_auto_eoi) };
            rotate_on_auto_eoi as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let special_fully_nested_mode: u8 =
                unsafe { ::std::mem::transmute(special_fully_nested_mode) };
            special_fully_nested_mode as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let special_mask_mode: u8 = unsafe { ::std::mem::transmute(special_mask_mode) };
            special_mask_mode as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let is_master: u8 = unsafe { ::std::mem::transmute(is_master) };
            is_master as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_PIC {
    pub t: hvm_hw_vpic,
    pub c: [::std::os::raw::c_char; 3usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_PIC() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_PIC>(),
        12usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_PIC))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_PIC>(),
        1usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_PIC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PIC>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PIC),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PIC>())).c as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PIC),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PIC>())).cpt as *const _ as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PIC),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union vioapic_redir_entry {
    pub bits: u64,
    pub fields: vioapic_redir_entry__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vioapic_redir_entry__bindgen_ty_1 {
    pub vector: u8,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize], u8>,
    pub reserved: [u8; 4usize],
    pub dest_id: u8,
}
#[test]
fn bindgen_test_layout_vioapic_redir_entry__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<vioapic_redir_entry__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(vioapic_redir_entry__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<vioapic_redir_entry__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(vioapic_redir_entry__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vioapic_redir_entry__bindgen_ty_1>())).vector as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vioapic_redir_entry__bindgen_ty_1),
            "::",
            stringify!(vector)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vioapic_redir_entry__bindgen_ty_1>())).reserved as *const _
                as usize
        },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(vioapic_redir_entry__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<vioapic_redir_entry__bindgen_ty_1>())).dest_id as *const _
                as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(vioapic_redir_entry__bindgen_ty_1),
            "::",
            stringify!(dest_id)
        )
    );
}
impl vioapic_redir_entry__bindgen_ty_1 {
    #[inline]
    pub fn delivery_mode(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_delivery_mode(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn dest_mode(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_dest_mode(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delivery_status(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_delivery_status(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn polarity(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_polarity(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn remote_irr(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_remote_irr(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn trig_mode(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_trig_mode(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mask(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_mask(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserve(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_reserve(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        delivery_mode: u8,
        dest_mode: u8,
        delivery_status: u8,
        polarity: u8,
        remote_irr: u8,
        trig_mode: u8,
        mask: u8,
        reserve: u8,
    ) -> __BindgenBitfieldUnit<[u8; 2usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let delivery_mode: u8 = unsafe { ::std::mem::transmute(delivery_mode) };
            delivery_mode as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let dest_mode: u8 = unsafe { ::std::mem::transmute(dest_mode) };
            dest_mode as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let delivery_status: u8 = unsafe { ::std::mem::transmute(delivery_status) };
            delivery_status as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let polarity: u8 = unsafe { ::std::mem::transmute(polarity) };
            polarity as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let remote_irr: u8 = unsafe { ::std::mem::transmute(remote_irr) };
            remote_irr as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let trig_mode: u8 = unsafe { ::std::mem::transmute(trig_mode) };
            trig_mode as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let mask: u8 = unsafe { ::std::mem::transmute(mask) };
            mask as u64
        });
        __bindgen_bitfield_unit.set(9usize, 7u8, {
            let reserve: u8 = unsafe { ::std::mem::transmute(reserve) };
            reserve as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_vioapic_redir_entry() {
    assert_eq!(
        ::std::mem::size_of::<vioapic_redir_entry>(),
        8usize,
        concat!("Size of: ", stringify!(vioapic_redir_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<vioapic_redir_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(vioapic_redir_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vioapic_redir_entry>())).bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vioapic_redir_entry),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<vioapic_redir_entry>())).fields as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vioapic_redir_entry),
            "::",
            stringify!(fields)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_vioapic {
    pub base_address: u64,
    pub ioregsel: u32,
    pub id: u32,
    pub redirtbl: [vioapic_redir_entry; 48usize],
}
#[test]
fn bindgen_test_layout_hvm_hw_vioapic() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_vioapic>(),
        400usize,
        concat!("Size of: ", stringify!(hvm_hw_vioapic))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_vioapic>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_vioapic))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vioapic>())).base_address as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vioapic),
            "::",
            stringify!(base_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vioapic>())).ioregsel as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vioapic),
            "::",
            stringify!(ioregsel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vioapic>())).id as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vioapic),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_vioapic>())).redirtbl as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_vioapic),
            "::",
            stringify!(redirtbl)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __HVM_SAVE_TYPE_IOAPIC {
    pub t: hvm_hw_vioapic,
    pub c: [::std::os::raw::c_char; 4usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_IOAPIC() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_IOAPIC>(),
        408usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_IOAPIC))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_IOAPIC>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_IOAPIC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_IOAPIC>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_IOAPIC),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_IOAPIC>())).c as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_IOAPIC),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_IOAPIC>())).cpt as *const _ as usize },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_IOAPIC),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_lapic {
    pub apic_base_msr: u64,
    pub disabled: u32,
    pub timer_divisor: u32,
    pub tdt_msr: u64,
}
#[test]
fn bindgen_test_layout_hvm_hw_lapic() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_lapic>(),
        24usize,
        concat!("Size of: ", stringify!(hvm_hw_lapic))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_lapic>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_lapic))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_lapic>())).apic_base_msr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_lapic),
            "::",
            stringify!(apic_base_msr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_lapic>())).disabled as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_lapic),
            "::",
            stringify!(disabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_lapic>())).timer_divisor as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_lapic),
            "::",
            stringify!(timer_divisor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_lapic>())).tdt_msr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_lapic),
            "::",
            stringify!(tdt_msr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_LAPIC {
    pub t: hvm_hw_lapic,
    pub c: [::std::os::raw::c_char; 5usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_LAPIC() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_LAPIC>(),
        32usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_LAPIC))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_LAPIC>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_LAPIC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_LAPIC>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_LAPIC),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_LAPIC>())).c as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_LAPIC),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_LAPIC>())).cpt as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_LAPIC),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_lapic_regs {
    pub data: [u8; 1024usize],
}
#[test]
fn bindgen_test_layout_hvm_hw_lapic_regs() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_lapic_regs>(),
        1024usize,
        concat!("Size of: ", stringify!(hvm_hw_lapic_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_lapic_regs>(),
        1usize,
        concat!("Alignment of ", stringify!(hvm_hw_lapic_regs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_lapic_regs>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_lapic_regs),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __HVM_SAVE_TYPE_LAPIC_REGS {
    pub t: hvm_hw_lapic_regs,
    pub c: [::std::os::raw::c_char; 6usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_LAPIC_REGS() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_LAPIC_REGS>(),
        1031usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_LAPIC_REGS))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_LAPIC_REGS>(),
        1usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_LAPIC_REGS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_LAPIC_REGS>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_LAPIC_REGS),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_LAPIC_REGS>())).c as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_LAPIC_REGS),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_LAPIC_REGS>())).cpt as *const _ as usize },
        1030usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_LAPIC_REGS),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_pci_irqs {
    pub __bindgen_anon_1: hvm_hw_pci_irqs__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hvm_hw_pci_irqs__bindgen_ty_1 {
    pub i: [::std::os::raw::c_ulong; 2usize],
    pub pad: [u64; 2usize],
    _bindgen_union_align: [u64; 2usize],
}
#[test]
fn bindgen_test_layout_hvm_hw_pci_irqs__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_pci_irqs__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(hvm_hw_pci_irqs__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_pci_irqs__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_pci_irqs__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pci_irqs__bindgen_ty_1>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pci_irqs__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pci_irqs__bindgen_ty_1>())).pad as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pci_irqs__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_hw_pci_irqs() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_pci_irqs>(),
        16usize,
        concat!("Size of: ", stringify!(hvm_hw_pci_irqs))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_pci_irqs>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_pci_irqs))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __HVM_SAVE_TYPE_PCI_IRQ {
    pub t: hvm_hw_pci_irqs,
    pub c: [::std::os::raw::c_char; 7usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_PCI_IRQ() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_PCI_IRQ>(),
        24usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_PCI_IRQ))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_PCI_IRQ>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_PCI_IRQ))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PCI_IRQ>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PCI_IRQ),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PCI_IRQ>())).c as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PCI_IRQ),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PCI_IRQ>())).cpt as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PCI_IRQ),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_isa_irqs {
    pub __bindgen_anon_1: hvm_hw_isa_irqs__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hvm_hw_isa_irqs__bindgen_ty_1 {
    pub i: [::std::os::raw::c_ulong; 1usize],
    pub pad: [u64; 1usize],
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_hvm_hw_isa_irqs__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_isa_irqs__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(hvm_hw_isa_irqs__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_isa_irqs__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_isa_irqs__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_isa_irqs__bindgen_ty_1>())).i as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_isa_irqs__bindgen_ty_1),
            "::",
            stringify!(i)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_isa_irqs__bindgen_ty_1>())).pad as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_isa_irqs__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_hw_isa_irqs() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_isa_irqs>(),
        8usize,
        concat!("Size of: ", stringify!(hvm_hw_isa_irqs))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_isa_irqs>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_isa_irqs))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __HVM_SAVE_TYPE_ISA_IRQ {
    pub t: hvm_hw_isa_irqs,
    pub c: [::std::os::raw::c_char; 8usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_ISA_IRQ() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_ISA_IRQ>(),
        24usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_ISA_IRQ))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_ISA_IRQ>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_ISA_IRQ))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_ISA_IRQ>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_ISA_IRQ),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_ISA_IRQ>())).c as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_ISA_IRQ),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_ISA_IRQ>())).cpt as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_ISA_IRQ),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_pci_link {
    pub route: [u8; 4usize],
    pub pad0: [u8; 4usize],
}
#[test]
fn bindgen_test_layout_hvm_hw_pci_link() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_pci_link>(),
        8usize,
        concat!("Size of: ", stringify!(hvm_hw_pci_link))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_pci_link>(),
        1usize,
        concat!("Alignment of ", stringify!(hvm_hw_pci_link))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pci_link>())).route as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pci_link),
            "::",
            stringify!(route)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pci_link>())).pad0 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pci_link),
            "::",
            stringify!(pad0)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_PCI_LINK {
    pub t: hvm_hw_pci_link,
    pub c: [::std::os::raw::c_char; 9usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_PCI_LINK() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_PCI_LINK>(),
        18usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_PCI_LINK))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_PCI_LINK>(),
        1usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_PCI_LINK))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PCI_LINK>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PCI_LINK),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PCI_LINK>())).c as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PCI_LINK),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PCI_LINK>())).cpt as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PCI_LINK),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_pit {
    pub channels: [hvm_hw_pit_hvm_hw_pit_channel; 3usize],
    pub speaker_data_on: u32,
    pub pad0: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_pit_hvm_hw_pit_channel {
    pub count: u32,
    pub latched_count: u16,
    pub count_latched: u8,
    pub status_latched: u8,
    pub status: u8,
    pub read_state: u8,
    pub write_state: u8,
    pub write_latch: u8,
    pub rw_mode: u8,
    pub mode: u8,
    pub bcd: u8,
    pub gate: u8,
}
#[test]
fn bindgen_test_layout_hvm_hw_pit_hvm_hw_pit_channel() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_pit_hvm_hw_pit_channel>(),
        16usize,
        concat!("Size of: ", stringify!(hvm_hw_pit_hvm_hw_pit_channel))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_pit_hvm_hw_pit_channel>(),
        4usize,
        concat!("Alignment of ", stringify!(hvm_hw_pit_hvm_hw_pit_channel))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).latched_count as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(latched_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).count_latched as *const _
                as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(count_latched)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).status_latched as *const _
                as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(status_latched)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).status as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).read_state as *const _
                as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(read_state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).write_state as *const _
                as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(write_state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).write_latch as *const _
                as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(write_latch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).rw_mode as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(rw_mode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).mode as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).bcd as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(bcd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_pit_hvm_hw_pit_channel>())).gate as *const _ as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit_hvm_hw_pit_channel),
            "::",
            stringify!(gate)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_hw_pit() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_pit>(),
        56usize,
        concat!("Size of: ", stringify!(hvm_hw_pit))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_pit>(),
        4usize,
        concat!("Alignment of ", stringify!(hvm_hw_pit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pit>())).channels as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit),
            "::",
            stringify!(channels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pit>())).speaker_data_on as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit),
            "::",
            stringify!(speaker_data_on)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pit>())).pad0 as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pit),
            "::",
            stringify!(pad0)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_PIT {
    pub t: hvm_hw_pit,
    pub c: [::std::os::raw::c_char; 10usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_PIT() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_PIT>(),
        68usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_PIT))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_PIT>(),
        4usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_PIT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PIT>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PIT),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PIT>())).c as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PIT),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PIT>())).cpt as *const _ as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PIT),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_rtc {
    pub cmos_data: [u8; 14usize],
    pub cmos_index: u8,
    pub pad0: u8,
}
#[test]
fn bindgen_test_layout_hvm_hw_rtc() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_rtc>(),
        16usize,
        concat!("Size of: ", stringify!(hvm_hw_rtc))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_rtc>(),
        1usize,
        concat!("Alignment of ", stringify!(hvm_hw_rtc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_rtc>())).cmos_data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_rtc),
            "::",
            stringify!(cmos_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_rtc>())).cmos_index as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_rtc),
            "::",
            stringify!(cmos_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_rtc>())).pad0 as *const _ as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_rtc),
            "::",
            stringify!(pad0)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_RTC {
    pub t: hvm_hw_rtc,
    pub c: [::std::os::raw::c_char; 11usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_RTC() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_RTC>(),
        28usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_RTC))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_RTC>(),
        1usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_RTC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_RTC>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_RTC),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_RTC>())).c as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_RTC),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_RTC>())).cpt as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_RTC),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_hpet {
    pub capability: u64,
    pub res0: u64,
    pub config: u64,
    pub res1: u64,
    pub isr: u64,
    pub res2: [u64; 25usize],
    pub mc64: u64,
    pub res3: u64,
    pub timers: [hvm_hw_hpet__bindgen_ty_1; 3usize],
    pub res5: [u64; 84usize],
    pub period: [u64; 3usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_hpet__bindgen_ty_1 {
    pub config: u64,
    pub cmp: u64,
    pub fsb: u64,
    pub res4: u64,
}
#[test]
fn bindgen_test_layout_hvm_hw_hpet__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_hpet__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(hvm_hw_hpet__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_hpet__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_hpet__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_hpet__bindgen_ty_1>())).config as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet__bindgen_ty_1),
            "::",
            stringify!(config)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet__bindgen_ty_1>())).cmp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet__bindgen_ty_1),
            "::",
            stringify!(cmp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet__bindgen_ty_1>())).fsb as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet__bindgen_ty_1),
            "::",
            stringify!(fsb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet__bindgen_ty_1>())).res4 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet__bindgen_ty_1),
            "::",
            stringify!(res4)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_hw_hpet() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_hpet>(),
        1048usize,
        concat!("Size of: ", stringify!(hvm_hw_hpet))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_hpet>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_hpet))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).capability as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(capability)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).res0 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(res0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).config as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(config)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).res1 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(res1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).isr as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(isr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).res2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(res2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).mc64 as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(mc64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).res3 as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(res3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).timers as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(timers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).res5 as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(res5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_hpet>())).period as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_hpet),
            "::",
            stringify!(period)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __HVM_SAVE_TYPE_HPET {
    pub t: hvm_hw_hpet,
    pub c: [::std::os::raw::c_char; 12usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_HPET() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_HPET>(),
        1064usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_HPET))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_HPET>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_HPET))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_HPET>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_HPET),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_HPET>())).c as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_HPET),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_HPET>())).cpt as *const _ as usize },
        1060usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_HPET),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_pmtimer {
    pub tmr_val: u32,
    pub pm1a_sts: u16,
    pub pm1a_en: u16,
}
#[test]
fn bindgen_test_layout_hvm_hw_pmtimer() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_pmtimer>(),
        8usize,
        concat!("Size of: ", stringify!(hvm_hw_pmtimer))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_pmtimer>(),
        4usize,
        concat!("Alignment of ", stringify!(hvm_hw_pmtimer))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pmtimer>())).tmr_val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pmtimer),
            "::",
            stringify!(tmr_val)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pmtimer>())).pm1a_sts as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pmtimer),
            "::",
            stringify!(pm1a_sts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_pmtimer>())).pm1a_en as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_pmtimer),
            "::",
            stringify!(pm1a_en)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_PMTIMER {
    pub t: hvm_hw_pmtimer,
    pub c: [::std::os::raw::c_char; 13usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_PMTIMER() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_PMTIMER>(),
        24usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_PMTIMER))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_PMTIMER>(),
        4usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_PMTIMER))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PMTIMER>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PMTIMER),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PMTIMER>())).c as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PMTIMER),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_PMTIMER>())).cpt as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_PMTIMER),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_mtrr {
    pub msr_pat_cr: u64,
    pub msr_mtrr_var: [u64; 16usize],
    pub msr_mtrr_fixed: [u64; 11usize],
    pub msr_mtrr_cap: u64,
    pub msr_mtrr_def_type: u64,
}
#[test]
fn bindgen_test_layout_hvm_hw_mtrr() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_mtrr>(),
        240usize,
        concat!("Size of: ", stringify!(hvm_hw_mtrr))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_mtrr>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_mtrr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_mtrr>())).msr_pat_cr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_mtrr),
            "::",
            stringify!(msr_pat_cr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_mtrr>())).msr_mtrr_var as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_mtrr),
            "::",
            stringify!(msr_mtrr_var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_mtrr>())).msr_mtrr_fixed as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_mtrr),
            "::",
            stringify!(msr_mtrr_fixed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_mtrr>())).msr_mtrr_cap as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_mtrr),
            "::",
            stringify!(msr_mtrr_cap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_mtrr>())).msr_mtrr_def_type as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_mtrr),
            "::",
            stringify!(msr_mtrr_def_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_MTRR {
    pub t: hvm_hw_mtrr,
    pub c: [::std::os::raw::c_char; 14usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_MTRR() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_MTRR>(),
        256usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_MTRR))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_MTRR>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_MTRR))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_MTRR>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_MTRR),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_MTRR>())).c as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_MTRR),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_MTRR>())).cpt as *const _ as usize },
        254usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_MTRR),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_cpu_xsave {
    pub xfeature_mask: u64,
    pub xcr0: u64,
    pub xcr0_accum: u64,
    pub save_area: hvm_hw_cpu_xsave__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_cpu_xsave__bindgen_ty_1 {
    pub fpu_sse: hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1,
    pub xsave_hdr: hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1 {
    pub x: [::std::os::raw::c_char; 512usize],
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1>(),
        512usize,
        concat!(
            "Size of: ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1>())).x as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(x)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr {
    pub xstate_bv: u64,
    pub xcomp_bv: u64,
    pub reserved: [u64; 6usize],
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr>()))
                .xstate_bv as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr),
            "::",
            stringify!(xstate_bv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr>())).xcomp_bv
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr),
            "::",
            stringify!(xcomp_bv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr>())).reserved
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1_hvm_hw_cpu_xsave_hdr),
            "::",
            stringify!(reserved)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu_xsave__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu_xsave__bindgen_ty_1>(),
        576usize,
        concat!("Size of: ", stringify!(hvm_hw_cpu_xsave__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu_xsave__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_cpu_xsave__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu_xsave__bindgen_ty_1>())).fpu_sse as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1),
            "::",
            stringify!(fpu_sse)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_hw_cpu_xsave__bindgen_ty_1>())).xsave_hdr as *const _
                as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave__bindgen_ty_1),
            "::",
            stringify!(xsave_hdr)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_hw_cpu_xsave() {
    assert_eq!(
        ::std::mem::size_of::<hvm_hw_cpu_xsave>(),
        600usize,
        concat!("Size of: ", stringify!(hvm_hw_cpu_xsave))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_hw_cpu_xsave>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_hw_cpu_xsave))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_xsave>())).xfeature_mask as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave),
            "::",
            stringify!(xfeature_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_xsave>())).xcr0 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave),
            "::",
            stringify!(xcr0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_xsave>())).xcr0_accum as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave),
            "::",
            stringify!(xcr0_accum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_hw_cpu_xsave>())).save_area as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_hw_cpu_xsave),
            "::",
            stringify!(save_area)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_viridian_domain_context {
    pub hypercall_gpa: u64,
    pub guest_os_id: u64,
    pub time_ref_count: u64,
    pub reference_tsc: u64,
}
#[test]
fn bindgen_test_layout_hvm_viridian_domain_context() {
    assert_eq!(
        ::std::mem::size_of::<hvm_viridian_domain_context>(),
        32usize,
        concat!("Size of: ", stringify!(hvm_viridian_domain_context))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_viridian_domain_context>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_viridian_domain_context))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_viridian_domain_context>())).hypercall_gpa as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_viridian_domain_context),
            "::",
            stringify!(hypercall_gpa)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_viridian_domain_context>())).guest_os_id as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_viridian_domain_context),
            "::",
            stringify!(guest_os_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_viridian_domain_context>())).time_ref_count as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_viridian_domain_context),
            "::",
            stringify!(time_ref_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_viridian_domain_context>())).reference_tsc as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_viridian_domain_context),
            "::",
            stringify!(reference_tsc)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_VIRIDIAN_DOMAIN {
    pub t: hvm_viridian_domain_context,
    pub c: [::std::os::raw::c_char; 15usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_VIRIDIAN_DOMAIN() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN>(),
        48usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN>())).t as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN>())).c as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN>())).cpt as *const _ as usize
        },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VIRIDIAN_DOMAIN),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_viridian_vcpu_context {
    pub vp_assist_msr: u64,
    pub vp_assist_vector: u8,
    pub _pad: [u8; 7usize],
}
#[test]
fn bindgen_test_layout_hvm_viridian_vcpu_context() {
    assert_eq!(
        ::std::mem::size_of::<hvm_viridian_vcpu_context>(),
        16usize,
        concat!("Size of: ", stringify!(hvm_viridian_vcpu_context))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_viridian_vcpu_context>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_viridian_vcpu_context))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_viridian_vcpu_context>())).vp_assist_msr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_viridian_vcpu_context),
            "::",
            stringify!(vp_assist_msr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hvm_viridian_vcpu_context>())).vp_assist_vector as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_viridian_vcpu_context),
            "::",
            stringify!(vp_assist_vector)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_viridian_vcpu_context>()))._pad as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_viridian_vcpu_context),
            "::",
            stringify!(_pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_VIRIDIAN_VCPU {
    pub t: hvm_viridian_vcpu_context,
    pub c: [::std::os::raw::c_char; 17usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_VIRIDIAN_VCPU() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_VIRIDIAN_VCPU>(),
        40usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_VIRIDIAN_VCPU))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_VIRIDIAN_VCPU>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_VIRIDIAN_VCPU))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VIRIDIAN_VCPU>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VIRIDIAN_VCPU),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VIRIDIAN_VCPU>())).c as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VIRIDIAN_VCPU),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VIRIDIAN_VCPU>())).cpt as *const _ as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VIRIDIAN_VCPU),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_vmce_vcpu {
    pub caps: u64,
    pub mci_ctl2_bank0: u64,
    pub mci_ctl2_bank1: u64,
    pub mcg_ext_ctl: u64,
}
#[test]
fn bindgen_test_layout_hvm_vmce_vcpu() {
    assert_eq!(
        ::std::mem::size_of::<hvm_vmce_vcpu>(),
        32usize,
        concat!("Size of: ", stringify!(hvm_vmce_vcpu))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_vmce_vcpu>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_vmce_vcpu))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_vmce_vcpu>())).caps as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_vmce_vcpu),
            "::",
            stringify!(caps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_vmce_vcpu>())).mci_ctl2_bank0 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_vmce_vcpu),
            "::",
            stringify!(mci_ctl2_bank0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_vmce_vcpu>())).mci_ctl2_bank1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_vmce_vcpu),
            "::",
            stringify!(mci_ctl2_bank1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_vmce_vcpu>())).mcg_ext_ctl as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_vmce_vcpu),
            "::",
            stringify!(mcg_ext_ctl)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_VMCE_VCPU {
    pub t: hvm_vmce_vcpu,
    pub c: [::std::os::raw::c_char; 18usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_VMCE_VCPU() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_VMCE_VCPU>(),
        56usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_VMCE_VCPU))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_VMCE_VCPU>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_VMCE_VCPU))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VMCE_VCPU>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VMCE_VCPU),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VMCE_VCPU>())).c as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VMCE_VCPU),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_VMCE_VCPU>())).cpt as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_VMCE_VCPU),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_tsc_adjust {
    pub tsc_adjust: u64,
}
#[test]
fn bindgen_test_layout_hvm_tsc_adjust() {
    assert_eq!(
        ::std::mem::size_of::<hvm_tsc_adjust>(),
        8usize,
        concat!("Size of: ", stringify!(hvm_tsc_adjust))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_tsc_adjust>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_tsc_adjust))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_tsc_adjust>())).tsc_adjust as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_tsc_adjust),
            "::",
            stringify!(tsc_adjust)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __HVM_SAVE_TYPE_TSC_ADJUST {
    pub t: hvm_tsc_adjust,
    pub c: [::std::os::raw::c_char; 19usize],
    pub cpt: [::std::os::raw::c_char; 1usize],
}
#[test]
fn bindgen_test_layout___HVM_SAVE_TYPE_TSC_ADJUST() {
    assert_eq!(
        ::std::mem::size_of::<__HVM_SAVE_TYPE_TSC_ADJUST>(),
        32usize,
        concat!("Size of: ", stringify!(__HVM_SAVE_TYPE_TSC_ADJUST))
    );
    assert_eq!(
        ::std::mem::align_of::<__HVM_SAVE_TYPE_TSC_ADJUST>(),
        8usize,
        concat!("Alignment of ", stringify!(__HVM_SAVE_TYPE_TSC_ADJUST))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_TSC_ADJUST>())).t as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_TSC_ADJUST),
            "::",
            stringify!(t)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_TSC_ADJUST>())).c as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_TSC_ADJUST),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__HVM_SAVE_TYPE_TSC_ADJUST>())).cpt as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(__HVM_SAVE_TYPE_TSC_ADJUST),
            "::",
            stringify!(cpt)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct hvm_msr {
    pub count: u32,
    pub msr: __IncompleteArrayField<hvm_msr_hvm_one_msr>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hvm_msr_hvm_one_msr {
    pub index: u32,
    pub _rsvd: u32,
    pub val: u64,
}
#[test]
fn bindgen_test_layout_hvm_msr_hvm_one_msr() {
    assert_eq!(
        ::std::mem::size_of::<hvm_msr_hvm_one_msr>(),
        16usize,
        concat!("Size of: ", stringify!(hvm_msr_hvm_one_msr))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_msr_hvm_one_msr>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_msr_hvm_one_msr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_msr_hvm_one_msr>())).index as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_msr_hvm_one_msr),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_msr_hvm_one_msr>()))._rsvd as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_msr_hvm_one_msr),
            "::",
            stringify!(_rsvd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_msr_hvm_one_msr>())).val as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_msr_hvm_one_msr),
            "::",
            stringify!(val)
        )
    );
}
#[test]
fn bindgen_test_layout_hvm_msr() {
    assert_eq!(
        ::std::mem::size_of::<hvm_msr>(),
        8usize,
        concat!("Size of: ", stringify!(hvm_msr))
    );
    assert_eq!(
        ::std::mem::align_of::<hvm_msr>(),
        8usize,
        concat!("Alignment of ", stringify!(hvm_msr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_msr>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_msr),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hvm_msr>())).msr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hvm_msr),
            "::",
            stringify!(msr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_eoi {
    pub irq: u32,
}
#[test]
fn bindgen_test_layout_physdev_eoi() {
    assert_eq!(
        ::std::mem::size_of::<physdev_eoi>(),
        4usize,
        concat!("Size of: ", stringify!(physdev_eoi))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_eoi>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_eoi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_eoi>())).irq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_eoi),
            "::",
            stringify!(irq)
        )
    );
}
pub type physdev_eoi_t = physdev_eoi;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_eoi_t {
    pub p: *mut physdev_eoi_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_eoi_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_eoi_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_eoi_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_eoi_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_physdev_eoi_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_physdev_eoi_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_eoi_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_eoi_t {
    pub p: *const physdev_eoi_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_eoi_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_eoi_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_physdev_eoi_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_eoi_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_eoi_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_eoi_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_eoi_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_pirq_eoi_gmfn {
    pub gmfn: xen_pfn_t,
}
#[test]
fn bindgen_test_layout_physdev_pirq_eoi_gmfn() {
    assert_eq!(
        ::std::mem::size_of::<physdev_pirq_eoi_gmfn>(),
        8usize,
        concat!("Size of: ", stringify!(physdev_pirq_eoi_gmfn))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_pirq_eoi_gmfn>(),
        8usize,
        concat!("Alignment of ", stringify!(physdev_pirq_eoi_gmfn))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pirq_eoi_gmfn>())).gmfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pirq_eoi_gmfn),
            "::",
            stringify!(gmfn)
        )
    );
}
pub type physdev_pirq_eoi_gmfn_t = physdev_pirq_eoi_gmfn;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_pirq_eoi_gmfn_t {
    pub p: *mut physdev_pirq_eoi_gmfn_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_pirq_eoi_gmfn_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_pirq_eoi_gmfn_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_physdev_pirq_eoi_gmfn_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_pirq_eoi_gmfn_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_pirq_eoi_gmfn_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_pirq_eoi_gmfn_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_pirq_eoi_gmfn_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_pirq_eoi_gmfn_t {
    pub p: *const physdev_pirq_eoi_gmfn_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_pirq_eoi_gmfn_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_pirq_eoi_gmfn_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_pirq_eoi_gmfn_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_pirq_eoi_gmfn_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_pirq_eoi_gmfn_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_pirq_eoi_gmfn_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_pirq_eoi_gmfn_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_irq_status_query {
    pub irq: u32,
    pub flags: u32,
}
#[test]
fn bindgen_test_layout_physdev_irq_status_query() {
    assert_eq!(
        ::std::mem::size_of::<physdev_irq_status_query>(),
        8usize,
        concat!("Size of: ", stringify!(physdev_irq_status_query))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_irq_status_query>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_irq_status_query))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_irq_status_query>())).irq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_irq_status_query),
            "::",
            stringify!(irq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_irq_status_query>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_irq_status_query),
            "::",
            stringify!(flags)
        )
    );
}
pub type physdev_irq_status_query_t = physdev_irq_status_query;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_irq_status_query_t {
    pub p: *mut physdev_irq_status_query_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_irq_status_query_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_irq_status_query_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_physdev_irq_status_query_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_irq_status_query_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_irq_status_query_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_irq_status_query_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_irq_status_query_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_irq_status_query_t {
    pub p: *const physdev_irq_status_query_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_irq_status_query_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_irq_status_query_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_irq_status_query_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_irq_status_query_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_irq_status_query_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_irq_status_query_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_irq_status_query_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_set_iopl {
    pub iopl: u32,
}
#[test]
fn bindgen_test_layout_physdev_set_iopl() {
    assert_eq!(
        ::std::mem::size_of::<physdev_set_iopl>(),
        4usize,
        concat!("Size of: ", stringify!(physdev_set_iopl))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_set_iopl>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_set_iopl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_set_iopl>())).iopl as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_set_iopl),
            "::",
            stringify!(iopl)
        )
    );
}
pub type physdev_set_iopl_t = physdev_set_iopl;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_set_iopl_t {
    pub p: *mut physdev_set_iopl_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_set_iopl_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_set_iopl_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_set_iopl_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_set_iopl_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_set_iopl_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_set_iopl_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_set_iopl_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_set_iopl_t {
    pub p: *const physdev_set_iopl_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_set_iopl_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_set_iopl_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_set_iopl_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_set_iopl_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_set_iopl_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_set_iopl_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_set_iopl_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_set_iobitmap {
    pub bitmap: __guest_handle_uint8,
    pub nr_ports: u32,
}
#[test]
fn bindgen_test_layout_physdev_set_iobitmap() {
    assert_eq!(
        ::std::mem::size_of::<physdev_set_iobitmap>(),
        16usize,
        concat!("Size of: ", stringify!(physdev_set_iobitmap))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_set_iobitmap>(),
        8usize,
        concat!("Alignment of ", stringify!(physdev_set_iobitmap))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_set_iobitmap>())).bitmap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_set_iobitmap),
            "::",
            stringify!(bitmap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_set_iobitmap>())).nr_ports as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_set_iobitmap),
            "::",
            stringify!(nr_ports)
        )
    );
}
pub type physdev_set_iobitmap_t = physdev_set_iobitmap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_set_iobitmap_t {
    pub p: *mut physdev_set_iobitmap_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_set_iobitmap_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_set_iobitmap_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_physdev_set_iobitmap_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_set_iobitmap_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_set_iobitmap_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_set_iobitmap_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_set_iobitmap_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_set_iobitmap_t {
    pub p: *const physdev_set_iobitmap_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_set_iobitmap_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_set_iobitmap_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_set_iobitmap_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_set_iobitmap_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_set_iobitmap_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_set_iobitmap_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_set_iobitmap_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_apic {
    pub apic_physbase: ::std::os::raw::c_ulong,
    pub reg: u32,
    pub value: u32,
}
#[test]
fn bindgen_test_layout_physdev_apic() {
    assert_eq!(
        ::std::mem::size_of::<physdev_apic>(),
        16usize,
        concat!("Size of: ", stringify!(physdev_apic))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_apic>(),
        8usize,
        concat!("Alignment of ", stringify!(physdev_apic))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_apic>())).apic_physbase as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_apic),
            "::",
            stringify!(apic_physbase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_apic>())).reg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_apic),
            "::",
            stringify!(reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_apic>())).value as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_apic),
            "::",
            stringify!(value)
        )
    );
}
pub type physdev_apic_t = physdev_apic;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_apic_t {
    pub p: *mut physdev_apic_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_apic_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_apic_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_apic_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_apic_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_physdev_apic_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_physdev_apic_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_apic_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_apic_t {
    pub p: *const physdev_apic_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_apic_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_apic_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_physdev_apic_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_apic_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_apic_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_apic_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_apic_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_irq {
    pub irq: u32,
    pub vector: u32,
}
#[test]
fn bindgen_test_layout_physdev_irq() {
    assert_eq!(
        ::std::mem::size_of::<physdev_irq>(),
        8usize,
        concat!("Size of: ", stringify!(physdev_irq))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_irq>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_irq))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_irq>())).irq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_irq),
            "::",
            stringify!(irq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_irq>())).vector as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_irq),
            "::",
            stringify!(vector)
        )
    );
}
pub type physdev_irq_t = physdev_irq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_irq_t {
    pub p: *mut physdev_irq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_irq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_irq_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_irq_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_irq_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_physdev_irq_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_physdev_irq_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_irq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_irq_t {
    pub p: *const physdev_irq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_irq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_irq_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_physdev_irq_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_irq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_irq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_irq_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_irq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_map_pirq {
    pub domid: domid_t,
    pub type_: ::std::os::raw::c_int,
    pub index: ::std::os::raw::c_int,
    pub pirq: ::std::os::raw::c_int,
    pub bus: ::std::os::raw::c_int,
    pub devfn: ::std::os::raw::c_int,
    pub entry_nr: ::std::os::raw::c_int,
    pub table_base: u64,
}
#[test]
fn bindgen_test_layout_physdev_map_pirq() {
    assert_eq!(
        ::std::mem::size_of::<physdev_map_pirq>(),
        40usize,
        concat!("Size of: ", stringify!(physdev_map_pirq))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_map_pirq>(),
        8usize,
        concat!("Alignment of ", stringify!(physdev_map_pirq))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_map_pirq>())).domid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_map_pirq),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_map_pirq>())).type_ as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_map_pirq),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_map_pirq>())).index as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_map_pirq),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_map_pirq>())).pirq as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_map_pirq),
            "::",
            stringify!(pirq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_map_pirq>())).bus as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_map_pirq),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_map_pirq>())).devfn as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_map_pirq),
            "::",
            stringify!(devfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_map_pirq>())).entry_nr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_map_pirq),
            "::",
            stringify!(entry_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_map_pirq>())).table_base as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_map_pirq),
            "::",
            stringify!(table_base)
        )
    );
}
pub type physdev_map_pirq_t = physdev_map_pirq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_map_pirq_t {
    pub p: *mut physdev_map_pirq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_map_pirq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_map_pirq_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_map_pirq_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_map_pirq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_map_pirq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_map_pirq_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_map_pirq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_map_pirq_t {
    pub p: *const physdev_map_pirq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_map_pirq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_map_pirq_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_map_pirq_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_map_pirq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_map_pirq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_map_pirq_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_map_pirq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_unmap_pirq {
    pub domid: domid_t,
    pub pirq: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_physdev_unmap_pirq() {
    assert_eq!(
        ::std::mem::size_of::<physdev_unmap_pirq>(),
        8usize,
        concat!("Size of: ", stringify!(physdev_unmap_pirq))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_unmap_pirq>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_unmap_pirq))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_unmap_pirq>())).domid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_unmap_pirq),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_unmap_pirq>())).pirq as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_unmap_pirq),
            "::",
            stringify!(pirq)
        )
    );
}
pub type physdev_unmap_pirq_t = physdev_unmap_pirq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_unmap_pirq_t {
    pub p: *mut physdev_unmap_pirq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_unmap_pirq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_unmap_pirq_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_unmap_pirq_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_unmap_pirq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_unmap_pirq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_unmap_pirq_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_unmap_pirq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_unmap_pirq_t {
    pub p: *const physdev_unmap_pirq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_unmap_pirq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_unmap_pirq_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_unmap_pirq_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_unmap_pirq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_unmap_pirq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_unmap_pirq_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_unmap_pirq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_manage_pci {
    pub bus: u8,
    pub devfn: u8,
}
#[test]
fn bindgen_test_layout_physdev_manage_pci() {
    assert_eq!(
        ::std::mem::size_of::<physdev_manage_pci>(),
        2usize,
        concat!("Size of: ", stringify!(physdev_manage_pci))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_manage_pci>(),
        1usize,
        concat!("Alignment of ", stringify!(physdev_manage_pci))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_manage_pci>())).bus as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_manage_pci>())).devfn as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci),
            "::",
            stringify!(devfn)
        )
    );
}
pub type physdev_manage_pci_t = physdev_manage_pci;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_manage_pci_t {
    pub p: *mut physdev_manage_pci_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_manage_pci_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_manage_pci_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_manage_pci_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_manage_pci_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_manage_pci_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_manage_pci_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_manage_pci_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_manage_pci_t {
    pub p: *const physdev_manage_pci_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_manage_pci_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_manage_pci_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_manage_pci_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_manage_pci_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_manage_pci_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_manage_pci_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_manage_pci_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_restore_msi {
    pub bus: u8,
    pub devfn: u8,
}
#[test]
fn bindgen_test_layout_physdev_restore_msi() {
    assert_eq!(
        ::std::mem::size_of::<physdev_restore_msi>(),
        2usize,
        concat!("Size of: ", stringify!(physdev_restore_msi))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_restore_msi>(),
        1usize,
        concat!("Alignment of ", stringify!(physdev_restore_msi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_restore_msi>())).bus as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_restore_msi),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_restore_msi>())).devfn as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_restore_msi),
            "::",
            stringify!(devfn)
        )
    );
}
pub type physdev_restore_msi_t = physdev_restore_msi;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_restore_msi_t {
    pub p: *mut physdev_restore_msi_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_restore_msi_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_restore_msi_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_physdev_restore_msi_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_restore_msi_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_restore_msi_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_restore_msi_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_restore_msi_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_restore_msi_t {
    pub p: *const physdev_restore_msi_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_restore_msi_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_restore_msi_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_restore_msi_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_restore_msi_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_restore_msi_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_restore_msi_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_restore_msi_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_manage_pci_ext {
    pub bus: u8,
    pub devfn: u8,
    pub is_extfn: ::std::os::raw::c_uint,
    pub is_virtfn: ::std::os::raw::c_uint,
    pub physfn: physdev_manage_pci_ext__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_manage_pci_ext__bindgen_ty_1 {
    pub bus: u8,
    pub devfn: u8,
}
#[test]
fn bindgen_test_layout_physdev_manage_pci_ext__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<physdev_manage_pci_ext__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(physdev_manage_pci_ext__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_manage_pci_ext__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(physdev_manage_pci_ext__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_manage_pci_ext__bindgen_ty_1>())).bus as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci_ext__bindgen_ty_1),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_manage_pci_ext__bindgen_ty_1>())).devfn as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci_ext__bindgen_ty_1),
            "::",
            stringify!(devfn)
        )
    );
}
#[test]
fn bindgen_test_layout_physdev_manage_pci_ext() {
    assert_eq!(
        ::std::mem::size_of::<physdev_manage_pci_ext>(),
        16usize,
        concat!("Size of: ", stringify!(physdev_manage_pci_ext))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_manage_pci_ext>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_manage_pci_ext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_manage_pci_ext>())).bus as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci_ext),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_manage_pci_ext>())).devfn as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci_ext),
            "::",
            stringify!(devfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_manage_pci_ext>())).is_extfn as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci_ext),
            "::",
            stringify!(is_extfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_manage_pci_ext>())).is_virtfn as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci_ext),
            "::",
            stringify!(is_virtfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_manage_pci_ext>())).physfn as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_manage_pci_ext),
            "::",
            stringify!(physfn)
        )
    );
}
pub type physdev_manage_pci_ext_t = physdev_manage_pci_ext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_manage_pci_ext_t {
    pub p: *mut physdev_manage_pci_ext_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_manage_pci_ext_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_manage_pci_ext_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_physdev_manage_pci_ext_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_manage_pci_ext_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_manage_pci_ext_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_manage_pci_ext_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_manage_pci_ext_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_manage_pci_ext_t {
    pub p: *const physdev_manage_pci_ext_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_manage_pci_ext_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_manage_pci_ext_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_manage_pci_ext_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_manage_pci_ext_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_manage_pci_ext_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_manage_pci_ext_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_manage_pci_ext_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct physdev_op {
    pub cmd: u32,
    pub u: physdev_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union physdev_op__bindgen_ty_1 {
    pub irq_status_query: physdev_irq_status_query,
    pub set_iopl: physdev_set_iopl,
    pub set_iobitmap: physdev_set_iobitmap,
    pub apic_op: physdev_apic,
    pub irq_op: physdev_irq,
    _bindgen_union_align: [u64; 2usize],
}
#[test]
fn bindgen_test_layout_physdev_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<physdev_op__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(physdev_op__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_op__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(physdev_op__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_op__bindgen_ty_1>())).irq_status_query as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_op__bindgen_ty_1),
            "::",
            stringify!(irq_status_query)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_op__bindgen_ty_1>())).set_iopl as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_op__bindgen_ty_1),
            "::",
            stringify!(set_iopl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_op__bindgen_ty_1>())).set_iobitmap as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_op__bindgen_ty_1),
            "::",
            stringify!(set_iobitmap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_op__bindgen_ty_1>())).apic_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_op__bindgen_ty_1),
            "::",
            stringify!(apic_op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_op__bindgen_ty_1>())).irq_op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_op__bindgen_ty_1),
            "::",
            stringify!(irq_op)
        )
    );
}
#[test]
fn bindgen_test_layout_physdev_op() {
    assert_eq!(
        ::std::mem::size_of::<physdev_op>(),
        24usize,
        concat!("Size of: ", stringify!(physdev_op))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_op>(),
        8usize,
        concat!("Alignment of ", stringify!(physdev_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_op>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_op),
            "::",
            stringify!(u)
        )
    );
}
pub type physdev_op_t = physdev_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_op_t {
    pub p: *mut physdev_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_op_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_physdev_op_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_physdev_op_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_op_t {
    pub p: *const physdev_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_physdev_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_setup_gsi {
    pub gsi: ::std::os::raw::c_int,
    pub triggering: u8,
    pub polarity: u8,
}
#[test]
fn bindgen_test_layout_physdev_setup_gsi() {
    assert_eq!(
        ::std::mem::size_of::<physdev_setup_gsi>(),
        8usize,
        concat!("Size of: ", stringify!(physdev_setup_gsi))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_setup_gsi>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_setup_gsi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_setup_gsi>())).gsi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_setup_gsi),
            "::",
            stringify!(gsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_setup_gsi>())).triggering as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_setup_gsi),
            "::",
            stringify!(triggering)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_setup_gsi>())).polarity as *const _ as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_setup_gsi),
            "::",
            stringify!(polarity)
        )
    );
}
pub type physdev_setup_gsi_t = physdev_setup_gsi;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_setup_gsi_t {
    pub p: *mut physdev_setup_gsi_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_setup_gsi_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_setup_gsi_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_setup_gsi_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_setup_gsi_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_setup_gsi_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_setup_gsi_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_setup_gsi_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_setup_gsi_t {
    pub p: *const physdev_setup_gsi_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_setup_gsi_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_setup_gsi_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_setup_gsi_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_setup_gsi_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_setup_gsi_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_setup_gsi_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_setup_gsi_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_get_free_pirq {
    pub type_: ::std::os::raw::c_int,
    pub pirq: u32,
}
#[test]
fn bindgen_test_layout_physdev_get_free_pirq() {
    assert_eq!(
        ::std::mem::size_of::<physdev_get_free_pirq>(),
        8usize,
        concat!("Size of: ", stringify!(physdev_get_free_pirq))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_get_free_pirq>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_get_free_pirq))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_get_free_pirq>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_get_free_pirq),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_get_free_pirq>())).pirq as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_get_free_pirq),
            "::",
            stringify!(pirq)
        )
    );
}
pub type physdev_get_free_pirq_t = physdev_get_free_pirq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_get_free_pirq_t {
    pub p: *mut physdev_get_free_pirq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_get_free_pirq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_get_free_pirq_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_physdev_get_free_pirq_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_get_free_pirq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_get_free_pirq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_get_free_pirq_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_get_free_pirq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_get_free_pirq_t {
    pub p: *const physdev_get_free_pirq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_get_free_pirq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_get_free_pirq_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_get_free_pirq_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_get_free_pirq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_get_free_pirq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_get_free_pirq_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_get_free_pirq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_pci_mmcfg_reserved {
    pub address: u64,
    pub segment: u16,
    pub start_bus: u8,
    pub end_bus: u8,
    pub flags: u32,
}
#[test]
fn bindgen_test_layout_physdev_pci_mmcfg_reserved() {
    assert_eq!(
        ::std::mem::size_of::<physdev_pci_mmcfg_reserved>(),
        16usize,
        concat!("Size of: ", stringify!(physdev_pci_mmcfg_reserved))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_pci_mmcfg_reserved>(),
        8usize,
        concat!("Alignment of ", stringify!(physdev_pci_mmcfg_reserved))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_pci_mmcfg_reserved>())).address as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_mmcfg_reserved),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_pci_mmcfg_reserved>())).segment as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_mmcfg_reserved),
            "::",
            stringify!(segment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_pci_mmcfg_reserved>())).start_bus as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_mmcfg_reserved),
            "::",
            stringify!(start_bus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_pci_mmcfg_reserved>())).end_bus as *const _ as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_mmcfg_reserved),
            "::",
            stringify!(end_bus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_pci_mmcfg_reserved>())).flags as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_mmcfg_reserved),
            "::",
            stringify!(flags)
        )
    );
}
pub type physdev_pci_mmcfg_reserved_t = physdev_pci_mmcfg_reserved;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_pci_mmcfg_reserved_t {
    pub p: *mut physdev_pci_mmcfg_reserved_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_pci_mmcfg_reserved_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_pci_mmcfg_reserved_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_physdev_pci_mmcfg_reserved_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_pci_mmcfg_reserved_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_pci_mmcfg_reserved_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_pci_mmcfg_reserved_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_pci_mmcfg_reserved_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_pci_mmcfg_reserved_t {
    pub p: *const physdev_pci_mmcfg_reserved_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_pci_mmcfg_reserved_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_pci_mmcfg_reserved_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_pci_mmcfg_reserved_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_pci_mmcfg_reserved_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_pci_mmcfg_reserved_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_pci_mmcfg_reserved_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_pci_mmcfg_reserved_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct physdev_pci_device_add {
    pub seg: u16,
    pub bus: u8,
    pub devfn: u8,
    pub flags: u32,
    pub physfn: physdev_pci_device_add__bindgen_ty_1,
    pub optarr: __IncompleteArrayField<u32>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_pci_device_add__bindgen_ty_1 {
    pub bus: u8,
    pub devfn: u8,
}
#[test]
fn bindgen_test_layout_physdev_pci_device_add__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<physdev_pci_device_add__bindgen_ty_1>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(physdev_pci_device_add__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_pci_device_add__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(physdev_pci_device_add__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_pci_device_add__bindgen_ty_1>())).bus as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device_add__bindgen_ty_1),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_pci_device_add__bindgen_ty_1>())).devfn as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device_add__bindgen_ty_1),
            "::",
            stringify!(devfn)
        )
    );
}
#[test]
fn bindgen_test_layout_physdev_pci_device_add() {
    assert_eq!(
        ::std::mem::size_of::<physdev_pci_device_add>(),
        12usize,
        concat!("Size of: ", stringify!(physdev_pci_device_add))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_pci_device_add>(),
        4usize,
        concat!("Alignment of ", stringify!(physdev_pci_device_add))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device_add>())).seg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device_add),
            "::",
            stringify!(seg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device_add>())).bus as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device_add),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device_add>())).devfn as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device_add),
            "::",
            stringify!(devfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device_add>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device_add),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device_add>())).physfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device_add),
            "::",
            stringify!(physfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device_add>())).optarr as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device_add),
            "::",
            stringify!(optarr)
        )
    );
}
pub type physdev_pci_device_add_t = physdev_pci_device_add;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_pci_device_add_t {
    pub p: *mut physdev_pci_device_add_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_pci_device_add_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_pci_device_add_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_physdev_pci_device_add_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_pci_device_add_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_pci_device_add_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_pci_device_add_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_pci_device_add_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_pci_device_add_t {
    pub p: *const physdev_pci_device_add_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_pci_device_add_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_pci_device_add_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_pci_device_add_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_pci_device_add_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_pci_device_add_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_pci_device_add_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_pci_device_add_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct physdev_pci_device {
    pub seg: u16,
    pub bus: u8,
    pub devfn: u8,
}
#[test]
fn bindgen_test_layout_physdev_pci_device() {
    assert_eq!(
        ::std::mem::size_of::<physdev_pci_device>(),
        4usize,
        concat!("Size of: ", stringify!(physdev_pci_device))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_pci_device>(),
        2usize,
        concat!("Alignment of ", stringify!(physdev_pci_device))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device>())).seg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device),
            "::",
            stringify!(seg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device>())).bus as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_pci_device>())).devfn as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_pci_device),
            "::",
            stringify!(devfn)
        )
    );
}
pub type physdev_pci_device_t = physdev_pci_device;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_pci_device_t {
    pub p: *mut physdev_pci_device_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_pci_device_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_pci_device_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_pci_device_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_pci_device_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_pci_device_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_pci_device_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_pci_device_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_pci_device_t {
    pub p: *const physdev_pci_device_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_pci_device_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_pci_device_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_pci_device_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_pci_device_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_pci_device_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_pci_device_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_pci_device_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct physdev_dbgp_op {
    pub op: u8,
    pub bus: u8,
    pub u: physdev_dbgp_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union physdev_dbgp_op__bindgen_ty_1 {
    pub pci: physdev_pci_device,
    _bindgen_union_align: [u16; 2usize],
}
#[test]
fn bindgen_test_layout_physdev_dbgp_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<physdev_dbgp_op__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(physdev_dbgp_op__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_dbgp_op__bindgen_ty_1>(),
        2usize,
        concat!("Alignment of ", stringify!(physdev_dbgp_op__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<physdev_dbgp_op__bindgen_ty_1>())).pci as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_dbgp_op__bindgen_ty_1),
            "::",
            stringify!(pci)
        )
    );
}
#[test]
fn bindgen_test_layout_physdev_dbgp_op() {
    assert_eq!(
        ::std::mem::size_of::<physdev_dbgp_op>(),
        6usize,
        concat!("Size of: ", stringify!(physdev_dbgp_op))
    );
    assert_eq!(
        ::std::mem::align_of::<physdev_dbgp_op>(),
        2usize,
        concat!("Alignment of ", stringify!(physdev_dbgp_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_dbgp_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_dbgp_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_dbgp_op>())).bus as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_dbgp_op),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<physdev_dbgp_op>())).u as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(physdev_dbgp_op),
            "::",
            stringify!(u)
        )
    );
}
pub type physdev_dbgp_op_t = physdev_dbgp_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_physdev_dbgp_op_t {
    pub p: *mut physdev_dbgp_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_physdev_dbgp_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_physdev_dbgp_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_physdev_dbgp_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_physdev_dbgp_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_physdev_dbgp_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_physdev_dbgp_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_physdev_dbgp_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_physdev_dbgp_op_t {
    pub p: *const physdev_dbgp_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_physdev_dbgp_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_physdev_dbgp_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_physdev_dbgp_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_physdev_dbgp_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_physdev_dbgp_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_physdev_dbgp_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_physdev_dbgp_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_memory_reservation {
    pub extent_start: __guest_handle_xen_pfn_t,
    pub nr_extents: xen_ulong_t,
    pub extent_order: ::std::os::raw::c_uint,
    pub mem_flags: ::std::os::raw::c_uint,
    pub domid: domid_t,
}
#[test]
fn bindgen_test_layout_xen_memory_reservation() {
    assert_eq!(
        ::std::mem::size_of::<xen_memory_reservation>(),
        32usize,
        concat!("Size of: ", stringify!(xen_memory_reservation))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_memory_reservation>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_memory_reservation))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_memory_reservation>())).extent_start as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_reservation),
            "::",
            stringify!(extent_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_memory_reservation>())).nr_extents as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_reservation),
            "::",
            stringify!(nr_extents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_memory_reservation>())).extent_order as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_reservation),
            "::",
            stringify!(extent_order)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_memory_reservation>())).mem_flags as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_reservation),
            "::",
            stringify!(mem_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_memory_reservation>())).domid as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_reservation),
            "::",
            stringify!(domid)
        )
    );
}
pub type xen_memory_reservation_t = xen_memory_reservation;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_memory_reservation_t {
    pub p: *mut xen_memory_reservation_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_memory_reservation_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_memory_reservation_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_memory_reservation_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_memory_reservation_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_memory_reservation_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_memory_reservation_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_memory_reservation_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_memory_reservation_t {
    pub p: *const xen_memory_reservation_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_memory_reservation_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_memory_reservation_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_memory_reservation_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_memory_reservation_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_memory_reservation_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_memory_reservation_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_memory_reservation_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_memory_exchange {
    pub in_: xen_memory_reservation,
    pub out: xen_memory_reservation,
    pub nr_exchanged: xen_ulong_t,
}
#[test]
fn bindgen_test_layout_xen_memory_exchange() {
    assert_eq!(
        ::std::mem::size_of::<xen_memory_exchange>(),
        72usize,
        concat!("Size of: ", stringify!(xen_memory_exchange))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_memory_exchange>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_memory_exchange))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_memory_exchange>())).in_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_exchange),
            "::",
            stringify!(in_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_memory_exchange>())).out as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_exchange),
            "::",
            stringify!(out)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_memory_exchange>())).nr_exchanged as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_exchange),
            "::",
            stringify!(nr_exchanged)
        )
    );
}
pub type xen_memory_exchange_t = xen_memory_exchange;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_memory_exchange_t {
    pub p: *mut xen_memory_exchange_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_memory_exchange_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_memory_exchange_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_memory_exchange_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_memory_exchange_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_memory_exchange_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_memory_exchange_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_memory_exchange_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_memory_exchange_t {
    pub p: *const xen_memory_exchange_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_memory_exchange_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_memory_exchange_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_memory_exchange_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_memory_exchange_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_memory_exchange_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_memory_exchange_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_memory_exchange_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_machphys_mfn_list {
    pub max_extents: ::std::os::raw::c_uint,
    pub extent_start: __guest_handle_xen_pfn_t,
    pub nr_extents: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_xen_machphys_mfn_list() {
    assert_eq!(
        ::std::mem::size_of::<xen_machphys_mfn_list>(),
        24usize,
        concat!("Size of: ", stringify!(xen_machphys_mfn_list))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_machphys_mfn_list>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_machphys_mfn_list))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_machphys_mfn_list>())).max_extents as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_machphys_mfn_list),
            "::",
            stringify!(max_extents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_machphys_mfn_list>())).extent_start as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_machphys_mfn_list),
            "::",
            stringify!(extent_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_machphys_mfn_list>())).nr_extents as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_machphys_mfn_list),
            "::",
            stringify!(nr_extents)
        )
    );
}
pub type xen_machphys_mfn_list_t = xen_machphys_mfn_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_machphys_mfn_list_t {
    pub p: *mut xen_machphys_mfn_list_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_machphys_mfn_list_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_machphys_mfn_list_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_machphys_mfn_list_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_machphys_mfn_list_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_machphys_mfn_list_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_machphys_mfn_list_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_machphys_mfn_list_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_machphys_mfn_list_t {
    pub p: *const xen_machphys_mfn_list_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_machphys_mfn_list_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_machphys_mfn_list_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_machphys_mfn_list_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_machphys_mfn_list_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_machphys_mfn_list_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_machphys_mfn_list_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_machphys_mfn_list_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_machphys_mapping {
    pub v_start: xen_ulong_t,
    pub v_end: xen_ulong_t,
    pub max_mfn: xen_ulong_t,
}
#[test]
fn bindgen_test_layout_xen_machphys_mapping() {
    assert_eq!(
        ::std::mem::size_of::<xen_machphys_mapping>(),
        24usize,
        concat!("Size of: ", stringify!(xen_machphys_mapping))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_machphys_mapping>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_machphys_mapping))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_machphys_mapping>())).v_start as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_machphys_mapping),
            "::",
            stringify!(v_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_machphys_mapping>())).v_end as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_machphys_mapping),
            "::",
            stringify!(v_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_machphys_mapping>())).max_mfn as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_machphys_mapping),
            "::",
            stringify!(max_mfn)
        )
    );
}
pub type xen_machphys_mapping_t = xen_machphys_mapping;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_machphys_mapping_t {
    pub p: *mut xen_machphys_mapping_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_machphys_mapping_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_machphys_mapping_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_machphys_mapping_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_machphys_mapping_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_machphys_mapping_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_machphys_mapping_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_machphys_mapping_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_machphys_mapping_t {
    pub p: *const xen_machphys_mapping_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_machphys_mapping_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_machphys_mapping_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_machphys_mapping_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_machphys_mapping_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_machphys_mapping_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_machphys_mapping_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_machphys_mapping_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_add_to_physmap {
    pub domid: domid_t,
    pub size: u16,
    pub space: ::std::os::raw::c_uint,
    pub idx: xen_ulong_t,
    pub gpfn: xen_pfn_t,
}
#[test]
fn bindgen_test_layout_xen_add_to_physmap() {
    assert_eq!(
        ::std::mem::size_of::<xen_add_to_physmap>(),
        24usize,
        concat!("Size of: ", stringify!(xen_add_to_physmap))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_add_to_physmap>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_add_to_physmap))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap>())).domid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap>())).size as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap>())).space as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap),
            "::",
            stringify!(space)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap>())).idx as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap>())).gpfn as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap),
            "::",
            stringify!(gpfn)
        )
    );
}
pub type xen_add_to_physmap_t = xen_add_to_physmap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_add_to_physmap_t {
    pub p: *mut xen_add_to_physmap_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_add_to_physmap_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_add_to_physmap_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_add_to_physmap_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_add_to_physmap_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_add_to_physmap_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_add_to_physmap_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_add_to_physmap_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_add_to_physmap_t {
    pub p: *const xen_add_to_physmap_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_add_to_physmap_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_add_to_physmap_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_add_to_physmap_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_add_to_physmap_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_add_to_physmap_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_add_to_physmap_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_add_to_physmap_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_add_to_physmap_batch {
    pub domid: domid_t,
    pub space: u16,
    pub size: u16,
    pub u: xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra,
    pub idxs: __guest_handle_xen_ulong_t,
    pub gpfns: __guest_handle_xen_pfn_t,
    pub errs: __guest_handle_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra {
    pub foreign_domid: domid_t,
    pub res0: u16,
    _bindgen_union_align: u16,
}
#[test]
fn bindgen_test_layout_xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra() {
    assert_eq!(
        ::std::mem::size_of::<xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra>()))
                .foreign_domid as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra),
            "::",
            stringify!(foreign_domid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra>())).res0
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch_xen_add_to_physmap_batch_extra),
            "::",
            stringify!(res0)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_add_to_physmap_batch() {
    assert_eq!(
        ::std::mem::size_of::<xen_add_to_physmap_batch>(),
        32usize,
        concat!("Size of: ", stringify!(xen_add_to_physmap_batch))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_add_to_physmap_batch>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_add_to_physmap_batch))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap_batch>())).domid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap_batch>())).space as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch),
            "::",
            stringify!(space)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap_batch>())).size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap_batch>())).u as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap_batch>())).idxs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch),
            "::",
            stringify!(idxs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap_batch>())).gpfns as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch),
            "::",
            stringify!(gpfns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_add_to_physmap_batch>())).errs as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_add_to_physmap_batch),
            "::",
            stringify!(errs)
        )
    );
}
pub type xen_add_to_physmap_batch_t = xen_add_to_physmap_batch;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_add_to_physmap_batch_t {
    pub p: *mut xen_add_to_physmap_batch_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_add_to_physmap_batch_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_add_to_physmap_batch_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_add_to_physmap_batch_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_add_to_physmap_batch_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_add_to_physmap_batch_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_add_to_physmap_batch_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_add_to_physmap_batch_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_add_to_physmap_batch_t {
    pub p: *const xen_add_to_physmap_batch_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_add_to_physmap_batch_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_add_to_physmap_batch_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_add_to_physmap_batch_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_add_to_physmap_batch_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_add_to_physmap_batch_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_add_to_physmap_batch_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_add_to_physmap_batch_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_remove_from_physmap {
    pub domid: domid_t,
    pub gpfn: xen_pfn_t,
}
#[test]
fn bindgen_test_layout_xen_remove_from_physmap() {
    assert_eq!(
        ::std::mem::size_of::<xen_remove_from_physmap>(),
        16usize,
        concat!("Size of: ", stringify!(xen_remove_from_physmap))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_remove_from_physmap>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_remove_from_physmap))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_remove_from_physmap>())).domid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_remove_from_physmap),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_remove_from_physmap>())).gpfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_remove_from_physmap),
            "::",
            stringify!(gpfn)
        )
    );
}
pub type xen_remove_from_physmap_t = xen_remove_from_physmap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_remove_from_physmap_t {
    pub p: *mut xen_remove_from_physmap_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_remove_from_physmap_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_remove_from_physmap_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_remove_from_physmap_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_remove_from_physmap_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_remove_from_physmap_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_remove_from_physmap_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_remove_from_physmap_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_remove_from_physmap_t {
    pub p: *const xen_remove_from_physmap_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_remove_from_physmap_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_remove_from_physmap_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_remove_from_physmap_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_remove_from_physmap_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_remove_from_physmap_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_remove_from_physmap_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_remove_from_physmap_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_memory_map {
    pub nr_entries: ::std::os::raw::c_uint,
    pub buffer: __guest_handle_void,
}
#[test]
fn bindgen_test_layout_xen_memory_map() {
    assert_eq!(
        ::std::mem::size_of::<xen_memory_map>(),
        16usize,
        concat!("Size of: ", stringify!(xen_memory_map))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_memory_map>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_memory_map))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_memory_map>())).nr_entries as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_map),
            "::",
            stringify!(nr_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_memory_map>())).buffer as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_memory_map),
            "::",
            stringify!(buffer)
        )
    );
}
pub type xen_memory_map_t = xen_memory_map;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_memory_map_t {
    pub p: *mut xen_memory_map_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_memory_map_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_memory_map_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_memory_map_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_memory_map_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_xen_memory_map_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_memory_map_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_memory_map_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_memory_map_t {
    pub p: *const xen_memory_map_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_memory_map_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_memory_map_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_memory_map_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_memory_map_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_memory_map_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_memory_map_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_memory_map_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_foreign_memory_map {
    pub domid: domid_t,
    pub map: xen_memory_map,
}
#[test]
fn bindgen_test_layout_xen_foreign_memory_map() {
    assert_eq!(
        ::std::mem::size_of::<xen_foreign_memory_map>(),
        24usize,
        concat!("Size of: ", stringify!(xen_foreign_memory_map))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_foreign_memory_map>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_foreign_memory_map))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_foreign_memory_map>())).domid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_foreign_memory_map),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_foreign_memory_map>())).map as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_foreign_memory_map),
            "::",
            stringify!(map)
        )
    );
}
pub type xen_foreign_memory_map_t = xen_foreign_memory_map;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_foreign_memory_map_t {
    pub p: *mut xen_foreign_memory_map_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_foreign_memory_map_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_foreign_memory_map_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_foreign_memory_map_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_foreign_memory_map_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_foreign_memory_map_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_foreign_memory_map_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_foreign_memory_map_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_foreign_memory_map_t {
    pub p: *const xen_foreign_memory_map_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_foreign_memory_map_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_foreign_memory_map_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_foreign_memory_map_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_foreign_memory_map_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_foreign_memory_map_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_foreign_memory_map_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_foreign_memory_map_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_pod_target {
    pub target_pages: u64,
    pub tot_pages: u64,
    pub pod_cache_pages: u64,
    pub pod_entries: u64,
    pub domid: domid_t,
}
#[test]
fn bindgen_test_layout_xen_pod_target() {
    assert_eq!(
        ::std::mem::size_of::<xen_pod_target>(),
        40usize,
        concat!("Size of: ", stringify!(xen_pod_target))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_pod_target>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_pod_target))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_pod_target>())).target_pages as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_pod_target),
            "::",
            stringify!(target_pages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_pod_target>())).tot_pages as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_pod_target),
            "::",
            stringify!(tot_pages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_pod_target>())).pod_cache_pages as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_pod_target),
            "::",
            stringify!(pod_cache_pages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_pod_target>())).pod_entries as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_pod_target),
            "::",
            stringify!(pod_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_pod_target>())).domid as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_pod_target),
            "::",
            stringify!(domid)
        )
    );
}
pub type xen_pod_target_t = xen_pod_target;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_mem_paging_op {
    pub op: u8,
    pub domain: domid_t,
    pub buffer: u64,
    pub gfn: u64,
}
#[test]
fn bindgen_test_layout_xen_mem_paging_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_paging_op>(),
        24usize,
        concat!("Size of: ", stringify!(xen_mem_paging_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_paging_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_mem_paging_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_paging_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_paging_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_paging_op>())).domain as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_paging_op),
            "::",
            stringify!(domain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_paging_op>())).buffer as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_paging_op),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_paging_op>())).gfn as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_paging_op),
            "::",
            stringify!(gfn)
        )
    );
}
pub type xen_mem_paging_op_t = xen_mem_paging_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_mem_paging_op_t {
    pub p: *mut xen_mem_paging_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_mem_paging_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_mem_paging_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_mem_paging_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_mem_paging_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_mem_paging_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_mem_paging_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_mem_paging_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_mem_paging_op_t {
    pub p: *const xen_mem_paging_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_mem_paging_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_mem_paging_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_mem_paging_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_mem_paging_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_mem_paging_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_mem_paging_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_mem_paging_op_t),
            "::",
            stringify!(p)
        )
    );
}
pub const xenmem_access_t_XENMEM_access_n: xenmem_access_t = 0;
pub const xenmem_access_t_XENMEM_access_r: xenmem_access_t = 1;
pub const xenmem_access_t_XENMEM_access_w: xenmem_access_t = 2;
pub const xenmem_access_t_XENMEM_access_rw: xenmem_access_t = 3;
pub const xenmem_access_t_XENMEM_access_x: xenmem_access_t = 4;
pub const xenmem_access_t_XENMEM_access_rx: xenmem_access_t = 5;
pub const xenmem_access_t_XENMEM_access_wx: xenmem_access_t = 6;
pub const xenmem_access_t_XENMEM_access_rwx: xenmem_access_t = 7;
pub const xenmem_access_t_XENMEM_access_rx2rw: xenmem_access_t = 8;
pub const xenmem_access_t_XENMEM_access_n2rwx: xenmem_access_t = 9;
pub const xenmem_access_t_XENMEM_access_default: xenmem_access_t = 10;
pub type xenmem_access_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_mem_access_op {
    pub op: u8,
    pub access: u8,
    pub domid: domid_t,
    pub nr: u32,
    pub pfn: u64,
    pub pfn_list: __guest_handle_const_uint64,
    pub access_list: __guest_handle_const_uint8,
}
#[test]
fn bindgen_test_layout_xen_mem_access_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_access_op>(),
        32usize,
        concat!("Size of: ", stringify!(xen_mem_access_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_access_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_mem_access_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_access_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_access_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_access_op>())).access as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_access_op),
            "::",
            stringify!(access)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_access_op>())).domid as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_access_op),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_access_op>())).nr as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_access_op),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_access_op>())).pfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_access_op),
            "::",
            stringify!(pfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_access_op>())).pfn_list as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_access_op),
            "::",
            stringify!(pfn_list)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_access_op>())).access_list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_access_op),
            "::",
            stringify!(access_list)
        )
    );
}
pub type xen_mem_access_op_t = xen_mem_access_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_mem_access_op_t {
    pub p: *mut xen_mem_access_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_mem_access_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_mem_access_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_mem_access_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_mem_access_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_mem_access_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_mem_access_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_mem_access_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_mem_access_op_t {
    pub p: *const xen_mem_access_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_mem_access_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_mem_access_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_mem_access_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_mem_access_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_mem_access_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_mem_access_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_mem_access_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_mem_sharing_op {
    pub op: u8,
    pub domain: domid_t,
    pub u: xen_mem_sharing_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_mem_sharing_op__bindgen_ty_1 {
    pub nominate: xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate,
    pub share: xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share,
    pub range: xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range,
    pub debug: xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug,
    _bindgen_union_align: [u64; 5usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate {
    pub u: xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1,
    pub handle: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1 {
    pub gfn: u64,
    pub grant_ref: u32,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1>(
        ),
        8usize,
        concat!(
            "Size of: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<
            xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1,
        >(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1,
            >()))
            .gfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1),
            "::",
            stringify!(gfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1,
            >()))
            .grant_ref as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate__bindgen_ty_1),
            "::",
            stringify!(grant_ref)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate>())).u
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate>()))
                .handle as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_nominate),
            "::",
            stringify!(handle)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share {
    pub source_gfn: u64,
    pub source_handle: u64,
    pub client_gfn: u64,
    pub client_handle: u64,
    pub client_domain: domid_t,
}
#[test]
fn bindgen_test_layout_xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share>()))
                .source_gfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share),
            "::",
            stringify!(source_gfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share>()))
                .source_handle as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share),
            "::",
            stringify!(source_handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share>()))
                .client_gfn as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share),
            "::",
            stringify!(client_gfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share>()))
                .client_handle as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share),
            "::",
            stringify!(client_handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share>()))
                .client_domain as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_share),
            "::",
            stringify!(client_domain)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range {
    pub first_gfn: u64,
    pub last_gfn: u64,
    pub opaque: u64,
    pub client_domain: domid_t,
    pub _pad: [u16; 3usize],
}
#[test]
fn bindgen_test_layout_xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range>()))
                .first_gfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range),
            "::",
            stringify!(first_gfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range>()))
                .last_gfn as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range),
            "::",
            stringify!(last_gfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range>())).opaque
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range),
            "::",
            stringify!(opaque)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range>()))
                .client_domain as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range),
            "::",
            stringify!(client_domain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range>()))._pad
                as *const _ as usize
        },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_range),
            "::",
            stringify!(_pad)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug {
    pub u: xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1 {
    pub gfn: u64,
    pub mfn: u64,
    pub gref: u32,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1>(
        ),
        8usize,
        concat!(
            "Size of: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1>(
        ),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1,
            >()))
            .gfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1),
            "::",
            stringify!(gfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1,
            >()))
            .mfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1),
            "::",
            stringify!(mfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1,
            >()))
            .gref as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug__bindgen_ty_1),
            "::",
            stringify!(gref)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug>())).u
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1_mem_sharing_op_debug),
            "::",
            stringify!(u)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_mem_sharing_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_sharing_op__bindgen_ty_1>(),
        40usize,
        concat!("Size of: ", stringify!(xen_mem_sharing_op__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_sharing_op__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1>())).nominate as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1),
            "::",
            stringify!(nominate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1>())).share as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1),
            "::",
            stringify!(share)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1>())).range as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1),
            "::",
            stringify!(range)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_mem_sharing_op__bindgen_ty_1>())).debug as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op__bindgen_ty_1),
            "::",
            stringify!(debug)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_mem_sharing_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_mem_sharing_op>(),
        48usize,
        concat!("Size of: ", stringify!(xen_mem_sharing_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_mem_sharing_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_mem_sharing_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_sharing_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_sharing_op>())).domain as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op),
            "::",
            stringify!(domain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_mem_sharing_op>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_mem_sharing_op),
            "::",
            stringify!(u)
        )
    );
}
pub type xen_mem_sharing_op_t = xen_mem_sharing_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_mem_sharing_op_t {
    pub p: *mut xen_mem_sharing_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_mem_sharing_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_mem_sharing_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_mem_sharing_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_mem_sharing_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_mem_sharing_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_mem_sharing_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_mem_sharing_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_mem_sharing_op_t {
    pub p: *const xen_mem_sharing_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_mem_sharing_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_mem_sharing_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_mem_sharing_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_mem_sharing_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_mem_sharing_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_mem_sharing_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_mem_sharing_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_reserved_device_memory {
    pub start_pfn: xen_pfn_t,
    pub nr_pages: xen_ulong_t,
}
#[test]
fn bindgen_test_layout_xen_reserved_device_memory() {
    assert_eq!(
        ::std::mem::size_of::<xen_reserved_device_memory>(),
        16usize,
        concat!("Size of: ", stringify!(xen_reserved_device_memory))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_reserved_device_memory>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_reserved_device_memory))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_reserved_device_memory>())).start_pfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_reserved_device_memory),
            "::",
            stringify!(start_pfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_reserved_device_memory>())).nr_pages as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_reserved_device_memory),
            "::",
            stringify!(nr_pages)
        )
    );
}
pub type xen_reserved_device_memory_t = xen_reserved_device_memory;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_reserved_device_memory_t {
    pub p: *mut xen_reserved_device_memory_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_reserved_device_memory_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_reserved_device_memory_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_reserved_device_memory_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_reserved_device_memory_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_reserved_device_memory_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_reserved_device_memory_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_reserved_device_memory_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_reserved_device_memory_t {
    pub p: *const xen_reserved_device_memory_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_reserved_device_memory_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_reserved_device_memory_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_reserved_device_memory_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_reserved_device_memory_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_reserved_device_memory_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_reserved_device_memory_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_reserved_device_memory_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_reserved_device_memory_map {
    pub flags: u32,
    pub nr_entries: ::std::os::raw::c_uint,
    pub buffer: __guest_handle_xen_reserved_device_memory_t,
    pub dev: xen_reserved_device_memory_map__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_reserved_device_memory_map__bindgen_ty_1 {
    pub pci: physdev_pci_device,
    _bindgen_union_align: [u16; 2usize],
}
#[test]
fn bindgen_test_layout_xen_reserved_device_memory_map__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_reserved_device_memory_map__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(xen_reserved_device_memory_map__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_reserved_device_memory_map__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(xen_reserved_device_memory_map__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_reserved_device_memory_map__bindgen_ty_1>())).pci as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_reserved_device_memory_map__bindgen_ty_1),
            "::",
            stringify!(pci)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_reserved_device_memory_map() {
    assert_eq!(
        ::std::mem::size_of::<xen_reserved_device_memory_map>(),
        24usize,
        concat!("Size of: ", stringify!(xen_reserved_device_memory_map))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_reserved_device_memory_map>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_reserved_device_memory_map))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_reserved_device_memory_map>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_reserved_device_memory_map),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_reserved_device_memory_map>())).nr_entries as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_reserved_device_memory_map),
            "::",
            stringify!(nr_entries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_reserved_device_memory_map>())).buffer as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_reserved_device_memory_map),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_reserved_device_memory_map>())).dev as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_reserved_device_memory_map),
            "::",
            stringify!(dev)
        )
    );
}
pub type xen_reserved_device_memory_map_t = xen_reserved_device_memory_map;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_reserved_device_memory_map_t {
    pub p: *mut xen_reserved_device_memory_map_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_reserved_device_memory_map_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_reserved_device_memory_map_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_reserved_device_memory_map_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_reserved_device_memory_map_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_reserved_device_memory_map_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_reserved_device_memory_map_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_reserved_device_memory_map_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_reserved_device_memory_map_t {
    pub p: *const xen_reserved_device_memory_map_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_reserved_device_memory_map_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_reserved_device_memory_map_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_reserved_device_memory_map_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_reserved_device_memory_map_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_reserved_device_memory_map_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_reserved_device_memory_map_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_reserved_device_memory_map_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_vmemrange {
    pub start: u64,
    pub end: u64,
    pub flags: ::std::os::raw::c_uint,
    pub nid: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_xen_vmemrange() {
    assert_eq!(
        ::std::mem::size_of::<xen_vmemrange>(),
        24usize,
        concat!("Size of: ", stringify!(xen_vmemrange))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_vmemrange>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_vmemrange))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_vmemrange>())).start as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vmemrange),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_vmemrange>())).end as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vmemrange),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_vmemrange>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vmemrange),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_vmemrange>())).nid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vmemrange),
            "::",
            stringify!(nid)
        )
    );
}
pub type xen_vmemrange_t = xen_vmemrange;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_vmemrange_t {
    pub p: *mut xen_vmemrange_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_vmemrange_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_vmemrange_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_vmemrange_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_vmemrange_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_xen_vmemrange_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_vmemrange_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_vmemrange_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_vmemrange_t {
    pub p: *const xen_vmemrange_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_vmemrange_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_vmemrange_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_vmemrange_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_vmemrange_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_vmemrange_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_vmemrange_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_vmemrange_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_vnuma_topology_info {
    pub domid: domid_t,
    pub pad: u16,
    pub nr_vnodes: ::std::os::raw::c_uint,
    pub nr_vcpus: ::std::os::raw::c_uint,
    pub nr_vmemranges: ::std::os::raw::c_uint,
    pub vdistance: xen_vnuma_topology_info__bindgen_ty_1,
    pub vcpu_to_vnode: xen_vnuma_topology_info__bindgen_ty_2,
    pub vmemrange: xen_vnuma_topology_info__bindgen_ty_3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_vnuma_topology_info__bindgen_ty_1 {
    pub h: __guest_handle_uint,
    pub pad: u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_xen_vnuma_topology_info__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_vnuma_topology_info__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_vnuma_topology_info__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info__bindgen_ty_1>())).h as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_1),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info__bindgen_ty_1>())).pad as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_vnuma_topology_info__bindgen_ty_2 {
    pub h: __guest_handle_uint,
    pub pad: u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_xen_vnuma_topology_info__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<xen_vnuma_topology_info__bindgen_ty_2>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_vnuma_topology_info__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info__bindgen_ty_2>())).h as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_2),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info__bindgen_ty_2>())).pad as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_2),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_vnuma_topology_info__bindgen_ty_3 {
    pub h: __guest_handle_xen_vmemrange_t,
    pub pad: u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_xen_vnuma_topology_info__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<xen_vnuma_topology_info__bindgen_ty_3>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_vnuma_topology_info__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info__bindgen_ty_3>())).h as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_3),
            "::",
            stringify!(h)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info__bindgen_ty_3>())).pad as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info__bindgen_ty_3),
            "::",
            stringify!(pad)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_vnuma_topology_info() {
    assert_eq!(
        ::std::mem::size_of::<xen_vnuma_topology_info>(),
        40usize,
        concat!("Size of: ", stringify!(xen_vnuma_topology_info))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_vnuma_topology_info>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_vnuma_topology_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_vnuma_topology_info>())).domid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_vnuma_topology_info>())).pad as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info>())).nr_vnodes as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info),
            "::",
            stringify!(nr_vnodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info>())).nr_vcpus as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info),
            "::",
            stringify!(nr_vcpus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info>())).nr_vmemranges as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info),
            "::",
            stringify!(nr_vmemranges)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info>())).vdistance as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info),
            "::",
            stringify!(vdistance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info>())).vcpu_to_vnode as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info),
            "::",
            stringify!(vcpu_to_vnode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_vnuma_topology_info>())).vmemrange as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_vnuma_topology_info),
            "::",
            stringify!(vmemrange)
        )
    );
}
pub type xen_vnuma_topology_info_t = xen_vnuma_topology_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_vnuma_topology_info_t {
    pub p: *mut xen_vnuma_topology_info_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_vnuma_topology_info_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_vnuma_topology_info_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_vnuma_topology_info_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_vnuma_topology_info_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_vnuma_topology_info_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_vnuma_topology_info_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_vnuma_topology_info_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_vnuma_topology_info_t {
    pub p: *const xen_vnuma_topology_info_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_vnuma_topology_info_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_vnuma_topology_info_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_vnuma_topology_info_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_vnuma_topology_info_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_vnuma_topology_info_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_vnuma_topology_info_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_vnuma_topology_info_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_createdomain {
    pub ssidref: u32,
    pub handle: xen_domain_handle_t,
    pub flags: u32,
    pub config: xen_arch_domainconfig,
}
#[test]
fn bindgen_test_layout_xen_domctl_createdomain() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_createdomain>(),
        28usize,
        concat!("Size of: ", stringify!(xen_domctl_createdomain))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_createdomain>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_createdomain))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_createdomain>())).ssidref as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_createdomain),
            "::",
            stringify!(ssidref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_createdomain>())).handle as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_createdomain),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_createdomain>())).flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_createdomain),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_createdomain>())).config as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_createdomain),
            "::",
            stringify!(config)
        )
    );
}
pub type xen_domctl_createdomain_t = xen_domctl_createdomain;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_createdomain_t {
    pub p: *mut xen_domctl_createdomain_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_createdomain_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_createdomain_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_createdomain_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_createdomain_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_createdomain_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_createdomain_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_createdomain_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_createdomain_t {
    pub p: *const xen_domctl_createdomain_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_createdomain_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_createdomain_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_createdomain_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_createdomain_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_createdomain_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_createdomain_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_createdomain_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_getdomaininfo {
    pub domain: domid_t,
    pub flags: u32,
    pub tot_pages: u64,
    pub max_pages: u64,
    pub outstanding_pages: u64,
    pub shr_pages: u64,
    pub paged_pages: u64,
    pub shared_info_frame: u64,
    pub cpu_time: u64,
    pub nr_online_vcpus: u32,
    pub max_vcpu_id: u32,
    pub ssidref: u32,
    pub handle: xen_domain_handle_t,
    pub cpupool: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_getdomaininfo() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_getdomaininfo>(),
        96usize,
        concat!("Size of: ", stringify!(xen_domctl_getdomaininfo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_getdomaininfo>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_getdomaininfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).domain as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(domain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).tot_pages as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(tot_pages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).max_pages as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(max_pages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).outstanding_pages as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(outstanding_pages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).shr_pages as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(shr_pages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).paged_pages as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(paged_pages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).shared_info_frame as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(shared_info_frame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).cpu_time as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(cpu_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).nr_online_vcpus as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(nr_online_vcpus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).max_vcpu_id as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(max_vcpu_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).ssidref as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(ssidref)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).handle as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getdomaininfo>())).cpupool as *const _ as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getdomaininfo),
            "::",
            stringify!(cpupool)
        )
    );
}
pub type xen_domctl_getdomaininfo_t = xen_domctl_getdomaininfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_getdomaininfo_t {
    pub p: *mut xen_domctl_getdomaininfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_getdomaininfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_getdomaininfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_getdomaininfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_getdomaininfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_getdomaininfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_getdomaininfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_getdomaininfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_getdomaininfo_t {
    pub p: *const xen_domctl_getdomaininfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_getdomaininfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_getdomaininfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_getdomaininfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_getdomaininfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_getdomaininfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_getdomaininfo_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_getdomaininfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_getmemlist {
    pub max_pfns: u64,
    pub start_pfn: u64,
    pub buffer: __guest_handle_uint64,
    pub num_pfns: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_getmemlist() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_getmemlist>(),
        32usize,
        concat!("Size of: ", stringify!(xen_domctl_getmemlist))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_getmemlist>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_getmemlist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getmemlist>())).max_pfns as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getmemlist),
            "::",
            stringify!(max_pfns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getmemlist>())).start_pfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getmemlist),
            "::",
            stringify!(start_pfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getmemlist>())).buffer as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getmemlist),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getmemlist>())).num_pfns as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getmemlist),
            "::",
            stringify!(num_pfns)
        )
    );
}
pub type xen_domctl_getmemlist_t = xen_domctl_getmemlist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_getmemlist_t {
    pub p: *mut xen_domctl_getmemlist_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_getmemlist_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_getmemlist_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_getmemlist_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_getmemlist_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_getmemlist_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_getmemlist_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_getmemlist_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_getmemlist_t {
    pub p: *const xen_domctl_getmemlist_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_getmemlist_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_getmemlist_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_getmemlist_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_getmemlist_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_getmemlist_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_getmemlist_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_getmemlist_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_getpageframeinfo3 {
    pub num: u64,
    pub array: __guest_handle_xen_pfn_t,
}
#[test]
fn bindgen_test_layout_xen_domctl_getpageframeinfo3() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_getpageframeinfo3>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_getpageframeinfo3))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_getpageframeinfo3>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_getpageframeinfo3))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getpageframeinfo3>())).num as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getpageframeinfo3),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_getpageframeinfo3>())).array as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getpageframeinfo3),
            "::",
            stringify!(array)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_shadow_op_stats {
    pub fault_count: u32,
    pub dirty_count: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_shadow_op_stats() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_shadow_op_stats>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_shadow_op_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_shadow_op_stats>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_shadow_op_stats))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_shadow_op_stats>())).fault_count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_shadow_op_stats),
            "::",
            stringify!(fault_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_shadow_op_stats>())).dirty_count as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_shadow_op_stats),
            "::",
            stringify!(dirty_count)
        )
    );
}
pub type xen_domctl_shadow_op_stats_t = xen_domctl_shadow_op_stats;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_shadow_op_stats_t {
    pub p: *mut xen_domctl_shadow_op_stats_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_shadow_op_stats_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_shadow_op_stats_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_shadow_op_stats_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_shadow_op_stats_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_shadow_op_stats_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_shadow_op_stats_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_shadow_op_stats_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_shadow_op_stats_t {
    pub p: *const xen_domctl_shadow_op_stats_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_shadow_op_stats_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_shadow_op_stats_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_shadow_op_stats_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_shadow_op_stats_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_shadow_op_stats_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_shadow_op_stats_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_shadow_op_stats_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_shadow_op {
    pub op: u32,
    pub mode: u32,
    pub mb: u32,
    pub dirty_bitmap: __guest_handle_uint8,
    pub pages: u64,
    pub stats: xen_domctl_shadow_op_stats,
}
#[test]
fn bindgen_test_layout_xen_domctl_shadow_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_shadow_op>(),
        40usize,
        concat!("Size of: ", stringify!(xen_domctl_shadow_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_shadow_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_shadow_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_shadow_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_shadow_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_shadow_op>())).mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_shadow_op),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_shadow_op>())).mb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_shadow_op),
            "::",
            stringify!(mb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_shadow_op>())).dirty_bitmap as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_shadow_op),
            "::",
            stringify!(dirty_bitmap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_shadow_op>())).pages as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_shadow_op),
            "::",
            stringify!(pages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_shadow_op>())).stats as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_shadow_op),
            "::",
            stringify!(stats)
        )
    );
}
pub type xen_domctl_shadow_op_t = xen_domctl_shadow_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_shadow_op_t {
    pub p: *mut xen_domctl_shadow_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_shadow_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_shadow_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_shadow_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_shadow_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_shadow_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_shadow_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_shadow_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_shadow_op_t {
    pub p: *const xen_domctl_shadow_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_shadow_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_shadow_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_shadow_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_shadow_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_shadow_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_shadow_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_shadow_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_max_mem {
    pub max_memkb: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_max_mem() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_max_mem>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_max_mem))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_max_mem>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_max_mem))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_max_mem>())).max_memkb as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_max_mem),
            "::",
            stringify!(max_memkb)
        )
    );
}
pub type xen_domctl_max_mem_t = xen_domctl_max_mem;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_max_mem_t {
    pub p: *mut xen_domctl_max_mem_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_max_mem_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_max_mem_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_domctl_max_mem_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_max_mem_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_max_mem_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_max_mem_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_max_mem_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_max_mem_t {
    pub p: *const xen_domctl_max_mem_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_max_mem_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_max_mem_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_max_mem_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_max_mem_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_max_mem_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_max_mem_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_max_mem_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_vcpucontext {
    pub vcpu: u32,
    pub ctxt: __guest_handle_vcpu_guest_context_t,
}
#[test]
fn bindgen_test_layout_xen_domctl_vcpucontext() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_vcpucontext>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_vcpucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_vcpucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_vcpucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpucontext>())).vcpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpucontext),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpucontext>())).ctxt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpucontext),
            "::",
            stringify!(ctxt)
        )
    );
}
pub type xen_domctl_vcpucontext_t = xen_domctl_vcpucontext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_vcpucontext_t {
    pub p: *mut xen_domctl_vcpucontext_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_vcpucontext_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_vcpucontext_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_vcpucontext_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_vcpucontext_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_vcpucontext_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_vcpucontext_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_vcpucontext_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_vcpucontext_t {
    pub p: *const xen_domctl_vcpucontext_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_vcpucontext_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_vcpucontext_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_vcpucontext_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_vcpucontext_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_vcpucontext_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_vcpucontext_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_vcpucontext_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_getvcpuinfo {
    pub vcpu: u32,
    pub online: u8,
    pub blocked: u8,
    pub running: u8,
    pub cpu_time: u64,
    pub cpu: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_getvcpuinfo() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_getvcpuinfo>(),
        24usize,
        concat!("Size of: ", stringify!(xen_domctl_getvcpuinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_getvcpuinfo>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_getvcpuinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getvcpuinfo>())).vcpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getvcpuinfo),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getvcpuinfo>())).online as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getvcpuinfo),
            "::",
            stringify!(online)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getvcpuinfo>())).blocked as *const _ as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getvcpuinfo),
            "::",
            stringify!(blocked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getvcpuinfo>())).running as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getvcpuinfo),
            "::",
            stringify!(running)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getvcpuinfo>())).cpu_time as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getvcpuinfo),
            "::",
            stringify!(cpu_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_getvcpuinfo>())).cpu as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_getvcpuinfo),
            "::",
            stringify!(cpu)
        )
    );
}
pub type xen_domctl_getvcpuinfo_t = xen_domctl_getvcpuinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_getvcpuinfo_t {
    pub p: *mut xen_domctl_getvcpuinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_getvcpuinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_getvcpuinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_getvcpuinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_getvcpuinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_getvcpuinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_getvcpuinfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_getvcpuinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_getvcpuinfo_t {
    pub p: *const xen_domctl_getvcpuinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_getvcpuinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_getvcpuinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_getvcpuinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_getvcpuinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_getvcpuinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_getvcpuinfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_getvcpuinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_nodeaffinity {
    pub nodemap: xenctl_bitmap,
}
#[test]
fn bindgen_test_layout_xen_domctl_nodeaffinity() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_nodeaffinity>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_nodeaffinity))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_nodeaffinity>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_nodeaffinity))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_nodeaffinity>())).nodemap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_nodeaffinity),
            "::",
            stringify!(nodemap)
        )
    );
}
pub type xen_domctl_nodeaffinity_t = xen_domctl_nodeaffinity;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_nodeaffinity_t {
    pub p: *mut xen_domctl_nodeaffinity_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_nodeaffinity_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_nodeaffinity_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_nodeaffinity_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_nodeaffinity_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_nodeaffinity_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_nodeaffinity_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_nodeaffinity_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_nodeaffinity_t {
    pub p: *const xen_domctl_nodeaffinity_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_nodeaffinity_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_nodeaffinity_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_nodeaffinity_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_nodeaffinity_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_nodeaffinity_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_nodeaffinity_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_nodeaffinity_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_vcpuaffinity {
    pub vcpu: u32,
    pub flags: u32,
    pub cpumap_hard: xenctl_bitmap,
    pub cpumap_soft: xenctl_bitmap,
}
#[test]
fn bindgen_test_layout_xen_domctl_vcpuaffinity() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_vcpuaffinity>(),
        40usize,
        concat!("Size of: ", stringify!(xen_domctl_vcpuaffinity))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_vcpuaffinity>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_vcpuaffinity))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpuaffinity>())).vcpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpuaffinity),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpuaffinity>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpuaffinity),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_vcpuaffinity>())).cpumap_hard as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpuaffinity),
            "::",
            stringify!(cpumap_hard)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_vcpuaffinity>())).cpumap_soft as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpuaffinity),
            "::",
            stringify!(cpumap_soft)
        )
    );
}
pub type xen_domctl_vcpuaffinity_t = xen_domctl_vcpuaffinity;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_vcpuaffinity_t {
    pub p: *mut xen_domctl_vcpuaffinity_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_vcpuaffinity_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_vcpuaffinity_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_vcpuaffinity_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_vcpuaffinity_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_vcpuaffinity_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_vcpuaffinity_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_vcpuaffinity_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_vcpuaffinity_t {
    pub p: *const xen_domctl_vcpuaffinity_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_vcpuaffinity_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_vcpuaffinity_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_vcpuaffinity_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_vcpuaffinity_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_vcpuaffinity_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_vcpuaffinity_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_vcpuaffinity_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_max_vcpus {
    pub max: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_max_vcpus() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_max_vcpus>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_max_vcpus))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_max_vcpus>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_max_vcpus))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_max_vcpus>())).max as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_max_vcpus),
            "::",
            stringify!(max)
        )
    );
}
pub type xen_domctl_max_vcpus_t = xen_domctl_max_vcpus;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_max_vcpus_t {
    pub p: *mut xen_domctl_max_vcpus_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_max_vcpus_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_max_vcpus_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_max_vcpus_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_max_vcpus_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_max_vcpus_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_max_vcpus_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_max_vcpus_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_max_vcpus_t {
    pub p: *const xen_domctl_max_vcpus_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_max_vcpus_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_max_vcpus_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_max_vcpus_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_max_vcpus_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_max_vcpus_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_max_vcpus_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_max_vcpus_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_sched_credit {
    pub weight: u16,
    pub cap: u16,
}
#[test]
fn bindgen_test_layout_xen_domctl_sched_credit() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_sched_credit>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_sched_credit))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_sched_credit>(),
        2usize,
        concat!("Alignment of ", stringify!(xen_domctl_sched_credit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_sched_credit>())).weight as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_sched_credit),
            "::",
            stringify!(weight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_sched_credit>())).cap as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_sched_credit),
            "::",
            stringify!(cap)
        )
    );
}
pub type xen_domctl_sched_credit_t = xen_domctl_sched_credit;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_sched_credit2 {
    pub weight: u16,
}
#[test]
fn bindgen_test_layout_xen_domctl_sched_credit2() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_sched_credit2>(),
        2usize,
        concat!("Size of: ", stringify!(xen_domctl_sched_credit2))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_sched_credit2>(),
        2usize,
        concat!("Alignment of ", stringify!(xen_domctl_sched_credit2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_sched_credit2>())).weight as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_sched_credit2),
            "::",
            stringify!(weight)
        )
    );
}
pub type xen_domctl_sched_credit2_t = xen_domctl_sched_credit2;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_sched_rtds {
    pub period: u32,
    pub budget: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_sched_rtds() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_sched_rtds>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_sched_rtds))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_sched_rtds>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_sched_rtds))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_sched_rtds>())).period as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_sched_rtds),
            "::",
            stringify!(period)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_sched_rtds>())).budget as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_sched_rtds),
            "::",
            stringify!(budget)
        )
    );
}
pub type xen_domctl_sched_rtds_t = xen_domctl_sched_rtds;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_domctl_schedparam_vcpu {
    pub u: xen_domctl_schedparam_vcpu__bindgen_ty_1,
    pub vcpuid: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_domctl_schedparam_vcpu__bindgen_ty_1 {
    pub credit: xen_domctl_sched_credit_t,
    pub credit2: xen_domctl_sched_credit2_t,
    pub rtds: xen_domctl_sched_rtds_t,
    _bindgen_union_align: [u32; 2usize],
}
#[test]
fn bindgen_test_layout_xen_domctl_schedparam_vcpu__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_schedparam_vcpu__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_schedparam_vcpu__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_schedparam_vcpu__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_schedparam_vcpu__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_schedparam_vcpu__bindgen_ty_1>())).credit as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_schedparam_vcpu__bindgen_ty_1),
            "::",
            stringify!(credit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_schedparam_vcpu__bindgen_ty_1>())).credit2 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_schedparam_vcpu__bindgen_ty_1),
            "::",
            stringify!(credit2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_schedparam_vcpu__bindgen_ty_1>())).rtds as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_schedparam_vcpu__bindgen_ty_1),
            "::",
            stringify!(rtds)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_schedparam_vcpu() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_schedparam_vcpu>(),
        12usize,
        concat!("Size of: ", stringify!(xen_domctl_schedparam_vcpu))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_schedparam_vcpu>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_schedparam_vcpu))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_schedparam_vcpu>())).u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_schedparam_vcpu),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_schedparam_vcpu>())).vcpuid as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_schedparam_vcpu),
            "::",
            stringify!(vcpuid)
        )
    );
}
pub type xen_domctl_schedparam_vcpu_t = xen_domctl_schedparam_vcpu;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_schedparam_vcpu_t {
    pub p: *mut xen_domctl_schedparam_vcpu_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_schedparam_vcpu_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_schedparam_vcpu_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_schedparam_vcpu_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_schedparam_vcpu_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_schedparam_vcpu_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_schedparam_vcpu_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_schedparam_vcpu_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_schedparam_vcpu_t {
    pub p: *const xen_domctl_schedparam_vcpu_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_schedparam_vcpu_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_schedparam_vcpu_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_schedparam_vcpu_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_schedparam_vcpu_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_schedparam_vcpu_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_schedparam_vcpu_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_schedparam_vcpu_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_domctl_scheduler_op {
    pub sched_id: u32,
    pub cmd: u32,
    pub u: xen_domctl_scheduler_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_domctl_scheduler_op__bindgen_ty_1 {
    pub credit: xen_domctl_sched_credit_t,
    pub credit2: xen_domctl_sched_credit2_t,
    pub rtds: xen_domctl_sched_rtds_t,
    pub v: xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1 {
    pub vcpus: __guest_handle_xen_domctl_schedparam_vcpu_t,
    pub nr_vcpus: u32,
    pub padding: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1>())).vcpus
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(vcpus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1>())).nr_vcpus
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(nr_vcpus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1>())).padding
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(padding)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_scheduler_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_scheduler_op__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_scheduler_op__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_scheduler_op__bindgen_ty_1>())).credit as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1),
            "::",
            stringify!(credit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_scheduler_op__bindgen_ty_1>())).credit2 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1),
            "::",
            stringify!(credit2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_scheduler_op__bindgen_ty_1>())).rtds as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1),
            "::",
            stringify!(rtds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_scheduler_op__bindgen_ty_1>())).v as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op__bindgen_ty_1),
            "::",
            stringify!(v)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_scheduler_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_scheduler_op>(),
        24usize,
        concat!("Size of: ", stringify!(xen_domctl_scheduler_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_scheduler_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_scheduler_op))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_scheduler_op>())).sched_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op),
            "::",
            stringify!(sched_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_scheduler_op>())).cmd as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_scheduler_op>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_scheduler_op),
            "::",
            stringify!(u)
        )
    );
}
pub type xen_domctl_scheduler_op_t = xen_domctl_scheduler_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_scheduler_op_t {
    pub p: *mut xen_domctl_scheduler_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_scheduler_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_scheduler_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_scheduler_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_scheduler_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_scheduler_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_scheduler_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_scheduler_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_scheduler_op_t {
    pub p: *const xen_domctl_scheduler_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_scheduler_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_scheduler_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_scheduler_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_scheduler_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_scheduler_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_scheduler_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_scheduler_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_setdomainhandle {
    pub handle: xen_domain_handle_t,
}
#[test]
fn bindgen_test_layout_xen_domctl_setdomainhandle() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_setdomainhandle>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_setdomainhandle))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_setdomainhandle>(),
        1usize,
        concat!("Alignment of ", stringify!(xen_domctl_setdomainhandle))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_setdomainhandle>())).handle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_setdomainhandle),
            "::",
            stringify!(handle)
        )
    );
}
pub type xen_domctl_setdomainhandle_t = xen_domctl_setdomainhandle;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_setdomainhandle_t {
    pub p: *mut xen_domctl_setdomainhandle_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_setdomainhandle_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_setdomainhandle_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_setdomainhandle_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_setdomainhandle_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_setdomainhandle_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_setdomainhandle_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_setdomainhandle_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_setdomainhandle_t {
    pub p: *const xen_domctl_setdomainhandle_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_setdomainhandle_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_setdomainhandle_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_setdomainhandle_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_setdomainhandle_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_setdomainhandle_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_setdomainhandle_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_setdomainhandle_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_setdebugging {
    pub enable: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_setdebugging() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_setdebugging>(),
        1usize,
        concat!("Size of: ", stringify!(xen_domctl_setdebugging))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_setdebugging>(),
        1usize,
        concat!("Alignment of ", stringify!(xen_domctl_setdebugging))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_setdebugging>())).enable as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_setdebugging),
            "::",
            stringify!(enable)
        )
    );
}
pub type xen_domctl_setdebugging_t = xen_domctl_setdebugging;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_setdebugging_t {
    pub p: *mut xen_domctl_setdebugging_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_setdebugging_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_setdebugging_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_setdebugging_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_setdebugging_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_setdebugging_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_setdebugging_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_setdebugging_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_setdebugging_t {
    pub p: *const xen_domctl_setdebugging_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_setdebugging_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_setdebugging_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_setdebugging_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_setdebugging_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_setdebugging_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_setdebugging_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_setdebugging_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_irq_permission {
    pub pirq: u8,
    pub allow_access: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_irq_permission() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_irq_permission>(),
        2usize,
        concat!("Size of: ", stringify!(xen_domctl_irq_permission))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_irq_permission>(),
        1usize,
        concat!("Alignment of ", stringify!(xen_domctl_irq_permission))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_irq_permission>())).pirq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_irq_permission),
            "::",
            stringify!(pirq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_irq_permission>())).allow_access as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_irq_permission),
            "::",
            stringify!(allow_access)
        )
    );
}
pub type xen_domctl_irq_permission_t = xen_domctl_irq_permission;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_irq_permission_t {
    pub p: *mut xen_domctl_irq_permission_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_irq_permission_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_irq_permission_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_irq_permission_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_irq_permission_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_irq_permission_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_irq_permission_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_irq_permission_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_irq_permission_t {
    pub p: *const xen_domctl_irq_permission_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_irq_permission_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_irq_permission_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_irq_permission_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_irq_permission_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_irq_permission_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_irq_permission_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_irq_permission_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_iomem_permission {
    pub first_mfn: u64,
    pub nr_mfns: u64,
    pub allow_access: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_iomem_permission() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_iomem_permission>(),
        24usize,
        concat!("Size of: ", stringify!(xen_domctl_iomem_permission))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_iomem_permission>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_iomem_permission))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_iomem_permission>())).first_mfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_iomem_permission),
            "::",
            stringify!(first_mfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_iomem_permission>())).nr_mfns as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_iomem_permission),
            "::",
            stringify!(nr_mfns)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_iomem_permission>())).allow_access as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_iomem_permission),
            "::",
            stringify!(allow_access)
        )
    );
}
pub type xen_domctl_iomem_permission_t = xen_domctl_iomem_permission;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_iomem_permission_t {
    pub p: *mut xen_domctl_iomem_permission_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_iomem_permission_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_iomem_permission_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_iomem_permission_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_iomem_permission_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_iomem_permission_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_iomem_permission_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_iomem_permission_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_iomem_permission_t {
    pub p: *const xen_domctl_iomem_permission_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_iomem_permission_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_iomem_permission_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_iomem_permission_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_iomem_permission_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_iomem_permission_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_iomem_permission_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_iomem_permission_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_ioport_permission {
    pub first_port: u32,
    pub nr_ports: u32,
    pub allow_access: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_ioport_permission() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_ioport_permission>(),
        12usize,
        concat!("Size of: ", stringify!(xen_domctl_ioport_permission))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_ioport_permission>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_ioport_permission))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ioport_permission>())).first_port as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ioport_permission),
            "::",
            stringify!(first_port)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ioport_permission>())).nr_ports as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ioport_permission),
            "::",
            stringify!(nr_ports)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ioport_permission>())).allow_access as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ioport_permission),
            "::",
            stringify!(allow_access)
        )
    );
}
pub type xen_domctl_ioport_permission_t = xen_domctl_ioport_permission;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_ioport_permission_t {
    pub p: *mut xen_domctl_ioport_permission_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_ioport_permission_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_ioport_permission_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_ioport_permission_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_ioport_permission_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_ioport_permission_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_ioport_permission_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_ioport_permission_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_ioport_permission_t {
    pub p: *const xen_domctl_ioport_permission_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_ioport_permission_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_ioport_permission_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_ioport_permission_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_ioport_permission_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_ioport_permission_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_ioport_permission_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_ioport_permission_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_hypercall_init {
    pub gmfn: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_hypercall_init() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_hypercall_init>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_hypercall_init))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_hypercall_init>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_hypercall_init))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_hypercall_init>())).gmfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_hypercall_init),
            "::",
            stringify!(gmfn)
        )
    );
}
pub type xen_domctl_hypercall_init_t = xen_domctl_hypercall_init;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_hypercall_init_t {
    pub p: *mut xen_domctl_hypercall_init_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_hypercall_init_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_hypercall_init_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_hypercall_init_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_hypercall_init_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_hypercall_init_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_hypercall_init_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_hypercall_init_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_hypercall_init_t {
    pub p: *const xen_domctl_hypercall_init_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_hypercall_init_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_hypercall_init_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_hypercall_init_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_hypercall_init_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_hypercall_init_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_hypercall_init_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_hypercall_init_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_settimeoffset {
    pub time_offset_seconds: i64,
}
#[test]
fn bindgen_test_layout_xen_domctl_settimeoffset() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_settimeoffset>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_settimeoffset))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_settimeoffset>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_settimeoffset))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_settimeoffset>())).time_offset_seconds as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_settimeoffset),
            "::",
            stringify!(time_offset_seconds)
        )
    );
}
pub type xen_domctl_settimeoffset_t = xen_domctl_settimeoffset;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_settimeoffset_t {
    pub p: *mut xen_domctl_settimeoffset_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_settimeoffset_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_settimeoffset_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_settimeoffset_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_settimeoffset_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_settimeoffset_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_settimeoffset_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_settimeoffset_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_settimeoffset_t {
    pub p: *const xen_domctl_settimeoffset_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_settimeoffset_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_settimeoffset_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_settimeoffset_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_settimeoffset_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_settimeoffset_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_settimeoffset_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_settimeoffset_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_hvmcontext {
    pub size: u32,
    pub buffer: __guest_handle_uint8,
}
#[test]
fn bindgen_test_layout_xen_domctl_hvmcontext() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_hvmcontext>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_hvmcontext))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_hvmcontext>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_hvmcontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_hvmcontext>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_hvmcontext),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_hvmcontext>())).buffer as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_hvmcontext),
            "::",
            stringify!(buffer)
        )
    );
}
pub type xen_domctl_hvmcontext_t = xen_domctl_hvmcontext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_hvmcontext_t {
    pub p: *mut xen_domctl_hvmcontext_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_hvmcontext_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_hvmcontext_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_hvmcontext_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_hvmcontext_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_hvmcontext_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_hvmcontext_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_hvmcontext_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_hvmcontext_t {
    pub p: *const xen_domctl_hvmcontext_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_hvmcontext_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_hvmcontext_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_hvmcontext_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_hvmcontext_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_hvmcontext_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_hvmcontext_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_hvmcontext_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_address_size {
    pub size: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_address_size() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_address_size>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_address_size))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_address_size>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_address_size))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_address_size>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_address_size),
            "::",
            stringify!(size)
        )
    );
}
pub type xen_domctl_address_size_t = xen_domctl_address_size;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_address_size_t {
    pub p: *mut xen_domctl_address_size_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_address_size_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_address_size_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_address_size_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_address_size_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_address_size_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_address_size_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_address_size_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_address_size_t {
    pub p: *const xen_domctl_address_size_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_address_size_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_address_size_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_address_size_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_address_size_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_address_size_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_address_size_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_address_size_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_sendtrigger {
    pub trigger: u32,
    pub vcpu: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_sendtrigger() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_sendtrigger>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_sendtrigger))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_sendtrigger>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_sendtrigger))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_sendtrigger>())).trigger as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_sendtrigger),
            "::",
            stringify!(trigger)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_sendtrigger>())).vcpu as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_sendtrigger),
            "::",
            stringify!(vcpu)
        )
    );
}
pub type xen_domctl_sendtrigger_t = xen_domctl_sendtrigger;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_sendtrigger_t {
    pub p: *mut xen_domctl_sendtrigger_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_sendtrigger_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_sendtrigger_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_sendtrigger_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_sendtrigger_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_sendtrigger_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_sendtrigger_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_sendtrigger_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_sendtrigger_t {
    pub p: *const xen_domctl_sendtrigger_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_sendtrigger_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_sendtrigger_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_sendtrigger_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_sendtrigger_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_sendtrigger_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_sendtrigger_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_sendtrigger_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_domctl_assign_device {
    pub dev: u32,
    pub u: xen_domctl_assign_device__bindgen_ty_1,
    pub flag: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_domctl_assign_device__bindgen_ty_1 {
    pub pci: xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1,
    pub dt: xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2,
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1 {
    pub machine_sbdf: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1>()))
                .machine_sbdf as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(machine_sbdf)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2 {
    pub size: u32,
    pub path: __guest_handle_char,
}
#[test]
fn bindgen_test_layout_xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2>())).size
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2>())).path
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(path)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_assign_device__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_assign_device__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_assign_device__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_assign_device__bindgen_ty_1>())).pci as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1),
            "::",
            stringify!(pci)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_assign_device__bindgen_ty_1>())).dt as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_assign_device__bindgen_ty_1),
            "::",
            stringify!(dt)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_assign_device() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_assign_device>(),
        32usize,
        concat!("Size of: ", stringify!(xen_domctl_assign_device))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_assign_device>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_assign_device))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_assign_device>())).dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_assign_device),
            "::",
            stringify!(dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_assign_device>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_assign_device),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_assign_device>())).flag as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_assign_device),
            "::",
            stringify!(flag)
        )
    );
}
pub type xen_domctl_assign_device_t = xen_domctl_assign_device;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_assign_device_t {
    pub p: *mut xen_domctl_assign_device_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_assign_device_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_assign_device_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_assign_device_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_assign_device_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_assign_device_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_assign_device_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_assign_device_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_assign_device_t {
    pub p: *const xen_domctl_assign_device_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_assign_device_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_assign_device_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_assign_device_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_assign_device_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_assign_device_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_assign_device_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_assign_device_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_get_device_group {
    pub machine_sbdf: u32,
    pub max_sdevs: u32,
    pub num_sdevs: u32,
    pub sdev_array: __guest_handle_uint32,
}
#[test]
fn bindgen_test_layout_xen_domctl_get_device_group() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_get_device_group>(),
        24usize,
        concat!("Size of: ", stringify!(xen_domctl_get_device_group))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_get_device_group>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_get_device_group))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_get_device_group>())).machine_sbdf as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_get_device_group),
            "::",
            stringify!(machine_sbdf)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_get_device_group>())).max_sdevs as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_get_device_group),
            "::",
            stringify!(max_sdevs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_get_device_group>())).num_sdevs as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_get_device_group),
            "::",
            stringify!(num_sdevs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_get_device_group>())).sdev_array as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_get_device_group),
            "::",
            stringify!(sdev_array)
        )
    );
}
pub type xen_domctl_get_device_group_t = xen_domctl_get_device_group;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_get_device_group_t {
    pub p: *mut xen_domctl_get_device_group_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_get_device_group_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_get_device_group_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_get_device_group_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_get_device_group_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_get_device_group_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_get_device_group_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_get_device_group_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_get_device_group_t {
    pub p: *const xen_domctl_get_device_group_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_get_device_group_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_get_device_group_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_get_device_group_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_get_device_group_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_get_device_group_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_get_device_group_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_get_device_group_t),
            "::",
            stringify!(p)
        )
    );
}
pub const pt_irq_type_e_PT_IRQ_TYPE_PCI: pt_irq_type_e = 0;
pub const pt_irq_type_e_PT_IRQ_TYPE_ISA: pt_irq_type_e = 1;
pub const pt_irq_type_e_PT_IRQ_TYPE_MSI: pt_irq_type_e = 2;
pub const pt_irq_type_e_PT_IRQ_TYPE_MSI_TRANSLATE: pt_irq_type_e = 3;
pub const pt_irq_type_e_PT_IRQ_TYPE_SPI: pt_irq_type_e = 4;
pub type pt_irq_type_e = u32;
pub use self::pt_irq_type_e as pt_irq_type_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_domctl_bind_pt_irq {
    pub machine_irq: u32,
    pub irq_type: pt_irq_type_t,
    pub hvm_domid: u32,
    pub u: xen_domctl_bind_pt_irq__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_domctl_bind_pt_irq__bindgen_ty_1 {
    pub isa: xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1,
    pub pci: xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2,
    pub msi: xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3,
    pub spi: xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4,
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1 {
    pub isa_irq: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1>())).isa_irq
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(isa_irq)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2 {
    pub bus: u8,
    pub device: u8,
    pub intx: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2>(),
        3usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2>())).bus
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(bus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2>())).device
                as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(device)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2>())).intx
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(intx)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3 {
    pub gvec: u8,
    pub gflags: u32,
    pub gtable: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3>())).gvec
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(gvec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3>())).gflags
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(gflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3>())).gtable
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(gtable)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4 {
    pub spi: u16,
}
#[test]
fn bindgen_test_layout_xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4>())).spi
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(spi)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_bind_pt_irq__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_bind_pt_irq__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_bind_pt_irq__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1>())).isa as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1),
            "::",
            stringify!(isa)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1>())).pci as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1),
            "::",
            stringify!(pci)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1>())).msi as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1),
            "::",
            stringify!(msi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq__bindgen_ty_1>())).spi as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq__bindgen_ty_1),
            "::",
            stringify!(spi)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_bind_pt_irq() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_bind_pt_irq>(),
        32usize,
        concat!("Size of: ", stringify!(xen_domctl_bind_pt_irq))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_bind_pt_irq>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_bind_pt_irq))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq>())).machine_irq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq),
            "::",
            stringify!(machine_irq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_bind_pt_irq>())).irq_type as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq),
            "::",
            stringify!(irq_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_bind_pt_irq>())).hvm_domid as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq),
            "::",
            stringify!(hvm_domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_bind_pt_irq>())).u as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_bind_pt_irq),
            "::",
            stringify!(u)
        )
    );
}
pub type xen_domctl_bind_pt_irq_t = xen_domctl_bind_pt_irq;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_bind_pt_irq_t {
    pub p: *mut xen_domctl_bind_pt_irq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_bind_pt_irq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_bind_pt_irq_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_bind_pt_irq_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_bind_pt_irq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_bind_pt_irq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_bind_pt_irq_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_bind_pt_irq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_bind_pt_irq_t {
    pub p: *const xen_domctl_bind_pt_irq_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_bind_pt_irq_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_bind_pt_irq_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_bind_pt_irq_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_bind_pt_irq_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_bind_pt_irq_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_bind_pt_irq_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_bind_pt_irq_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_memory_mapping {
    pub first_gfn: u64,
    pub first_mfn: u64,
    pub nr_mfns: u64,
    pub add_mapping: u32,
    pub padding: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_memory_mapping() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_memory_mapping>(),
        32usize,
        concat!("Size of: ", stringify!(xen_domctl_memory_mapping))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_memory_mapping>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_memory_mapping))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_memory_mapping>())).first_gfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_memory_mapping),
            "::",
            stringify!(first_gfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_memory_mapping>())).first_mfn as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_memory_mapping),
            "::",
            stringify!(first_mfn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_memory_mapping>())).nr_mfns as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_memory_mapping),
            "::",
            stringify!(nr_mfns)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_memory_mapping>())).add_mapping as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_memory_mapping),
            "::",
            stringify!(add_mapping)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_memory_mapping>())).padding as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_memory_mapping),
            "::",
            stringify!(padding)
        )
    );
}
pub type xen_domctl_memory_mapping_t = xen_domctl_memory_mapping;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_memory_mapping_t {
    pub p: *mut xen_domctl_memory_mapping_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_memory_mapping_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_memory_mapping_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_memory_mapping_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_memory_mapping_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_memory_mapping_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_memory_mapping_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_memory_mapping_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_memory_mapping_t {
    pub p: *const xen_domctl_memory_mapping_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_memory_mapping_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_memory_mapping_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_memory_mapping_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_memory_mapping_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_memory_mapping_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_memory_mapping_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_memory_mapping_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_ioport_mapping {
    pub first_gport: u32,
    pub first_mport: u32,
    pub nr_ports: u32,
    pub add_mapping: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_ioport_mapping() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_ioport_mapping>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_ioport_mapping))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_ioport_mapping>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_ioport_mapping))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ioport_mapping>())).first_gport as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ioport_mapping),
            "::",
            stringify!(first_gport)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ioport_mapping>())).first_mport as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ioport_mapping),
            "::",
            stringify!(first_mport)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ioport_mapping>())).nr_ports as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ioport_mapping),
            "::",
            stringify!(nr_ports)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ioport_mapping>())).add_mapping as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ioport_mapping),
            "::",
            stringify!(add_mapping)
        )
    );
}
pub type xen_domctl_ioport_mapping_t = xen_domctl_ioport_mapping;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_ioport_mapping_t {
    pub p: *mut xen_domctl_ioport_mapping_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_ioport_mapping_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_ioport_mapping_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_ioport_mapping_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_ioport_mapping_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_ioport_mapping_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_ioport_mapping_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_ioport_mapping_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_ioport_mapping_t {
    pub p: *const xen_domctl_ioport_mapping_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_ioport_mapping_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_ioport_mapping_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_ioport_mapping_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_ioport_mapping_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_ioport_mapping_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_ioport_mapping_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_ioport_mapping_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_pin_mem_cacheattr {
    pub start: u64,
    pub end: u64,
    pub type_: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_pin_mem_cacheattr() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_pin_mem_cacheattr>(),
        24usize,
        concat!("Size of: ", stringify!(xen_domctl_pin_mem_cacheattr))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_pin_mem_cacheattr>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_pin_mem_cacheattr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_pin_mem_cacheattr>())).start as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_pin_mem_cacheattr),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_pin_mem_cacheattr>())).end as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_pin_mem_cacheattr),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_pin_mem_cacheattr>())).type_ as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_pin_mem_cacheattr),
            "::",
            stringify!(type_)
        )
    );
}
pub type xen_domctl_pin_mem_cacheattr_t = xen_domctl_pin_mem_cacheattr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_pin_mem_cacheattr_t {
    pub p: *mut xen_domctl_pin_mem_cacheattr_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_pin_mem_cacheattr_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_pin_mem_cacheattr_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_pin_mem_cacheattr_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_pin_mem_cacheattr_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_pin_mem_cacheattr_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_pin_mem_cacheattr_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_pin_mem_cacheattr_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_pin_mem_cacheattr_t {
    pub p: *const xen_domctl_pin_mem_cacheattr_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_pin_mem_cacheattr_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_pin_mem_cacheattr_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_pin_mem_cacheattr_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_pin_mem_cacheattr_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_pin_mem_cacheattr_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_pin_mem_cacheattr_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_pin_mem_cacheattr_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_domctl_ext_vcpucontext {
    pub vcpu: u32,
    pub size: u32,
    pub syscall32_callback_eip: u64,
    pub sysenter_callback_eip: u64,
    pub syscall32_callback_cs: u16,
    pub sysenter_callback_cs: u16,
    pub syscall32_disables_events: u8,
    pub sysenter_disables_events: u8,
    pub __bindgen_anon_1: xen_domctl_ext_vcpucontext__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_domctl_ext_vcpucontext__bindgen_ty_1 {
    pub mcg_cap: u64,
    pub vmce: hvm_vmce_vcpu,
    _bindgen_union_align: [u64; 4usize],
}
#[test]
fn bindgen_test_layout_xen_domctl_ext_vcpucontext__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_ext_vcpucontext__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_ext_vcpucontext__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_ext_vcpucontext__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_ext_vcpucontext__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext__bindgen_ty_1>())).mcg_cap as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext__bindgen_ty_1),
            "::",
            stringify!(mcg_cap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext__bindgen_ty_1>())).vmce as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext__bindgen_ty_1),
            "::",
            stringify!(vmce)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_ext_vcpucontext() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_ext_vcpucontext>(),
        64usize,
        concat!("Size of: ", stringify!(xen_domctl_ext_vcpucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_ext_vcpucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_ext_vcpucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext>())).vcpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext>())).size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext>())).syscall32_callback_eip
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext),
            "::",
            stringify!(syscall32_callback_eip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext>())).sysenter_callback_eip as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext),
            "::",
            stringify!(sysenter_callback_eip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext>())).syscall32_callback_cs as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext),
            "::",
            stringify!(syscall32_callback_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext>())).sysenter_callback_cs as *const _
                as usize
        },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext),
            "::",
            stringify!(sysenter_callback_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext>())).syscall32_disables_events
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext),
            "::",
            stringify!(syscall32_disables_events)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_ext_vcpucontext>())).sysenter_disables_events
                as *const _ as usize
        },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_ext_vcpucontext),
            "::",
            stringify!(sysenter_disables_events)
        )
    );
}
pub type xen_domctl_ext_vcpucontext_t = xen_domctl_ext_vcpucontext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_ext_vcpucontext_t {
    pub p: *mut xen_domctl_ext_vcpucontext_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_ext_vcpucontext_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_ext_vcpucontext_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_ext_vcpucontext_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_ext_vcpucontext_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_ext_vcpucontext_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_ext_vcpucontext_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_ext_vcpucontext_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_ext_vcpucontext_t {
    pub p: *const xen_domctl_ext_vcpucontext_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_ext_vcpucontext_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_ext_vcpucontext_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_ext_vcpucontext_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_ext_vcpucontext_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_ext_vcpucontext_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_ext_vcpucontext_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_ext_vcpucontext_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_set_target {
    pub target: domid_t,
}
#[test]
fn bindgen_test_layout_xen_domctl_set_target() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_set_target>(),
        2usize,
        concat!("Size of: ", stringify!(xen_domctl_set_target))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_set_target>(),
        2usize,
        concat!("Alignment of ", stringify!(xen_domctl_set_target))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_set_target>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_set_target),
            "::",
            stringify!(target)
        )
    );
}
pub type xen_domctl_set_target_t = xen_domctl_set_target;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_set_target_t {
    pub p: *mut xen_domctl_set_target_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_set_target_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_set_target_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_set_target_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_set_target_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_set_target_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_set_target_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_set_target_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_set_target_t {
    pub p: *const xen_domctl_set_target_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_set_target_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_set_target_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_set_target_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_set_target_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_set_target_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_set_target_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_set_target_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_cpuid {
    pub input: [u32; 2usize],
    pub eax: u32,
    pub ebx: u32,
    pub ecx: u32,
    pub edx: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_cpuid() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_cpuid>(),
        24usize,
        concat!("Size of: ", stringify!(xen_domctl_cpuid))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_cpuid>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_cpuid))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_cpuid>())).input as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_cpuid),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_cpuid>())).eax as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_cpuid),
            "::",
            stringify!(eax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_cpuid>())).ebx as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_cpuid),
            "::",
            stringify!(ebx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_cpuid>())).ecx as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_cpuid),
            "::",
            stringify!(ecx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_cpuid>())).edx as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_cpuid),
            "::",
            stringify!(edx)
        )
    );
}
pub type xen_domctl_cpuid_t = xen_domctl_cpuid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_cpuid_t {
    pub p: *mut xen_domctl_cpuid_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_cpuid_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_cpuid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_domctl_cpuid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_cpuid_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_cpuid_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_cpuid_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_cpuid_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_cpuid_t {
    pub p: *const xen_domctl_cpuid_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_cpuid_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_cpuid_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_cpuid_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_cpuid_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_cpuid_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_cpuid_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_cpuid_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_subscribe {
    pub port: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_subscribe() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_subscribe>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_subscribe))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_subscribe>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_subscribe))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_subscribe>())).port as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_subscribe),
            "::",
            stringify!(port)
        )
    );
}
pub type xen_domctl_subscribe_t = xen_domctl_subscribe;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_subscribe_t {
    pub p: *mut xen_domctl_subscribe_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_subscribe_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_subscribe_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_subscribe_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_subscribe_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_subscribe_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_subscribe_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_subscribe_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_subscribe_t {
    pub p: *const xen_domctl_subscribe_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_subscribe_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_subscribe_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_subscribe_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_subscribe_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_subscribe_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_subscribe_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_subscribe_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_debug_op {
    pub op: u32,
    pub vcpu: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_debug_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_debug_op>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_debug_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_debug_op>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_debug_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_debug_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_debug_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_debug_op>())).vcpu as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_debug_op),
            "::",
            stringify!(vcpu)
        )
    );
}
pub type xen_domctl_debug_op_t = xen_domctl_debug_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_debug_op_t {
    pub p: *mut xen_domctl_debug_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_debug_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_debug_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_debug_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_debug_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_debug_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_debug_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_debug_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_debug_op_t {
    pub p: *const xen_domctl_debug_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_debug_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_debug_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_debug_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_debug_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_debug_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_debug_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_debug_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_hvmcontext_partial {
    pub type_: u32,
    pub instance: u32,
    pub buffer: __guest_handle_uint8,
}
#[test]
fn bindgen_test_layout_xen_domctl_hvmcontext_partial() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_hvmcontext_partial>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_hvmcontext_partial))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_hvmcontext_partial>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_hvmcontext_partial))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_hvmcontext_partial>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_hvmcontext_partial),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_hvmcontext_partial>())).instance as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_hvmcontext_partial),
            "::",
            stringify!(instance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_hvmcontext_partial>())).buffer as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_hvmcontext_partial),
            "::",
            stringify!(buffer)
        )
    );
}
pub type xen_domctl_hvmcontext_partial_t = xen_domctl_hvmcontext_partial;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_hvmcontext_partial_t {
    pub p: *mut xen_domctl_hvmcontext_partial_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_hvmcontext_partial_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_hvmcontext_partial_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_hvmcontext_partial_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_hvmcontext_partial_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_hvmcontext_partial_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_hvmcontext_partial_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_hvmcontext_partial_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_hvmcontext_partial_t {
    pub p: *const xen_domctl_hvmcontext_partial_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_hvmcontext_partial_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_hvmcontext_partial_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_hvmcontext_partial_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_hvmcontext_partial_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_hvmcontext_partial_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_hvmcontext_partial_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_hvmcontext_partial_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_disable_migrate {
    pub disable: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_disable_migrate() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_disable_migrate>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_disable_migrate))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_disable_migrate>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_disable_migrate))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_disable_migrate>())).disable as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_disable_migrate),
            "::",
            stringify!(disable)
        )
    );
}
pub type xen_domctl_disable_migrate_t = xen_domctl_disable_migrate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_tsc_info {
    pub tsc_mode: u32,
    pub gtsc_khz: u32,
    pub incarnation: u32,
    pub pad: u32,
    pub elapsed_nsec: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_tsc_info() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_tsc_info>(),
        24usize,
        concat!("Size of: ", stringify!(xen_domctl_tsc_info))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_tsc_info>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_tsc_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_tsc_info>())).tsc_mode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_tsc_info),
            "::",
            stringify!(tsc_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_tsc_info>())).gtsc_khz as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_tsc_info),
            "::",
            stringify!(gtsc_khz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_tsc_info>())).incarnation as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_tsc_info),
            "::",
            stringify!(incarnation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_tsc_info>())).pad as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_tsc_info),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_tsc_info>())).elapsed_nsec as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_tsc_info),
            "::",
            stringify!(elapsed_nsec)
        )
    );
}
pub type xen_domctl_tsc_info_t = xen_domctl_tsc_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_gdbsx_memio {
    pub pgd3val: u64,
    pub gva: u64,
    pub uva: u64,
    pub len: u32,
    pub gwr: u8,
    pub remain: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_gdbsx_memio() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_gdbsx_memio>(),
        40usize,
        concat!("Size of: ", stringify!(xen_domctl_gdbsx_memio))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_gdbsx_memio>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_gdbsx_memio))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_gdbsx_memio>())).pgd3val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_memio),
            "::",
            stringify!(pgd3val)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_gdbsx_memio>())).gva as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_memio),
            "::",
            stringify!(gva)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_gdbsx_memio>())).uva as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_memio),
            "::",
            stringify!(uva)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_gdbsx_memio>())).len as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_memio),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_gdbsx_memio>())).gwr as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_memio),
            "::",
            stringify!(gwr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_gdbsx_memio>())).remain as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_memio),
            "::",
            stringify!(remain)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_gdbsx_pauseunp_vcpu {
    pub vcpu: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_gdbsx_pauseunp_vcpu() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_gdbsx_pauseunp_vcpu>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_gdbsx_pauseunp_vcpu))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_gdbsx_pauseunp_vcpu>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_gdbsx_pauseunp_vcpu))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_gdbsx_pauseunp_vcpu>())).vcpu as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_pauseunp_vcpu),
            "::",
            stringify!(vcpu)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_gdbsx_domstatus {
    pub paused: u8,
    pub vcpu_id: u32,
    pub vcpu_ev: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_gdbsx_domstatus() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_gdbsx_domstatus>(),
        12usize,
        concat!("Size of: ", stringify!(xen_domctl_gdbsx_domstatus))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_gdbsx_domstatus>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_gdbsx_domstatus))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_gdbsx_domstatus>())).paused as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_domstatus),
            "::",
            stringify!(paused)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_gdbsx_domstatus>())).vcpu_id as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_domstatus),
            "::",
            stringify!(vcpu_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_gdbsx_domstatus>())).vcpu_ev as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_gdbsx_domstatus),
            "::",
            stringify!(vcpu_ev)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_vm_event_op {
    pub op: u32,
    pub mode: u32,
    pub port: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_vm_event_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_vm_event_op>(),
        12usize,
        concat!("Size of: ", stringify!(xen_domctl_vm_event_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_vm_event_op>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_vm_event_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vm_event_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vm_event_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vm_event_op>())).mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vm_event_op),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vm_event_op>())).port as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vm_event_op),
            "::",
            stringify!(port)
        )
    );
}
pub type xen_domctl_vm_event_op_t = xen_domctl_vm_event_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_vm_event_op_t {
    pub p: *mut xen_domctl_vm_event_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_vm_event_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_vm_event_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_vm_event_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_vm_event_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_vm_event_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_vm_event_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_vm_event_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_vm_event_op_t {
    pub p: *const xen_domctl_vm_event_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_vm_event_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_vm_event_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_vm_event_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_vm_event_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_vm_event_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_vm_event_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_vm_event_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_domctl_mem_sharing_op {
    pub op: u8,
    pub u: xen_domctl_mem_sharing_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_domctl_mem_sharing_op__bindgen_ty_1 {
    pub enable: u8,
    _bindgen_union_align: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_mem_sharing_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_mem_sharing_op__bindgen_ty_1>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_mem_sharing_op__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_mem_sharing_op__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_mem_sharing_op__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_mem_sharing_op__bindgen_ty_1>())).enable as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_mem_sharing_op__bindgen_ty_1),
            "::",
            stringify!(enable)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_mem_sharing_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_mem_sharing_op>(),
        2usize,
        concat!("Size of: ", stringify!(xen_domctl_mem_sharing_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_mem_sharing_op>(),
        1usize,
        concat!("Alignment of ", stringify!(xen_domctl_mem_sharing_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_mem_sharing_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_mem_sharing_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_mem_sharing_op>())).u as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_mem_sharing_op),
            "::",
            stringify!(u)
        )
    );
}
pub type xen_domctl_mem_sharing_op_t = xen_domctl_mem_sharing_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_mem_sharing_op_t {
    pub p: *mut xen_domctl_mem_sharing_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_mem_sharing_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_mem_sharing_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_mem_sharing_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_mem_sharing_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_mem_sharing_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_mem_sharing_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_mem_sharing_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_mem_sharing_op_t {
    pub p: *const xen_domctl_mem_sharing_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_mem_sharing_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_mem_sharing_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_mem_sharing_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_mem_sharing_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_mem_sharing_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_mem_sharing_op_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_mem_sharing_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_audit_p2m {
    pub orphans: u64,
    pub m2p_bad: u64,
    pub p2m_bad: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_audit_p2m() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_audit_p2m>(),
        24usize,
        concat!("Size of: ", stringify!(xen_domctl_audit_p2m))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_audit_p2m>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_audit_p2m))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_audit_p2m>())).orphans as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_audit_p2m),
            "::",
            stringify!(orphans)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_audit_p2m>())).m2p_bad as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_audit_p2m),
            "::",
            stringify!(m2p_bad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_audit_p2m>())).p2m_bad as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_audit_p2m),
            "::",
            stringify!(p2m_bad)
        )
    );
}
pub type xen_domctl_audit_p2m_t = xen_domctl_audit_p2m;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_audit_p2m_t {
    pub p: *mut xen_domctl_audit_p2m_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_audit_p2m_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_audit_p2m_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_audit_p2m_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_audit_p2m_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_audit_p2m_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_audit_p2m_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_audit_p2m_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_audit_p2m_t {
    pub p: *const xen_domctl_audit_p2m_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_audit_p2m_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_audit_p2m_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_audit_p2m_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_audit_p2m_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_audit_p2m_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_audit_p2m_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_audit_p2m_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_set_virq_handler {
    pub virq: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_set_virq_handler() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_set_virq_handler>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_set_virq_handler))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_set_virq_handler>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_set_virq_handler))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_set_virq_handler>())).virq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_set_virq_handler),
            "::",
            stringify!(virq)
        )
    );
}
pub type xen_domctl_set_virq_handler_t = xen_domctl_set_virq_handler;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_set_virq_handler_t {
    pub p: *mut xen_domctl_set_virq_handler_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_set_virq_handler_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_set_virq_handler_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_set_virq_handler_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_set_virq_handler_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_set_virq_handler_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_set_virq_handler_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_set_virq_handler_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_set_virq_handler_t {
    pub p: *const xen_domctl_set_virq_handler_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_set_virq_handler_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_set_virq_handler_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_set_virq_handler_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_set_virq_handler_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_set_virq_handler_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_set_virq_handler_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_set_virq_handler_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_vcpuextstate {
    pub vcpu: u32,
    pub xfeature_mask: u64,
    pub size: u64,
    pub buffer: __guest_handle_uint64,
}
#[test]
fn bindgen_test_layout_xen_domctl_vcpuextstate() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_vcpuextstate>(),
        32usize,
        concat!("Size of: ", stringify!(xen_domctl_vcpuextstate))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_vcpuextstate>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_vcpuextstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpuextstate>())).vcpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpuextstate),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_vcpuextstate>())).xfeature_mask as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpuextstate),
            "::",
            stringify!(xfeature_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpuextstate>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpuextstate),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpuextstate>())).buffer as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpuextstate),
            "::",
            stringify!(buffer)
        )
    );
}
pub type xen_domctl_vcpuextstate_t = xen_domctl_vcpuextstate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_vcpuextstate_t {
    pub p: *mut xen_domctl_vcpuextstate_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_vcpuextstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_vcpuextstate_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_vcpuextstate_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_vcpuextstate_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_vcpuextstate_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_vcpuextstate_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_vcpuextstate_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_vcpuextstate_t {
    pub p: *const xen_domctl_vcpuextstate_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_vcpuextstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_vcpuextstate_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_vcpuextstate_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_vcpuextstate_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_vcpuextstate_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_vcpuextstate_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_vcpuextstate_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_set_access_required {
    pub access_required: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_set_access_required() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_set_access_required>(),
        1usize,
        concat!("Size of: ", stringify!(xen_domctl_set_access_required))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_set_access_required>(),
        1usize,
        concat!("Alignment of ", stringify!(xen_domctl_set_access_required))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_set_access_required>())).access_required as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_set_access_required),
            "::",
            stringify!(access_required)
        )
    );
}
pub type xen_domctl_set_access_required_t = xen_domctl_set_access_required;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_set_access_required_t {
    pub p: *mut xen_domctl_set_access_required_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_set_access_required_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_set_access_required_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_set_access_required_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_set_access_required_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_set_access_required_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_set_access_required_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_set_access_required_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_set_access_required_t {
    pub p: *const xen_domctl_set_access_required_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_set_access_required_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_set_access_required_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_set_access_required_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_set_access_required_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_set_access_required_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_set_access_required_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_set_access_required_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_set_broken_page_p2m {
    pub pfn: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_set_broken_page_p2m() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_set_broken_page_p2m>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_set_broken_page_p2m))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_set_broken_page_p2m>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_set_broken_page_p2m))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_set_broken_page_p2m>())).pfn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_set_broken_page_p2m),
            "::",
            stringify!(pfn)
        )
    );
}
pub type xen_domctl_set_broken_page_p2m_t = xen_domctl_set_broken_page_p2m;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_set_broken_page_p2m_t {
    pub p: *mut xen_domctl_set_broken_page_p2m_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_set_broken_page_p2m_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_set_broken_page_p2m_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_set_broken_page_p2m_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_set_broken_page_p2m_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_set_broken_page_p2m_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_set_broken_page_p2m_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_set_broken_page_p2m_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_set_broken_page_p2m_t {
    pub p: *const xen_domctl_set_broken_page_p2m_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_set_broken_page_p2m_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_set_broken_page_p2m_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_set_broken_page_p2m_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_set_broken_page_p2m_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_set_broken_page_p2m_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_set_broken_page_p2m_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_set_broken_page_p2m_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_set_max_evtchn {
    pub max_port: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_set_max_evtchn() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_set_max_evtchn>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_set_max_evtchn))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_set_max_evtchn>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_set_max_evtchn))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_set_max_evtchn>())).max_port as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_set_max_evtchn),
            "::",
            stringify!(max_port)
        )
    );
}
pub type xen_domctl_set_max_evtchn_t = xen_domctl_set_max_evtchn;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_set_max_evtchn_t {
    pub p: *mut xen_domctl_set_max_evtchn_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_set_max_evtchn_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_set_max_evtchn_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_set_max_evtchn_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_set_max_evtchn_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_set_max_evtchn_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_set_max_evtchn_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_set_max_evtchn_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_set_max_evtchn_t {
    pub p: *const xen_domctl_set_max_evtchn_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_set_max_evtchn_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_set_max_evtchn_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_set_max_evtchn_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_set_max_evtchn_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_set_max_evtchn_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_set_max_evtchn_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_set_max_evtchn_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_cacheflush {
    pub start_pfn: xen_pfn_t,
    pub nr_pfns: xen_pfn_t,
}
#[test]
fn bindgen_test_layout_xen_domctl_cacheflush() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_cacheflush>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_cacheflush))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_cacheflush>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_cacheflush))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_cacheflush>())).start_pfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_cacheflush),
            "::",
            stringify!(start_pfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_cacheflush>())).nr_pfns as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_cacheflush),
            "::",
            stringify!(nr_pfns)
        )
    );
}
pub type xen_domctl_cacheflush_t = xen_domctl_cacheflush;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_cacheflush_t {
    pub p: *mut xen_domctl_cacheflush_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_cacheflush_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_cacheflush_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_cacheflush_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_cacheflush_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_cacheflush_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_cacheflush_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_cacheflush_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_cacheflush_t {
    pub p: *const xen_domctl_cacheflush_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_cacheflush_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_cacheflush_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_cacheflush_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_cacheflush_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_cacheflush_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_cacheflush_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_cacheflush_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_vcpu_msr {
    pub index: u32,
    pub reserved: u32,
    pub value: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_vcpu_msr() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_vcpu_msr>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_vcpu_msr))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_vcpu_msr>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_vcpu_msr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpu_msr>())).index as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpu_msr),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpu_msr>())).reserved as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpu_msr),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpu_msr>())).value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpu_msr),
            "::",
            stringify!(value)
        )
    );
}
pub type xen_domctl_vcpu_msr_t = xen_domctl_vcpu_msr;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_vcpu_msr_t {
    pub p: *mut xen_domctl_vcpu_msr_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_vcpu_msr_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_vcpu_msr_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_vcpu_msr_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_vcpu_msr_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_vcpu_msr_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_vcpu_msr_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_vcpu_msr_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_vcpu_msr_t {
    pub p: *const xen_domctl_vcpu_msr_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_vcpu_msr_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_vcpu_msr_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_vcpu_msr_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_vcpu_msr_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_vcpu_msr_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_vcpu_msr_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_vcpu_msr_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_vcpu_msrs {
    pub vcpu: u32,
    pub msr_count: u32,
    pub msrs: __guest_handle_xen_domctl_vcpu_msr_t,
}
#[test]
fn bindgen_test_layout_xen_domctl_vcpu_msrs() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_vcpu_msrs>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_vcpu_msrs))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_vcpu_msrs>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_vcpu_msrs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpu_msrs>())).vcpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpu_msrs),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpu_msrs>())).msr_count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpu_msrs),
            "::",
            stringify!(msr_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vcpu_msrs>())).msrs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vcpu_msrs),
            "::",
            stringify!(msrs)
        )
    );
}
pub type xen_domctl_vcpu_msrs_t = xen_domctl_vcpu_msrs;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_vcpu_msrs_t {
    pub p: *mut xen_domctl_vcpu_msrs_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_vcpu_msrs_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_vcpu_msrs_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_vcpu_msrs_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_vcpu_msrs_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_vcpu_msrs_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_vcpu_msrs_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_vcpu_msrs_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_vcpu_msrs_t {
    pub p: *const xen_domctl_vcpu_msrs_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_vcpu_msrs_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_vcpu_msrs_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_vcpu_msrs_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_vcpu_msrs_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_vcpu_msrs_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_vcpu_msrs_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_vcpu_msrs_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_vnuma {
    pub nr_vnodes: u32,
    pub nr_vmemranges: u32,
    pub nr_vcpus: u32,
    pub pad: u32,
    pub vdistance: __guest_handle_uint,
    pub vcpu_to_vnode: __guest_handle_uint,
    pub vnode_to_pnode: __guest_handle_uint,
    pub vmemrange: __guest_handle_xen_vmemrange_t,
}
#[test]
fn bindgen_test_layout_xen_domctl_vnuma() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_vnuma>(),
        48usize,
        concat!("Size of: ", stringify!(xen_domctl_vnuma))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_vnuma>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_vnuma))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vnuma>())).nr_vnodes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vnuma),
            "::",
            stringify!(nr_vnodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vnuma>())).nr_vmemranges as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vnuma),
            "::",
            stringify!(nr_vmemranges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vnuma>())).nr_vcpus as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vnuma),
            "::",
            stringify!(nr_vcpus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vnuma>())).pad as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vnuma),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vnuma>())).vdistance as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vnuma),
            "::",
            stringify!(vdistance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vnuma>())).vcpu_to_vnode as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vnuma),
            "::",
            stringify!(vcpu_to_vnode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vnuma>())).vnode_to_pnode as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vnuma),
            "::",
            stringify!(vnode_to_pnode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_vnuma>())).vmemrange as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_vnuma),
            "::",
            stringify!(vmemrange)
        )
    );
}
pub type xen_domctl_vnuma_t = xen_domctl_vnuma;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_vnuma_t {
    pub p: *mut xen_domctl_vnuma_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_vnuma_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_vnuma_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_domctl_vnuma_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_vnuma_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_vnuma_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_vnuma_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_vnuma_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_vnuma_t {
    pub p: *const xen_domctl_vnuma_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_vnuma_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_vnuma_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_vnuma_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_vnuma_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_vnuma_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_vnuma_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_vnuma_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_psr_cmt_op {
    pub cmd: u32,
    pub data: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_psr_cmt_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_psr_cmt_op>(),
        8usize,
        concat!("Size of: ", stringify!(xen_domctl_psr_cmt_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_psr_cmt_op>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_psr_cmt_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_psr_cmt_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_psr_cmt_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_psr_cmt_op>())).data as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_psr_cmt_op),
            "::",
            stringify!(data)
        )
    );
}
pub type xen_domctl_psr_cmt_op_t = xen_domctl_psr_cmt_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_psr_cmt_op_t {
    pub p: *mut xen_domctl_psr_cmt_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_psr_cmt_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_psr_cmt_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_psr_cmt_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_psr_cmt_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_psr_cmt_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_psr_cmt_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_psr_cmt_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_psr_cmt_op_t {
    pub p: *const xen_domctl_psr_cmt_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_psr_cmt_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_psr_cmt_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_psr_cmt_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_psr_cmt_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_psr_cmt_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_psr_cmt_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_psr_cmt_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_domctl_monitor_op {
    pub op: u32,
    pub event: u32,
    pub u: xen_domctl_monitor_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_domctl_monitor_op__bindgen_ty_1 {
    pub mov_to_cr: xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1,
    pub mov_to_msr: xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2,
    pub guest_request: xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3,
    pub debug_exception: xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4,
    _bindgen_union_align: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1 {
    pub index: u8,
    pub sync: u8,
    pub onchangeonly: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1>(),
        3usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1>())).index
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1>())).sync
                as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(sync)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1>()))
                .onchangeonly as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(onchangeonly)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2 {
    pub msr: u32,
}
#[test]
fn bindgen_test_layout_xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2>())).msr
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(msr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3 {
    pub sync: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3>())).sync
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(sync)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4 {
    pub sync: u8,
}
#[test]
fn bindgen_test_layout_xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4>())).sync
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(sync)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_monitor_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_monitor_op__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(xen_domctl_monitor_op__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_monitor_op__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1>())).mov_to_cr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1),
            "::",
            stringify!(mov_to_cr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1>())).mov_to_msr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1),
            "::",
            stringify!(mov_to_msr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1>())).guest_request
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1),
            "::",
            stringify!(guest_request)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl_monitor_op__bindgen_ty_1>())).debug_exception
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op__bindgen_ty_1),
            "::",
            stringify!(debug_exception)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl_monitor_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_monitor_op>(),
        12usize,
        concat!("Size of: ", stringify!(xen_domctl_monitor_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_monitor_op>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_domctl_monitor_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_monitor_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_monitor_op>())).event as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op),
            "::",
            stringify!(event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_monitor_op>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_monitor_op),
            "::",
            stringify!(u)
        )
    );
}
pub type xen_domctl_monitor_op_t = xen_domctl_monitor_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_monitor_op_t {
    pub p: *mut xen_domctl_monitor_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_monitor_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_monitor_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_monitor_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_monitor_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_monitor_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_monitor_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_monitor_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_monitor_op_t {
    pub p: *const xen_domctl_monitor_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_monitor_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_monitor_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_monitor_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_monitor_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_monitor_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_monitor_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_monitor_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_domctl_psr_cat_op {
    pub cmd: u32,
    pub target: u32,
    pub data: u64,
}
#[test]
fn bindgen_test_layout_xen_domctl_psr_cat_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl_psr_cat_op>(),
        16usize,
        concat!("Size of: ", stringify!(xen_domctl_psr_cat_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl_psr_cat_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl_psr_cat_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_psr_cat_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_psr_cat_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_psr_cat_op>())).target as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_psr_cat_op),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl_psr_cat_op>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl_psr_cat_op),
            "::",
            stringify!(data)
        )
    );
}
pub type xen_domctl_psr_cat_op_t = xen_domctl_psr_cat_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_psr_cat_op_t {
    pub p: *mut xen_domctl_psr_cat_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_psr_cat_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_psr_cat_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_domctl_psr_cat_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_psr_cat_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_domctl_psr_cat_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_domctl_psr_cat_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_psr_cat_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_psr_cat_op_t {
    pub p: *const xen_domctl_psr_cat_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_psr_cat_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_psr_cat_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_domctl_psr_cat_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_psr_cat_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_psr_cat_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_psr_cat_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_psr_cat_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_domctl {
    pub cmd: u32,
    pub interface_version: u32,
    pub domain: domid_t,
    pub u: xen_domctl__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_domctl__bindgen_ty_1 {
    pub createdomain: xen_domctl_createdomain,
    pub getdomaininfo: xen_domctl_getdomaininfo,
    pub getmemlist: xen_domctl_getmemlist,
    pub getpageframeinfo3: xen_domctl_getpageframeinfo3,
    pub nodeaffinity: xen_domctl_nodeaffinity,
    pub vcpuaffinity: xen_domctl_vcpuaffinity,
    pub shadow_op: xen_domctl_shadow_op,
    pub max_mem: xen_domctl_max_mem,
    pub vcpucontext: xen_domctl_vcpucontext,
    pub getvcpuinfo: xen_domctl_getvcpuinfo,
    pub max_vcpus: xen_domctl_max_vcpus,
    pub scheduler_op: xen_domctl_scheduler_op,
    pub setdomainhandle: xen_domctl_setdomainhandle,
    pub setdebugging: xen_domctl_setdebugging,
    pub irq_permission: xen_domctl_irq_permission,
    pub iomem_permission: xen_domctl_iomem_permission,
    pub ioport_permission: xen_domctl_ioport_permission,
    pub hypercall_init: xen_domctl_hypercall_init,
    pub settimeoffset: xen_domctl_settimeoffset,
    pub disable_migrate: xen_domctl_disable_migrate,
    pub tsc_info: xen_domctl_tsc_info,
    pub hvmcontext: xen_domctl_hvmcontext,
    pub hvmcontext_partial: xen_domctl_hvmcontext_partial,
    pub address_size: xen_domctl_address_size,
    pub sendtrigger: xen_domctl_sendtrigger,
    pub get_device_group: xen_domctl_get_device_group,
    pub assign_device: xen_domctl_assign_device,
    pub bind_pt_irq: xen_domctl_bind_pt_irq,
    pub memory_mapping: xen_domctl_memory_mapping,
    pub ioport_mapping: xen_domctl_ioport_mapping,
    pub pin_mem_cacheattr: xen_domctl_pin_mem_cacheattr,
    pub ext_vcpucontext: xen_domctl_ext_vcpucontext,
    pub set_target: xen_domctl_set_target,
    pub subscribe: xen_domctl_subscribe,
    pub debug_op: xen_domctl_debug_op,
    pub vm_event_op: xen_domctl_vm_event_op,
    pub mem_sharing_op: xen_domctl_mem_sharing_op,
    pub cpuid: xen_domctl_cpuid,
    pub vcpuextstate: xen_domctl_vcpuextstate,
    pub vcpu_msrs: xen_domctl_vcpu_msrs,
    pub access_required: xen_domctl_set_access_required,
    pub audit_p2m: xen_domctl_audit_p2m,
    pub set_virq_handler: xen_domctl_set_virq_handler,
    pub set_max_evtchn: xen_domctl_set_max_evtchn,
    pub gdbsx_guest_memio: xen_domctl_gdbsx_memio,
    pub set_broken_page_p2m: xen_domctl_set_broken_page_p2m,
    pub cacheflush: xen_domctl_cacheflush,
    pub gdbsx_pauseunp_vcpu: xen_domctl_gdbsx_pauseunp_vcpu,
    pub gdbsx_domstatus: xen_domctl_gdbsx_domstatus,
    pub vnuma: xen_domctl_vnuma,
    pub psr_cmt_op: xen_domctl_psr_cmt_op,
    pub monitor_op: xen_domctl_monitor_op,
    pub psr_cat_op: xen_domctl_psr_cat_op,
    pub pad: [u8; 128usize],
    _bindgen_union_align: [u64; 16usize],
}
#[test]
fn bindgen_test_layout_xen_domctl__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl__bindgen_ty_1>(),
        128usize,
        concat!("Size of: ", stringify!(xen_domctl__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).createdomain as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(createdomain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).getdomaininfo as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(getdomaininfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).getmemlist as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(getmemlist)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).getpageframeinfo3 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(getpageframeinfo3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).nodeaffinity as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(nodeaffinity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).vcpuaffinity as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(vcpuaffinity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).shadow_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(shadow_op)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).max_mem as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(max_mem)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).vcpucontext as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(vcpucontext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).getvcpuinfo as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(getvcpuinfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).max_vcpus as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(max_vcpus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).scheduler_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(scheduler_op)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).setdomainhandle as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(setdomainhandle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).setdebugging as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(setdebugging)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).irq_permission as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(irq_permission)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).iomem_permission as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(iomem_permission)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).ioport_permission as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(ioport_permission)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).hypercall_init as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(hypercall_init)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).settimeoffset as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(settimeoffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).disable_migrate as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(disable_migrate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).tsc_info as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(tsc_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).hvmcontext as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(hvmcontext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).hvmcontext_partial as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(hvmcontext_partial)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).address_size as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(address_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).sendtrigger as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(sendtrigger)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).get_device_group as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(get_device_group)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).assign_device as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(assign_device)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).bind_pt_irq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(bind_pt_irq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).memory_mapping as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(memory_mapping)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).ioport_mapping as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(ioport_mapping)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).pin_mem_cacheattr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(pin_mem_cacheattr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).ext_vcpucontext as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(ext_vcpucontext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).set_target as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(set_target)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).subscribe as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(subscribe)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).debug_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(debug_op)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).vm_event_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(vm_event_op)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).mem_sharing_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(mem_sharing_op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).cpuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(cpuid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).vcpuextstate as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(vcpuextstate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).vcpu_msrs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(vcpu_msrs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).access_required as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(access_required)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).audit_p2m as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(audit_p2m)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).set_virq_handler as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(set_virq_handler)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).set_max_evtchn as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(set_max_evtchn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).gdbsx_guest_memio as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(gdbsx_guest_memio)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).set_broken_page_p2m as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(set_broken_page_p2m)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).cacheflush as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(cacheflush)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).gdbsx_pauseunp_vcpu as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(gdbsx_pauseunp_vcpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).gdbsx_domstatus as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(gdbsx_domstatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).vnuma as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(vnuma)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).psr_cmt_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(psr_cmt_op)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).monitor_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(monitor_op)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).psr_cat_op as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(psr_cat_op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl__bindgen_ty_1>())).pad as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_domctl() {
    assert_eq!(
        ::std::mem::size_of::<xen_domctl>(),
        144usize,
        concat!("Size of: ", stringify!(xen_domctl))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_domctl>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_domctl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl>())).interface_version as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl),
            "::",
            stringify!(interface_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl>())).domain as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl),
            "::",
            stringify!(domain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_domctl>())).u as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_domctl),
            "::",
            stringify!(u)
        )
    );
}
pub type xen_domctl_t = xen_domctl;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_domctl_t {
    pub p: *mut xen_domctl_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_domctl_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_domctl_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_domctl_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_domctl_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_xen_domctl_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_xen_domctl_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_domctl_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_domctl_t {
    pub p: *const xen_domctl_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_domctl_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_domctl_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_xen_domctl_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_domctl_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_domctl_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_domctl_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_domctl_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_tmem_oid {
    pub oid: [u64; 3usize],
}
#[test]
fn bindgen_test_layout_xen_tmem_oid() {
    assert_eq!(
        ::std::mem::size_of::<xen_tmem_oid>(),
        24usize,
        concat!("Size of: ", stringify!(xen_tmem_oid))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_tmem_oid>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_tmem_oid))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_tmem_oid>())).oid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_tmem_oid),
            "::",
            stringify!(oid)
        )
    );
}
pub type xen_tmem_oid_t = xen_tmem_oid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_tmem_oid_t {
    pub p: *mut xen_tmem_oid_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_tmem_oid_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_tmem_oid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_tmem_oid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_tmem_oid_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_xen_tmem_oid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_xen_tmem_oid_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_tmem_oid_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_tmem_oid_t {
    pub p: *const xen_tmem_oid_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_tmem_oid_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_tmem_oid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_xen_tmem_oid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_tmem_oid_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_tmem_oid_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_tmem_oid_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_tmem_oid_t),
            "::",
            stringify!(p)
        )
    );
}
pub type tmem_cli_va_t = __guest_handle_char;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct tmem_op {
    pub cmd: u32,
    pub pool_id: i32,
    pub u: tmem_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union tmem_op__bindgen_ty_1 {
    pub creat: tmem_op__bindgen_ty_1__bindgen_ty_1,
    pub gen: tmem_op__bindgen_ty_1__bindgen_ty_2,
    _bindgen_union_align: [u64; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tmem_op__bindgen_ty_1__bindgen_ty_1 {
    pub uuid: [u64; 2usize],
    pub flags: u32,
    pub arg1: u32,
}
#[test]
fn bindgen_test_layout_tmem_op__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<tmem_op__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(tmem_op__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<tmem_op__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_1>())).uuid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(uuid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_1>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_1>())).arg1 as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(arg1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tmem_op__bindgen_ty_1__bindgen_ty_2 {
    pub oid: xen_tmem_oid_t,
    pub index: u32,
    pub tmem_offset: u32,
    pub pfn_offset: u32,
    pub len: u32,
    pub cmfn: xen_pfn_t,
}
#[test]
fn bindgen_test_layout_tmem_op__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<tmem_op__bindgen_ty_1__bindgen_ty_2>(),
        48usize,
        concat!("Size of: ", stringify!(tmem_op__bindgen_ty_1__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<tmem_op__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_2>())).oid as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(oid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_2>())).index as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_2>())).tmem_offset as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(tmem_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_2>())).pfn_offset as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(pfn_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_2>())).len as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<tmem_op__bindgen_ty_1__bindgen_ty_2>())).cmfn as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(cmfn)
        )
    );
}
#[test]
fn bindgen_test_layout_tmem_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<tmem_op__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(tmem_op__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<tmem_op__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(tmem_op__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tmem_op__bindgen_ty_1>())).creat as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1),
            "::",
            stringify!(creat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tmem_op__bindgen_ty_1>())).gen as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op__bindgen_ty_1),
            "::",
            stringify!(gen)
        )
    );
}
#[test]
fn bindgen_test_layout_tmem_op() {
    assert_eq!(
        ::std::mem::size_of::<tmem_op>(),
        56usize,
        concat!("Size of: ", stringify!(tmem_op))
    );
    assert_eq!(
        ::std::mem::align_of::<tmem_op>(),
        8usize,
        concat!("Alignment of ", stringify!(tmem_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tmem_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tmem_op>())).pool_id as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op),
            "::",
            stringify!(pool_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tmem_op>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tmem_op),
            "::",
            stringify!(u)
        )
    );
}
pub type tmem_op_t = tmem_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_tmem_op_t {
    pub p: *mut tmem_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_tmem_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_tmem_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_tmem_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_tmem_op_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_tmem_op_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_tmem_op_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_tmem_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_tmem_op_t {
    pub p: *const tmem_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_tmem_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_tmem_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_tmem_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_tmem_op_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_const_tmem_op_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_tmem_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_tmem_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_readconsole {
    pub clear: u8,
    pub incremental: u8,
    pub pad0: u8,
    pub pad1: u8,
    pub index: u32,
    pub buffer: __guest_handle_char,
    pub count: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_readconsole() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_readconsole>(),
        24usize,
        concat!("Size of: ", stringify!(xen_sysctl_readconsole))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_readconsole>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_readconsole))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_readconsole>())).clear as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_readconsole),
            "::",
            stringify!(clear)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_readconsole>())).incremental as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_readconsole),
            "::",
            stringify!(incremental)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_readconsole>())).pad0 as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_readconsole),
            "::",
            stringify!(pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_readconsole>())).pad1 as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_readconsole),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_readconsole>())).index as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_readconsole),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_readconsole>())).buffer as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_readconsole),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_readconsole>())).count as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_readconsole),
            "::",
            stringify!(count)
        )
    );
}
pub type xen_sysctl_readconsole_t = xen_sysctl_readconsole;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_readconsole_t {
    pub p: *mut xen_sysctl_readconsole_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_readconsole_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_readconsole_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_readconsole_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_readconsole_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_readconsole_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_readconsole_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_readconsole_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_readconsole_t {
    pub p: *const xen_sysctl_readconsole_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_readconsole_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_readconsole_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_readconsole_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_readconsole_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_readconsole_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_readconsole_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_readconsole_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_tbuf_op {
    pub cmd: u32,
    pub cpu_mask: xenctl_bitmap,
    pub evt_mask: u32,
    pub buffer_mfn: u64,
    pub size: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_tbuf_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_tbuf_op>(),
        48usize,
        concat!("Size of: ", stringify!(xen_sysctl_tbuf_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_tbuf_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_tbuf_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_tbuf_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_tbuf_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_tbuf_op>())).cpu_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_tbuf_op),
            "::",
            stringify!(cpu_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_tbuf_op>())).evt_mask as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_tbuf_op),
            "::",
            stringify!(evt_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_tbuf_op>())).buffer_mfn as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_tbuf_op),
            "::",
            stringify!(buffer_mfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_tbuf_op>())).size as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_tbuf_op),
            "::",
            stringify!(size)
        )
    );
}
pub type xen_sysctl_tbuf_op_t = xen_sysctl_tbuf_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_tbuf_op_t {
    pub p: *mut xen_sysctl_tbuf_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_tbuf_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_tbuf_op_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_sysctl_tbuf_op_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_tbuf_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_tbuf_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_tbuf_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_tbuf_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_tbuf_op_t {
    pub p: *const xen_sysctl_tbuf_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_tbuf_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_tbuf_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_tbuf_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_tbuf_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_tbuf_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_tbuf_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_tbuf_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_physinfo {
    pub threads_per_core: u32,
    pub cores_per_socket: u32,
    pub nr_cpus: u32,
    pub max_cpu_id: u32,
    pub nr_nodes: u32,
    pub max_node_id: u32,
    pub cpu_khz: u32,
    pub total_pages: u64,
    pub free_pages: u64,
    pub scrub_pages: u64,
    pub outstanding_pages: u64,
    pub hw_cap: [u32; 8usize],
    pub capabilities: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_physinfo() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_physinfo>(),
        104usize,
        concat!("Size of: ", stringify!(xen_sysctl_physinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_physinfo>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_physinfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_physinfo>())).threads_per_core as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(threads_per_core)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_physinfo>())).cores_per_socket as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(cores_per_socket)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).nr_cpus as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(nr_cpus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).max_cpu_id as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(max_cpu_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).nr_nodes as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(nr_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).max_node_id as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(max_node_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).cpu_khz as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(cpu_khz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).total_pages as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(total_pages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).free_pages as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(free_pages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).scrub_pages as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(scrub_pages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_physinfo>())).outstanding_pages as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(outstanding_pages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_physinfo>())).hw_cap as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(hw_cap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_physinfo>())).capabilities as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_physinfo),
            "::",
            stringify!(capabilities)
        )
    );
}
pub type xen_sysctl_physinfo_t = xen_sysctl_physinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_physinfo_t {
    pub p: *mut xen_sysctl_physinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_physinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_physinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_physinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_physinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_physinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_physinfo_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_physinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_physinfo_t {
    pub p: *const xen_sysctl_physinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_physinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_physinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_physinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_physinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_physinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_physinfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_physinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_sched_id {
    pub sched_id: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_sched_id() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_sched_id>(),
        4usize,
        concat!("Size of: ", stringify!(xen_sysctl_sched_id))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_sched_id>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_sysctl_sched_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_sched_id>())).sched_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_sched_id),
            "::",
            stringify!(sched_id)
        )
    );
}
pub type xen_sysctl_sched_id_t = xen_sysctl_sched_id;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_sched_id_t {
    pub p: *mut xen_sysctl_sched_id_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_sched_id_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_sched_id_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_sched_id_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_sched_id_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_sched_id_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_sched_id_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_sched_id_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_sched_id_t {
    pub p: *const xen_sysctl_sched_id_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_sched_id_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_sched_id_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_sched_id_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_sched_id_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_sched_id_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_sched_id_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_sched_id_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_sysctl_perfc_desc {
    pub name: [::std::os::raw::c_char; 80usize],
    pub nr_vals: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_perfc_desc() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_perfc_desc>(),
        84usize,
        concat!("Size of: ", stringify!(xen_sysctl_perfc_desc))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_perfc_desc>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_sysctl_perfc_desc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_perfc_desc>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_perfc_desc),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_perfc_desc>())).nr_vals as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_perfc_desc),
            "::",
            stringify!(nr_vals)
        )
    );
}
pub type xen_sysctl_perfc_desc_t = xen_sysctl_perfc_desc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_perfc_desc_t {
    pub p: *mut xen_sysctl_perfc_desc_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_perfc_desc_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_perfc_desc_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_perfc_desc_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_perfc_desc_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_perfc_desc_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_perfc_desc_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_perfc_desc_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_perfc_desc_t {
    pub p: *const xen_sysctl_perfc_desc_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_perfc_desc_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_perfc_desc_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_desc_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_perfc_desc_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_desc_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_perfc_desc_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_desc_t),
            "::",
            stringify!(p)
        )
    );
}
pub type xen_sysctl_perfc_val_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_perfc_val_t {
    pub p: *mut xen_sysctl_perfc_val_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_perfc_val_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_perfc_val_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_perfc_val_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_perfc_val_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_perfc_val_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_perfc_val_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_perfc_val_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_perfc_val_t {
    pub p: *const xen_sysctl_perfc_val_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_perfc_val_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_perfc_val_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_val_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_perfc_val_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_val_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_perfc_val_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_val_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_perfc_op {
    pub cmd: u32,
    pub nr_counters: u32,
    pub nr_vals: u32,
    pub desc: __guest_handle_xen_sysctl_perfc_desc_t,
    pub val: __guest_handle_xen_sysctl_perfc_val_t,
}
#[test]
fn bindgen_test_layout_xen_sysctl_perfc_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_perfc_op>(),
        32usize,
        concat!("Size of: ", stringify!(xen_sysctl_perfc_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_perfc_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_perfc_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_perfc_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_perfc_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_perfc_op>())).nr_counters as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_perfc_op),
            "::",
            stringify!(nr_counters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_perfc_op>())).nr_vals as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_perfc_op),
            "::",
            stringify!(nr_vals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_perfc_op>())).desc as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_perfc_op),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_perfc_op>())).val as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_perfc_op),
            "::",
            stringify!(val)
        )
    );
}
pub type xen_sysctl_perfc_op_t = xen_sysctl_perfc_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_perfc_op_t {
    pub p: *mut xen_sysctl_perfc_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_perfc_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_perfc_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_perfc_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_perfc_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_perfc_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_perfc_op_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_perfc_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_perfc_op_t {
    pub p: *const xen_sysctl_perfc_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_perfc_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_perfc_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_perfc_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_perfc_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_perfc_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_getdomaininfolist {
    pub first_domain: domid_t,
    pub max_domains: u32,
    pub buffer: __guest_handle_xen_domctl_getdomaininfo_t,
    pub num_domains: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_getdomaininfolist() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_getdomaininfolist>(),
        24usize,
        concat!("Size of: ", stringify!(xen_sysctl_getdomaininfolist))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_getdomaininfolist>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_getdomaininfolist))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_getdomaininfolist>())).first_domain as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_getdomaininfolist),
            "::",
            stringify!(first_domain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_getdomaininfolist>())).max_domains as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_getdomaininfolist),
            "::",
            stringify!(max_domains)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_getdomaininfolist>())).buffer as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_getdomaininfolist),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_getdomaininfolist>())).num_domains as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_getdomaininfolist),
            "::",
            stringify!(num_domains)
        )
    );
}
pub type xen_sysctl_getdomaininfolist_t = xen_sysctl_getdomaininfolist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_getdomaininfolist_t {
    pub p: *mut xen_sysctl_getdomaininfolist_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_getdomaininfolist_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_getdomaininfolist_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_getdomaininfolist_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_getdomaininfolist_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_getdomaininfolist_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_getdomaininfolist_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_getdomaininfolist_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_getdomaininfolist_t {
    pub p: *const xen_sysctl_getdomaininfolist_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_getdomaininfolist_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_getdomaininfolist_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_getdomaininfolist_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_getdomaininfolist_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_getdomaininfolist_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_getdomaininfolist_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_getdomaininfolist_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_debug_keys {
    pub keys: __guest_handle_char,
    pub nr_keys: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_debug_keys() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_debug_keys>(),
        16usize,
        concat!("Size of: ", stringify!(xen_sysctl_debug_keys))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_debug_keys>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_debug_keys))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_debug_keys>())).keys as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_debug_keys),
            "::",
            stringify!(keys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_debug_keys>())).nr_keys as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_debug_keys),
            "::",
            stringify!(nr_keys)
        )
    );
}
pub type xen_sysctl_debug_keys_t = xen_sysctl_debug_keys;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_debug_keys_t {
    pub p: *mut xen_sysctl_debug_keys_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_debug_keys_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_debug_keys_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_debug_keys_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_debug_keys_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_debug_keys_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_debug_keys_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_debug_keys_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_debug_keys_t {
    pub p: *const xen_sysctl_debug_keys_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_debug_keys_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_debug_keys_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_debug_keys_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_debug_keys_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_debug_keys_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_debug_keys_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_debug_keys_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_cpuinfo {
    pub idletime: u64,
}
#[test]
fn bindgen_test_layout_xen_sysctl_cpuinfo() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_cpuinfo>(),
        8usize,
        concat!("Size of: ", stringify!(xen_sysctl_cpuinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_cpuinfo>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_cpuinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpuinfo>())).idletime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpuinfo),
            "::",
            stringify!(idletime)
        )
    );
}
pub type xen_sysctl_cpuinfo_t = xen_sysctl_cpuinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_cpuinfo_t {
    pub p: *mut xen_sysctl_cpuinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_cpuinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_cpuinfo_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_sysctl_cpuinfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_cpuinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_cpuinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_cpuinfo_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_cpuinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_cpuinfo_t {
    pub p: *const xen_sysctl_cpuinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_cpuinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_cpuinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_cpuinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_cpuinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_cpuinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_cpuinfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_cpuinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_getcpuinfo {
    pub max_cpus: u32,
    pub info: __guest_handle_xen_sysctl_cpuinfo_t,
    pub nr_cpus: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_getcpuinfo() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_getcpuinfo>(),
        24usize,
        concat!("Size of: ", stringify!(xen_sysctl_getcpuinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_getcpuinfo>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_getcpuinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_getcpuinfo>())).max_cpus as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_getcpuinfo),
            "::",
            stringify!(max_cpus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_getcpuinfo>())).info as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_getcpuinfo),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_getcpuinfo>())).nr_cpus as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_getcpuinfo),
            "::",
            stringify!(nr_cpus)
        )
    );
}
pub type xen_sysctl_getcpuinfo_t = xen_sysctl_getcpuinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_getcpuinfo_t {
    pub p: *mut xen_sysctl_getcpuinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_getcpuinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_getcpuinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_getcpuinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_getcpuinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_getcpuinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_getcpuinfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_getcpuinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_getcpuinfo_t {
    pub p: *const xen_sysctl_getcpuinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_getcpuinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_getcpuinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_getcpuinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_getcpuinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_getcpuinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_getcpuinfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_getcpuinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_availheap {
    pub min_bitwidth: u32,
    pub max_bitwidth: u32,
    pub node: i32,
    pub avail_bytes: u64,
}
#[test]
fn bindgen_test_layout_xen_sysctl_availheap() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_availheap>(),
        24usize,
        concat!("Size of: ", stringify!(xen_sysctl_availheap))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_availheap>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_availheap))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_availheap>())).min_bitwidth as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_availheap),
            "::",
            stringify!(min_bitwidth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_availheap>())).max_bitwidth as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_availheap),
            "::",
            stringify!(max_bitwidth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_availheap>())).node as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_availheap),
            "::",
            stringify!(node)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_availheap>())).avail_bytes as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_availheap),
            "::",
            stringify!(avail_bytes)
        )
    );
}
pub type xen_sysctl_availheap_t = xen_sysctl_availheap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_availheap_t {
    pub p: *mut xen_sysctl_availheap_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_availheap_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_availheap_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_availheap_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_availheap_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_availheap_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_availheap_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_availheap_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_availheap_t {
    pub p: *const xen_sysctl_availheap_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_availheap_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_availheap_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_availheap_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_availheap_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_availheap_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_availheap_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_availheap_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pm_px_val {
    pub freq: u64,
    pub residency: u64,
    pub count: u64,
}
#[test]
fn bindgen_test_layout_pm_px_val() {
    assert_eq!(
        ::std::mem::size_of::<pm_px_val>(),
        24usize,
        concat!("Size of: ", stringify!(pm_px_val))
    );
    assert_eq!(
        ::std::mem::align_of::<pm_px_val>(),
        8usize,
        concat!("Alignment of ", stringify!(pm_px_val))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_val>())).freq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_val),
            "::",
            stringify!(freq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_val>())).residency as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_val),
            "::",
            stringify!(residency)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_val>())).count as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_val),
            "::",
            stringify!(count)
        )
    );
}
pub type pm_px_val_t = pm_px_val;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_pm_px_val_t {
    pub p: *mut pm_px_val_t,
}
#[test]
fn bindgen_test_layout___guest_handle_pm_px_val_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_pm_px_val_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_pm_px_val_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_pm_px_val_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_pm_px_val_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_pm_px_val_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_pm_px_val_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_pm_px_val_t {
    pub p: *const pm_px_val_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_pm_px_val_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_pm_px_val_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_pm_px_val_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_pm_px_val_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_pm_px_val_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_pm_px_val_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_pm_px_val_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pm_px_stat {
    pub total: u8,
    pub usable: u8,
    pub last: u8,
    pub cur: u8,
    pub trans_pt: __guest_handle_uint64,
    pub pt: __guest_handle_pm_px_val_t,
}
#[test]
fn bindgen_test_layout_pm_px_stat() {
    assert_eq!(
        ::std::mem::size_of::<pm_px_stat>(),
        24usize,
        concat!("Size of: ", stringify!(pm_px_stat))
    );
    assert_eq!(
        ::std::mem::align_of::<pm_px_stat>(),
        8usize,
        concat!("Alignment of ", stringify!(pm_px_stat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_stat>())).total as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_stat),
            "::",
            stringify!(total)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_stat>())).usable as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_stat),
            "::",
            stringify!(usable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_stat>())).last as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_stat),
            "::",
            stringify!(last)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_stat>())).cur as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_stat),
            "::",
            stringify!(cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_stat>())).trans_pt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_stat),
            "::",
            stringify!(trans_pt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_px_stat>())).pt as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_px_stat),
            "::",
            stringify!(pt)
        )
    );
}
pub type pm_px_stat_t = pm_px_stat;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_pm_px_stat_t {
    pub p: *mut pm_px_stat_t,
}
#[test]
fn bindgen_test_layout___guest_handle_pm_px_stat_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_pm_px_stat_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_pm_px_stat_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_pm_px_stat_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__guest_handle_pm_px_stat_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__guest_handle_pm_px_stat_t>())).p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_pm_px_stat_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_pm_px_stat_t {
    pub p: *const pm_px_stat_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_pm_px_stat_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_pm_px_stat_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_const_pm_px_stat_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_pm_px_stat_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_pm_px_stat_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_pm_px_stat_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_pm_px_stat_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pm_cx_stat {
    pub nr: u32,
    pub last: u32,
    pub idle_time: u64,
    pub triggers: __guest_handle_uint64,
    pub residencies: __guest_handle_uint64,
    pub nr_pc: u32,
    pub nr_cc: u32,
    pub pc: __guest_handle_uint64,
    pub cc: __guest_handle_uint64,
}
#[test]
fn bindgen_test_layout_pm_cx_stat() {
    assert_eq!(
        ::std::mem::size_of::<pm_cx_stat>(),
        56usize,
        concat!("Size of: ", stringify!(pm_cx_stat))
    );
    assert_eq!(
        ::std::mem::align_of::<pm_cx_stat>(),
        8usize,
        concat!("Alignment of ", stringify!(pm_cx_stat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).last as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(last)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).idle_time as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(idle_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).triggers as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(triggers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).residencies as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(residencies)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).nr_pc as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(nr_pc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).nr_cc as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(nr_cc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).pc as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(pc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pm_cx_stat>())).cc as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pm_cx_stat),
            "::",
            stringify!(cc)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_sysctl_get_pmstat {
    pub type_: u32,
    pub cpuid: u32,
    pub u: xen_sysctl_get_pmstat__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_sysctl_get_pmstat__bindgen_ty_1 {
    pub getpx: pm_px_stat,
    pub getcx: pm_cx_stat,
    _bindgen_union_align: [u64; 7usize],
}
#[test]
fn bindgen_test_layout_xen_sysctl_get_pmstat__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_get_pmstat__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(xen_sysctl_get_pmstat__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_get_pmstat__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_sysctl_get_pmstat__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_get_pmstat__bindgen_ty_1>())).getpx as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_get_pmstat__bindgen_ty_1),
            "::",
            stringify!(getpx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_get_pmstat__bindgen_ty_1>())).getcx as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_get_pmstat__bindgen_ty_1),
            "::",
            stringify!(getcx)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_sysctl_get_pmstat() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_get_pmstat>(),
        64usize,
        concat!("Size of: ", stringify!(xen_sysctl_get_pmstat))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_get_pmstat>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_get_pmstat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_get_pmstat>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_get_pmstat),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_get_pmstat>())).cpuid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_get_pmstat),
            "::",
            stringify!(cpuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_get_pmstat>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_get_pmstat),
            "::",
            stringify!(u)
        )
    );
}
pub type xen_sysctl_get_pmstat_t = xen_sysctl_get_pmstat;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_get_pmstat_t {
    pub p: *mut xen_sysctl_get_pmstat_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_get_pmstat_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_get_pmstat_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_get_pmstat_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_get_pmstat_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_get_pmstat_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_get_pmstat_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_get_pmstat_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_get_pmstat_t {
    pub p: *const xen_sysctl_get_pmstat_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_get_pmstat_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_get_pmstat_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_get_pmstat_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_get_pmstat_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_get_pmstat_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_get_pmstat_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_get_pmstat_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_cpu_hotplug {
    pub cpu: u32,
    pub op: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_cpu_hotplug() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_cpu_hotplug>(),
        8usize,
        concat!("Size of: ", stringify!(xen_sysctl_cpu_hotplug))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_cpu_hotplug>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_sysctl_cpu_hotplug))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpu_hotplug>())).cpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpu_hotplug),
            "::",
            stringify!(cpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpu_hotplug>())).op as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpu_hotplug),
            "::",
            stringify!(op)
        )
    );
}
pub type xen_sysctl_cpu_hotplug_t = xen_sysctl_cpu_hotplug;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_cpu_hotplug_t {
    pub p: *mut xen_sysctl_cpu_hotplug_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_cpu_hotplug_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_cpu_hotplug_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_cpu_hotplug_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_cpu_hotplug_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_cpu_hotplug_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_cpu_hotplug_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_cpu_hotplug_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_cpu_hotplug_t {
    pub p: *const xen_sysctl_cpu_hotplug_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_cpu_hotplug_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_cpu_hotplug_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_cpu_hotplug_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_cpu_hotplug_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_cpu_hotplug_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_cpu_hotplug_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_cpu_hotplug_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_userspace {
    pub scaling_setspeed: u32,
}
#[test]
fn bindgen_test_layout_xen_userspace() {
    assert_eq!(
        ::std::mem::size_of::<xen_userspace>(),
        4usize,
        concat!("Size of: ", stringify!(xen_userspace))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_userspace>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_userspace))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_userspace>())).scaling_setspeed as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_userspace),
            "::",
            stringify!(scaling_setspeed)
        )
    );
}
pub type xen_userspace_t = xen_userspace;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_ondemand {
    pub sampling_rate_max: u32,
    pub sampling_rate_min: u32,
    pub sampling_rate: u32,
    pub up_threshold: u32,
}
#[test]
fn bindgen_test_layout_xen_ondemand() {
    assert_eq!(
        ::std::mem::size_of::<xen_ondemand>(),
        16usize,
        concat!("Size of: ", stringify!(xen_ondemand))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_ondemand>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_ondemand))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_ondemand>())).sampling_rate_max as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_ondemand),
            "::",
            stringify!(sampling_rate_max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_ondemand>())).sampling_rate_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_ondemand),
            "::",
            stringify!(sampling_rate_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_ondemand>())).sampling_rate as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_ondemand),
            "::",
            stringify!(sampling_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_ondemand>())).up_threshold as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_ondemand),
            "::",
            stringify!(up_threshold)
        )
    );
}
pub type xen_ondemand_t = xen_ondemand;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_get_cpufreq_para {
    pub cpu_num: u32,
    pub freq_num: u32,
    pub gov_num: u32,
    pub affected_cpus: __guest_handle_uint32,
    pub scaling_available_frequencies: __guest_handle_uint32,
    pub scaling_available_governors: __guest_handle_char,
    pub scaling_driver: [::std::os::raw::c_char; 16usize],
    pub cpuinfo_cur_freq: u32,
    pub cpuinfo_max_freq: u32,
    pub cpuinfo_min_freq: u32,
    pub scaling_cur_freq: u32,
    pub scaling_governor: [::std::os::raw::c_char; 16usize],
    pub scaling_max_freq: u32,
    pub scaling_min_freq: u32,
    pub u: xen_get_cpufreq_para__bindgen_ty_1,
    pub turbo_enabled: i32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_get_cpufreq_para__bindgen_ty_1 {
    pub userspace: xen_userspace,
    pub ondemand: xen_ondemand,
    _bindgen_union_align: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_xen_get_cpufreq_para__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_get_cpufreq_para__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(xen_get_cpufreq_para__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_get_cpufreq_para__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(xen_get_cpufreq_para__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para__bindgen_ty_1>())).userspace as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para__bindgen_ty_1),
            "::",
            stringify!(userspace)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para__bindgen_ty_1>())).ondemand as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para__bindgen_ty_1),
            "::",
            stringify!(ondemand)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_get_cpufreq_para() {
    assert_eq!(
        ::std::mem::size_of::<xen_get_cpufreq_para>(),
        120usize,
        concat!("Size of: ", stringify!(xen_get_cpufreq_para))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_get_cpufreq_para>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_get_cpufreq_para))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_get_cpufreq_para>())).cpu_num as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(cpu_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_get_cpufreq_para>())).freq_num as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(freq_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_get_cpufreq_para>())).gov_num as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(gov_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).affected_cpus as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(affected_cpus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).scaling_available_frequencies
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(scaling_available_frequencies)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).scaling_available_governors as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(scaling_available_governors)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).scaling_driver as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(scaling_driver)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).cpuinfo_cur_freq as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(cpuinfo_cur_freq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).cpuinfo_max_freq as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(cpuinfo_max_freq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).cpuinfo_min_freq as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(cpuinfo_min_freq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).scaling_cur_freq as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(scaling_cur_freq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).scaling_governor as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(scaling_governor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).scaling_max_freq as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(scaling_max_freq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).scaling_min_freq as *const _ as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(scaling_min_freq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_get_cpufreq_para>())).u as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_get_cpufreq_para>())).turbo_enabled as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_get_cpufreq_para),
            "::",
            stringify!(turbo_enabled)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_set_cpufreq_gov {
    pub scaling_governor: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout_xen_set_cpufreq_gov() {
    assert_eq!(
        ::std::mem::size_of::<xen_set_cpufreq_gov>(),
        16usize,
        concat!("Size of: ", stringify!(xen_set_cpufreq_gov))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_set_cpufreq_gov>(),
        1usize,
        concat!("Alignment of ", stringify!(xen_set_cpufreq_gov))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_set_cpufreq_gov>())).scaling_governor as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_set_cpufreq_gov),
            "::",
            stringify!(scaling_governor)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_set_cpufreq_para {
    pub ctrl_type: u32,
    pub ctrl_value: u32,
}
#[test]
fn bindgen_test_layout_xen_set_cpufreq_para() {
    assert_eq!(
        ::std::mem::size_of::<xen_set_cpufreq_para>(),
        8usize,
        concat!("Size of: ", stringify!(xen_set_cpufreq_para))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_set_cpufreq_para>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_set_cpufreq_para))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_set_cpufreq_para>())).ctrl_type as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_set_cpufreq_para),
            "::",
            stringify!(ctrl_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_set_cpufreq_para>())).ctrl_value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_set_cpufreq_para),
            "::",
            stringify!(ctrl_value)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_sysctl_pm_op {
    pub cmd: u32,
    pub cpuid: u32,
    pub u: xen_sysctl_pm_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union xen_sysctl_pm_op__bindgen_ty_1 {
    pub get_para: xen_get_cpufreq_para,
    pub set_gov: xen_set_cpufreq_gov,
    pub set_para: xen_set_cpufreq_para,
    pub get_avgfreq: u64,
    pub set_sched_opt_smt: u32,
    pub get_max_cstate: u32,
    pub set_max_cstate: u32,
    pub get_vcpu_migration_delay: u32,
    pub set_vcpu_migration_delay: u32,
    _bindgen_union_align: [u64; 15usize],
}
#[test]
fn bindgen_test_layout_xen_sysctl_pm_op__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_pm_op__bindgen_ty_1>(),
        120usize,
        concat!("Size of: ", stringify!(xen_sysctl_pm_op__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_pm_op__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_pm_op__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).get_para as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(get_para)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).set_gov as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(set_gov)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).set_para as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(set_para)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).get_avgfreq as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(get_avgfreq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).set_sched_opt_smt as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(set_sched_opt_smt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).get_max_cstate as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(get_max_cstate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).set_max_cstate as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(set_max_cstate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).get_vcpu_migration_delay
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(get_vcpu_migration_delay)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_pm_op__bindgen_ty_1>())).set_vcpu_migration_delay
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op__bindgen_ty_1),
            "::",
            stringify!(set_vcpu_migration_delay)
        )
    );
}
#[test]
fn bindgen_test_layout_xen_sysctl_pm_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_pm_op>(),
        128usize,
        concat!("Size of: ", stringify!(xen_sysctl_pm_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_pm_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_pm_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_pm_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_pm_op>())).cpuid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op),
            "::",
            stringify!(cpuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_pm_op>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_pm_op),
            "::",
            stringify!(u)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_page_offline_op {
    pub cmd: u32,
    pub start: u32,
    pub end: u32,
    pub status: __guest_handle_uint32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_page_offline_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_page_offline_op>(),
        24usize,
        concat!("Size of: ", stringify!(xen_sysctl_page_offline_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_page_offline_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_page_offline_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_page_offline_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_page_offline_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_page_offline_op>())).start as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_page_offline_op),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_page_offline_op>())).end as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_page_offline_op),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_page_offline_op>())).status as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_page_offline_op),
            "::",
            stringify!(status)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_sysctl_lockprof_data {
    pub name: [::std::os::raw::c_char; 40usize],
    pub type_: i32,
    pub idx: i32,
    pub lock_cnt: u64,
    pub block_cnt: u64,
    pub lock_time: u64,
    pub block_time: u64,
}
#[test]
fn bindgen_test_layout_xen_sysctl_lockprof_data() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_lockprof_data>(),
        80usize,
        concat!("Size of: ", stringify!(xen_sysctl_lockprof_data))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_lockprof_data>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_lockprof_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_lockprof_data>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_data),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_lockprof_data>())).type_ as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_data),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_lockprof_data>())).idx as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_data),
            "::",
            stringify!(idx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_lockprof_data>())).lock_cnt as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_data),
            "::",
            stringify!(lock_cnt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_lockprof_data>())).block_cnt as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_data),
            "::",
            stringify!(block_cnt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_lockprof_data>())).lock_time as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_data),
            "::",
            stringify!(lock_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_lockprof_data>())).block_time as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_data),
            "::",
            stringify!(block_time)
        )
    );
}
pub type xen_sysctl_lockprof_data_t = xen_sysctl_lockprof_data;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_lockprof_data_t {
    pub p: *mut xen_sysctl_lockprof_data_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_lockprof_data_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_lockprof_data_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_lockprof_data_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_lockprof_data_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_lockprof_data_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_lockprof_data_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_lockprof_data_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_lockprof_data_t {
    pub p: *const xen_sysctl_lockprof_data_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_lockprof_data_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_lockprof_data_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_lockprof_data_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_lockprof_data_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_lockprof_data_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_lockprof_data_t>())).p
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_lockprof_data_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_lockprof_op {
    pub cmd: u32,
    pub max_elem: u32,
    pub nr_elem: u32,
    pub time: u64,
    pub data: __guest_handle_xen_sysctl_lockprof_data_t,
}
#[test]
fn bindgen_test_layout_xen_sysctl_lockprof_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_lockprof_op>(),
        32usize,
        concat!("Size of: ", stringify!(xen_sysctl_lockprof_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_lockprof_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_lockprof_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_lockprof_op>())).cmd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_op),
            "::",
            stringify!(cmd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_lockprof_op>())).max_elem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_op),
            "::",
            stringify!(max_elem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_lockprof_op>())).nr_elem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_op),
            "::",
            stringify!(nr_elem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_lockprof_op>())).time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_op),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_lockprof_op>())).data as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_lockprof_op),
            "::",
            stringify!(data)
        )
    );
}
pub type xen_sysctl_lockprof_op_t = xen_sysctl_lockprof_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_lockprof_op_t {
    pub p: *mut xen_sysctl_lockprof_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_lockprof_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_lockprof_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_lockprof_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_lockprof_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_lockprof_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_lockprof_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_lockprof_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_lockprof_op_t {
    pub p: *const xen_sysctl_lockprof_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_lockprof_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_lockprof_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_lockprof_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_lockprof_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_lockprof_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_lockprof_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_lockprof_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_cputopo {
    pub core: u32,
    pub socket: u32,
    pub node: u32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_cputopo() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_cputopo>(),
        12usize,
        concat!("Size of: ", stringify!(xen_sysctl_cputopo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_cputopo>(),
        4usize,
        concat!("Alignment of ", stringify!(xen_sysctl_cputopo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cputopo>())).core as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cputopo),
            "::",
            stringify!(core)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cputopo>())).socket as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cputopo),
            "::",
            stringify!(socket)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cputopo>())).node as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cputopo),
            "::",
            stringify!(node)
        )
    );
}
pub type xen_sysctl_cputopo_t = xen_sysctl_cputopo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_cputopo_t {
    pub p: *mut xen_sysctl_cputopo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_cputopo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_cputopo_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_sysctl_cputopo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_cputopo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_cputopo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_cputopo_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_cputopo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_cputopo_t {
    pub p: *const xen_sysctl_cputopo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_cputopo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_cputopo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_cputopo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_cputopo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_cputopo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_cputopo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_cputopo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_cputopoinfo {
    pub num_cpus: u32,
    pub cputopo: __guest_handle_xen_sysctl_cputopo_t,
}
#[test]
fn bindgen_test_layout_xen_sysctl_cputopoinfo() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_cputopoinfo>(),
        16usize,
        concat!("Size of: ", stringify!(xen_sysctl_cputopoinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_cputopoinfo>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_cputopoinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cputopoinfo>())).num_cpus as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cputopoinfo),
            "::",
            stringify!(num_cpus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cputopoinfo>())).cputopo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cputopoinfo),
            "::",
            stringify!(cputopo)
        )
    );
}
pub type xen_sysctl_cputopoinfo_t = xen_sysctl_cputopoinfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_cputopoinfo_t {
    pub p: *mut xen_sysctl_cputopoinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_cputopoinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_cputopoinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_cputopoinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_cputopoinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_cputopoinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_cputopoinfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_cputopoinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_cputopoinfo_t {
    pub p: *const xen_sysctl_cputopoinfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_cputopoinfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_cputopoinfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_cputopoinfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_cputopoinfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_cputopoinfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_cputopoinfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_cputopoinfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_meminfo {
    pub memsize: u64,
    pub memfree: u64,
}
#[test]
fn bindgen_test_layout_xen_sysctl_meminfo() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_meminfo>(),
        16usize,
        concat!("Size of: ", stringify!(xen_sysctl_meminfo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_meminfo>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_meminfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_meminfo>())).memsize as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_meminfo),
            "::",
            stringify!(memsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_meminfo>())).memfree as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_meminfo),
            "::",
            stringify!(memfree)
        )
    );
}
pub type xen_sysctl_meminfo_t = xen_sysctl_meminfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_meminfo_t {
    pub p: *mut xen_sysctl_meminfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_meminfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_meminfo_t>(),
        8usize,
        concat!("Size of: ", stringify!(__guest_handle_xen_sysctl_meminfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_meminfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_meminfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_meminfo_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_meminfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_meminfo_t {
    pub p: *const xen_sysctl_meminfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_meminfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_meminfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_meminfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_meminfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_meminfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_meminfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_meminfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_numainfo {
    pub num_nodes: u32,
    pub meminfo: __guest_handle_xen_sysctl_meminfo_t,
    pub distance: __guest_handle_uint32,
}
#[test]
fn bindgen_test_layout_xen_sysctl_numainfo() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_numainfo>(),
        24usize,
        concat!("Size of: ", stringify!(xen_sysctl_numainfo))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_numainfo>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_numainfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_numainfo>())).num_nodes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_numainfo),
            "::",
            stringify!(num_nodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_numainfo>())).meminfo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_numainfo),
            "::",
            stringify!(meminfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_numainfo>())).distance as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_numainfo),
            "::",
            stringify!(distance)
        )
    );
}
pub type xen_sysctl_numainfo_t = xen_sysctl_numainfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_numainfo_t {
    pub p: *mut xen_sysctl_numainfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_numainfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_numainfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_numainfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_numainfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_numainfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_numainfo_t>())).p as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_numainfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_numainfo_t {
    pub p: *const xen_sysctl_numainfo_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_numainfo_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_numainfo_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_numainfo_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_numainfo_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_numainfo_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_numainfo_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_numainfo_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_cpupool_op {
    pub op: u32,
    pub cpupool_id: u32,
    pub sched_id: u32,
    pub domid: u32,
    pub cpu: u32,
    pub n_dom: u32,
    pub cpumap: xenctl_bitmap,
}
#[test]
fn bindgen_test_layout_xen_sysctl_cpupool_op() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_cpupool_op>(),
        40usize,
        concat!("Size of: ", stringify!(xen_sysctl_cpupool_op))
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_cpupool_op>(),
        8usize,
        concat!("Alignment of ", stringify!(xen_sysctl_cpupool_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpupool_op>())).op as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpupool_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_cpupool_op>())).cpupool_id as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpupool_op),
            "::",
            stringify!(cpupool_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpupool_op>())).sched_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpupool_op),
            "::",
            stringify!(sched_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpupool_op>())).domid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpupool_op),
            "::",
            stringify!(domid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpupool_op>())).cpu as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpupool_op),
            "::",
            stringify!(cpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpupool_op>())).n_dom as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpupool_op),
            "::",
            stringify!(n_dom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<xen_sysctl_cpupool_op>())).cpumap as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_cpupool_op),
            "::",
            stringify!(cpumap)
        )
    );
}
pub type xen_sysctl_cpupool_op_t = xen_sysctl_cpupool_op;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_xen_sysctl_cpupool_op_t {
    pub p: *mut xen_sysctl_cpupool_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_xen_sysctl_cpupool_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_xen_sysctl_cpupool_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_xen_sysctl_cpupool_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_xen_sysctl_cpupool_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_xen_sysctl_cpupool_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_xen_sysctl_cpupool_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_xen_sysctl_cpupool_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __guest_handle_const_xen_sysctl_cpupool_op_t {
    pub p: *const xen_sysctl_cpupool_op_t,
}
#[test]
fn bindgen_test_layout___guest_handle_const_xen_sysctl_cpupool_op_t() {
    assert_eq!(
        ::std::mem::size_of::<__guest_handle_const_xen_sysctl_cpupool_op_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__guest_handle_const_xen_sysctl_cpupool_op_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__guest_handle_const_xen_sysctl_cpupool_op_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__guest_handle_const_xen_sysctl_cpupool_op_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__guest_handle_const_xen_sysctl_cpupool_op_t>())).p as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__guest_handle_const_xen_sysctl_cpupool_op_t),
            "::",
            stringify!(p)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct xen_sysctl_arinc653_schedule {
    pub major_frame: u64,
    pub num_sched_entries: u8,
    pub sched_entries: [xen_sysctl_arinc653_schedule__bindgen_ty_1; 64usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xen_sysctl_arinc653_schedule__bindgen_ty_1 {
    pub dom_handle: xen_domain_handle_t,
    pub vcpu_id: ::std::os::raw::c_uint,
    pub runtime: u64,
}
#[test]
fn bindgen_test_layout_xen_sysctl_arinc653_schedule__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<xen_sysctl_arinc653_schedule__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(xen_sysctl_arinc653_schedule__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<xen_sysctl_arinc653_schedule__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(xen_sysctl_arinc653_schedule__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_arinc653_schedule__bindgen_ty_1>())).dom_handle
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(xen_sysctl_arinc653_schedule__bindgen_ty_1),
            "::",
            stringify!(dom_handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<xen_sysctl_arinc653_schedule__bindgen_ty_1>())).vcpu_id
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: 