#![doc(html_root_url = "https://codeberg.org/RustedTerrier/xekeys/wiki")]
#![feature(exclusive_range_pattern)]
pub fn get_keys() -> Keys {
    use std::{io, io::Read};
    let mut keys = io::stdin().bytes();
    let mut pressed = Keys { ..Default::default() };
    match keys.next().transpose().unwrap() {
        | Some(byte) => match byte {
            | b'\x1b' => match keys.next().transpose().unwrap() {
                | Some(b'[') => match keys.next().transpose().unwrap() {
                    | Some(b'1') => {
                        let mut next = keys.next().transpose().unwrap();
                        if next == Some(b';') {
                            next = keys.next().transpose().unwrap();
                        }
                        match next {
                            // Super
                            | Some(b'1') => match keys.next().transpose().unwrap() {
                                | Some(b'A') => {
                                    pressed.movement.up = true;
                                    pressed.mods.super_ = true;
                                },
                                | Some(b'B') => {
                                    pressed.movement.down = true;
                                    pressed.mods.super_ = true;
                                },
                                | Some(b'C') => {
                                    pressed.movement.right = true;
                                    pressed.mods.super_ = true;
                                },
                                | Some(b'D') => {
                                    pressed.movement.left = true;
                                    pressed.mods.super_ = true;
                                },
                                | Some(b'~') => pressed.special.function = Some(1),
                                | _ => {}
                            },
                            // Shift
                            | Some(b'2') => match keys.next().transpose().unwrap() {
                                | Some(b'A') => {
                                    pressed.movement.up = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'B') => {
                                    pressed.movement.down = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'C') => {
                                    pressed.movement.right = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'D') => {
                                    pressed.movement.left = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'~') => pressed.special.function = Some(2),
                                | _ => {}
                            },
                            // Alt
                            | Some(b'3') => match keys.next().transpose().unwrap() {
                                | Some(b'A') => {
                                    pressed.movement.up = true;
                                    pressed.mods.alt = true;
                                },
                                | Some(b'B') => {
                                    pressed.movement.down = true;
                                    pressed.mods.alt = true;
                                },
                                | Some(b'C') => {
                                    pressed.movement.right = true;
                                    pressed.mods.alt = true;
                                },
                                | Some(b'D') => {
                                    pressed.movement.left = true;
                                    pressed.mods.alt = true;
                                },
                                | Some(b'~') => pressed.special.function = Some(3),
                                | _ => {}
                            },
                            // Super and Shift
                            | Some(b'4') => match keys.next().transpose().unwrap() {
                                | Some(b'A') => {
                                    pressed.movement.up = true;
                                    pressed.mods.super_ = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'B') => {
                                    pressed.movement.down = true;
                                    pressed.mods.super_ = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'C') => {
                                    pressed.movement.right = true;
                                    pressed.mods.super_ = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'D') => {
                                    pressed.movement.left = true;
                                    pressed.mods.super_ = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'~') => pressed.special.function = Some(4),
                                | _ => {}
                            },
                            // Control
                            | Some(b'5') => match keys.next().transpose().unwrap() {
                                | Some(b'A') => {
                                    pressed.movement.up = true;
                                    pressed.mods.ctrl = true;
                                },
                                | Some(b'B') => {
                                    pressed.movement.down = true;
                                    pressed.mods.ctrl = true;
                                },
                                | Some(b'C') => {
                                    pressed.movement.right = true;
                                    pressed.mods.ctrl = true;
                                },
                                | Some(b'D') => {
                                    pressed.movement.left = true;
                                    pressed.mods.ctrl = true;
                                },
                                | Some(b'~') => pressed.special.function = Some(5),
                                | _ => {}
                            },
                            // Control and Shift
                            | Some(b'6') => match keys.next().transpose().unwrap() {
                                | Some(b'A') => {
                                    pressed.movement.up = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'B') => {
                                    pressed.movement.down = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'C') => {
                                    pressed.movement.right = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'D') => {
                                    pressed.movement.left = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.shift = true;
                                },
                                | _ => {}
                            },
                            // Alt + Control
                            | Some(b'7') => match keys.next().transpose().unwrap() {
                                | Some(b'A') => {
                                    pressed.movement.up = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.alt = true;
                                },
                                | Some(b'B') => {
                                    pressed.movement.down = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.alt = true;
                                },
                                | Some(b'C') => {
                                    pressed.movement.right = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.alt = true;
                                },
                                | Some(b'D') => {
                                    pressed.movement.left = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.alt = true;
                                },
                                | Some(b'~') => pressed.special.function = Some(6),
                                | _ => {}
                            },
                            // Control + Alt + Shift
                            | Some(b'8') => match keys.next().transpose().unwrap() {
                                | Some(b'A') => {
                                    pressed.movement.up = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.alt = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'B') => {
                                    pressed.movement.down = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.alt = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'C') => {
                                    pressed.movement.right = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.alt = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'D') => {
                                    pressed.movement.left = true;
                                    pressed.mods.ctrl = true;
                                    pressed.mods.alt = true;
                                    pressed.mods.shift = true;
                                },
                                | Some(b'~') => pressed.special.function = Some(7),
                                | _ => {}
                            },
                            | Some(b'9') => match keys.next().transpose().unwrap() {
                                | Some(b'~') => pressed.special.function = Some(8),
                                | _ => {}
                            },
                            | _ => pressed.special.escape = true
                        }
                    },
                    | Some(b'2') => match keys.next().transpose().unwrap() {
                        | Some(b'0') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(9),
                            | _ => {}
                        },
                        | Some(b'1') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(10),
                            | _ => {}
                        },
                        | Some(b'3') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(11),
                            | _ => {}
                        },
                        | Some(b'4') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(12),
                            | _ => {}
                        },
                        | Some(b'5') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(13),
                            | _ => {}
                        },
                        | Some(b'6') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(14),
                            | _ => {}
                        },
                        | Some(b'8') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(15),
                            | _ => {}
                        },
                        | Some(b'9') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(16),
                            | _ => {}
                        },
                        | _ => {}
                    },
                    | Some(b'3') => match keys.next().transpose().unwrap() {
                        | Some(b'~') => pressed.special.backspace = true,
                        | Some(b';') => match keys.next().transpose().unwrap() {
                            | Some(b'3') | Some(b'5') => match keys.next().transpose().unwrap() {
                                | Some(b'~') => {
                                    pressed.special.backspace = true;
                                    pressed.mods.alt = true;
                                },
                                | _ => {}
                            },
                            | _ => {}
                        },
                        | Some(b'1') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(17),
                            | _ => {}
                        },
                        | Some(b'2') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(18),
                            | _ => {}
                        },
                        | Some(b'3') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(19),
                            | _ => {}
                        },
                        | Some(b'4') => match keys.next().transpose().unwrap() {
                            | Some(b'~') => pressed.special.function = Some(20),
                            | _ => {}
                        },
                        | _ => {}
                    },
                    // Arrow keys
                    | Some(b'A') => pressed.movement.up = true,
                    | Some(b'B') => pressed.movement.down = true,
                    | Some(b'C') => pressed.movement.right = true,
                    | Some(b'D') => pressed.movement.left = true,
                    | _ => pressed.special.escape = true
                },
                | Some(b'O') => match keys.next().transpose().unwrap() {
                    | Some(b'P') => pressed.special.function = Some(1),
                    | Some(b'Q') => pressed.special.function = Some(2),
                    | Some(b'R') => pressed.special.function = Some(3),
                    | Some(b'S') => pressed.special.function = Some(4),
                    | _ => {}
                },
                | Some(b'\x1B') => pressed.special.escape = true,
                | Some(b'\x7f') => {
                    pressed.special.backspace = true;
                    pressed.mods.alt = true;
                },
                // I change it to \n because that's more intuitive(at least in my opinion)
                | Some(b'\r') | Some(b'\n') => {
                    pressed.letter = Some('\n');
                    pressed.mods.alt = true;
                },
                | Some(byte @ _) => {
                    pressed.mods.alt = true;
                    pressed.letter = Some((byte as char).to_ascii_lowercase());
                    if byte == byte.to_ascii_uppercase() {
                        pressed.mods.shift = true;
                    }
                },
                | None => {}
            },
            | _ => {
                match byte {
                    | b'0' => pressed.letter = Some('0'),
                    | b'1' => pressed.letter = Some('1'),
                    | b'2' => pressed.letter = Some('2'),
                    | b'3' => pressed.letter = Some('3'),
                    | b'4' => pressed.letter = Some('4'),
                    | b'5' => pressed.letter = Some('5'),
                    | b'6' => pressed.letter = Some('6'),
                    | b'7' => pressed.letter = Some('7'),
                    | b'8' => pressed.letter = Some('8'),
                    | b'9' => pressed.letter = Some('9'),
                    // I change it to \n because that's more intuitive(at least in my opinion)
                    | b'\r' | b'\n' => pressed.letter = Some('\n'),
                    | b'\t' => pressed.letter = Some('\t'),
                    | _ => match byte {
                        | b' ' ..= b'~' => {
                            pressed.letter = Some(byte.to_ascii_lowercase() as char);
                            if byte == byte.to_ascii_uppercase() {
                                pressed.mods.shift = true;
                            }
                        },
                        | b'\x7f' => pressed.special.backspace = true,
                        | b'\x00' .. b'\x1c' => {
                            pressed.letter = Some((byte + 96) as char);
                            pressed.mods.ctrl = true;
                            // This may not be true but it's not case sensitive
                            pressed.mods.shift = true;
                        },
                        | b'\x1c' ..= b'\x1f' => {
                            pressed.letter = Some((byte + 64) as char);
                            pressed.mods.ctrl = true;
                            // This may not be true but it's not case sensitive
                            pressed.mods.shift = true;
                        },
                        | _ => pressed.special.escape = true
                    }
                }
            }
        },
        | None => {}
    }
    pressed
}

#[derive(Clone, Default)]
pub struct Keys {
    pub mods:     Mods,
    pub movement: ArrowKeys,
    pub letter:   Option<char>,
    pub special:  Special
}

#[derive(Clone, Default)]
pub struct Mods {
    pub super_: bool,
    pub shift:  bool,
    pub ctrl:   bool,
    pub alt:    bool
}

#[derive(Clone, Default)]
pub struct ArrowKeys {
    pub right: bool,
    pub left:  bool,
    pub up:    bool,
    pub down:  bool
}

#[derive(Clone, Default)]
pub struct Special {
    pub function:  Option<u8>,
    pub escape:    bool,
    pub page_up:   bool,
    pub page_down: bool,
    pub backspace: bool
}
