# XEKEYS

A simple program to gather key-presses.

## Note: 
* None of the mod keys are case sensitive.
* Ctrl does not work on '-', ';', ''', ',', '.', '[' or '+'.
* Super only supports arrow keys as I found no way to support regular keys. Any pull requests on this issue would be appreciated.
* Raw mode is needed for most of the key detection.


## Simple example

```rust
extern crate xekeys;

use xekeys::get_keys;

fn main() {
    loop {
        // Here we get the keypresses as a struct.
        let keys = get_keys();

        // Here we check if q is pressed and control is pressed and if so, we break.
        if keys.letter == 'q' && keys.mods.ctrl {
            break;
        }
    }
}
```

## Motivation

When I was using termion, I came to the realization that I was unabled to detect ctrl+arrow keys, something I needed. So I made my own crate; but, to justify using this over termion, I added most of the functionality of termion key presses and some extra, such as more modifiers with arrow keys and function keys up to 20.

## License

XEKEYS uses BSD-3 clause.

## Planned Features:

 * Raw Mode
 * Readability

## More Info:

* [Structs](https://codeberg.org/RustedTerrier/xekeys/wiki/Structs/)
