use crate::CargoPackage;
use convert_case::{Case, Casing};
use chrono::Local;

pub(crate) struct SourceFileGenerator {
}

impl SourceFileGenerator {

    pub(crate) fn create_objc_header(package: &CargoPackage, is_macos: bool) -> String {
        let mut content = String::new();
        let ext = if is_macos { "_macos" } else { "_ios" };
        content.push_str("//\n");
        content.push_str(format!("//  {}{}.h\n", package.xcode_framework_name, ext).as_str());
        content.push_str(format!("//  {}{}\n", package.xcode_framework_name, ext).as_str());
        content.push_str("//\n");
        content.push_str(format!("//  Generated by {} - {}\n",
                                 clap::crate_name!().to_case(Case::Pascal),
                                 clap::crate_version!()).as_str());
        content.push_str(format!("//   on {} \n",
                                 Local::now()).as_str());
        content.push_str("//\n\n");

        content.push_str("#import <Foundation/Foundation.h>\n\n\n");
        content.push_str(format!("//! Project version number for {}{}.\n", package.xcode_framework_name, ext).as_str());
        content.push_str(format!("FOUNDATION_EXPORT double {}{}VersionNumber;\n\n", package.xcode_framework_name, ext).as_str());

        content.push_str(format!("//! Project version string for {}{}.\n", package.xcode_framework_name, ext).as_str());
        content.push_str(format!("FOUNDATION_EXPORT const unsigned char {}{}VersionString[];\n\n", package.xcode_framework_name, ext).as_str());

        content.push_str(format!("// In this header, you should import all the public headers of your framework using statements like #import <{}{}/PublicHeader.h>\n\n", package.xcode_framework_name, ext).as_str());
        content
    }

    pub(crate) fn create_docc_file(package: &CargoPackage, is_macos: bool) -> String {
        let mut content = String::new();
        let ext = if is_macos { "_macos" } else { "_ios" };
        content.push_str(format!("# ``{}{}``\n\n", package.xcode_framework_name, ext).as_str());
        content.push_str("<!--@START_MENU_TOKEN@-->Summary<!--@END_MENU_TOKEN@-->\n\n");
        content.push_str("## Overview");
        content.push_str("<!--@START_MENU_TOKEN@-->Text<!--@END_MENU_TOKEN@-->\n\n");
        content.push_str("## Topics\n\n");
        content.push_str("### <!--@START_MENU_TOKEN@-->Group<!--@END_MENU_TOKEN@-->\n\n");
        content.push_str("- <!--@START_MENU_TOKEN@-->``Symbol``<!--@END_MENU_TOKEN@-->");
        content
    }

    pub(crate) fn create_swift_file(package: &CargoPackage, is_macos: bool) -> String {
        let mut content = String::new();
        let ext = if is_macos { "_macos" } else { "_ios" };
        content.push_str("//\n");
        content.push_str(format!("//  {}{}Tests.h\n", package.xcode_framework_name, ext).as_str());
        content.push_str(format!("//  {}{}Tests\n", package.xcode_framework_name, ext).as_str());
        content.push_str("//\n");
        content.push_str(format!("//  Generated by {} - {}\n",
                                 clap::crate_name!().to_case(Case::Pascal),
                                 clap::crate_version!()).as_str());
        content.push_str(format!("//   on {} \n",
                                 Local::now()).as_str());
        content.push_str("//\n\n");

        content.push_str("import XCTest\n");
        content.push_str(format!("@testable import {}{}\n\n", package.xcode_framework_name, ext).as_str());
        content.push_str(format!("class {}{}Tests: XCTestCase {{\n\n", package.xcode_framework_name, ext).as_str());
        content.push_str("    override func setUpWithError() throws {\n");
        content.push_str("        // Put teardown code here. This method is called after the invocation of each test method in the class.\n    }\n\n");
        content.push_str("    func testExample() throws {\n        // This is an example of a functional test case.\n");
        content.push_str("        // Use XCTAssert and related functions to verify your tests produce the correct results.\n");
        content.push_str("        // Any test you write for XCTest can be annotated as throws and async.\n");
        content.push_str("        // Mark your test throws to produce an unexpected failure when your test encounters an uncaught error.\n");
        content.push_str("        // Mark your test async to allow awaiting for asynchronous code to complete. Check the results with assertions afterwards.\n    }\n\n");
        content.push_str("    func testPerformanceExample() throws {\n        // This is an example of a performance test case.\n");
        content.push_str("        self.measure {\n            // Put the code you want to measure the time of here.\n");
        content.push_str("        }\n    }\n\n}\n");
        content
    }
}