//importing required deps
use scraper::{Html, Selector};

#[tokio::main]

//The "main" function !!! This is Option because of clap!
pub async fn xchangeit(amount: Option<&str>, from: Option<&str>, to: Option<&str>) -> Result<(), Box<dyn std::error::Error>> {

    //formatting the url to actually get where the user wants to get!
    let url_final = format!("https://www.xe.com/currencyconverter/convert/?Amount={:?}&From={:?}&To={:?}", amount.unwrap_or_default(), from.unwrap_or_default(), to.unwrap_or_default());

    let url = url_final.replace("\"", "");

    //this line is for testing!
    //println!("{}", url);

    let req = reqwest::get(url).await?;

    //this line is for testing!
    //println!("{:?}", req);

    //fragment
    let fragment = Html::parse_fragment(&req.text().await?);

    //the "filter" for the element
    let selector = Selector::parse(".iGrAod").unwrap();

    //actually looking for the element!
    for elem in fragment.select(&selector) {
        println!("{}", elem.text().collect::<String>().trim());
    }

    Ok(())

}

