// Copyright 2014 The syscall.rs Project Developers. See the
// COPYRIGHT file at the top-level directory of this distribution.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

//! System call numbers for x86-64 Linux.

pub const READ: isize = 0;
pub const WRITE: isize = 1;
pub const OPEN: isize = 2;
pub const CLOSE: isize = 3;
pub const STAT: isize = 4;
pub const FSTAT: isize = 5;
pub const LSTAT: isize = 6;
pub const POLL: isize = 7;
pub const LSEEK: isize = 8;
pub const MMAP: isize = 9;
pub const MPROTECT: isize = 10;
pub const MUNMAP: isize = 11;
pub const BRK: isize = 12;
pub const RT_SIGACTION: isize = 13;
pub const RT_SIGPROCMASK: isize = 14;
pub const RT_SIGRETURN: isize = 15;
pub const IOCTL: isize = 16;
pub const PREAD64: isize = 17;
pub const PWRITE64: isize = 18;
pub const READV: isize = 19;
pub const WRITEV: isize = 20;
pub const ACCESS: isize = 21;
pub const PIPE: isize = 22;
pub const SELECT: isize = 23;
pub const SCHED_YIELD: isize = 24;
pub const MREMAP: isize = 25;
pub const MSYNC: isize = 26;
pub const MINCORE: isize = 27;
pub const MADVISE: isize = 28;
pub const SHMGET: isize = 29;
pub const SHMAT: isize = 30;
pub const SHMCTL: isize = 31;
pub const DUP: isize = 32;
pub const DUP2: isize = 33;
pub const PAUSE: isize = 34;
pub const NANOSLEEP: isize = 35;
pub const GETITIMER: isize = 36;
pub const ALARM: isize = 37;
pub const SETITIMER: isize = 38;
pub const GETPID: isize = 39;
pub const SENDFILE: isize = 40;
pub const SOCKET: isize = 41;
pub const CONNECT: isize = 42;
pub const ACCEPT: isize = 43;
pub const SENDTO: isize = 44;
pub const RECVFROM: isize = 45;
pub const SENDMSG: isize = 46;
pub const RECVMSG: isize = 47;
pub const SHUTDOWN: isize = 48;
pub const BIND: isize = 49;
pub const LISTEN: isize = 50;
pub const GETSOCKNAME: isize = 51;
pub const GETPEERNAME: isize = 52;
pub const SOCKETPAIR: isize = 53;
pub const SETSOCKOPT: isize = 54;
pub const GETSOCKOPT: isize = 55;
pub const CLONE: isize = 56;
pub const FORK: isize = 57;
pub const VFORK: isize = 58;
pub const EXECVE: isize = 59;
pub const EXIT: isize = 60;
pub const WAIT4: isize = 61;
pub const KILL: isize = 62;
pub const UNAME: isize = 63;
pub const SEMGET: isize = 64;
pub const SEMOP: isize = 65;
pub const SEMCTL: isize = 66;
pub const SHMDT: isize = 67;
pub const MSGGET: isize = 68;
pub const MSGSND: isize = 69;
pub const MSGRCV: isize = 70;
pub const MSGCTL: isize = 71;
pub const FCNTL: isize = 72;
pub const FLOCK: isize = 73;
pub const FSYNC: isize = 74;
pub const FDATASYNC: isize = 75;
pub const TRUNCATE: isize = 76;
pub const FTRUNCATE: isize = 77;
pub const GETDENTS: isize = 78;
pub const GETCWD: isize = 79;
pub const CHDIR: isize = 80;
pub const FCHDIR: isize = 81;
pub const RENAME: isize = 82;
pub const MKDIR: isize = 83;
pub const RMDIR: isize = 84;
pub const CREAT: isize = 85;
pub const LINK: isize = 86;
pub const UNLINK: isize = 87;
pub const SYMLINK: isize = 88;
pub const READLINK: isize = 89;
pub const CHMOD: isize = 90;
pub const FCHMOD: isize = 91;
pub const CHOWN: isize = 92;
pub const FCHOWN: isize = 93;
pub const LCHOWN: isize = 94;
pub const UMASK: isize = 95;
pub const GETTIMEOFDAY: isize = 96;
pub const GETRLIMIT: isize = 97;
pub const GETRUSAGE: isize = 98;
pub const SYSINFO: isize = 99;
pub const TIMES: isize = 100;
pub const PTRACE: isize = 101;
pub const GETUID: isize = 102;
pub const SYSLOG: isize = 103;
pub const GETGID: isize = 104;
pub const SETUID: isize = 105;
pub const SETGID: isize = 106;
pub const GETEUID: isize = 107;
pub const GETEGID: isize = 108;
pub const SETPGID: isize = 109;
pub const GETPPID: isize = 110;
pub const GETPGRP: isize = 111;
pub const SETSID: isize = 112;
pub const SETREUID: isize = 113;
pub const SETREGID: isize = 114;
pub const GETGROUPS: isize = 115;
pub const SETGROUPS: isize = 116;
pub const SETRESUID: isize = 117;
pub const GETRESUID: isize = 118;
pub const SETRESGID: isize = 119;
pub const GETRESGID: isize = 120;
pub const GETPGID: isize = 121;
pub const SETFSUID: isize = 122;
pub const SETFSGID: isize = 123;
pub const GETSID: isize = 124;
pub const CAPGET: isize = 125;
pub const CAPSET: isize = 126;
pub const RT_SIGPENDING: isize = 127;
pub const RT_SIGTIMEDWAIT: isize = 128;
pub const RT_SIGQUEUEINFO: isize = 129;
pub const RT_SIGSUSPEND: isize = 130;
pub const SIGALTSTACK: isize = 131;
pub const UTIME: isize = 132;
pub const MKNOD: isize = 133;
pub const USELIB: isize = 134;
pub const PERSONALITY: isize = 135;
pub const USTAT: isize = 136;
pub const STATFS: isize = 137;
pub const FSTATFS: isize = 138;
pub const SYSFS: isize = 139;
pub const GETPRIORITY: isize = 140;
pub const SETPRIORITY: isize = 141;
pub const SCHED_SETPARAM: isize = 142;
pub const SCHED_GETPARAM: isize = 143;
pub const SCHED_SETSCHEDULER: isize = 144;
pub const SCHED_GETSCHEDULER: isize = 145;
pub const SCHED_GET_PRIORITY_MAX: isize = 146;
pub const SCHED_GET_PRIORITY_MIN: isize = 147;
pub const SCHED_RR_GET_INTERVAL: isize = 148;
pub const MLOCK: isize = 149;
pub const MUNLOCK: isize = 150;
pub const MLOCKALL: isize = 151;
pub const MUNLOCKALL: isize = 152;
pub const VHANGUP: isize = 153;
pub const MODIFY_LDT: isize = 154;
pub const PIVOT_ROOT: isize = 155;
pub const _SYSCTL: isize = 156;
pub const PRCTL: isize = 157;
pub const ARCH_PRCTL: isize = 158;
pub const ADJTIMEX: isize = 159;
pub const SETRLIMIT: isize = 160;
pub const CHROOT: isize = 161;
pub const SYNC: isize = 162;
pub const ACCT: isize = 163;
pub const SETTIMEOFDAY: isize = 164;
pub const MOUNT: isize = 165;
pub const UMOUNT2: isize = 166;
pub const SWAPON: isize = 167;
pub const SWAPOFF: isize = 168;
pub const REBOOT: isize = 169;
pub const SETHOSTNAME: isize = 170;
pub const SETDOMAINNAME: isize = 171;
pub const IOPL: isize = 172;
pub const IOPERM: isize = 173;
pub const CREATE_MODULE: isize = 174;
pub const INIT_MODULE: isize = 175;
pub const DELETE_MODULE: isize = 176;
pub const GET_KERNEL_SYMS: isize = 177;
pub const QUERY_MODULE: isize = 178;
pub const QUOTACTL: isize = 179;
pub const NFSSERVCTL: isize = 180;
pub const GETPMSG: isize = 181;
pub const PUTPMSG: isize = 182;
pub const AFS_SYSCALL: isize = 183;
pub const TUXCALL: isize = 184;
pub const SECURITY: isize = 185;
pub const GETTID: isize = 186;
pub const READAHEAD: isize = 187;
pub const SETXATTR: isize = 188;
pub const LSETXATTR: isize = 189;
pub const FSETXATTR: isize = 190;
pub const GETXATTR: isize = 191;
pub const LGETXATTR: isize = 192;
pub const FGETXATTR: isize = 193;
pub const LISTXATTR: isize = 194;
pub const LLISTXATTR: isize = 195;
pub const FLISTXATTR: isize = 196;
pub const REMOVEXATTR: isize = 197;
pub const LREMOVEXATTR: isize = 198;
pub const FREMOVEXATTR: isize = 199;
pub const TKILL: isize = 200;
pub const TIME: isize = 201;
pub const FUTEX: isize = 202;
pub const SCHED_SETAFFINITY: isize = 203;
pub const SCHED_GETAFFINITY: isize = 204;
pub const SET_THREAD_AREA: isize = 205;
pub const IO_SETUP: isize = 206;
pub const IO_DESTROY: isize = 207;
pub const IO_GETEVENTS: isize = 208;
pub const IO_SUBMIT: isize = 209;
pub const IO_CANCEL: isize = 210;
pub const GET_THREAD_AREA: isize = 211;
pub const LOOKUP_DCOOKIE: isize = 212;
pub const EPOLL_CREATE: isize = 213;
pub const EPOLL_CTL_OLD: isize = 214;
pub const EPOLL_WAIT_OLD: isize = 215;
pub const REMAP_FILE_PAGES: isize = 216;
pub const GETDENTS64: isize = 217;
pub const SET_TID_ADDRESS: isize = 218;
pub const RESTART_SYSCALL: isize = 219;
pub const SEMTIMEDOP: isize = 220;
pub const FADVISE64: isize = 221;
pub const TIMER_CREATE: isize = 222;
pub const TIMER_SETTIME: isize = 223;
pub const TIMER_GETTIME: isize = 224;
pub const TIMER_GETOVERRUN: isize = 225;
pub const TIMER_DELETE: isize = 226;
pub const CLOCK_SETTIME: isize = 227;
pub const CLOCK_GETTIME: isize = 228;
pub const CLOCK_GETRES: isize = 229;
pub const CLOCK_NANOSLEEP: isize = 230;
pub const EXIT_GROUP: isize = 231;
pub const EPOLL_WAIT: isize = 232;
pub const EPOLL_CTL: isize = 233;
pub const TGKILL: isize = 234;
pub const UTIMES: isize = 235;
pub const VSERVER: isize = 236;
pub const MBIND: isize = 237;
pub const SET_MEMPOLICY: isize = 238;
pub const GET_MEMPOLICY: isize = 239;
pub const MQ_OPEN: isize = 240;
pub const MQ_UNLINK: isize = 241;
pub const MQ_TIMEDSEND: isize = 242;
pub const MQ_TIMEDRECEIVE: isize = 243;
pub const MQ_NOTIFY: isize = 244;
pub const MQ_GETSETATTR: isize = 245;
pub const KEXEC_LOAD: isize = 246;
pub const WAITID: isize = 247;
pub const ADD_KEY: isize = 248;
pub const REQUEST_KEY: isize = 249;
pub const KEYCTL: isize = 250;
pub const IOPRIO_SET: isize = 251;
pub const IOPRIO_GET: isize = 252;
pub const INOTIFY_INIT: isize = 253;
pub const INOTIFY_ADD_WATCH: isize = 254;
pub const INOTIFY_RM_WATCH: isize = 255;
pub const MIGRATE_PAGES: isize = 256;
pub const OPENAT: isize = 257;
pub const MKDIRAT: isize = 258;
pub const MKNODAT: isize = 259;
pub const FCHOWNAT: isize = 260;
pub const FUTIMESAT: isize = 261;
pub const NEWFSTATAT: isize = 262;
pub const UNLINKAT: isize = 263;
pub const RENAMEAT: isize = 264;
pub const LINKAT: isize = 265;
pub const SYMLINKAT: isize = 266;
pub const READLINKAT: isize = 267;
pub const FCHMODAT: isize = 268;
pub const FACCESSAT: isize = 269;
pub const PSELECT6: isize = 270;
pub const PPOLL: isize = 271;
pub const UNSHARE: isize = 272;
pub const SET_ROBUST_LIST: isize = 273;
pub const GET_ROBUST_LIST: isize = 274;
pub const SPLICE: isize = 275;
pub const TEE: isize = 276;
pub const SYNC_FILE_RANGE: isize = 277;
pub const VMSPLICE: isize = 278;
pub const MOVE_PAGES: isize = 279;
pub const UTIMENSAT: isize = 280;
pub const EPOLL_PWAIT: isize = 281;
pub const SIGNALFD: isize = 282;
pub const TIMERFD_CREATE: isize = 283;
pub const EVENTFD: isize = 284;
pub const FALLOCATE: isize = 285;
pub const TIMERFD_SETTIME: isize = 286;
pub const TIMERFD_GETTIME: isize = 287;
pub const ACCEPT4: isize = 288;
pub const SIGNALFD4: isize = 289;
pub const EVENTFD2: isize = 290;
pub const EPOLL_CREATE1: isize = 291;
pub const DUP3: isize = 292;
pub const PIPE2: isize = 293;
pub const INOTIFY_INIT1: isize = 294;
pub const PREADV: isize = 295;
pub const PWRITEV: isize = 296;
pub const RT_TGSIGQUEUEINFO: isize = 297;
pub const PERF_EVENT_OPEN: isize = 298;
pub const RECVMMSG: isize = 299;
pub const FANOTIFY_INIT: isize = 300;
pub const FANOTIFY_MARK: isize = 301;
pub const PRLIMIT64: isize = 302;
pub const NAME_TO_HANDLE_AT: isize = 303;
pub const OPEN_BY_HANDLE_AT: isize = 304;
pub const CLOCK_ADJTIME: isize = 305;
pub const SYNCFS: isize = 306;
pub const SENDMMSG: isize = 307;
pub const SETNS: isize = 308;
pub const GETCPU: isize = 309;
pub const PROCESS_VM_READV: isize = 310;
pub const PROCESS_VM_WRITEV: isize = 311;
pub const KCMP: isize = 312;
pub const FINIT_MODULE: isize = 313;
pub const SCHED_SETATTR: isize = 314;
pub const SCHED_GETATTR: isize = 315;
pub const RENAMEAT2: isize = 316;
pub const SECCOMP: isize = 317;
pub const GETRANDOM: isize = 318;
pub const MEMFD_CREATE: isize = 319;
pub const KEXEC_FILE_LOAD: isize = 320;
pub const BPF: isize = 321;
pub const EXECVEAT: isize = 322;
