use std::path::Path;
use chrono::{Local, Utc};
use std::fmt;
use ansi_term::Color;

#[derive(Copy, Clone, Debug)]
pub enum Timezone {
    None,
    Utc,
    Local,
}

pub(crate) static DEFAULT_TIME_FORMAT: &str = "%Y-%m-%d %H:%M:%S";

pub fn format_time(timezone: &Timezone) -> String {
    match timezone {
        Timezone::None => "".to_string(),
        Timezone::Local => format!("{} ", Local::now().format(DEFAULT_TIME_FORMAT)),
        Timezone::Utc => format!("{} ", Utc::now().format(DEFAULT_TIME_FORMAT)),
    }
}

pub fn format_path(path: &str, line: u32) -> String {
    let path = Path::new(path);
    let pathname = path.file_stem().unwrap().to_owned().into_string().unwrap();
    // let pathname = path.file_name().unwrap().to_owned().into_string().unwrap();
    let pathname = format!("{}:{}", pathname, line);
    pathname
}

pub fn __print_val(path: &str, line: u32, args :fmt::Arguments) {
    let timestamp = format_time(&Timezone::Local);
    let mut path_str = format_path(path, line);

    // timestamp = Color::Fixed(250).paint(timestamp).to_string();
    path_str = Color::Blue.paint(path_str).to_string();

    let mut color_msg = format!("{}", args);
    color_msg = Color::Purple.paint(color_msg).to_string();

    let message = format!("{}{} {}", timestamp, path_str, color_msg);
    println!("{}", message);
}

