
use log::{Level, LevelFilter, Log, Metadata, Record, SetLoggerError};

// use chrono::{Local, Utc};

enum Timezone {
    None,
    Utc,
    Local,
}

static LOG_LEVEL_NAMES: [&str; 6] = ["N/A", "E", "W", "I", "D", "T"];

fn level_to_str(l: &Level) -> &'static str {
    LOG_LEVEL_NAMES[*l as usize]
}

pub struct XLog {
    level: LevelFilter,
}

impl XLog {

}