<img align="right" width="30%" height="30%" src="https://preview.ibb.co/ePa1eH/wu_dragon.png" alt="wu_dragon">

# Wu

[![Foo](https://user-images.githubusercontent.com/7288322/34429152-141689f8-ecb9-11e7-8003-b5a10a5fcb29.png)](https://discord.gg/qm92sPP)
[![MIT License](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/wu-lang/wu/blob/master/LICENSE)

An expression oriented, gradually typed and mission-critical programming language.

## Syntax

A full walk-through of the language can be found over at the [wu-lang documentation](https://wu-lang.gitbook.io/guide/).

### Details

Wu strives to be a decently useful language with focus on control, readability and scalability. The syntax of Wu is heavily inspired by the strong and safe one of Rust, while keeping the advantages of being high-level and gradually typed. The language is meant and designed to be a solid alternative to Python, Lua and MoonScript, while being superior on control and maintainability.

### Example

<img src="https://i.ibb.co/TtJP6DQ/code.png" alt="code" border="0">

## Selling points

- [x] Compiles to Lua
- [x] Gradual typing
- [x] Rust-like trait system
- [x] Expression oriented design
- [x] Perfect Lua interoperability
- [x] Match patterns
- [x] Cool logo
- [ ] You are using it

## Libraries

- [`lover`](https://github.com/nilq/lover): Type-safe bindings for the Love2D game engine.
- [`std`](https://github.com/wu-lang/std): Wrapper for the Lua standard library.

## Disclaimer

Wu is built and maintained by a minimal team of people and was primarily developed during boring primary school classes, to help make time pass faster. Currently being maintained by an 18-year-old.

## Contributors

- [nilq](https://github.com/nilq)

- [evolbug](https://github.com/evolbug)

- [fuzzylitchi](https://github.com/fuzzylitchi)

### License

[MIT License](https://github.com/wu-lang/wu/blob/master/LICENSE)
