

use url::Url;
use env_logger::Builder;
use log::LevelFilter;

use tungstenite::client::connect_with_config;
use tungstenite::extensions::deflate::{DeflateConfigBuilder, DeflateExt};
use tungstenite::protocol::WebSocketConfig;
use tungstenite::{connect, Error, Message, Result};
fn main() {
    let mut builder = Builder::new();
    builder.filter_level(LevelFilter::Trace);
    builder.init();

    let request = Url::parse("wss://stream.binance.com:9443/stream?streams=btcusdt@trade").unwrap();
    // let (mut socket, response) =
    //     connect(request).expect("Can't connect");

    let deflate_config = DeflateConfigBuilder::default()
        .max_message_size(None)
        .build();

    let (mut socket, response) = connect_with_config(
        request,
        Some(WebSocketConfig {
            max_send_queue: None,
            max_frame_size: Some(16 << 20),
            encoder: DeflateExt::new(deflate_config),
        }),
    ).unwrap();


    println!("Connected to the server");
    println!("Response HTTP code: {}", response.status());
    println!("Response contains the following headers:");
    for (ref header, value) in response.headers() {
        println!("* {} = {}", header, value.to_str().unwrap());
    }

    // socket
    //     .write_message(Message::Text("Hello WebSocket".into()))
    //     .unwrap();
    loop {
        let msg = socket.read_message().expect("Error reading message");
        println!("Received: {}", msg);
    }
    // socket.close(None);
}
