[![github]](https://github.com/usagi/write-to-file)&ensp;[![crates-io]](https://crates.io/crates/write-to-file)&ensp;[![docs-rs]](https://docs.rs/write-to-file)<br>
[![Build Status](https://travis-ci.org/usagi/write-to-file.svg?branch=master)](https://travis-ci.org/usagi/write-to-file)

[github]: https://img.shields.io/badge/github-8da0cb?style=for-the-badge&labelColor=555555&logo=github
[crates-io]: https://img.shields.io/badge/crates.io-fc8d62?style=for-the-badge&labelColor=555555&logo=rust
[docs-rs]: https://img.shields.io/badge/docs.rs-66c2a5?style=for-the-badge&labelColor=555555&logoColor=white&logo=data:image/svg+xml;base64,PHN2ZyByb2xlPSJpbWciIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgdmlld0JveD0iMCAwIDUxMiA1MTIiPjxwYXRoIGZpbGw9IiNmNWY1ZjUiIGQ9Ik00ODguNiAyNTAuMkwzOTIgMjE0VjEwNS41YzAtMTUtOS4zLTI4LjQtMjMuNC0zMy43bC0xMDAtMzcuNWMtOC4xLTMuMS0xNy4xLTMuMS0yNS4zIDBsLTEwMCAzNy41Yy0xNC4xIDUuMy0yMy40IDE4LjctMjMuNCAzMy43VjIxNGwtOTYuNiAzNi4yQzkuMyAyNTUuNSAwIDI2OC45IDAgMjgzLjlWMzk0YzAgMTMuNiA3LjcgMjYuMSAxOS45IDMyLjJsMTAwIDUwYzEwLjEgNS4xIDIyLjEgNS4xIDMyLjIgMGwxMDMuOS01MiAxMDMuOSA1MmMxMC4xIDUuMSAyMi4xIDUuMSAzMi4yIDBsMTAwLTUwYzEyLjItNi4xIDE5LjktMTguNiAxOS45LTMyLjJWMjgzLjljMC0xNS05LjMtMjguNC0yMy40LTMzLjd6TTM1OCAyMTQuOGwtODUgMzEuOXYtNjguMmw4NS0zN3Y3My4zek0xNTQgMTA0LjFsMTAyLTM4LjIgMTAyIDM4LjJ2LjZsLTEwMiA0MS40LTEwMi00MS40di0uNnptODQgMjkxLjFsLTg1IDQyLjV2LTc5LjFsODUtMzguOHY3NS40em0wLTExMmwtMTAyIDQxLjQtMTAyLTQxLjR2LS42bDEwMi0zOC4yIDEwMiAzOC4ydi42em0yNDAgMTEybC04NSA0Mi41di03OS4xbDg1LTM4Ljh2NzUuNHptMC0xMTJsLTEwMiA0MS40LTEwMi00MS40di0uNmwxMDItMzguMiAxMDIgMzguMnYuNnoiPjwvcGF0aD48L3N2Zz4K

# write-to-file

Write to a file, simple helper fn and traits lib crate.

I'm tired to implements these very simple file writing feature, but I don't need more a rich features. So I publish the crate. Enjoy rust in relaxed. 🤗

## Tests as Examples: [tests/](tests/)

### function version usage:

```rust
use write_to_file::write_to_file;

// write binary
let buf = vec![1u8, 2, 3, 4];
let expected = buf.clone();
let path = "target/test/file.bin";
write_to_file(path, buf).unwrap(); // <- Easy to write!

// write text
let buf = "Nyanko is one of the greatest life.".to_string();
let expected = buf.clone();
let path = "target/test/file.txt";
write_to_file(path, buf).unwrap(); // <- Easy to write!
```

### trait version usage:

```rust
use write_to_file::WriteToFile;

// Vec<u8>
let buf: Vec<u8> = vec![1u8, 2, 3, 4];
let path = "target/test/file.bin";
buf.write_to_file(path).unwrap(); // <- Easy to write!

// &[u8]
let buf: &[u8] = buf.as_slice();
let path = "target/test/file.bin";
buf.write_to_file(path).unwrap(); // <- Easy to write!

// String
let buf: String = "Nyanko is one of the greatest life.".to_string();
let path = "target/test/file.txt";
buf.write_to_file(path).unwrap(); // <- Easy to write!

// &str
let buf: &str = buf.as_str();
let path = "target/test/file.txt";
buf.write_to_file(path).unwrap(); // <- Easy to write!
```

## LICENSE

- [MIT](LICENSE.md)

## Author

- USAGI.NETWORK / Usagi Ito <https://github.com/usagi/>
